/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb;

import com.sapportals.htmlb.Button;
import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.Container;
import com.sapportals.htmlb.DropdownListBox;
import com.sapportals.htmlb.IJavascriptComponent;
import com.sapportals.htmlb.InputField;
import com.sapportals.htmlb.JavascriptFragment;
import com.sapportals.htmlb.LabeledComponent;
import com.sapportals.htmlb.MessageBar;
import com.sapportals.htmlb.TextEdit;
import com.sapportals.htmlb.event.IEventModifier;
import com.sapportals.htmlb.hovermenu.HoverMenu;
import com.sapportals.htmlb.hovermenu.HoverMenuItem;
import com.sapportals.htmlb.table.TableView;
import com.sapportals.htmlb.util.DefaultHtmlbEncoder;
import com.sapportals.htmlb.util.EmptyEnumeration;
import com.sapportals.htmlb.util.Log;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;

public class Form
extends Container {
    public static final String UI_ID = "Form";
    public static final int VAR_BEGIN = 0;
    public static final int VAR_END = 1;
    private static int formCounter;
    private static final String METHOD_POST = "POST";
    private boolean scrollingToLastPosition;
    private String method;
    private String action;
    private String formId;
    private String encodingType;
    private String target;
    private String language;
    private Button defaultButton;
    private boolean loadingMessage = false;
    transient HashMap formElements;
    transient TableView currentTableView;
    transient ArrayList formEndJavascriptList;
    transient HashSet jsFuncNames;
    transient TreeMap forceJavascriptInterface;
    transient ArrayList modifierStack;
    private String LABELED = "reserved";
    transient HashSet hoverMenus;
    transient HashMap fullIdFormElements = new HashMap();
    transient ClassLoader classLoader;
    transient HashSet scrollContainer;
    private boolean messageBarRequired = true;
    private MessageBar messageBar = new MessageBar("messagebar");
    private boolean messageBarAtBodyEnd = false;
    private Component focusedControl;
    private StringBuffer standAloneHoverMenus;
    private boolean userDefinedMessageBar;
    private HashMap forcedEnabledElement = new HashMap();
    private boolean testMode = System.getProperty("htmlb.testMode") != null;
    private boolean widthInHundredPercent;
    private boolean heightInHundredPercent;
    private HashSet valueHelpMappingFields = new HashSet();
    transient ArrayList eventList;
    transient ArrayList classList;

    public Form() {
        this.setMethod(METHOD_POST);
        this.generateFormId();
    }

    public Form(String formId) {
        this.setMethod(METHOD_POST);
        this.formId = formId;
    }

    private static synchronized int incrementCounter() {
        return formCounter++;
    }

    private void generateFormId() {
        this.setFormId("htmlb_" + Integer.toString(Form.incrementCounter()));
    }

    public void pushEventModifier(IEventModifier eventModifier) {
        if (this.modifierStack == null) {
            this.modifierStack = new ArrayList();
        }
        this.modifierStack.add(eventModifier);
    }

    public IEventModifier popEventModifier() {
        if (this.modifierStack == null) {
            throw new EmptyStackException();
        }
        int n = this.modifierStack.size() - 1;
        IEventModifier result = (IEventModifier)this.modifierStack.get(n);
        this.modifierStack.remove(n);
        return result;
    }

    public IEventModifier getCurrentEventModifier() {
        if (this.modifierStack == null) {
            return null;
        }
        if (this.modifierStack.size() == 0) {
            return null;
        }
        int n = this.modifierStack.size() - 1;
        return (IEventModifier)this.modifierStack.get(n);
    }

    public ArrayList getEventModifier() {
        return this.modifierStack;
    }

    public String getUI() {
        return UI_ID;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String theMethod) {
        this.method = theMethod;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String theAction) {
        this.action = theAction;
    }

    public String getFormId() {
        return this.formId;
    }

    public void setFormId(String theFormId) {
        this.formId = theFormId;
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    public void setEncodingType(String theEncodingType) {
        this.encodingType = theEncodingType;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public Button getDefaultButton() {
        return this.defaultButton;
    }

    public void setDefaultButton(Button defaultButton) {
        this.defaultButton = defaultButton;
    }

    public Component getFocusedControl() {
        return this.focusedControl;
    }

    public void setFocusedControl(InputField focusedInputField) {
        this.focusedControl = focusedInputField;
    }

    public void setFocusedControl(DropdownListBox focusedDropdownListBox) {
        this.focusedControl = focusedDropdownListBox;
    }

    public void setFocusedControl(TextEdit focusedTextEdit) {
        this.focusedControl = focusedTextEdit;
    }

    public void setFocusedControl(Button focusedButton) {
        this.focusedControl = focusedButton;
    }

    public void setFocusedControl(Component focusedComponent) {
        this.focusedControl = focusedComponent;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    protected int registerFormElement(Component component) {
        return this.registerFormElement(component, component.getId());
    }

    public int registerFormElement(Component component, String id) {
        FormElement element;
        if (id == null) {
            throw new IllegalStateException("Components of " + component.getClass() + " must have a id within a form");
        }
        if (this.formElements == null) {
            this.formElements = new HashMap();
        }
        if ((element = (FormElement)this.formElements.get(id)) == null) {
            element = new FormElement(this.formElements.size() + 1, component);
            this.formElements.put(id, element);
        } else if (this.LABELED.equals(element.componentClass)) {
            element.componentClass = null;
            element.component = component;
            if (component instanceof LabeledComponent) {
                ((LabeledComponent)((Object)component)).setLabeled(true);
            }
        } else if (!component.equals(element.component)) {
            String change;
            IEventModifier eventModifier = this.getCurrentEventModifier();
            String string = change = eventModifier != null ? eventModifier.getComponentIdModifier() : "";
            if ("".equals(change)) {
                throw new IllegalStateException("Form elements must have unique ids: " + id + " (" + component.getClass() + ")");
            }
        }
        return element.index;
    }

    public int getIndexOfElement(Component component) {
        return this.registerFormElement(component);
    }

    public HashMap getRegisteredElements() {
        return this.formElements;
    }

    public Iterator getRegisteredElementNames() {
        Set mySet;
        if (this.formElements != null && (mySet = this.formElements.keySet()) != null) {
            return mySet.iterator();
        }
        return EmptyEnumeration.getInstance();
    }

    public int getIdForEvent(String eventName) {
        int index;
        if (this.eventList == null) {
            this.eventList = new ArrayList();
        }
        if ((index = this.eventList.indexOf(eventName)) < 0) {
            this.eventList.add(eventName);
            index = this.eventList.indexOf(eventName);
        }
        return index;
    }

    public String getEventNameForId(int index) {
        if (this.eventList != null) {
            return (String)this.eventList.get(index);
        }
        return null;
    }

    public int getIdForClass(Class aClass) {
        int index;
        String className = aClass.getName();
        if (this.classList == null) {
            this.classList = new ArrayList();
        }
        if ((index = this.classList.indexOf(className)) < 0) {
            this.classList.add(className);
            index = this.classList.indexOf(className);
        }
        return index;
    }

    public Class getClassForId(int index) {
        if (this.classList != null) {
            String className = (String)this.classList.get(index);
            try {
                if (this.classLoader == null) {
                    return Class.forName(className);
                }
                return Class.forName(className, true, this.classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Unknown class: " + className);
            }
        }
        return null;
    }

    public String encodeFormElements() {
        String encodedString = null;
        try {
            Iterator keys;
            DefaultHtmlbEncoder encoder = new DefaultHtmlbEncoder();
            encoder.prepareEncoding();
            if (this.formElements != null) {
                Set keySet = this.formElements.keySet();
                int num = keySet.size();
                encoder.addProperty(num);
                Iterator keys2 = keySet.iterator();
                while (keys2.hasNext()) {
                    String key = (String)keys2.next();
                    FormElement element = (FormElement)this.formElements.get(key);
                    encoder.addProperty(key);
                    encoder.addProperty(element.getIndex());
                    Component c = element.getComponent();
                    if (c != null) {
                        String cid = c.getEncodedIdForForm(this);
                        encoder.addProperty(cid);
                        continue;
                    }
                    encoder.addProperty(" ");
                }
            } else {
                encoder.addProperty(0);
            }
            if (this.eventList != null) {
                encoder.addProperty(this.eventList.size());
                keys = ((AbstractList)this.eventList).iterator();
                while (keys.hasNext()) {
                    String s = (String)keys.next();
                    encoder.addProperty(s);
                }
            } else {
                encoder.addProperty(0);
            }
            if (this.classList != null) {
                encoder.addProperty(this.classList.size());
                keys = ((AbstractList)this.classList).iterator();
                while (keys.hasNext()) {
                    String s = (String)keys.next();
                    encoder.addProperty(s);
                }
            } else {
                encoder.addProperty(0);
            }
            encodedString = encoder.getEncodedString();
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't encode form elements");
        }
        return encodedString;
    }

    public void decodeFormElements(String encodedString) {
        if (encodedString != null && !"".equals(encodedString)) {
            try {
                String key;
                int i;
                DefaultHtmlbEncoder encoder = new DefaultHtmlbEncoder();
                encoder.prepareDecoding(encodedString);
                int num = encoder.getIntProperty();
                if (num > 0) {
                    this.formElements = new HashMap(num);
                    i = 0;
                    while (i < num) {
                        key = encoder.getStringProperty();
                        int index = encoder.getIntProperty();
                        String cid = encoder.getStringProperty();
                        FormElement element = new FormElement(index, cid);
                        this.formElements.put(key, element);
                        ++i;
                    }
                }
                if ((num = encoder.getIntProperty()) > 0) {
                    this.eventList = new ArrayList(num);
                    i = 0;
                    while (i < num) {
                        key = encoder.getStringProperty();
                        this.eventList.add(key);
                        ++i;
                    }
                }
                if ((num = encoder.getIntProperty()) > 0) {
                    this.classList = new ArrayList(num);
                    i = 0;
                    while (i < num) {
                        key = encoder.getStringProperty();
                        this.classList.add(key);
                        ++i;
                    }
                }
                encoder.finishDecoding();
            }
            catch (IOException e) {
                Log.getLogLocation(false).debugT("Should not happen: Form", "decodeFormElements");
            }
        }
    }

    public String getFullIdForComponent(Component component) {
        IEventModifier myEventModifier = this.getCurrentEventModifier();
        String result = null;
        if (myEventModifier != null && !(component instanceof HoverMenu)) {
            String modifierID = ((Component)((Object)myEventModifier)).getId();
            int internalId = this.registerFormElement(component, modifierID + "_" + component.getId());
            result = this.getFormId() + "_" + Integer.toString(internalId);
            result = result + myEventModifier.getComponentIdModifier();
        } else {
            int internalId = this.registerFormElement(component);
            result = this.getFormId() + "_" + Integer.toString(internalId);
        }
        return result;
    }

    public void registerHoverMenu(HoverMenu hoverMenu) {
        if (this.hoverMenus == null) {
            this.hoverMenus = new HashSet();
        }
        this.hoverMenus.add(hoverMenu);
        Iterator it = hoverMenu.getMenuItemsIterator();
        while (it.hasNext()) {
            HoverMenuItem item = (HoverMenuItem)it.next();
            if (item.getSubMenu() == null) continue;
            this.registerHoverMenu(item.getSubMenu());
        }
    }

    public HashSet getHoverMenus() {
        return this.hoverMenus;
    }

    public String getComponentIdForLabel(String id) {
        return this.getFormId() + "_" + Integer.toString(this.getIndexOfLabel(id));
    }

    public int getIndexOfLabel(String id) {
        IEventModifier myEventModifier = this.getCurrentEventModifier();
        if (this.formElements == null) {
            this.formElements = new HashMap();
        }
        FormElement element = (FormElement)this.formElements.get(id);
        int index = 0;
        if (element == null) {
            index = this.formElements.size() + 1;
            element = new FormElement(index, this.LABELED);
            this.formElements.put(id, element);
        } else {
            index = element.index;
        }
        return index;
    }

    public boolean isLabeled(String id) {
        FormElement element;
        if (this.formElements != null && (element = (FormElement)this.formElements.get(id)) != null) {
            return this.LABELED.equals(element.componentClass);
        }
        return false;
    }

    public String getFullIdForComponent(String name) {
        FormElement myElement;
        if (this.formElements != null && (myElement = (FormElement)this.formElements.get(name)) != null) {
            if (this.testMode) {
                return this.getFormId() + "_" + myElement.getIndex() + "x" + name;
            }
            return this.getFormId() + "_" + myElement.getIndex();
        }
        return null;
    }

    public Component getComponentById(String id) {
        FormElement myElement;
        if (this.formElements != null && (myElement = (FormElement)this.formElements.get(id)) != null) {
            return myElement.getComponent();
        }
        return null;
    }

    public String getUserIdForIndex(int index) {
        if (this.formElements != null) {
            Iterator entries = this.formElements.keySet().iterator();
            while (entries.hasNext()) {
                String key = (String)entries.next();
                FormElement myElement = (FormElement)this.formElements.get(key);
                if (myElement.index != index) continue;
                return key;
            }
        }
        return null;
    }

    public String getFullIdForComponent(String modifierName, String name, int row) {
        FormElement myElement;
        if (this.formElements != null && (myElement = (FormElement)this.formElements.get(modifierName + "_" + name)) != null) {
            if (this.testMode) {
                return this.getFormId() + "_" + myElement.getIndex() + "_a" + row + "x" + name;
            }
            return this.getFormId() + "_" + myElement.getIndex() + "_a" + row;
        }
        return null;
    }

    public String getClassIdForComponent(String name) {
        FormElement myElement;
        if (this.formElements != null && (myElement = (FormElement)this.formElements.get(name)) != null) {
            return myElement.componentClass;
        }
        return null;
    }

    public String getClassIdForComponent(String tableName, String name) {
        FormElement myElement;
        if (this.formElements != null && (myElement = (FormElement)this.formElements.get(tableName + "_" + name)) != null) {
            return myElement.componentClass;
        }
        return null;
    }

    public void addFormEndJavascript(JavascriptFragment javascript) {
        if (this.formEndJavascriptList == null) {
            this.formEndJavascriptList = new ArrayList();
            this.jsFuncNames = new HashSet();
        }
        boolean contained = false;
        String jsFuncName = javascript.getJSFuncName();
        if (this.jsFuncNames.contains(jsFuncName)) {
            contained = true;
        }
        if (!contained) {
            this.formEndJavascriptList.add(javascript);
            this.jsFuncNames.add(jsFuncName);
        }
    }

    public ArrayList getFormEndJavascripts() {
        return this.formEndJavascriptList;
    }

    public void clearFormEndJavascripts() {
        this.formEndJavascriptList = null;
        this.jsFuncNames = null;
    }

    public void addForceJavascriptInterface(IJavascriptComponent c, String generatedId) {
        if (this.forceJavascriptInterface == null) {
            this.forceJavascriptInterface = new TreeMap();
        }
        this.forceJavascriptInterface.put(generatedId, c);
    }

    public TreeMap getForceJavascriptInterface() {
        return this.forceJavascriptInterface;
    }

    public void clearForceJavascriptInterface() {
        this.forceJavascriptInterface = null;
    }

    public boolean isScrollingToLastPosition() {
        return this.scrollingToLastPosition;
    }

    public void setScrollingToLastPosition(boolean scrollingToLastPosition) {
        this.scrollingToLastPosition = scrollingToLastPosition;
    }

    public void addFullIdFormElement(String componentId, String fullId) {
        this.fullIdFormElements.put(componentId, fullId);
    }

    public HashMap getFullIdFormElements() {
        return this.fullIdFormElements;
    }

    public MessageBar getMessageBar() {
        return this.messageBar;
    }

    public void setMessageBar(MessageBar messageBar) {
        this.messageBar = messageBar;
        this.setUserDefinedMessageBar(true);
    }

    public boolean isUserDefinedMessageBar() {
        return this.userDefinedMessageBar;
    }

    public void setUserDefinedMessageBar(boolean userDefinedMessageBar) {
        this.userDefinedMessageBar = userDefinedMessageBar;
    }

    public boolean isMessageBarAtFormEnd() {
        return this.messageBarAtBodyEnd;
    }

    public void setMessageBarAtFormEnd(boolean messageBarAtBodyEnd) {
        this.messageBarAtBodyEnd = messageBarAtBodyEnd;
    }

    public void addStandAloneHoverMenusAsString(StringBuffer hoverMenusAsString) {
        if (this.standAloneHoverMenus == null) {
            this.standAloneHoverMenus = new StringBuffer();
        }
        this.standAloneHoverMenus.append((Object)hoverMenusAsString);
    }

    public StringBuffer getStandAloneHoverMenusAsString() {
        return this.standAloneHoverMenus;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void registerScrollContainer(String id) {
        if (this.scrollContainer == null) {
            this.scrollContainer = new HashSet();
        }
        this.scrollContainer.add(id);
    }

    public HashSet getScrollContainerSet() {
        return this.scrollContainer;
    }

    public boolean isMessageBarRequired() {
        return this.messageBarRequired;
    }

    public void setMessageBarRequired(boolean messageBarRequired) {
        this.messageBarRequired = messageBarRequired;
    }

    public void addForcedEnabledElement(String generatedId, Component component) {
        this.forcedEnabledElement.put(generatedId, component);
    }

    public HashMap getForcedEnabledElement() {
        return this.forcedEnabledElement;
    }

    public boolean isWidthInHundredPercent() {
        return this.widthInHundredPercent;
    }

    public void setWidthInHundredPercent(boolean widthInHundredPercent) {
        this.widthInHundredPercent = widthInHundredPercent;
    }

    public boolean isHeightInHundredPercent() {
        return this.heightInHundredPercent;
    }

    public void setHeightInHundredPercent(boolean heightInHundredPercent) {
        this.heightInHundredPercent = heightInHundredPercent;
    }

    public HashSet getValueHelpMappingFields() {
        return this.valueHelpMappingFields;
    }

    public void registerValueHelpMappingField(InputField field) {
        this.valueHelpMappingFields.add(field);
    }

    public void setLoadingMessage(boolean show) {
        this.loadingMessage = show;
    }

    public boolean isLoadingMessage() {
        return this.loadingMessage;
    }

    public class FormElement {
        int index;
        Component component;
        String componentClass;

        public FormElement(int index, Component component) {
            this.index = index;
            this.component = component;
        }

        public FormElement(int index, String componentClass) {
            this.index = index;
            this.componentClass = componentClass;
        }

        public int getIndex() {
            return this.index;
        }

        public Component getComponent() {
            return this.component;
        }

        public String getComponentClass() {
            return this.componentClass;
        }
    }
}

