/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb;

import com.sapportals.htmlb.Container;
import com.sapportals.htmlb.IEventValidationComponent;
import com.sapportals.htmlb.enum.EventTrigger;
import com.sapportals.htmlb.event.Event;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.validation.Validator;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class EventValidationContainer
extends Container
implements IEventValidationComponent {
    private boolean enabled = true;
    private HashMap clientEvents = new HashMap();
    private HashMap serverEvents = new HashMap();
    private Validator applicationValidator;
    private String errortext;

    public EventValidationContainer() {
    }

    public EventValidationContainer(String id) {
        super(id);
    }

    public void setValidator(Validator validator) {
        this.applicationValidator = validator;
    }

    public Validator getValidator() {
        return this.applicationValidator;
    }

    public ArrayList getAllValidators() {
        Validator appValidator = this.getValidator();
        if (appValidator != null) {
            ArrayList<Validator> list = new ArrayList<Validator>();
            list.add(appValidator);
            return list;
        }
        return null;
    }

    public void setErrorText(String errortext) {
        this.errortext = errortext;
    }

    public String getErrorText() {
        return this.errortext;
    }

    public void setClientEvent(EventTrigger trigger, String javascript) {
        if (javascript == null || javascript.equals("")) {
            this.clientEvents.remove(trigger);
        } else {
            this.clientEvents.put(trigger, javascript);
        }
    }

    public String getClientEvent(EventTrigger trigger) {
        return (String)this.clientEvents.get(trigger);
    }

    public void setServerEvent(EventTrigger trigger, Event event) {
        if (event == null) {
            this.serverEvents.remove(trigger);
        } else {
            this.serverEvents.put(trigger, event);
        }
    }

    public Event getServerEvent(EventTrigger trigger) {
        return (Event)this.serverEvents.get(trigger);
    }

    public HashMap getClientEventMap() {
        return this.clientEvents;
    }

    public HashMap getServerEventMap() {
        return this.serverEvents;
    }

    public boolean isDisabled() {
        return !this.enabled;
    }

    public void setDisabled(boolean disabled) {
        this.enabled = !disabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void renderJavascriptInterface(IPageContext renderContext, String generatedId) {
        renderContext.renderJavascriptInterface(this, generatedId);
    }

    public boolean isRequiresValidation() {
        return false;
    }
}

