/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb;

import com.sapportals.htmlb.DefaultListModel;
import com.sapportals.htmlb.EventValidationComponent;
import com.sapportals.htmlb.IListModel;
import com.sapportals.htmlb.IUserDataComponent;
import com.sapportals.htmlb.LabeledComponent;
import com.sapportals.htmlb.enum.DropdownListBoxDesign;
import com.sapportals.htmlb.enum.EventTrigger;
import com.sapportals.htmlb.event.Event;
import com.sapportals.htmlb.event.ListSelectEvent;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.type.AbstractDataType;
import com.sapportals.htmlb.type.DataString;
import java.util.Iterator;

public class DropdownListBox
extends EventValidationComponent
implements IUserDataComponent,
LabeledComponent {
    public static final String UI_ID = "DropdownListBox";
    IListModel model;
    String onSelect;
    String onClientSelect;
    String tooltip;
    String width;
    boolean labeled;
    DropdownListBoxDesign design;
    boolean requiresValidation = false;

    public DropdownListBox(String name) {
        this.setId(name);
        this.setModel(this.createDefaultModel());
    }

    protected IListModel createDefaultModel() {
        DefaultListModel myModel = new DefaultListModel();
        myModel.setSingleSelection(true);
        return myModel;
    }

    protected void initFromPageContext(IPageContext pc, String baseId) {
        this.setSelection(pc.getParameter(baseId));
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public IListModel getModel() {
        return this.model;
    }

    public void setModel(IListModel model) {
        if (!model.isSingleSelection()) {
            throw new IllegalArgumentException("DropdownListBox supports only single selection models");
        }
        this.model = model;
    }

    public boolean isSelected(String key) {
        return this.model.isSelected(key);
    }

    public String getSelection() {
        return this.model.getSingleSelection();
    }

    public void setSelection(String selection) {
        this.model.setSelection(selection);
    }

    public String getNameOfKeyColumn() {
        return this.model.getNameOfKeyColumn();
    }

    public void setNameOfKeyColumn(String nameOfKeyColumn) {
        this.model.setNameOfKeyColumn(nameOfKeyColumn);
    }

    public String getNameOfValueColumn() {
        return this.model.getNameOfTextColumn();
    }

    public void setNameOfValueColumn(String nameOfValueColumn) {
        this.model.setNameOfTextColumn(nameOfValueColumn);
    }

    public String getOnSelect() {
        Event event = this.getServerEvent(EventTrigger.ON_CHANGE);
        return event == null ? null : event.getAction();
    }

    public void setOnSelect(String onSelect) {
        ListSelectEvent listSelectEvent = new ListSelectEvent();
        listSelectEvent.setAction(onSelect);
        this.setServerEvent(EventTrigger.ON_CHANGE, listSelectEvent);
    }

    public String getOnClientSelect() {
        return this.getClientEvent(EventTrigger.ON_CHANGE);
    }

    public void setOnClientSelect(String onClientSelect) {
        this.setClientEvent(EventTrigger.ON_CHANGE, onClientSelect);
    }

    public String getUI() {
        return UI_ID;
    }

    public void addItem(String key, String text) {
        this.model.addItem(key, text);
    }

    public String getTextForKey(String key) {
        return this.model.getTextForKey(key);
    }

    public Iterator getKeys() {
        return this.model.getKeys();
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public AbstractDataType getValueAsDataType() {
        String selection = this.getSelection();
        if (selection != null) {
            return new DataString(selection);
        }
        return null;
    }

    public void setLabeled(boolean isLabeled) {
        this.labeled = isLabeled;
    }

    public boolean isLabeled() {
        return this.labeled;
    }

    public Iterator getKeySet() {
        return this.model.getKeys();
    }

    public DropdownListBoxDesign getDesign() {
        return this.design;
    }

    public void setDesign(DropdownListBoxDesign design) {
        this.design = design;
    }

    public boolean isRequiresValidation() {
        return this.requiresValidation;
    }

    public void setRequiresValidation(boolean requiresValidation) {
        this.requiresValidation = requiresValidation;
    }
}

