/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.Container;
import com.sapportals.htmlb.Includes;
import com.sapportals.htmlb.enum.ResourceType;
import com.sapportals.htmlb.hovermenu.HoverMenu;
import com.sapportals.htmlb.hovermenu.HoverMenuItem;
import com.sapportals.htmlb.rendering.IPageContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class Document
extends Container {
    public static final String UI_ID = "Document";
    public static final int VAR_BEGIN = 0;
    public static final int VAR_END = 1;
    public static final int VAR_HEADINCLUDES = 2;
    public static final int VAR_BODYBEGININCLUDES = 3;
    public static final int VAR_BODYENDINCLUDES = 4;
    public static final int VAR_DOCBEGIN = 5;
    public static final int VAR_DOCEND = 6;
    public static final int VAR_HEADBEGIN = 7;
    public static final int VAR_HEADEND = 8;
    public static final int VAR_BODYBEGIN = 9;
    public static final int VAR_BODYEND = 10;
    public static final int VAR_HEAD = 11;
    public static final int VAR_DOCTYPE = 12;
    String title;
    String headRawText;
    Includes includes;
    String documentId;
    int elementId;
    transient HashMap docElements;
    transient HashSet hoverMenus;
    transient HashSet clientSideTexts508;
    transient HashSet clientSideStandardTexts = new HashSet();
    private static int docCounter = 0;

    public Document(String title) {
        this.title = title;
        this.generateDocumentId();
        this.elementId = 0;
    }

    private static synchronized int incrementCounter() {
        return docCounter++;
    }

    private void generateDocumentId() {
        this.setDocumentId("htmlb_" + Integer.toString(Document.incrementCounter()));
    }

    public String getNewElementId() {
        String result = Integer.toString(this.elementId);
        ++this.elementId;
        return result;
    }

    public String getElementId(Component c) {
        if (this.docElements == null) {
            this.docElements = new HashMap();
        }
        String result = null;
        result = (String)this.docElements.get(c);
        if (result == null) {
            result = Integer.toHexString(c.hashCode());
            result = c.getUI() + result;
            this.docElements.put(c, result);
            if (c instanceof HoverMenu) {
                this.registerHoverMenu((HoverMenu)c);
            }
            ++this.elementId;
            return result;
        }
        return result;
    }

    public String getUI() {
        return UI_ID;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getHeadRawText() {
        return this.headRawText;
    }

    public void setHeadRawText(String headRawText) {
        this.headRawText = headRawText;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public Includes getIncludes() {
        return this.includes;
    }

    public void setIncludes(Includes includes) {
        this.includes = includes;
    }

    public void addHeadResource(ResourceType type, String key, Object data) {
        this.getIncludes().addHeadResource(type, key, data, null);
    }

    public void registerHoverMenu(HoverMenu hoverMenu) {
        if (this.hoverMenus == null) {
            this.hoverMenus = new HashSet();
        }
        this.hoverMenus.add(hoverMenu);
        Iterator it = hoverMenu.getMenuItemsIterator();
        while (it.hasNext()) {
            HoverMenuItem item = (HoverMenuItem)it.next();
            if (item.getSubMenu() == null) continue;
            this.registerHoverMenu(item.getSubMenu());
        }
    }

    public HashSet getHoverMenus() {
        return this.hoverMenus;
    }

    public void register508Text(String key) {
        if (this.clientSideTexts508 == null) {
            this.clientSideTexts508 = new HashSet();
        }
        this.clientSideTexts508.add(key);
    }

    public HashSet get508Texts() {
        return this.clientSideTexts508;
    }

    public void registerStandardText(String key) {
        this.clientSideStandardTexts.add(key);
    }

    public HashSet getStandardTexts() {
        return this.clientSideStandardTexts;
    }

    public void render(int selector, IPageContext rendererContext) {
        switch (selector) {
            case 0: 
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                rendererContext.render(this, selector);
                break;
            }
            case 2: {
                this.getIncludes().render(0, rendererContext);
                break;
            }
            case 3: {
                this.getIncludes().render(1, rendererContext);
                break;
            }
            case 4: {
                this.getIncludes().render(2, rendererContext);
            }
        }
    }
}

