/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb;

import com.sapportals.htmlb.IListModel;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class DefaultListModel
implements IListModel,
Serializable {
    String nameOfKeyColumn;
    String nameOfValueColumn;
    ArrayList keys = new ArrayList();
    ArrayList texts = new ArrayList();
    ArrayList selection = new ArrayList();
    boolean isSingleSelect;

    public void addItem(String key, String text) {
        if (this.getTextForKey(key) != null) {
            this.removeItem(key);
        }
        this.keys.add(key);
        this.texts.add(text);
    }

    public void addItem(int index, String key, String text) {
        this.keys.add(index, key);
        this.texts.add(index, text);
    }

    public int size() {
        return this.keys.size();
    }

    public String getKeyByIndex(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Illegal index: " + index);
        }
        return (String)this.keys.get(index);
    }

    public String getTextByIndex(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Illegal index: " + index);
        }
        return (String)this.texts.get(index);
    }

    public Iterator getKeys() {
        return ((AbstractList)this.keys).iterator();
    }

    public String getTextForKey(String key) {
        int index = this.keys.indexOf(key);
        if (index >= 0) {
            return (String)this.texts.get(index);
        }
        return null;
    }

    public boolean isSelected(int index) {
        return this.isSelected(this.getKeyByIndex(index));
    }

    public boolean isSelected(String key) {
        return this.selection.contains(key);
    }

    public String getNameOfKeyColumn() {
        return this.nameOfKeyColumn;
    }

    public void setNameOfKeyColumn(String nameOfKeyColumn) {
        this.nameOfKeyColumn = nameOfKeyColumn;
    }

    public String getNameOfTextColumn() {
        return this.nameOfValueColumn;
    }

    public void setNameOfTextColumn(String nameOfValueColumn) {
        this.nameOfValueColumn = nameOfValueColumn;
    }

    public void setSelection(String key) {
        this.selection.clear();
        this.selection.add(key);
    }

    public boolean isSingleSelection() {
        return this.isSingleSelect;
    }

    public void setSingleSelection(boolean isSingleSelection) {
        this.isSingleSelect = isSingleSelection;
    }

    public String getSingleSelection() {
        if (this.isSingleSelect) {
            if (this.selection.size() == 1) {
                return (String)this.selection.get(0);
            }
            return null;
        }
        throw new IllegalStateException("List uses multiselection");
    }

    public String[] getMultiSelection() {
        String[] result = new String[this.selection.size()];
        int i = 0;
        while (i < this.selection.size()) {
            result[i] = (String)this.selection.get(i);
            ++i;
        }
        return result;
    }

    public void addSelection(String key) {
        if (!this.selection.contains(key)) {
            this.selection.add(key);
        }
    }

    public void removeSelection(String key) {
        ((AbstractCollection)this.selection).remove(key);
    }

    public void removeItem(String key) {
        int index = this.keys.indexOf(key);
        if (index < 0) {
            throw new IllegalStateException("Model doesn't contain any item with the given key:" + key);
        }
        this.keys.remove(index);
        this.texts.remove(index);
        this.removeSelection(key);
    }
}

