/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb;

import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.type.DayRanges;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateNavigatorModel {
    private Integer centeredMonth = null;
    private Integer centeredYear = null;
    private Date today;
    private DayRanges selectedDays;
    private Calendar calendar;
    private Locale locale;
    private boolean localeUnknown = false;

    public DateNavigatorModel(IPageContext pc) {
        this.init(pc.getLocale());
    }

    public DateNavigatorModel() {
        this.init(Locale.getDefault());
        this.setLocaleUnknown(true);
    }

    public void setLocale(Locale l) {
        this.init(l);
        this.setLocaleUnknown(false);
    }

    private void init(Locale l) {
        this.locale = l;
        this.calendar = Calendar.getInstance(l);
        this.setToday(new Date());
        this.calendar.setTime(this.getToday());
        this.setCenteredMonth(this.calendar.get(2));
        this.setCenteredYear(this.calendar.get(1));
    }

    public Integer getCenteredMonth() {
        return this.centeredMonth;
    }

    public void setCenteredMonth(int centeredMonth) {
        this.centeredMonth = new Integer(centeredMonth);
    }

    public Integer getCenteredYear() {
        return this.centeredYear;
    }

    public void setCenteredYear(int centeredYear) {
        this.centeredYear = new Integer(centeredYear);
    }

    public Date getToday() {
        return this.today;
    }

    public void setToday(Date today) {
        this.today = DayRanges.normalizeDate(this.calendar, today);
    }

    public DayRanges getSelectedDays() {
        return this.selectedDays;
    }

    public void setSelectedDays(DayRanges selectedDays) {
        this.selectedDays = selectedDays;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean isLocaleUnknown() {
        return this.localeUnknown;
    }

    protected void setLocaleUnknown(boolean localeUnknown) {
        this.localeUnknown = localeUnknown;
    }
}

