/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb;

import com.sapportals.htmlb.Container;
import com.sapportals.htmlb.Form;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.util.Log;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public abstract class Component {
    String id;
    String description;
    String language;
    Container parent;
    boolean jsObjectNeeded = false;
    static /* synthetic */ Class class$java$lang$String;

    public Component() {
    }

    public Component(String id) {
        this.setId(id);
    }

    public Container getParent() {
        return this.parent;
    }

    public void setParent(Container parent) {
        Container oldParent = this.parent;
        if (oldParent != null) {
            oldParent.removeComponent(this);
        }
        this.parent = parent;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public abstract String getUI();

    public void render(IPageContext rendererContext) {
        rendererContext.render(this);
    }

    public String renderAsString(IPageContext pageContext) {
        StringWriter myStringWriter = new StringWriter();
        Writer oldWriter = pageContext.getWriter();
        pageContext.setWriter(myStringWriter);
        pageContext.render(this);
        pageContext.setWriter(oldWriter);
        return myStringWriter.toString();
    }

    protected String getEncodedIdForForm(Form theForm) {
        return Integer.toString(theForm.getIdForClass(this.getClass()));
    }

    public static Component initializeFromId(String originalId, String id, IPageContext pc, String idInPage) {
        String componentId = id;
        int i = id.indexOf("_");
        if (i >= 0) {
            componentId = id.substring(0, i);
        }
        Class myClass = null;
        try {
            int intId = Integer.parseInt(componentId);
            myClass = pc.getOldForm().getClassForId(intId);
        }
        catch (NumberFormatException e) {
            Log.getLogLocation(false).debugT("Should not happen: could not retrieve class", "InitializeFromId");
        }
        if (myClass != null) {
            try {
                Constructor constructor;
                Object instance = null;
                try {
                    instance = myClass.newInstance();
                }
                catch (InstantiationException e) {
                    Log.getLogLocation(false).debugT("Void constructor not found for class " + myClass.getName(), "InstantiationException");
                }
                catch (IllegalAccessException e) {
                    Log.getLogLocation(false).debugT("initializeFromID for class " + myClass.getName(), "IllegalAccessException");
                }
                if (instance == null && (constructor = myClass.getConstructor(class$java$lang$String == null ? (class$java$lang$String = Component.class$("java.lang.String")) : class$java$lang$String)) != null) {
                    instance = constructor.newInstance(originalId);
                }
                if (instance instanceof Component) {
                    Component c = instance;
                    c.setId(originalId);
                    c.initFromShortId(pc, id);
                    c.initFromPageContext(pc, idInPage);
                    return c;
                }
            }
            catch (InstantiationException e) {
                Log.getLogLocation(false).debugT("Should not happen (class " + myClass.getName() + ")", "InstantiationException");
            }
            catch (IllegalAccessException e) {
                Log.getLogLocation(false).debugT("Should not happen (class" + myClass.getName() + ")", "IllegalAccessException");
            }
            catch (NoSuchMethodException e) {
                Log.getLogLocation(false).debugT("Should not happen (class" + myClass.getName() + ")", "NoSuchMethodException");
            }
            catch (InvocationTargetException e) {
                Log.getLogLocation(false).debugT("Should not happen (class " + myClass.getName() + ")", "InvocationTargetException");
            }
        }
        return null;
    }

    protected void initFromShortId(IPageContext pc, String id) {
    }

    protected void initFromPageContext(IPageContext pc, String baseId) {
    }

    public boolean requiresForm() {
        return true;
    }

    public boolean isJsObjectNeeded() {
        return this.jsObjectNeeded;
    }

    public void setJsObjectNeeded(boolean jsObjectNeeded) {
        this.jsObjectNeeded = jsObjectNeeded;
    }

    public void preRender(IPageContext pc) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

