/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb;

import com.sapportals.htmlb.IUserDataComponent;
import com.sapportals.htmlb.LabeledComponent;
import com.sapportals.htmlb.StatefulButtonBase;
import com.sapportals.htmlb.enum.EventTrigger;
import com.sapportals.htmlb.enum.ForcedTextDirection;
import com.sapportals.htmlb.event.CheckboxClickEvent;
import com.sapportals.htmlb.event.Event;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.type.AbstractDataType;
import com.sapportals.htmlb.type.DataBoolean;

public class Checkbox
extends StatefulButtonBase
implements IUserDataComponent,
LabeledComponent {
    public static final String UI_ID = "Checkbox";
    private String onClick;
    private String onClientClick;
    boolean labeled;
    private ForcedTextDirection textDirection = ForcedTextDirection.INHERIT;
    private boolean checked = false;

    public Checkbox(String key) {
        this.setKey(key);
    }

    public void setKey(String key) {
        super.setKey(key);
        this.setId(key);
    }

    protected Checkbox() {
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    protected void initFromPageContext(IPageContext pc, String baseId) {
        String c = pc.getParameter(baseId);
        if (c == null) {
            this.setChecked(false);
        } else {
            this.setChecked(true);
        }
    }

    public AbstractDataType getValueAsDataType() {
        return new DataBoolean(this.isChecked());
    }

    public String getOnClick() {
        Event event = this.getServerEvent(EventTrigger.ON_CLICK);
        return event == null ? null : event.getAction();
    }

    public void setOnClick(String onClick) {
        CheckboxClickEvent checkboxClickEvent = new CheckboxClickEvent();
        checkboxClickEvent.setAction(onClick);
        this.setServerEvent(EventTrigger.ON_CLICK, checkboxClickEvent);
    }

    public String getOnClientClick() {
        return this.getClientEvent(EventTrigger.ON_CLICK);
    }

    public void setOnClientClick(String onClientClick) {
        this.setClientEvent(EventTrigger.ON_CLICK, onClientClick);
    }

    public String getUI() {
        return UI_ID;
    }

    public void render(int selector, IPageContext rendererContext) {
        rendererContext.render(this, selector);
    }

    public void setLabeled(boolean isLabeled) {
        this.labeled = isLabeled;
    }

    public boolean isLabeled() {
        return this.labeled;
    }

    public ForcedTextDirection getTextDirection() {
        return this.textDirection;
    }

    public void setTextDirection(ForcedTextDirection textDirection) {
        this.textDirection = textDirection;
    }
}

