/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb;

import com.sapportals.htmlb.EventValidationComponent;
import com.sapportals.htmlb.IPopupTriggerContent;
import com.sapportals.htmlb.InputField;
import com.sapportals.htmlb.enum.ButtonDesign;
import com.sapportals.htmlb.enum.EventTrigger;
import com.sapportals.htmlb.enum.ForcedTextDirection;
import com.sapportals.htmlb.event.ButtonClickEvent;
import com.sapportals.htmlb.event.Event;
import com.sapportals.htmlb.validation.CancelButtonValidator;
import com.sapportals.htmlb.validation.OKButtonValidator;
import com.sapportals.htmlb.validation.Validator;
import java.util.ArrayList;

public class Button
extends EventValidationComponent
implements IPopupTriggerContent {
    public static final String UI_ID = "Button";
    private String text;
    private String tooltip;
    private String formId;
    private String onClick;
    private String onClientClick;
    private boolean encode = true;
    private String width;
    private ButtonDesign design;
    private boolean isOKButton;
    private boolean isCancelButton;
    private boolean isDataTransferingButton;
    private InputField fieldToTransferDataFrom;
    private ForcedTextDirection textDirection = ForcedTextDirection.INHERIT;

    protected Button() {
    }

    public Button(String name) {
        this.setId(name);
        this.setDesign(ButtonDesign.STANDARD);
    }

    public Button(String name, String text) {
        this.setId(name);
        this.setText(text);
        this.setDesign(ButtonDesign.STANDARD);
    }

    public String getUI() {
        return UI_ID;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public String getOnClick() {
        Event event = this.getServerEvent(EventTrigger.ON_CLICK);
        return event == null ? null : event.getAction();
    }

    public void setOnClick(String onClick) {
        ButtonClickEvent buttonClickEvent = new ButtonClickEvent(onClick);
        buttonClickEvent.setAction(onClick);
        this.setServerEvent(EventTrigger.ON_CLICK, buttonClickEvent);
    }

    public String getOnClientClick() {
        return this.getClientEvent(EventTrigger.ON_CLICK);
    }

    public void setOnClientClick(String onClientClick) {
        this.setClientEvent(EventTrigger.ON_CLICK, onClientClick);
    }

    public boolean isOKButton() {
        return this.isOKButton;
    }

    public void setOKButton(boolean OKButton) {
        this.isOKButton = OKButton;
        if (OKButton) {
            this.isCancelButton = false;
        }
        this.setRequiresValidation(true);
    }

    public boolean isCancelButton() {
        return this.isCancelButton;
    }

    public void setCancelButton(boolean CancelButton) {
        this.isCancelButton = CancelButton;
        if (CancelButton) {
            this.isOKButton = false;
        }
    }

    public ArrayList getAllValidators() {
        Validator appValidator = this.getValidator();
        if (this.isOKButton || appValidator != null) {
            ArrayList<Validator> list = new ArrayList<Validator>();
            if (appValidator != null) {
                list.add(appValidator);
            }
            if (this.isOKButton) {
                list.add(new OKButtonValidator());
            }
            if (this.isCancelButton) {
                list.add(new CancelButtonValidator());
            }
            return list;
        }
        return null;
    }

    public boolean isEncode() {
        return this.encode;
    }

    public void setEncode(boolean encode) {
        this.encode = encode;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public ButtonDesign getDesign() {
        return this.design;
    }

    public void setDesign(ButtonDesign design) {
        this.design = design;
    }

    public InputField getFieldToTransferDataFrom() {
        return this.fieldToTransferDataFrom;
    }

    public void setFieldToTransferDataFrom(InputField fieldToTransferDataFrom) {
        this.fieldToTransferDataFrom = fieldToTransferDataFrom;
    }

    public boolean isDataTransferingButton() {
        return this.isDataTransferingButton;
    }

    public void setDataTransferingButton(boolean dataTransferingButton) {
        this.isDataTransferingButton = dataTransferingButton;
    }

    public ForcedTextDirection getTextDirection() {
        return this.textDirection;
    }

    public void setTextDirection(ForcedTextDirection textDirection) {
        this.textDirection = textDirection;
    }
}

