/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.DefaultListModel;
import com.sapportals.htmlb.IListModel;
import com.sapportals.htmlb.enum.BreadCrumbBehavior;
import com.sapportals.htmlb.enum.BreadCrumbSize;
import java.util.Iterator;

public class BreadCrumb
extends Component {
    public static final String UI_ID = "BreadCrumb";
    private String tooltip;
    private String onClick;
    BreadCrumbSize size = BreadCrumbSize.MEDIUM;
    BreadCrumbBehavior behavior = BreadCrumbBehavior.DEFAULT;
    IListModel model;

    private BreadCrumb() {
    }

    public BreadCrumb(String id) {
        super(id);
        this.setModel(this.createDefaultModel());
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public String getOnClick() {
        return this.onClick;
    }

    public void setOnClick(String onClick) {
        this.onClick = onClick;
    }

    protected IListModel createDefaultModel() {
        DefaultListModel myModel = new DefaultListModel();
        myModel.setSingleSelection(false);
        return myModel;
    }

    public IListModel getModel() {
        return this.model;
    }

    public void setModel(IListModel model) {
        if (model.isSingleSelection()) {
            throw new IllegalArgumentException("BreadCrumb doesn't support selection models");
        }
        this.model = model;
    }

    public String getNameOfKeyColumn() {
        return this.model.getNameOfKeyColumn();
    }

    public void setNameOfKeyColumn(String nameOfKeyColumn) {
        this.model.setNameOfKeyColumn(nameOfKeyColumn);
    }

    public String getUI() {
        return UI_ID;
    }

    public void addItem(String key, String text) {
        this.model.addItem(key, text);
    }

    public String getTextForKey(String key) {
        return this.model.getTextForKey(key);
    }

    public Iterator getKeys() {
        return this.model.getKeys();
    }

    public BreadCrumbSize getSize() {
        return this.size;
    }

    public void setSize(BreadCrumbSize size) {
        this.size = size;
    }

    public BreadCrumbBehavior getBehavior() {
        return this.behavior;
    }

    public void setBehavior(BreadCrumbBehavior behavior) {
        this.behavior = behavior;
    }

    public boolean requiresForm() {
        return this.onClick != null && this.onClick.length() > 0;
    }
}

