/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.Container;
import com.sapportals.htmlb.rendering.IPageContext;

public abstract class AbstractCompositeComponent
extends Component {
    private IPageContext pageContext = null;
    protected Container container = null;

    protected String createCompositeComponentId(String id) {
        return this.getId() + ">" + this.escape(id);
    }

    public abstract void buildComposition();

    public void preRender(IPageContext pc) {
        this.pageContext = pc;
        this.buildComposition();
        if (this.container != null) {
            this.container.preRender(pc);
        }
    }

    public void render(IPageContext pc) {
        this.pageContext = pc;
        pc.getParamIdForComponent(this);
        if (this.container == null) {
            this.buildComposition();
        }
        if (this.container != null) {
            this.container.render(pc);
        }
    }

    public IPageContext getPageContext() {
        return this.pageContext;
    }

    private String escape(String str) {
        StringBuffer es = new StringBuffer();
        char c = '\u0000';
        int len = 0;
        if (str != null && str.length() > 0) {
            if (str.indexOf(62) > 0 || str.indexOf(37) > 0) {
                len = str.length();
                int i = 0;
                while (i < len) {
                    c = str.charAt(i);
                    switch (c) {
                        case '%': 
                        case '>': {
                            es.append("%");
                            es.append(Integer.toHexString(c));
                            es.append("%");
                            break;
                        }
                        default: {
                            es.append(c);
                        }
                    }
                    ++i;
                }
            } else {
                return str;
            }
        }
        return es.toString();
    }

    public static String unEscape(String str) {
        StringBuffer es = new StringBuffer();
        char c = '\u0000';
        String value = null;
        int pos = 0;
        int len = 0;
        if (str != null && str.length() > 0) {
            if (str.indexOf(37) > 0) {
                len = str.length();
                int i = 0;
                while (i < len) {
                    c = str.charAt(i);
                    switch (c) {
                        case '%': {
                            pos = str.indexOf(37, i + 1);
                            if (pos == i + 3 && pos < len) {
                                value = str.substring(i + 1, pos);
                                try {
                                    c = (char)Integer.parseInt(value, 16);
                                    es.append(c);
                                    i = pos;
                                }
                                catch (NumberFormatException ex) {
                                    es.append(c);
                                }
                                break;
                            }
                            es.append(c);
                            break;
                        }
                        default: {
                            es.append(c);
                        }
                    }
                    ++i;
                }
            } else {
                return str;
            }
        }
        return es.toString();
    }
}

