/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.eclipse.wizards;

import com.sap.tc.jtools.jlint.eclipse.launch.EclipseResponse;
import com.sap.tc.jtools.jlint.eclipse.launch.JLinRunner;
import com.sap.tc.jtools.jlint.eclipse.launch.MetaMarkerManager;
import com.sap.tc.jtools.jlint.eclipse.util.ExceptionHandler;
import com.sap.tc.jtools.jlint.eclipse.util.ResponseTransformatorTool;
import com.sap.tc.jtools.jlint.eclipse.wizards.ResultImportPage;
import com.sap.tc.jtools.jlint.eclipse.wizards.TextKeyWizards;
import com.sap.tc.jtools.jtci.PerformResponse;
import com.sap.tc.jtools.jtci.exceptions.BadTreeException;
import com.sap.tc.jtools.jtci.exceptions.NestableRuntimeException;
import com.sap.tc.jtools.jtci.interfaces.ResultInterface;
import com.sap.tc.jtools.util.xml.XMLParseException;
import com.sap.tc.jtools.util.xml.XMLTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ResultImportWizard
extends Wizard
implements IImportWizard {
    private IStructuredSelection sel;
    private ResultImportPage mainPage = new ResultImportPage(TextKeyWizards.PAGE_NAME.getText(), TextKeyWizards.PAGE_TITLE.getText(), this.getImageDescriptor("wizban/import_wiz.gif"));

    public ResultImportWizard() {
        this.mainPage.setDescription(TextKeyWizards.IMPORT_WIZ_DESCR.getText());
        this.setNeedsProgressMonitor(true);
        this.setDefaultPageImageDescriptor(this.getImageDescriptor("wizban/import_wiz.gif"));
    }

    public boolean performFinish() {
        IWorkspaceRunnable op = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
                try {
                    ResultImportWizard.this.finishPage(monitor);
                }
                catch (BadTreeException e) {
                    throw new NestableRuntimeException((Throwable)e);
                }
                catch (IOException e) {
                    throw new NestableRuntimeException((Throwable)e);
                }
                catch (XMLParseException e) {
                    throw new NestableRuntimeException((Throwable)e);
                }
            }
        };
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)new WorkbenchRunnableAdapter(op));
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e);
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    protected void finishPage(IProgressMonitor monitor) throws BadTreeException, IOException, XMLParseException, CoreException {
        String resFileName = this.mainPage.getFileName();
        if (null == resFileName) {
            throw new IllegalArgumentException("resultfile is null");
        }
        File resultFile = new File(resFileName);
        if (!resultFile.isFile()) {
            throw new IllegalArgumentException("resultfile " + resFileName + " is not a file");
        }
        monitor.beginTask(TextKeyWizards.IMPORT_TASK_DESCR.getText(), 100);
        monitor.worked(1);
        try {
            if (this.mainPage.clearMarkers()) {
                this.deleteJLinMarkers(this.mainPage.getProject());
            }
            PerformResponse response = this.readResponse(resultFile);
            monitor.worked(9);
            EclipseResponse[] transformedResponses = ResponseTransformatorTool.transform(response, this.mainPage.getProject(), (IProgressMonitor)new SubProgressMonitor(monitor, 80));
            MetaMarkerManager markerManager = new MetaMarkerManager(new Object[]{this.mainPage.getProject()}, transformedResponses);
            markerManager.createMarkers();
            monitor.worked(10);
            JLinRunner.showTasksView();
            this.showFinishedMessage(response, markerManager);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    private void deleteJLinMarkers(IProject project) throws CoreException {
        project.deleteMarkers(MetaMarkerManager.JLIN_MARKER_ID, true, 2);
    }

    private void showFinishedMessage(PerformResponse response, MetaMarkerManager manager) {
        int totalCreatedMsgCount = manager.getPrioHighCount() + manager.getPrioLowCount() + manager.getPrioNormalCount();
        ResultInterface[] results = response.getResults();
        int totalMsgCount = 0;
        int i = 0;
        while (i < results.length) {
            int prio = results[i].getPriority();
            if (prio >= 1 && prio <= 3) {
                ++totalMsgCount;
            }
            ++i;
        }
        int notFound = totalMsgCount - totalCreatedMsgCount;
        boolean warnNotFound = notFound > 0;
        final String msg = TextKeyWizards.IMPORT_FINISH_MSG.getFormattedText(new String[]{String.valueOf(totalCreatedMsgCount), String.valueOf(notFound)});
        final String title = TextKeyWizards.IMPORT_FINISH_TITLE.getText();
        final Display dsp = Display.getDefault();
        if (dsp != null) {
            Runnable runnable = warnNotFound ? new Runnable(){

                public void run() {
                    MessageDialog.openWarning((Shell)dsp.getActiveShell(), (String)title, (String)msg);
                }
            } : new Runnable(){

                public void run() {
                    MessageDialog.openInformation((Shell)dsp.getActiveShell(), (String)title, (String)msg);
                }
            };
            dsp.asyncExec(runnable);
        }
    }

    private PerformResponse readResponse(File resultFile) throws BadTreeException, IOException, XMLParseException {
        BufferedReader fileReader = null;
        PerformResponse response = null;
        try {
            fileReader = new BufferedReader(new FileReader(resultFile));
            response = new PerformResponse(XMLTool.parseReader((Reader)fileReader));
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                if (fileReader != null) {
                    ((Reader)fileReader).close();
                }
            }
            catch (IOException e) {
                ExceptionHandler.handle(e);
            }
            throw throwable;
        }
        try {
            if (fileReader != null) {
                ((Reader)fileReader).close();
            }
        }
        catch (IOException e) {
            ExceptionHandler.handle(e);
        }
        return response;
    }

    public void addPages() {
        super.addPages();
        this.mainPage.setWizard((IWizard)this);
        this.mainPage.setSelection(this.sel);
        this.addPage((IWizardPage)this.mainPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.sel = selection;
    }

    private ImageDescriptor getImageDescriptor(String relativePath) {
        String iconPath = "icons/full/";
        try {
            AbstractUIPlugin plugin = (AbstractUIPlugin)Platform.getPlugin((String)"org.eclipse.ui");
            URL installURL = plugin.getDescriptor().getInstallURL();
            URL url = new URL(installURL, iconPath + relativePath);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

