/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.eclipse.wizards;

import com.sap.tc.jtools.jlint.eclipse.JlinPlugin;
import com.sap.tc.jtools.jlint.eclipse.wizards.TextKeyWizards;
import com.sap.tc.jtools.jtci.PerformResponse;
import com.sap.tc.jtools.jtci.exceptions.BadTreeException;
import com.sap.tc.jtools.util.xml.XMLParseException;
import com.sap.tc.jtools.util.xml.XMLTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.internal.ui.SWTUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ResultImportPage
extends WizardPage {
    Text fImportText;
    Button fBrowseButton;
    Combo fProjectCombo;
    Button fProjectButton;
    Button fClearProblemsButton;
    private IProject[] allProjs;
    private String defaultProjName;
    private String defaultFileName;
    private boolean isProjectValid = false;
    private boolean isResultFileValid = false;

    public boolean isPageComplete() {
        return this.isProjectValid && this.isResultFileValid;
    }

    public ResultImportPage(String pageName) {
        super(pageName);
        this.setPageComplete(false);
        this.allProjs = this.getAccessibleProjects();
    }

    private IProject[] getAccessibleProjects() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> accessibleProjs = new ArrayList<IProject>();
        int i = 0;
        while (i < projects.length) {
            if (projects[i].isAccessible()) {
                accessibleProjs.add(projects[i]);
            }
            ++i;
        }
        return accessibleProjs.toArray(new IProject[0]);
    }

    public ResultImportPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setPageComplete(false);
        this.allProjs = this.getAccessibleProjects();
    }

    public void createControl(Composite parent) {
        Composite base = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 2;
        base.setLayout((Layout)topLayout);
        Label importFileLabel = new Label(base, 0);
        importFileLabel.setText(TextKeyWizards.IMPORT_LABEL.getText());
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        importFileLabel.setLayoutData((Object)gd);
        this.fImportText = new Text(base, 2048);
        this.fImportText.setLayoutData((Object)new GridData(768));
        this.fImportText.setToolTipText(TextKeyWizards.IMPORT_TOOLTIP.getText());
        if (this.defaultFileName != null) {
            this.fImportText.setText(this.defaultFileName);
        }
        this.fBrowseButton = new Button(base, 0);
        this.fBrowseButton.setText(TextKeyWizards.BROWSE_LABEL.getText());
        this.setButtonGridData(this.fBrowseButton);
        Label projLabel = new Label(base, 0);
        projLabel.setText(TextKeyWizards.PROJECT_LABEL.getText());
        gd = new GridData();
        gd.horizontalSpan = 2;
        projLabel.setLayoutData((Object)gd);
        this.fProjectCombo = new Combo(base, 12);
        int i = 0;
        while (i < this.allProjs.length) {
            String projName = this.allProjs[i].getName();
            this.fProjectCombo.add(projName);
            if (projName.equals(this.defaultProjName)) {
                this.fProjectCombo.select(i);
            }
            ++i;
        }
        this.fProjectCombo.setLayoutData((Object)new GridData(768));
        this.fProjectCombo.setToolTipText(TextKeyWizards.PROJECT_TOOLTIP.getText());
        this.fClearProblemsButton = new Button(base, 32);
        this.fClearProblemsButton.setText(TextKeyWizards.CLEAR_ALL_PROBLEMS_LABEL.getText());
        this.fClearProblemsButton.setSelection(true);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fClearProblemsButton.setLayoutData((Object)gd);
        this.setControl((Control)base);
        SelectionAdapter sl = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(JlinPlugin.getActiveWorkbenchShell());
                String initialFile = ResultImportPage.this.fImportText.getText();
                if (initialFile != null) {
                    fd.setFileName(initialFile.replace('\\', File.separatorChar).replace('/', File.separatorChar));
                }
                fd.setFilterExtensions(new String[]{"*.xml"});
                fd.setText(TextKeyWizards.IMPORT_LABEL.getText());
                String fileName = fd.open();
                if (fileName != null) {
                    ResultImportPage.this.fImportText.setText(fileName);
                }
            }
        };
        this.fBrowseButton.addSelectionListener((SelectionListener)sl);
        this.fImportText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                ResultImportPage.this.fImportText.update();
                ResultImportPage.this.updateResultFileValid();
                ResultImportPage.this.updateProjectValid();
                ResultImportPage.this.updateErrorMessage();
                ResultImportPage.super.getContainer().updateButtons();
            }
        });
        this.fProjectCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                ResultImportPage.this.fProjectCombo.update();
                ResultImportPage.this.updateProjectValid();
                ResultImportPage.this.updateErrorMessage();
                ResultImportPage.super.getContainer().updateButtons();
            }
        });
        this.updateProjectValid();
        this.updateResultFileValid();
        this.updateErrorMessage();
    }

    public String getFileName() {
        return this.fImportText.getText();
    }

    public IProject getProject() {
        return this.allProjs[this.fProjectCombo.getSelectionIndex()];
    }

    public boolean clearMarkers() {
        return this.fClearProblemsButton.getSelection();
    }

    public void setSelection(IStructuredSelection sel) {
        Object firstSelectedObject = sel.getFirstElement();
        if (firstSelectedObject instanceof IResource) {
            IResource resource = (IResource)firstSelectedObject;
            this.defaultProjName = resource.getProject().getName();
            IPath path = resource.getLocation();
            if (path != null) {
                this.defaultFileName = path.toOSString();
            }
        }
    }

    private void updateProjectValid() {
        if (this.fProjectCombo.getSelectionIndex() < 0) {
            this.setErrorMessage(TextKeyWizards.MISSING_PROJECT_MSG.getText());
            this.isProjectValid = false;
        } else {
            this.isProjectValid = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateResultFileValid() {
        BufferedReader fileReader;
        block16: {
            String fileName = this.fImportText.getText();
            if (fileName == null) {
                this.setErrorMessage(TextKeyWizards.MISSING_FILE_MSG.getText());
                this.isResultFileValid = false;
                return;
            }
            File resultsFile = new File(fileName);
            if (!resultsFile.isFile()) {
                this.setErrorMessage(TextKeyWizards.NOT_EXISTING_FILE_MSG.getText());
                this.isResultFileValid = false;
                return;
            }
            fileReader = null;
            PerformResponse response = null;
            try {
                try {
                    fileReader = new BufferedReader(new FileReader(resultsFile));
                    response = new PerformResponse(XMLTool.parseReader((Reader)fileReader));
                    if (response.getName() != null || response.getResults().length != 0) break block16;
                    this.setErrorMessage(TextKeyWizards.INVALID_RESULT_FILE_MSG.getText());
                    this.isResultFileValid = false;
                    Object var9_5 = null;
                    if (fileReader == null) return;
                }
                catch (BadTreeException e) {
                    this.setErrorMessage(TextKeyWizards.INVALID_RESULT_FILE_MSG.getText());
                    this.isResultFileValid = false;
                    Object var9_7 = null;
                    if (fileReader == null) return;
                    try {
                        ((Reader)fileReader).close();
                        return;
                    }
                    catch (IOException e1) {
                        this.setErrorMessage(TextKeyWizards.INVALID_RESULT_FILE_MSG.getText());
                        this.isResultFileValid = false;
                        return;
                    }
                }
                catch (IOException e) {
                    this.setErrorMessage(TextKeyWizards.INVALID_RESULT_FILE_MSG.getText());
                    this.isResultFileValid = false;
                    Object var9_8 = null;
                    if (fileReader == null) return;
                    try {}
                    catch (IOException e1) {
                        this.setErrorMessage(TextKeyWizards.INVALID_RESULT_FILE_MSG.getText());
                        this.isResultFileValid = false;
                        return;
                    }
                    ((Reader)fileReader).close();
                    return;
                }
                catch (XMLParseException e) {
                    this.setErrorMessage(TextKeyWizards.INVALID_RESULT_FILE_MSG.getText());
                    this.isResultFileValid = false;
                    Object var9_9 = null;
                    if (fileReader == null) return;
                    try {}
                    catch (IOException e1) {
                        this.setErrorMessage(TextKeyWizards.INVALID_RESULT_FILE_MSG.getText());
                        this.isResultFileValid = false;
                        return;
                    }
                    ((Reader)fileReader).close();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (fileReader == null) throw throwable;
                try {}
                catch (IOException e1) {
                    this.setErrorMessage(TextKeyWizards.INVALID_RESULT_FILE_MSG.getText());
                    this.isResultFileValid = false;
                    return;
                }
                ((Reader)fileReader).close();
                throw throwable;
            }
            try {}
            catch (IOException e1) {
                this.setErrorMessage(TextKeyWizards.INVALID_RESULT_FILE_MSG.getText());
                this.isResultFileValid = false;
                return;
            }
            ((Reader)fileReader).close();
            return;
        }
        Object var9_6 = null;
        if (fileReader != null) {
            try {}
            catch (IOException e1) {
                this.setErrorMessage(TextKeyWizards.INVALID_RESULT_FILE_MSG.getText());
                this.isResultFileValid = false;
                return;
            }
            ((Reader)fileReader).close();
        }
        this.isResultFileValid = true;
    }

    private void updateErrorMessage() {
        if (this.isResultFileValid && this.isProjectValid) {
            this.setErrorMessage(null);
        }
    }

    private void setButtonGridData(Button button) {
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        button.setLayoutData((Object)data);
        SWTUtil.setButtonDimensionHint((Button)button);
    }
}

