/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.eclipse.validator;

import com.sap.tc.jtools.jlint.Result;
import com.sap.tc.jtools.jlint.eclipse.launch.EclipseResponse;
import com.sap.tc.jtools.jlint.eclipse.launch.JLinRunner;
import com.sap.tc.jtools.jlint.eclipse.launch.MetaMarkerManager;
import com.sap.tc.jtools.jlint.eclipse.launch.MetaRequestManager;
import com.sap.tc.jtools.jlint.eclipse.util.JLinSetupCache;
import com.sap.tc.jtools.jlint.eclipse.validator.ValidationResult;
import com.sap.tc.jtools.jtci.Test;
import com.sap.tc.jtools.jtci.TestTree;
import com.sap.tc.jtools.jtci.TestTreeNode;
import com.sap.tc.jtools.jtci.exceptions.PerformException;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;
import com.sap.tc.jtools.jtci.interfaces.ResultInterface;
import com.sap.tc.jtools.jtci.interfaces.TestDescriptionInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;

public class Validator {
    private static Map requestCache = new HashMap();

    public static ValidationResult validate(Object[] testObjects) throws PerformException {
        return Validator.validate(testObjects, null, null);
    }

    public static ValidationResult validate(String sessionID, IProgressMonitor monitor) throws PerformException {
        return Validator.validate(sessionID, (MetaRequestManager)requestCache.get(sessionID), monitor);
    }

    public static ValidationResult validate(Object[] testObjects, String[] testGroups, IProgressMonitor monitor) throws PerformException {
        String sessionID = Long.toString(System.currentTimeMillis());
        Test[] tests = Validator.getTests(testGroups);
        MetaRequestManager requestManager = new MetaRequestManager(tests, testObjects);
        requestCache.put(sessionID, requestManager);
        return Validator.validate(sessionID, requestManager, monitor);
    }

    private static ValidationResult validate(String sessionID, MetaRequestManager requestManager, IProgressMonitor monitor) {
        JLinRunner runner = new JLinRunner(requestManager, monitor, null, null);
        runner.run();
        EclipseResponse[] responses = runner.getResponses();
        ArrayList<ResultInterface> results = new ArrayList<ResultInterface>();
        int i = 0;
        while (i < responses.length) {
            ResultInterface[] res = responses[i].getResponse().getResults();
            results.addAll(Arrays.asList(res));
            ++i;
        }
        ResultInterface[] resultArray = (ResultInterface[])results.toArray(new Result[results.size()]);
        HashMap<Object, ArrayList<ResultInterface>> object2Results = new HashMap<Object, ArrayList<ResultInterface>>();
        int i2 = 0;
        while (i2 < resultArray.length) {
            Object selection = requestManager.getObject(resultArray[i2]);
            if (selection != null) {
                ArrayList<ResultInterface> resultsForThisObject = (ArrayList<ResultInterface>)object2Results.get(selection);
                if (resultsForThisObject == null) {
                    resultsForThisObject = new ArrayList<ResultInterface>();
                    object2Results.put(selection, resultsForThisObject);
                }
                resultsForThisObject.add(resultArray[i2]);
            }
            ++i2;
        }
        IMarker[] markers = null;
        MetaMarkerManager markerManager = runner.getMarkerManager();
        if (markerManager != null) {
            markers = markerManager.getMarkers();
        }
        return new ValidationResult(sessionID, resultArray, markers, object2Results);
    }

    private static Test[] getTests(String[] testGroups) {
        int i;
        TestDescriptionInterface[] tdiArray;
        TestTree testTree = JLinSetupCache.getDispatcher().getTestTree();
        if (testGroups == null) {
            tdiArray = testTree.getAllLeaves();
        } else {
            ArrayList testList = new ArrayList();
            i = 0;
            while (i < testGroups.length) {
                StringTokenizer tokenizer = new StringTokenizer(testGroups[i], "/");
                testList.addAll(Validator.getTests(tokenizer, testTree));
                ++i;
            }
            tdiArray = testList.toArray(new TestDescriptionInterface[testList.size()]);
        }
        ArrayList<Test> outList = new ArrayList<Test>();
        i = 0;
        while (i < tdiArray.length) {
            if (Validator.isComplete(tdiArray[i])) {
                outList.add(new Test(tdiArray[i].getName(), tdiArray[i].getInputParameters()));
            }
            ++i;
        }
        return outList.toArray(new Test[outList.size()]);
    }

    private static List getTests(StringTokenizer tokenizer, TestTree tree) {
        if (!tokenizer.hasMoreTokens()) {
            ArrayList<TestDescriptionInterface> out = new ArrayList<TestDescriptionInterface>();
            TestDescriptionInterface[] descriptions = tree.getAllLeaves();
            int i = 0;
            while (i < descriptions.length) {
                out.add(descriptions[i]);
                ++i;
            }
            return out;
        }
        String currentToken = tokenizer.nextToken();
        TestTreeNode[] nodes = tree.getNodes();
        int i = 0;
        while (i < nodes.length) {
            if (nodes[i].getNodeType() == 2 && ((TestTree)nodes[i]).getName().equals(currentToken)) {
                return Validator.getTests(tokenizer, (TestTree)nodes[i]);
            }
            ++i;
        }
        return new ArrayList();
    }

    private static boolean isComplete(TestDescriptionInterface testDescription) {
        ParameterInterface[] params = testDescription.getInputParameters();
        int i = 0;
        while (i < params.length) {
            if (params[i].getValue() == null) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

