/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.eclipse.util;

import com.sap.tc.jtools.jlint.eclipse.ExtensionManager;
import com.sap.tc.jtools.jlint.eclipse.extension.EclipseModule;
import com.sap.tc.jtools.jlint.eclipse.launch.EclipseResponse;
import com.sap.tc.jtools.jlint.eclipse.wizards.EclipseRequestAdapter;
import com.sap.tc.jtools.jtci.PerformResponse;
import com.sap.tc.jtools.jtci.interfaces.ResultInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;

public class ResponseTransformatorTool {
    private static ExtensionManager manager = ExtensionManager.getExtensionManager();

    private ResponseTransformatorTool() {
    }

    public static EclipseResponse[] transform(PerformResponse response, IProject correspondingProject) {
        return ResponseTransformatorTool.transform(response, correspondingProject, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EclipseResponse[] transform(PerformResponse response, IProject correspondingProject, IProgressMonitor monitor) {
        HashMap<EclipseModule, ArrayList<ResultInterface>> module2ResultsMap = new HashMap<EclipseModule, ArrayList<ResultInterface>>();
        ResultInterface[] results = response.getResults();
        int i = 0;
        while (i < results.length) {
            EclipseModule module = manager.getModuleForTestObjectType(results[i].getTestObjectType());
            if (module != null) {
                ArrayList<ResultInterface> resultList = (ArrayList<ResultInterface>)module2ResultsMap.get((Object)module);
                if (resultList == null) {
                    resultList = new ArrayList<ResultInterface>();
                    module2ResultsMap.put(module, resultList);
                }
                resultList.add(results[i]);
            }
            ++i;
        }
        Set entries = module2ResultsMap.entrySet();
        ArrayList<EclipseResponse> eclipseResponseList = new ArrayList<EclipseResponse>(entries.size());
        if (monitor != null) {
            monitor.beginTask("Transforming results", entries.size());
        }
        try {
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                if (monitor != null) {
                    monitor.worked(1);
                }
                Map.Entry entry = iter.next();
                List resultList = (List)entry.getValue();
                PerformResponse newResponse = new PerformResponse("");
                Iterator iterator = resultList.iterator();
                while (iterator.hasNext()) {
                    newResponse.addResult((ResultInterface)iterator.next());
                }
                EclipseRequestAdapter dummyRequest = new EclipseRequestAdapter(correspondingProject, (EclipseModule)((Object)entry.getKey()));
                eclipseResponseList.add(new EclipseResponse(dummyRequest, newResponse));
            }
            Object var15_14 = null;
            if (monitor == null) return eclipseResponseList.toArray(new EclipseResponse[0]);
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            if (monitor == null) throw throwable;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return eclipseResponseList.toArray(new EclipseResponse[0]);
    }
}

