/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.eclipse.util;

import com.sap.tc.jtools.jlint.eclipse.JlinPlugin;
import com.sap.tc.jtools.jlint.eclipse.util.TextKeyUtil;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class ExceptionHandler {
    private ExceptionHandler() {
    }

    public static void handle(final Throwable pThrowable, final String pTitle, final String pInfo) {
        if (pThrowable instanceof ThreadDeath) {
            throw (ThreadDeath)pThrowable;
        }
        if (pThrowable instanceof InterruptedException) {
            return;
        }
        if (null == pThrowable) {
            ExceptionHandler.debuglog(pThrowable);
        }
        JlinPlugin.log(pThrowable);
        Runnable runnable = new Runnable(){

            public void run() {
                MessageBox box = new MessageBox(new Shell(), 131329);
                box.setText(pTitle);
                if (null == pThrowable) {
                    box.setMessage(pInfo);
                } else {
                    String msg = pThrowable.getMessage();
                    if (msg == null) {
                        msg = "";
                    }
                    box.setMessage(pInfo + msg);
                }
                box.open();
            }
        };
        Display dsp = Display.getDefault();
        if (dsp != null) {
            dsp.asyncExec(runnable);
        } else {
            System.err.println(pInfo + pThrowable.getMessage());
        }
    }

    public static void handle(Throwable t) {
        JlinPlugin.log(t);
        ExceptionHandler.handle(t, TextKeyUtil.ERROR_SHOW_TITLE.getText(), TextKeyUtil.ERROR_SHOW_MESSAGE.getFormattedText(new String[]{t.toString(), Platform.getLogFileLocation().toString()}));
    }

    private static void debuglog(Throwable t) {
        if (JlinPlugin.inDebugMode()) {
            try {
                JlinPlugin.log(t);
            }
            catch (Throwable bad) {
                System.err.println("Error during logging exception");
                bad.printStackTrace();
            }
        }
    }
}

