/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.eclipse.launch;

import com.sap.tc.jtools.jlint.eclipse.ExtensionManager;
import com.sap.tc.jtools.jlint.eclipse.extension.EclipseModule;
import com.sap.tc.jtools.jlint.eclipse.extension.IRequestCreator;
import com.sap.tc.jtools.jlint.eclipse.extension.ISelectionHandler;
import com.sap.tc.jtools.jlint.eclipse.launch.EclipseRequest;
import com.sap.tc.jtools.jlint.eclipse.launch.TextKeyLaunch;
import com.sap.tc.jtools.jlint.extension.Module;
import com.sap.tc.jtools.jtci.Test;
import com.sap.tc.jtools.jtci.TestObjectPosition;
import com.sap.tc.jtools.jtci.interfaces.ResultInterface;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class MetaRequestManager {
    private ExtensionManager extensionManager = ExtensionManager.getExtensionManager();
    private List requests = null;
    private List requestCreators = new ArrayList();
    private Object[] selectedObjects;
    private Test[] tests;
    private Map data2handler = new HashMap();

    public MetaRequestManager(Test[] tests, Object[] selectedObjects) {
        this.init(tests, selectedObjects);
    }

    private void init(Test[] tests, Object[] selectedObjects) {
        this.tests = tests;
        ISelectionHandler[] handlers = this.extensionManager.getSelectionHandlers();
        HashMap<ISelectionHandler, HashSet<Object>> handler2ObjectMap = new HashMap<ISelectionHandler, HashSet<Object>>();
        ArrayList<Object> noHandlerObjects = new ArrayList<Object>();
        int i = 0;
        while (i < selectedObjects.length) {
            boolean handlerFound = false;
            int j = 0;
            while (j < handlers.length) {
                if (handlers[j].canHandleObject(selectedObjects[i])) {
                    handlerFound = true;
                    HashSet<Object> objects = (HashSet<Object>)handler2ObjectMap.get(handlers[j]);
                    if (objects == null) {
                        objects = new HashSet<Object>();
                        handler2ObjectMap.put(handlers[j], objects);
                    }
                    objects.add(selectedObjects[i]);
                    break;
                }
                ++j;
            }
            if (!handlerFound) {
                noHandlerObjects.add(selectedObjects[i]);
            }
            ++i;
        }
        this.selectedObjects = selectedObjects;
        Module[] mods = this.extensionManager.getTestProvider().getModules();
        int i2 = 0;
        while (i2 < mods.length) {
            EclipseModule currentModule = (EclipseModule)mods[i2];
            IRequestCreator reqCr = currentModule.getRequestCreator();
            reqCr.reset();
            this.requestCreators.add(reqCr);
            Test[] moduleTests = this.pickTestsFromModule(tests, currentModule);
            if (moduleTests.length != 0) {
                Set handlerKeys = handler2ObjectMap.keySet();
                Iterator iter = handlerKeys.iterator();
                while (iter.hasNext()) {
                    ISelectionHandler handler = (ISelectionHandler)iter.next();
                    Set objs = (Set)handler2ObjectMap.get(handler);
                    handler.setSelection(objs.toArray());
                    Object[] data = handler.getData();
                    int j = 0;
                    while (j < data.length) {
                        this.data2handler.put(data[j], handler);
                        ++j;
                    }
                    reqCr.addData(data);
                    reqCr.addMetaData(handler.getMetaData());
                }
                reqCr.addData(noHandlerObjects.toArray());
            }
            ++i2;
        }
    }

    private Test[] pickTestsFromModule(Test[] tests, EclipseModule module) {
        ArrayList<Test> testList = new ArrayList<Test>();
        int i = 0;
        while (i < tests.length) {
            if (module.hasTest(tests[i].getName())) {
                testList.add(tests[i]);
            }
            ++i;
        }
        return testList.toArray(new Test[0]);
    }

    public EclipseRequest[] getRequests() {
        if (this.requests == null) {
            this.fillRequests();
        }
        return this.requests.toArray(new EclipseRequest[0]);
    }

    public Object[] getSelectedObjects() {
        return this.selectedObjects;
    }

    public int testObjectCount() {
        if (this.requests == null) {
            this.fillRequests();
        }
        int no = 0;
        Iterator iter = this.requests.iterator();
        while (iter.hasNext()) {
            EclipseRequest req = (EclipseRequest)iter.next();
            no += req.testObjectCount();
        }
        return no;
    }

    public void persistRequests(File dir) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(dir.getAbsolutePath() + " is not a directory");
        }
        if (this.requests == null) {
            this.fillRequests();
        }
        int i = 0;
        Iterator iter = this.requests.iterator();
        while (iter.hasNext()) {
            EclipseRequest request = (EclipseRequest)iter.next();
            String projectName = request.getProject().getName();
            request.saveTo(new File(dir, "request_" + projectName + "_" + String.valueOf(i) + ".xml"));
            ++i;
        }
    }

    public static void warnNoSources() {
        final Display dsp = Display.getDefault();
        if (dsp != null) {
            Runnable runnable = new Runnable(){

                public void run() {
                    MessageDialog.openWarning((Shell)new Shell(dsp), (String)TextKeyLaunch.NO_SOURCES_TITLE.getText(), (String)TextKeyLaunch.NO_SOURCES_MSG.getText());
                }
            };
            dsp.asyncExec(runnable);
        }
    }

    public static void warnProjectsOutOfSync(String[] projectNames) {
        final Display dsp = Display.getDefault();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < projectNames.length) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(projectNames[i]);
            ++i;
        }
        final String projectList = buf.toString();
        if (dsp != null) {
            Runnable runnable = new Runnable(){

                public void run() {
                    MessageDialog.openWarning((Shell)new Shell(dsp), (String)TextKeyLaunch.PROJECTS_OUT_OF_SYNC_TITLE.getText(), (String)TextKeyLaunch.PROJECTS_OUT_OF_SYNC_MSG.getFormattedText(projectList));
                }
            };
            dsp.asyncExec(runnable);
        }
    }

    public Object getObject(ResultInterface result) {
        ISelectionHandler handler;
        String toID = result.getTestObjectID();
        TestObjectPosition top = result.getResultPosition();
        Object data = null;
        Iterator iter = this.requestCreators.iterator();
        while (iter.hasNext()) {
            IRequestCreator rc = (IRequestCreator)iter.next();
            data = rc.getData(toID, top);
            if (data != null) break;
        }
        if ((handler = (ISelectionHandler)this.data2handler.get(data)) == null) {
            return data;
        }
        return handler.getSelection(data);
    }

    public String[] getOutOfSyncProjectNames() {
        int i;
        HashSet<IProject> outOfSyncProjects = new HashSet<IProject>();
        Iterator iter = this.requestCreators.iterator();
        while (iter.hasNext()) {
            IRequestCreator reqCr = (IRequestCreator)iter.next();
            IResource[] resources = reqCr.getResources();
            i = 0;
            while (i < resources.length) {
                outOfSyncProjects.add(resources[i].getProject());
                ++i;
            }
        }
        Iterator iter2 = outOfSyncProjects.iterator();
        while (iter2.hasNext()) {
            IProject project = (IProject)iter2.next();
            if (!project.isSynchronized(2)) continue;
            iter2.remove();
        }
        String[] outOfSyncNames = new String[outOfSyncProjects.size()];
        i = 0;
        Iterator iter3 = outOfSyncProjects.iterator();
        while (iter3.hasNext()) {
            outOfSyncNames[i] = ((IProject)iter3.next()).getName();
            ++i;
        }
        return outOfSyncNames;
    }

    private void fillRequests() {
        this.requests = new ArrayList();
        Module[] mods = this.extensionManager.getTestProvider().getModules();
        int i = 0;
        while (i < mods.length) {
            EclipseModule currentModule = (EclipseModule)mods[i];
            IRequestCreator reqCr = currentModule.getRequestCreator();
            Test[] moduleTests = this.pickTestsFromModule(this.tests, currentModule);
            if (moduleTests.length != 0) {
                EclipseRequest[] moduleRequests = reqCr.createRequests(moduleTests);
                int k = 0;
                while (k < moduleRequests.length) {
                    moduleRequests[k].setModule(currentModule);
                    ++k;
                }
                this.requests.addAll(Arrays.asList(moduleRequests));
            }
            ++i;
        }
    }
}

