/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.eclipse.launch;

import com.sap.tc.jtools.jlint.eclipse.ExtensionManager;
import com.sap.tc.jtools.jlint.eclipse.JlinPlugin;
import com.sap.tc.jtools.jlint.eclipse.extension.IMarkerManager;
import com.sap.tc.jtools.jlint.eclipse.extension.IMarkerPosition;
import com.sap.tc.jtools.jlint.eclipse.launch.EclipseResponse;
import com.sap.tc.jtools.jlint.eclipse.launch.TextKeyLaunch;
import com.sap.tc.jtools.jlint.eclipse.util.ExceptionHandler;
import com.sap.tc.jtools.jlint.eclipse.util.JLinSetupCache;
import com.sap.tc.jtools.jtci.Dispatcher;
import com.sap.tc.jtools.jtci.interfaces.ResultInterface;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

public class MetaMarkerManager
implements IWorkspaceRunnable {
    public static final String JLIN_MARKER_ID = JlinPlugin.getPluginId() + ".jlin_marker";
    private ExtensionManager extensionManager = ExtensionManager.getExtensionManager();
    private int highCount = 0;
    private int normalCount = 0;
    private int lowCount = 0;
    private List markerList = new ArrayList();
    public static final String ATTR_TEST_NAME = "jlin.test";
    private Object[] selectedObjects;
    private EclipseResponse[] responses;

    public int getPrioHighCount() {
        return this.highCount;
    }

    public int getPrioLowCount() {
        return this.lowCount;
    }

    public int getPrioNormalCount() {
        return this.normalCount;
    }

    public MetaMarkerManager(Object[] selectedObjects, EclipseResponse[] responses) {
        this.selectedObjects = selectedObjects;
        this.responses = responses;
    }

    private void clearJlinMarkers() {
        int i = 0;
        while (i < this.responses.length) {
            IResource[] resources = this.responses[i].getRequest().getModule().getRequestCreator().getResources();
            this.clearMarkersFor(resources);
            ++i;
        }
    }

    private void clearMarkersFor(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            if (resources[i] != null && resources[i].exists() && resources[i].getProject().isOpen()) {
                try {
                    resources[i].deleteMarkers(JLIN_MARKER_ID, true, 2);
                    resources[i].getProject().deleteMarkers(JLIN_MARKER_ID, true, 0);
                }
                catch (CoreException ce) {
                    // empty catch block
                }
            }
            ++i;
        }
        this.markerList = new ArrayList();
    }

    private void createJlinMarkers() {
        int i = 0;
        while (i < this.responses.length) {
            IMarkerManager markerMan = this.responses[i].getRequest().getModule().getMarkerManager();
            IProject correspondingProject = this.responses[i].getRequest().getProject();
            Dispatcher dispatcher = JLinSetupCache.getDispatcher();
            ResultInterface[] results = this.responses[i].getResponse().getResults();
            int j = 0;
            while (j < results.length) {
                IMarkerPosition pos = markerMan.getMarkerPosition(results[j].getResultPosition(), correspondingProject);
                if (pos != null) {
                    this.createMarker(pos, results[j]);
                }
                ++j;
            }
            ++i;
        }
    }

    private void createMarker(IMarkerPosition pos, ResultInterface result) {
        int prio = result.getPriority();
        if (prio < 1 || prio > 3) {
            return;
        }
        IMarker marker = null;
        try {
            marker = pos.getResource().createMarker(JLIN_MARKER_ID);
            prio = this.mapMarkerPrio(result);
            this.updatePrioCount(prio);
            marker.setAttribute("priority", prio);
            int line = pos.getLine();
            if (line > -1) {
                marker.setAttribute("lineNumber", line);
            }
            marker.setAttribute(ATTR_TEST_NAME, (Object)result.getTestName());
            marker.setAttribute("message", (Object)this.createErrorMsg(result));
            this.markerList.add(marker);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e);
        }
    }

    private void updatePrioCount(int prio) {
        switch (prio) {
            case 0: {
                ++this.lowCount;
                break;
            }
            case 1: {
                ++this.normalCount;
                break;
            }
            case 2: {
                ++this.highCount;
            }
        }
    }

    private int mapMarkerPrio(ResultInterface result) {
        switch (result.getPriority()) {
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
        }
        return 0;
    }

    private String createErrorMsg(ResultInterface result) {
        StringBuffer msg = new StringBuffer();
        msg.append("JLin ");
        msg.append(result.getTestName());
        msg.append(": ");
        msg.append(result.getErrorText());
        return msg.toString();
    }

    public void createMarkers() {
        try {
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)this, null);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e);
        }
    }

    public void run(IProgressMonitor monitor) {
        this.clearJlinMarkers();
        this.createJlinMarkers();
    }

    public void showFinishDialog(int filesChecked) {
        int totalCount = this.lowCount + this.normalCount + this.highCount;
        final String text = TextKeyLaunch.FINISH_MSG.getFormattedText(new String[]{String.valueOf(filesChecked), String.valueOf(totalCount), String.valueOf(this.highCount), String.valueOf(this.normalCount), String.valueOf(this.lowCount)});
        final String title = TextKeyLaunch.FINISH_TITLE.getText();
        final String[] labels = new String[]{IDialogConstants.CLOSE_LABEL};
        final int type = totalCount == 0 ? 2 : 4;
        Runnable runnable = new Runnable(){

            public void run() {
                new MessageDialog(null, title, null, text, type, labels, 0).open();
            }
        };
        Display dsp = Display.getDefault();
        if (dsp != null) {
            dsp.syncExec(runnable);
        }
    }

    public IMarker[] getMarkers() {
        return this.markerList.toArray(new IMarker[this.markerList.size()]);
    }
}

