/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.eclipse.launch;

import com.sap.tc.jtools.jlint.eclipse.JlinPlugin;
import com.sap.tc.jtools.jlint.eclipse.config.JLinPreferencePage;
import com.sap.tc.jtools.jlint.eclipse.config.TestSetTool;
import com.sap.tc.jtools.jlint.eclipse.launch.AbstractLaunchConfigTab;
import com.sap.tc.jtools.jlint.eclipse.launch.MetaRequestManager;
import com.sap.tc.jtools.jlint.eclipse.launch.TextKeyLaunch;
import com.sap.tc.jtools.jlint.eclipse.launch.VariantSelection;
import com.sap.tc.jtools.jtci.TestSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class LaunchTab
extends AbstractLaunchConfigTab
implements IJavaLaunchConfigurationConstants {
    public static final String CONTAINER_ATTR = JlinPlugin.getPluginId() + ".container";
    public static final String ATTR_TESTSET_NAME = JlinPlugin.getPluginId() + ".testsetname";
    private final ILabelProvider fJavaElementLabelProvider = new JavaElementLabelProvider(1088);
    private Text fContainerText;
    private Button fContainerButton;
    private IJavaElement fContainerElement;
    private Text fVariantText;
    private Button fVariantButton;
    static /* synthetic */ Class class$org$eclipse$jdt$core$IPackageFragmentRoot;
    static /* synthetic */ Class class$org$eclipse$jdt$core$IJavaProject;
    static /* synthetic */ Class class$org$eclipse$jdt$core$IPackageFragment;
    static /* synthetic */ Class class$org$eclipse$jdt$core$ICompilationUnit;
    static /* synthetic */ Class class$org$eclipse$jdt$core$IJavaModel;

    public void createControl(Composite parent) {
        Composite base = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 2;
        base.setLayout((Layout)topLayout);
        Label projLabel = new Label(base, 0);
        projLabel.setText(TextKeyLaunch.CONTAINER_LABEL.getText());
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        projLabel.setLayoutData((Object)gd);
        this.fContainerText = new Text(base, 2056);
        this.fContainerText.setLayoutData((Object)new GridData(768));
        this.fContainerText.setToolTipText(TextKeyLaunch.CONTAINER_TOOLTIP.getText());
        this.fContainerButton = new Button(base, 0);
        this.fContainerButton.setText(TextKeyLaunch.BROWSE_LABEL.getText());
        Label variantLabel = new Label(base, 0);
        variantLabel.setText(TextKeyLaunch.VARIANT_LABEL.getText());
        gd = new GridData();
        gd.horizontalSpan = 2;
        variantLabel.setLayoutData((Object)gd);
        this.fVariantText = new Text(base, 2048);
        this.fVariantText.setLayoutData((Object)new GridData(768));
        this.fVariantText.setToolTipText(TextKeyLaunch.VARIANT_TOOLTIP.getText());
        this.fVariantButton = new Button(base, 0);
        this.fVariantButton.setText(TextKeyLaunch.BROWSE_LABEL.getText());
        this.fContainerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LaunchTab.this.handleContainerSearchButtonSelected();
            }
        });
        SelectionAdapter sl = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VariantSelection vs = new VariantSelection();
                vs.show(JlinPlugin.getActiveWorkbenchShell());
                String variantName = vs.getResult();
                if (variantName != null) {
                    LaunchTab.this.fVariantText.setText(variantName);
                }
            }
        };
        this.fVariantButton.addSelectionListener((SelectionListener)sl);
        this.fContainerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                LaunchTab.super.updateLaunchConfigurationDialog();
            }
        });
        this.fVariantText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                LaunchTab.super.updateLaunchConfigurationDialog();
            }
        });
        this.setControl((Control)base);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy pConfig) {
        IJavaElement je = this.getContext();
        if (je != null && je.exists()) {
            this.fContainerElement = je.getJavaProject();
            pConfig.setAttribute(CONTAINER_ATTR, this.fContainerElement.getHandleIdentifier());
        } else {
            pConfig.setAttribute(CONTAINER_ATTR, "");
        }
        pConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true);
        pConfig.setAttribute(ATTR_TESTSET_NAME, JLinPreferencePage.getDefaultTestSetName());
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        String containerHandle;
        try {
            containerHandle = configuration.getAttribute(CONTAINER_ATTR, "");
        }
        catch (CoreException e) {
            containerHandle = null;
        }
        if ("".equals(containerHandle)) {
            containerHandle = null;
        }
        this.fContainerElement = JavaCore.create((String)containerHandle);
        String container = this.fContainerElement != null ? this.getPresentationName(this.fContainerElement) : "";
        this.fContainerText.setText(container);
        String vn = LaunchTab.getTestSetName(configuration);
        if (null != vn) {
            this.fVariantText.setText(vn);
        } else {
            this.fVariantText.setText(JLinPreferencePage.getDefaultTestSetName());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy pConfig) {
        if (this.fContainerElement != null) {
            pConfig.setAttribute(CONTAINER_ATTR, this.fContainerElement.getHandleIdentifier());
        }
        pConfig.setAttribute(ATTR_TESTSET_NAME, this.fVariantText.getText());
    }

    public String getName() {
        return TextKeyLaunch.LAUNCH_TAB_TITLE.getText();
    }

    public boolean isValid(ILaunchConfiguration pConfig) {
        this.setErrorMessage(null);
        this.setMessage(null);
        TestSet testSet = null;
        String name = this.fVariantText.getText().trim();
        if (0 < name.length()) {
            try {
                testSet = TestSetTool.readTestSet(name);
            }
            catch (Exception e) {
                this.setErrorMessage(TextKeyLaunch.CONFIG_BAD_VARIANT.getText());
                return false;
            }
        } else {
            this.setErrorMessage(TextKeyLaunch.CONFIG_INVALID_VARIANT.getText());
            return false;
        }
        if (this.fContainerElement != null) {
            if (!this.fContainerElement.exists()) {
                this.setErrorMessage(TextKeyLaunch.CONFIG_INVALID_PROJECT.getText());
                return false;
            }
            try {
                IProject project = (IProject)this.fContainerElement.getJavaProject().getCorrespondingResource();
                if (!project.isSynchronized(2)) {
                    this.setErrorMessage(TextKeyLaunch.PROJECT_OUT_OF_SYNC_MSG.getFormattedText(project.getName()));
                    return false;
                }
            }
            catch (JavaModelException e) {
                this.setErrorMessage(e.getMessage());
                return false;
            }
            if (testSet != null && new MetaRequestManager(testSet.getTests(), new IJavaElement[]{this.fContainerElement}).testObjectCount() == 0) {
                this.setErrorMessage(TextKeyLaunch.CONFIG_NO_SOURCES.getText());
                return false;
            }
        } else {
            this.setErrorMessage(TextKeyLaunch.CONFIG_INVALID_PROJECT.getText());
            return false;
        }
        return true;
    }

    private void handleContainerSearchButtonSelected() {
        IJavaElement javaElement = this.chooseContainer(this.fContainerElement);
        if (javaElement != null) {
            this.fContainerElement = javaElement;
            this.fContainerText.setText(this.getPresentationName(javaElement));
        }
    }

    private String getPresentationName(IJavaElement element) {
        return this.fJavaElementLabelProvider.getText((Object)element);
    }

    private IJavaElement chooseContainer(IJavaElement initElement) {
        Class[] acceptedClasses = new Class[]{class$org$eclipse$jdt$core$IPackageFragmentRoot == null ? (class$org$eclipse$jdt$core$IPackageFragmentRoot = LaunchTab.class$("org.eclipse.jdt.core.IPackageFragmentRoot")) : class$org$eclipse$jdt$core$IPackageFragmentRoot, class$org$eclipse$jdt$core$IJavaProject == null ? (class$org$eclipse$jdt$core$IJavaProject = LaunchTab.class$("org.eclipse.jdt.core.IJavaProject")) : class$org$eclipse$jdt$core$IJavaProject, class$org$eclipse$jdt$core$IPackageFragment == null ? (class$org$eclipse$jdt$core$IPackageFragment = LaunchTab.class$("org.eclipse.jdt.core.IPackageFragment")) : class$org$eclipse$jdt$core$IPackageFragment, class$org$eclipse$jdt$core$ICompilationUnit == null ? (class$org$eclipse$jdt$core$ICompilationUnit = LaunchTab.class$("org.eclipse.jdt.core.ICompilationUnit")) : class$org$eclipse$jdt$core$ICompilationUnit};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false){
            private IStatus STATUS_OK = new StatusInfo();
            private IStatus STATUS_ERROR = new StatusInfo(4, TextKeyLaunch.SELECTION_BINARY_MSG.getText());

            public IStatus validate(Object[] selection) {
                int i = 0;
                while (i < selection.length) {
                    IPackageFragmentRoot pfr;
                    if (selection[i] instanceof IJavaElement && (pfr = (IPackageFragmentRoot)((IJavaElement)selection[i]).getAncestor(3)) != null) {
                        try {
                            if (pfr.getKind() != 1) {
                                return this.STATUS_ERROR;
                            }
                        }
                        catch (JavaModelException e) {
                            return this.STATUS_ERROR;
                        }
                    }
                    ++i;
                }
                return this.STATUS_OK;
            }
        };
        acceptedClasses = new Class[]{class$org$eclipse$jdt$core$IJavaModel == null ? (class$org$eclipse$jdt$core$IJavaModel = LaunchTab.class$("org.eclipse.jdt.core.IJavaModel")) : class$org$eclipse$jdt$core$IJavaModel, class$org$eclipse$jdt$core$IPackageFragmentRoot == null ? (class$org$eclipse$jdt$core$IPackageFragmentRoot = LaunchTab.class$("org.eclipse.jdt.core.IPackageFragmentRoot")) : class$org$eclipse$jdt$core$IPackageFragmentRoot, class$org$eclipse$jdt$core$IJavaProject == null ? (class$org$eclipse$jdt$core$IJavaProject = LaunchTab.class$("org.eclipse.jdt.core.IJavaProject")) : class$org$eclipse$jdt$core$IJavaProject, class$org$eclipse$jdt$core$IPackageFragment == null ? (class$org$eclipse$jdt$core$IPackageFragment = LaunchTab.class$("org.eclipse.jdt.core.IPackageFragment")) : class$org$eclipse$jdt$core$IPackageFragment, class$org$eclipse$jdt$core$ICompilationUnit == null ? (class$org$eclipse$jdt$core$ICompilationUnit = LaunchTab.class$("org.eclipse.jdt.core.ICompilationUnit")) : class$org$eclipse$jdt$core$ICompilationUnit};
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses){

            public boolean select(Viewer viewer, Object parent, Object element) {
                return super.select(viewer, parent, element);
            }
        };
        StandardJavaElementContentProvider provider = new StandardJavaElementContentProvider();
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)provider);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setSorter((ViewerSorter)new JavaElementSorter());
        dialog.setTitle(TextKeyLaunch.CHOOSE_CONTAINER_TITLE.getText());
        dialog.setMessage(TextKeyLaunch.CHOOSE_CONTAINER_LABEL.getText());
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot()));
        dialog.setInitialSelection((Object)initElement);
        dialog.setAllowMultiple(false);
        if (dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            return (IJavaElement)element;
        }
        return null;
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static String getTestSetName(ILaunchConfiguration configuration) {
        try {
            String testSetName = configuration.getAttribute(ATTR_TESTSET_NAME, "");
            if (0 == testSetName.length()) {
                return null;
            }
            String[] actualTestSets = JLinPreferencePage.getTestSets();
            int i = 0;
            while (i < actualTestSets.length) {
                if (testSetName.equals(actualTestSets[i])) {
                    return testSetName;
                }
                ++i;
            }
            return null;
        }
        catch (CoreException ce) {
            JlinPlugin.log(ce);
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

