/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.eclipse.launch;

import com.sap.tc.jtools.jlint.eclipse.JlinPlugin;
import com.sap.tc.jtools.jlint.eclipse.config.JLinPreferencePage;
import com.sap.tc.jtools.jlint.eclipse.config.TestSetTool;
import com.sap.tc.jtools.jlint.eclipse.launch.JLinRunner;
import com.sap.tc.jtools.jlint.eclipse.launch.MetaRequestManager;
import com.sap.tc.jtools.jlint.eclipse.launch.TextKeyLaunch;
import com.sap.tc.jtools.jlint.eclipse.launch.VariantSelection;
import com.sap.tc.jtools.jlint.eclipse.util.ExceptionHandler;
import com.sap.tc.jtools.jtci.Test;
import com.sap.tc.jtools.jtci.TestSet;
import com.sap.tc.jtools.jtci.exceptions.BadTreeException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class LaunchShortcutImpl
implements ILaunchShortcut {
    static /* synthetic */ Class class$org$eclipse$core$resources$IFile;

    public void launch(ISelection selection, String mode) {
        if (selection.isEmpty()) {
            MetaRequestManager.warnNoSources();
            return;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sSelection = (IStructuredSelection)selection;
            Test[] tests = this.showVariantDialog();
            MetaRequestManager reqMan = new MetaRequestManager(tests, sSelection.toArray());
            this.runTests(reqMan);
        }
    }

    public void launch(IEditorPart editor, String mode) {
        IEditorInput input = editor.getEditorInput();
        IFile file = (IFile)input.getAdapter(class$org$eclipse$core$resources$IFile == null ? (class$org$eclipse$core$resources$IFile = LaunchShortcutImpl.class$("org.eclipse.core.resources.IFile")) : class$org$eclipse$core$resources$IFile);
        if (file == null) {
            MetaRequestManager.warnNoSources();
            return;
        }
        Test[] tests = this.showVariantDialog();
        MetaRequestManager reqMan = new MetaRequestManager(tests, new Object[]{file});
        this.runTests(reqMan);
    }

    private Test[] showVariantDialog() {
        Test[] tests = null;
        VariantSelection vs = new VariantSelection();
        Shell shell = JlinPlugin.getActiveWorkbenchShell();
        if (null == shell) {
            Display display = new Display();
            shell = new Shell(display);
        }
        vs.show(shell);
        String testSetName = vs.getResult();
        if (null == testSetName || 0 == testSetName.length()) {
            return null;
        }
        try {
            TestSet set = TestSetTool.readTestSet(testSetName);
            if (set != null) {
                tests = set.getActiveTests();
            }
        }
        catch (IOException io) {
            JlinPlugin.log(io);
            ExceptionHandler.handle(io, io.getClass().getName(), TextKeyLaunch.ACTIVE_TEST_EXC.getText() + io.getMessage());
        }
        catch (BadTreeException bt) {
            JlinPlugin.log(bt);
            ExceptionHandler.handle(bt, ((Object)((Object)bt)).getClass().getName(), TextKeyLaunch.ACTIVE_TEST_EXC.getText() + bt.getMessage());
        }
        if (null == tests || 0 == tests.length) {
            IllegalStateException illegalState = new IllegalStateException("");
            ExceptionHandler.handle(illegalState, TextKeyLaunch.VARIANT_CONTENT_TITLE.getText(), TextKeyLaunch.VARIANT_CONTENT_MESSAGE.getText());
            return null;
        }
        return tests;
    }

    private void runTests(MetaRequestManager requestMan) {
        String[] outOfSyncProjects = requestMan.getOutOfSyncProjectNames();
        if (outOfSyncProjects.length > 0) {
            MetaRequestManager.warnProjectsOutOfSync(outOfSyncProjects);
            return;
        }
        if (requestMan.testObjectCount() == 0) {
            MetaRequestManager.warnNoSources();
            return;
        }
        try {
            ProgressMonitorDialog dlg = new ProgressMonitorDialog(JlinPlugin.getActiveWorkbenchShell());
            String resultsDir = null;
            if (JLinPreferencePage.exportResult()) {
                resultsDir = JLinPreferencePage.getResultExportDirName();
            }
            dlg.run(true, true, (IRunnableWithProgress)new JLinRunner(requestMan, null, JlinPlugin.getBaseDir().toString(), resultsDir));
        }
        catch (InvocationTargetException e) {
            JlinPlugin.log(e);
            ExceptionHandler.handle(e);
        }
        catch (InterruptedException e) {
            JlinPlugin.log(e);
            ExceptionHandler.handle(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

