/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.eclipse.launch;

import com.sap.tc.jtools.jlint.eclipse.JlinPlugin;
import com.sap.tc.jtools.jlint.eclipse.launch.EclipseRequest;
import com.sap.tc.jtools.jlint.eclipse.launch.EclipseResponse;
import com.sap.tc.jtools.jlint.eclipse.launch.MetaMarkerManager;
import com.sap.tc.jtools.jlint.eclipse.launch.MetaRequestManager;
import com.sap.tc.jtools.jlint.eclipse.launch.TextKeyLaunch;
import com.sap.tc.jtools.jlint.eclipse.util.ExceptionHandler;
import com.sap.tc.jtools.jlint.eclipse.util.JLinSetupCache;
import com.sap.tc.jtools.jtci.Dispatcher;
import com.sap.tc.jtools.jtci.PerformRequest;
import com.sap.tc.jtools.jtci.PerformResponse;
import com.sap.tc.jtools.jtci.interfaces.Listener;
import com.sap.tc.jtools.jtci.interfaces.ResultInterface;
import com.sap.tc.jtools.util.structures.StructureTree;
import com.sap.tc.jtools.util.xml.XMLTool;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class JLinRunner
implements Runnable,
Listener,
IRunnableWithProgress {
    private IProgressMonitor monitor;
    private MetaRequestManager requestManager;
    private MetaMarkerManager markerManager;
    private List eclipseResponses = new ArrayList();
    private String requestDir;
    private String resultDir;

    public JLinRunner(MetaRequestManager requestManager) {
        this.requestManager = requestManager;
    }

    public JLinRunner(MetaRequestManager requestManager, IProgressMonitor monitor, String requestDir, String responseDir) {
        this.monitor = monitor;
        this.requestManager = requestManager;
        this.requestDir = requestDir;
        this.resultDir = responseDir;
    }

    public void run() {
        this.prepare();
        Dispatcher dispatcher = this.getDispatcher();
        EclipseRequest[] requests = this.requestManager.getRequests();
        try {
            int i = 0;
            while (i < requests.length) {
                this.eclipseResponses.add(new EclipseResponse(requests[i], dispatcher.processRequest((PerformRequest)requests[i])));
                ++i;
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
            if (this.monitor != null) {
                this.monitor.done();
            }
            return;
        }
        if (this.monitor != null && this.monitor.isCanceled()) {
            return;
        }
        this.finish();
    }

    private void finish() {
        this.persistResponses();
        EclipseResponse[] responses = this.eclipseResponses.toArray(new EclipseResponse[0]);
        this.markerManager = new MetaMarkerManager(this.requestManager.getSelectedObjects(), responses);
        this.markerManager.createMarkers();
        if (this.monitor != null) {
            this.monitor.done();
            this.markerManager.showFinishDialog(this.requestManager.testObjectCount());
        }
        JLinRunner.showTasksView();
    }

    private void prepare() {
        if (this.requestDir != null) {
            this.requestManager.persistRequests(new File(this.requestDir));
        }
        this.initMonitor();
    }

    public static void showTasksView() {
        Display dsp = Display.getDefault();
        if (dsp != null) {
            Runnable runnable = new Runnable(){

                public void run() {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    if (page != null) {
                        try {
                            page.showView("org.eclipse.ui.views.TaskList");
                        }
                        catch (PartInitException ex) {
                            JlinPlugin.log(ex);
                        }
                    }
                }
            };
            dsp.asyncExec(runnable);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void persistResponses() {
        if (this.resultDir == null || !new File(this.resultDir).isDirectory()) {
            return;
        }
        BufferedWriter writer = null;
        writer = new BufferedWriter(new FileWriter(new File(this.resultDir, "results.xml")));
        XMLTool.writeDocument((StructureTree)this.getMergedResponse().toStructureTree(), (Writer)writer);
        Object var4_2 = null;
        if (writer == null) return;
        try {
            writer.close();
            return;
        }
        catch (IOException e) {
            ExceptionHandler.handle(e);
        }
        return;
        {
            catch (IOException ioe) {
                JlinPlugin.log(ioe);
                ExceptionHandler.handle(ioe);
                Object var4_3 = null;
                if (writer == null) return;
                try {
                    writer.close();
                    return;
                }
                catch (IOException e) {
                    ExceptionHandler.handle(e);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (writer == null) throw throwable;
            try {
                writer.close();
                throw throwable;
            }
            catch (IOException e) {
                ExceptionHandler.handle(e);
            }
            throw throwable;
        }
    }

    private PerformResponse getMergedResponse() {
        ArrayList<ResultInterface> allResults = new ArrayList<ResultInterface>();
        Iterator iter = this.eclipseResponses.iterator();
        while (iter.hasNext()) {
            EclipseResponse reqResp = (EclipseResponse)iter.next();
            PerformResponse response = reqResp.getResponse();
            if (response == null || response.getResults() == null) continue;
            allResults.addAll(Arrays.asList(response.getResults()));
        }
        ResultInterface[] processedResults = JLinSetupCache.getDispatcher().processResults(allResults.toArray(new ResultInterface[0]));
        PerformResponse mergedResponse = new PerformResponse("");
        mergedResponse.addResults(processedResults);
        return mergedResponse;
    }

    private void initMonitor() {
        if (this.monitor != null) {
            String currentTaskName = TextKeyLaunch.JLIN_RUNNING.getText();
            this.monitor.beginTask(currentTaskName, this.requestManager.testObjectCount());
        }
    }

    private Dispatcher getDispatcher() {
        Dispatcher disp = JLinSetupCache.getDispatcher();
        disp.setListener((Listener)this);
        return disp;
    }

    public void processedTestObject(ResultInterface[] results) {
    }

    public boolean isCanceled() {
        if (this.monitor == null) {
            return false;
        }
        return this.monitor.isCanceled();
    }

    public void processedTestObjectComponent() {
        if (this.monitor != null) {
            this.monitor.worked(1);
        }
    }

    public void run(IProgressMonitor monitor) {
        this.monitor = monitor;
        this.run();
    }

    public MetaMarkerManager getMarkerManager() {
        return this.markerManager;
    }

    public EclipseResponse[] getResponses() {
        return this.eclipseResponses.toArray(new EclipseResponse[0]);
    }
}

