/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.eclipse.config;

import com.sap.tc.jtools.jlint.eclipse.JlinPlugin;
import com.sap.tc.jtools.jlint.eclipse.util.ExceptionHandler;
import com.sap.tc.jtools.jlint.eclipse.util.JLinSetupCache;
import com.sap.tc.jtools.jtci.Test;
import com.sap.tc.jtools.jtci.TestSet;
import com.sap.tc.jtools.jtci.exceptions.BadTreeException;
import com.sap.tc.jtools.jtci.exceptions.InvalidTestSpecificationException;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;
import com.sap.tc.jtools.jtci.interfaces.TestDescriptionInterface;
import com.sap.tc.jtools.util.structures.StructureTree;
import com.sap.tc.jtools.util.xml.XMLTool;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Vector;

public final class TestSetTool {
    public static final String DEFAULT_NAME = "DEFAULT";
    static final String TESTSET_EXTENSION = ".testset.xml";

    private TestSetTool() {
    }

    public static TestSet readTestSet(String name) throws IOException, BadTreeException {
        if (DEFAULT_NAME.equals(name)) {
            return TestSetTool.getDefault();
        }
        return TestSetTool.readTestSet(name, JlinPlugin.getBaseDir().toFile());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TestSet readTestSet(String name, File pBaseDir) throws IOException, BadTreeException {
        TestSet testSet;
        if (null == pBaseDir) {
            throw new NullPointerException("baseDir");
        }
        if (!pBaseDir.isDirectory()) {
            throw new FileNotFoundException(pBaseDir.toString());
        }
        FileReader reader = new FileReader(new File(pBaseDir, name + TESTSET_EXTENSION));
        try {
            try {
                TestSet testSet2 = new TestSet(XMLTool.parseReader((Reader)reader));
                testSet = TestSetTool.mergeWithToolDescr(testSet2);
                Object var6_7 = null;
            }
            catch (Exception e) {
                ExceptionHandler.handle(e);
                TestSet testSet3 = null;
                Object var6_8 = null;
                reader.close();
                return testSet3;
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            reader.close();
            throw throwable;
        }
        reader.close();
        return testSet;
    }

    private static TestSet mergeWithToolDescr(TestSet testSet) {
        Test[] tests = testSet.getTests();
        TestDescriptionInterface[] existingTests = JLinSetupCache.getDispatcher().getTests();
        int i = 0;
        while (i < tests.length) {
            boolean found = false;
            int j = 0;
            while (j < existingTests.length && !found) {
                if (tests[i].getName().equals(existingTests[j].getName())) {
                    found = true;
                    ParameterInterface[] defaultParams = existingTests[j].getInputParameters();
                    ArrayList<ParameterInterface> mergedParams = new ArrayList<ParameterInterface>();
                    ParameterInterface mergedParam = null;
                    int k = 0;
                    while (k < defaultParams.length) {
                        ParameterInterface correspondingParam = tests[i].getParameter(defaultParams[k].getName());
                        if (correspondingParam == null) {
                            mergedParam = defaultParams[k];
                        } else if (correspondingParam.getValue() == null) {
                            correspondingParam.setValue(defaultParams[k].getValue());
                            mergedParam = correspondingParam;
                        } else {
                            mergedParam = correspondingParam;
                        }
                        mergedParams.add(mergedParam);
                        ++k;
                    }
                    tests[i].setParameters(mergedParams.toArray(new ParameterInterface[0]));
                }
                ++j;
            }
            try {
                if (!found) {
                    throw new InvalidTestSpecificationException("test " + tests[i].getName() + " doesn't exist!");
                }
            }
            catch (InvalidTestSpecificationException e) {
                testSet.removeTest(tests[i]);
                ExceptionHandler.handle(e);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < existingTests.length) {
            if (testSet.getTest(existingTests[i2].getName()) == null) {
                testSet.addTest(new Test(existingTests[i2].getName(), existingTests[i2].getInputParameters(), false));
            }
            ++i2;
        }
        return testSet;
    }

    static void writeTestSet(TestSet pTestSet) throws IOException {
        TestSetTool.writeTestSet(pTestSet, JlinPlugin.getBaseDir().toFile());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void writeTestSet(TestSet pTestSet, File pBaseDir) throws IOException {
        if (null == pBaseDir) {
            throw new NullPointerException("baseDir");
        }
        if (!pBaseDir.isDirectory()) {
            throw new FileNotFoundException(pBaseDir.toString());
        }
        FileWriter writer = new FileWriter(new File(pBaseDir, pTestSet.getName() + TESTSET_EXTENSION));
        try {
            try {
                XMLTool.writeDocument((StructureTree)pTestSet.toStructureTree(), (Writer)writer);
            }
            catch (IOException e) {
                ExceptionHandler.handle(e);
                Object var5_4 = null;
                writer.close();
                return;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            writer.close();
            throw throwable;
        }
        writer.close();
    }

    static void purgeTestSet(TestSet pTestSet) throws IOException {
        TestSetTool.purgeTestSet(pTestSet.getName(), JlinPlugin.getBaseDir().toFile());
    }

    static void purgeTestSet(String pTestSetName) throws IOException {
        TestSetTool.purgeTestSet(pTestSetName, JlinPlugin.getBaseDir().toFile());
    }

    static void purgeTestSet(String pTestSetName, File pBaseDir) throws IOException {
        if (null == pBaseDir) {
            throw new NullPointerException("baseDir");
        }
        if (!pBaseDir.isDirectory()) {
            throw new FileNotFoundException(pBaseDir.toString());
        }
        File varFile = new File(pBaseDir, pTestSetName + TESTSET_EXTENSION);
        if (!varFile.isFile()) {
            throw new IOException("variant is not deleteable: " + varFile.toString());
        }
        varFile.delete();
    }

    static String[] scanTestSetNames() throws IOException {
        return TestSetTool.scanTestSetNames(JlinPlugin.getBaseDir().toFile());
    }

    static String[] scanTestSetNames(File pBaseDir) throws IOException {
        if (null == pBaseDir) {
            throw new NullPointerException("baseDir");
        }
        if (!pBaseDir.isDirectory()) {
            throw new FileNotFoundException(pBaseDir.toString());
        }
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File pPath, String pName) {
                return pName.endsWith(TestSetTool.TESTSET_EXTENSION);
            }
        };
        File[] content = pBaseDir.listFiles(filter);
        if (null == content || 0 == content.length) {
            return null;
        }
        String[] testSetNames = new String[content.length];
        int i = 0;
        while (i < content.length) {
            String filename = content[i].getName();
            testSetNames[i] = filename.substring(0, filename.length() - TESTSET_EXTENSION.length());
            ++i;
        }
        return testSetNames;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static TestSet getDefault() {
        File testSetFile = new File(JlinPlugin.getInstallDir(), "data/testconfig/testconfig.xml");
        try {
            TestSet testSet;
            FileReader reader = new FileReader(testSetFile);
            try {
                try {
                    TestSet defaultTestSet = new TestSet(XMLTool.parseReader((Reader)reader));
                    testSet = TestSetTool.mergeWithToolDescr(defaultTestSet);
                    Object var5_6 = null;
                }
                catch (Exception e) {
                    ExceptionHandler.handle(e);
                    Object var5_7 = null;
                    reader.close();
                    return TestSetTool.generateFromToolDescr(DEFAULT_NAME);
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                reader.close();
                throw throwable;
            }
            reader.close();
            return testSet;
        }
        catch (IOException e) {
            ExceptionHandler.handle(e);
        }
        return TestSetTool.generateFromToolDescr(DEFAULT_NAME);
    }

    public static TestSet generateFromToolDescr(String name) {
        TestDescriptionInterface[] testdescr = JLinSetupCache.getDispatcher().getTests();
        Vector<Test> tests = new Vector<Test>();
        int i = 0;
        while (i < testdescr.length) {
            tests.add(new Test(testdescr[i].getName(), testdescr[i].getInputParameters(), false));
            ++i;
        }
        return new TestSet(name, tests.toArray(new Test[tests.size()]));
    }
}

