/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.eclipse.config;

import com.sap.tc.jtools.jlint.eclipse.JlinPlugin;
import com.sap.tc.jtools.jlint.eclipse.config.IconKeyCfg;
import com.sap.tc.jtools.jlint.eclipse.config.ShowHelpAction;
import com.sap.tc.jtools.jlint.eclipse.config.TestDialog;
import com.sap.tc.jtools.jlint.eclipse.config.TextKeyCfg;
import com.sap.tc.jtools.jlint.eclipse.util.JLinSetupCache;
import com.sap.tc.jtools.jtci.Test;
import com.sap.tc.jtools.jtci.TestSet;
import com.sap.tc.jtools.jtci.TestTree;
import com.sap.tc.jtools.jtci.TestTreeNode;
import com.sap.tc.jtools.jtci.interfaces.TestDescriptionInterface;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TestSetDialog
extends Dialog
implements IMenuListener {
    private final TestSet fTestSet;
    private boolean readOnly;
    private Image fIconArgsMissing = null;
    private Image fIconArgsNone = null;
    private Image fIconArgsOkay = null;
    private Image fIconFolder = null;
    private TestTree fDescriptorTree = JLinSetupCache.getDispatcher().getTestTree();
    private Tree fTree = null;
    private Shell fShell = null;
    private static final int STATE_CHECKED_NONE = 1;
    private static final int STATE_CHECKED_ALL = 2;
    private static final int STATE_CHECKED_MIXED = 3;

    public TestSetDialog(Shell pParentShell, TestSet pTestSet, boolean readOnly) {
        super(pParentShell);
        this.fTestSet = pTestSet;
        this.readOnly = readOnly;
    }

    protected Control createDialogArea(Composite pBaseComposite) {
        this.fShell = pBaseComposite.getShell();
        if (this.readOnly) {
            this.fShell.setText(TextKeyCfg.VARIANT_SHOW_TITLE.getFormattedText(this.fTestSet.getName()));
        } else {
            this.fShell.setText(TextKeyCfg.VARIANT_EDIT_TITLE.getFormattedText(this.fTestSet.getName()));
        }
        Composite composite = new Composite(pBaseComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        Point size = this.computeSize();
        gd.widthHint = size.x;
        gd.heightHint = size.y;
        composite.setLayoutData((Object)gd);
        composite.setFont(pBaseComposite.getFont());
        this.createIcons(composite);
        this.createTree(composite);
        return composite;
    }

    private Point computeSize() {
        Rectangle r = Display.getCurrent().getClientArea();
        Point size = new Point(r.width, r.height);
        size.y = 1000 > r.height ? (400 > r.height ? 150 : 150 + r.height / 3) : 350 + r.height / 5;
        size.x = 1000 > r.width ? (400 > r.width ? 150 : 150 + r.width / 5) : 300 + r.width / 15;
        return size;
    }

    private void createIcons(Composite pParentComposite) {
        Display display = this.fShell.getDisplay();
        this.fIconArgsMissing = IconKeyCfg.TEST_PARAM_MISS.create(display);
        this.fIconArgsNone = IconKeyCfg.TEST_PARAM_NONE.create(display);
        this.fIconArgsOkay = IconKeyCfg.TEST_PARAM_OKAY.create(display);
        this.fIconFolder = JlinPlugin.getDefault().getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        DisposeListener dl = new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TestSetDialog.this.dispose();
            }
        };
        pParentComposite.addDisposeListener(dl);
    }

    private void dispose() {
        if (null != this.fIconArgsMissing && !this.fIconArgsMissing.isDisposed()) {
            this.fIconArgsMissing.dispose();
            this.fIconArgsMissing = null;
        }
        if (null != this.fIconArgsOkay && !this.fIconArgsOkay.isDisposed()) {
            this.fIconArgsOkay.dispose();
            this.fIconArgsOkay = null;
        }
        if (null != this.fIconArgsNone && !this.fIconArgsNone.isDisposed()) {
            this.fIconArgsNone.dispose();
            this.fIconArgsNone = null;
        }
    }

    private void createTree(Composite pParentComposite) {
        this.fTree = new Tree(pParentComposite, 36);
        this.fTree.setLayoutData((Object)new GridData(1808));
        this.fillTree();
        this.initMenu((Control)this.fTree);
        if (this.readOnly) {
            Listener ls = new Listener(){

                public void handleEvent(Event event) {
                    if (32 == event.detail && event.item instanceof TreeItem) {
                        TreeItem ti;
                        ti.setChecked(!(ti = (TreeItem)event.item).getChecked());
                    }
                }
            };
            this.fTree.addListener(13, ls);
        } else {
            Object ls = new SelectionChangedListener();
            this.fTree.addListener(13, (Listener)ls);
            ls = new SpaceAndMouseListener();
            this.fTree.addListener(8, (Listener)ls);
            this.fTree.addListener(1, (Listener)ls);
        }
    }

    private void fillTree() {
        TreeItem root = new TreeItem(this.fTree, 4);
        this.descendTree((TestTreeNode)this.fDescriptorTree, root);
        this.setSelectionFromChildren(root);
    }

    private void descendTree(TestTreeNode pDescrNode, TreeItem pGuiNode) {
        if (pDescrNode.getNodeType() == 2) {
            TestTree descrTree = (TestTree)pDescrNode;
            pGuiNode.setText(descrTree.getName());
            pGuiNode.setData((Object)descrTree);
            pGuiNode.setImage(this.fIconFolder);
            TestTreeNode[] children = descrTree.getNodes();
            int i = 0;
            while (i < children.length) {
                this.descendTree(children[i], new TreeItem(pGuiNode, 4));
                ++i;
            }
        } else if (pDescrNode.getNodeType() == 1) {
            TestDescriptionInterface testDescr = (TestDescriptionInterface)pDescrNode;
            Test test = this.fTestSet.getTest(testDescr.getName());
            if (test != null) {
                pGuiNode.setChecked(test.isActive() && test.paramsOkay());
            } else {
                test = new Test(testDescr.getName(), testDescr.getInputParameters(), false);
                this.fTestSet.addTest(test);
                pGuiNode.setChecked(false);
            }
            pGuiNode.setText(test.getName());
            pGuiNode.setData((Object)test);
            if (0 == test.getParameters().length) {
                pGuiNode.setImage(this.fIconArgsNone);
            } else if (test.paramsOkay()) {
                pGuiNode.setImage(this.fIconArgsOkay);
            } else {
                pGuiNode.setImage(this.fIconArgsMissing);
            }
        }
        pGuiNode.setExpanded(true);
    }

    void setSelectionFromChildren(TreeItem pBaseNode) {
        switch (this.setCheckStateFromChildren(pBaseNode)) {
            case 2: {
                pBaseNode.setChecked(true);
                pBaseNode.setGrayed(false);
                break;
            }
            case 3: {
                pBaseNode.setChecked(true);
                pBaseNode.setGrayed(true);
                break;
            }
            default: {
                pBaseNode.setChecked(false);
                pBaseNode.setGrayed(false);
            }
        }
    }

    private void updateTree() {
        this.updateAllItems(this.fTree.getItems()[0]);
        this.setCheckStateFromChildren(this.fTree.getItems()[0]);
    }

    private void updateAllItems(TreeItem item) {
        if (item.getData() instanceof Test) {
            Test test = (Test)item.getData();
            if (0 == test.getParameters().length) {
                item.setImage(this.fIconArgsNone);
            } else if (test.paramsOkay()) {
                item.setImage(this.fIconArgsOkay);
            } else {
                test.setActive(false);
                item.setImage(this.fIconArgsMissing);
                item.setChecked(false);
            }
        } else {
            TreeItem[] children = item.getItems();
            int i = 0;
            while (i < children.length) {
                this.updateAllItems(children[i]);
                ++i;
            }
        }
    }

    int setCheckStateFromChildren(TreeItem pItem) {
        if (pItem.getData() instanceof Test) {
            return pItem.getChecked() ? 2 : 1;
        }
        if (pItem.getData() instanceof TestTree) {
            TreeItem[] children = pItem.getItems();
            int status = 0;
            int i = 0;
            while (i < children.length) {
                status |= this.setCheckStateFromChildren(children[i]);
                ++i;
            }
            if (status == 0) {
                status = 1;
            }
            switch (status) {
                case 2: {
                    pItem.setChecked(true);
                    pItem.setGrayed(false);
                    break;
                }
                case 1: {
                    pItem.setChecked(false);
                    pItem.setGrayed(false);
                    break;
                }
                case 3: {
                    pItem.setChecked(true);
                    pItem.setGrayed(true);
                }
            }
            return status;
        }
        return 1;
    }

    private void initMenu(Control pControl) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)this);
        Menu menu = menuMgr.createContextMenu(pControl);
        pControl.setMenu(menu);
    }

    public void menuAboutToShow(IMenuManager pManager) {
        TreeItem[] items = this.fTree.getSelection();
        if (null != items && 0 < items.length) {
            int i = 0;
            while (i < items.length) {
                Object data = items[i].getData();
                if (data instanceof Test) {
                    Test test = (Test)data;
                    if (this.fIconArgsNone != items[i].getImage()) {
                        pManager.add((IAction)new ActionParamDialog(test));
                    }
                    pManager.add((IAction)new ShowHelpAction(this.fShell, test.getName()));
                }
                ++i;
            }
        }
    }

    class ActionParamDialog
    extends Action {
        private Test fTest;

        public ActionParamDialog(Test pTest) {
            super(pTest.getName());
            if (TestSetDialog.this.readOnly) {
                this.setText(TextKeyCfg.VARIANT_SHOW_TEST_ACTION.getText());
            } else {
                this.setText(TextKeyCfg.VARIANT_EDIT_TEST_ACTION.getText());
            }
            this.fTest = pTest;
        }

        public void run() {
            if (null != this.fTest) {
                new TestDialog(TestSetDialog.this.fShell, this.fTest, TestSetDialog.this.readOnly).open();
                TestSetDialog.this.updateTree();
            }
        }
    }

    class SpaceAndMouseListener
    implements Listener {
        SpaceAndMouseListener() {
        }

        public void handleEvent(Event e) {
            switch (e.type) {
                case 1: {
                    if (e.keyCode != 0) break;
                    this.handle();
                    break;
                }
                case 8: {
                    this.handle();
                }
            }
        }

        private void handle() {
            Object data;
            TreeItem[] items;
            if (null != TestSetDialog.this.fTree && null != (items = TestSetDialog.this.fTree.getSelection()) && 0 < items.length && (data = items[0].getData()) instanceof Test) {
                new ActionParamDialog((Test)data).run();
            }
        }
    }

    class SelectionChangedListener
    implements Listener {
        SelectionChangedListener() {
        }

        public void handleEvent(Event event) {
            if (32 == event.detail && null != event.item && event.item instanceof TreeItem) {
                TreeItem selectedItem = (TreeItem)event.item;
                this.setCheckStateRecursive(selectedItem, selectedItem.getChecked());
                TestSetDialog.this.setCheckStateFromChildren(TestSetDialog.this.fTree.getItems()[0]);
            }
        }

        private void setCheckStateRecursive(TreeItem item, boolean checked) {
            if (item.getData() instanceof TestTree) {
                TreeItem[] children = item.getItems();
                int i = 0;
                while (i < children.length) {
                    this.setCheckStateRecursive(children[i], checked);
                    ++i;
                }
            } else if (item.getData() instanceof Test) {
                Test test = (Test)item.getData();
                if (checked) {
                    test.setActive(test.paramsOkay());
                } else {
                    test.setActive(false);
                }
                item.setChecked(test.isActive());
            }
        }
    }
}

