/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.eclipse.config;

import com.sap.tc.jtools.jlint.eclipse.JlinPlugin;
import com.sap.tc.jtools.jlint.eclipse.config.NewVariantNameDialog;
import com.sap.tc.jtools.jlint.eclipse.config.TestSetDialog;
import com.sap.tc.jtools.jlint.eclipse.config.TestSetTool;
import com.sap.tc.jtools.jlint.eclipse.config.TextKeyCfg;
import com.sap.tc.jtools.jlint.eclipse.util.ExceptionHandler;
import com.sap.tc.jtools.jtci.Test;
import com.sap.tc.jtools.jtci.TestSet;
import com.sap.tc.jtools.jtci.exceptions.BadTreeException;
import java.io.IOException;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class TestSetComposite {
    public static final String RESULT_EXPORT_DIRNAME = "jlin.result.export.dirname";
    public static final String EXPORT_RESULT = "jlin.export.result";
    private IPreferenceStore prefStore = JlinPlugin.getDefault().getPreferenceStore();
    private final Shell fShell;
    private Label tabLabel;
    private Table fTab;
    private Composite buttonComposite;
    private Button newButton;
    private Button showButton;
    private Button editButton;
    private Button copyButton;
    private Button removeButton;
    private Button exportResultButton;
    private Text exportResultText;
    private Button browseExportResultButton;

    public TestSetComposite(Composite pParentComposite, String[] pVariantNames) {
        this.fShell = pParentComposite.getShell();
        Composite composite = new Composite(pParentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        this.createVariantsTab(composite, pVariantNames);
        this.createButtons(composite);
        this.createExportComposite(composite);
    }

    private void createExportComposite(Composite composite) {
        this.exportResultButton = new Button(composite, 16416);
        this.exportResultButton.setText(TextKeyCfg.EXPORT_BUTTON.getText());
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.exportResultButton.setLayoutData((Object)gridData);
        this.exportResultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TestSetComposite.this.exportResultButton.getSelection()) {
                    TestSetComposite.this.browseExportResultButton.setEnabled(true);
                    TestSetComposite.this.exportResultText.setEnabled(true);
                } else {
                    TestSetComposite.this.browseExportResultButton.setEnabled(false);
                    TestSetComposite.this.exportResultText.setEnabled(false);
                }
            }
        });
        this.exportResultText = new Text(composite, 2056);
        this.exportResultText.setLayoutData((Object)new GridData(768));
        this.browseExportResultButton = new Button(composite, 0x1000008);
        this.browseExportResultButton.setText(TextKeyCfg.BROWSE_LABEL.getText());
        this.browseExportResultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String dirName;
                DirectoryDialog dd = new DirectoryDialog(JlinPlugin.getActiveWorkbenchShell());
                dd.setText(TextKeyCfg.DIRDIALOG_TEXT.getText());
                String oldDir = TestSetComposite.this.exportResultText.getText();
                if (oldDir != null) {
                    dd.setFilterPath(oldDir);
                }
                if ((dirName = dd.open()) != null) {
                    TestSetComposite.this.exportResultText.setText(dirName);
                }
            }
        });
        this.setButtonGridData(this.browseExportResultButton);
        String exportFileName = this.prefStore.getString(RESULT_EXPORT_DIRNAME);
        boolean exportResult = this.prefStore.getBoolean(EXPORT_RESULT);
        this.exportResultButton.setSelection(exportResult);
        this.exportResultText.setText(exportFileName);
        if (exportResult) {
            this.exportResultText.setEnabled(true);
            this.browseExportResultButton.setEnabled(true);
        } else {
            this.exportResultText.setEnabled(false);
            this.browseExportResultButton.setEnabled(false);
        }
    }

    private void createVariantsTab(Composite parent, String[] variantNames) {
        this.tabLabel = new Label(parent, 16384);
        this.tabLabel.setText(TextKeyCfg.VARIANT_LABEL.getText());
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 4;
        this.tabLabel.setLayoutData((Object)gd);
        this.fTab = new Table(parent, 2820);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.fTab.setLayout((Layout)layout);
        GridData tgd = new GridData(1808);
        tgd.heightHint = this.fTab.getItemHeight();
        tgd.verticalAlignment = 4;
        tgd.horizontalAlignment = 4;
        tgd.grabExcessHorizontalSpace = true;
        tgd.grabExcessVerticalSpace = true;
        this.fTab.setLayoutData((Object)tgd);
        this.fillTab(variantNames);
        this.fTab.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if ("DEFAULT".equals(TestSetComposite.this.fTab.getItem(TestSetComposite.this.fTab.getSelectionIndex()).getText())) {
                    TestSetComposite.this.editButton.setEnabled(false);
                    TestSetComposite.this.removeButton.setEnabled(false);
                } else {
                    TestSetComposite.this.editButton.setEnabled(true);
                    TestSetComposite.this.removeButton.setEnabled(true);
                }
            }
        });
    }

    private void createButtons(Composite parent) {
        this.buttonComposite = new Composite(parent, 131072);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.buttonComposite.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 16;
        gridData.horizontalAlignment = 256;
        this.buttonComposite.setLayoutData((Object)gridData);
        this.newButton = new Button(this.buttonComposite, 0x1000008);
        this.newButton.setText(TextKeyCfg.NEW_BUTTON.getText());
        this.newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new ActionTestSetNew().run();
            }
        });
        this.setButtonGridData(this.newButton);
        this.showButton = new Button(this.buttonComposite, 0x1000008);
        this.showButton.setText(TextKeyCfg.SHOW_BUTTON.getText());
        this.showButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selIndex = TestSetComposite.this.fTab.getSelectionIndex();
                if (selIndex != -1) {
                    new ActionTestSetShow(TestSetComposite.this.fTab.getItem(selIndex)).run();
                }
            }
        });
        this.setButtonGridData(this.showButton);
        this.editButton = new Button(this.buttonComposite, 0x1000008);
        this.editButton.setText(TextKeyCfg.EDIT_BUTTON.getText());
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selIndex = TestSetComposite.this.fTab.getSelectionIndex();
                if (selIndex != -1) {
                    new ActionTestSetEdit(TestSetComposite.this.fTab.getItem(selIndex)).run();
                }
            }
        });
        this.setButtonGridData(this.editButton);
        this.copyButton = new Button(this.buttonComposite, 0x1000008);
        this.copyButton.setText(TextKeyCfg.COPY_BUTTON.getText());
        this.copyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selIndex = TestSetComposite.this.fTab.getSelectionIndex();
                if (selIndex != -1) {
                    new ActionTestSetCopy(TestSetComposite.this.fTab.getItem(selIndex)).run();
                }
            }
        });
        this.setButtonGridData(this.copyButton);
        this.removeButton = new Button(this.buttonComposite, 0x1000008);
        this.removeButton.setText(TextKeyCfg.REMOVE_BUTTON.getText());
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selIndex = TestSetComposite.this.fTab.getSelectionIndex();
                if (selIndex != -1) {
                    new ActionTestSetDelete(TestSetComposite.this.fTab.getItem(selIndex)).run();
                }
            }
        });
        this.setButtonGridData(this.removeButton);
    }

    private void setButtonGridData(Button button) {
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        button.setLayoutData((Object)data);
        SWTUtil.setButtonDimensionHint((Button)button);
    }

    private void fillTab(String[] pVariants) {
        int i = 0;
        while (i < pVariants.length) {
            TableItem variant = new TableItem(this.fTab, 4);
            variant.setText(pVariants[i]);
            variant.setData((Object)pVariants[i]);
            ++i;
        }
    }

    private void handleBadTreeException(BadTreeException pBT) {
        ExceptionHandler.handle(pBT, TextKeyCfg.PARSE_ERROR_TITLE.getText(), TextKeyCfg.PARSE_ERROR_MESSAGE.getText());
    }

    private void handleIOException(IOException pIO) {
        ExceptionHandler.handle(pIO, TextKeyCfg.IO_ERROR_TITLE.getText(), TextKeyCfg.IO_ERROR_MESSAGE.getText());
    }

    public boolean exportResult() {
        return this.exportResultButton.getSelection();
    }

    public String getExportFileName() {
        return this.exportResultText.getText();
    }

    class ActionTestSetDelete
    extends Action {
        private String fTestSet;
        TableItem fItem;

        public ActionTestSetDelete(TableItem pTableItem) {
            super(TextKeyCfg.BASE_DELETE_VARIANT_ACTION.getText());
            this.fTestSet = (String)pTableItem.getData();
            this.fItem = pTableItem;
        }

        public void run() {
            try {
                if ("DEFAULT".equals(this.fTestSet)) {
                    throw new IllegalStateException();
                }
                TestSetTool.purgeTestSet(this.fTestSet);
                this.fItem.dispose();
            }
            catch (IOException io) {
                TestSetComposite.this.handleIOException(io);
            }
        }
    }

    class ActionTestSetCopy
    extends Action {
        private String fTestSet;

        public ActionTestSetCopy(TableItem pTableItem) {
            super(TextKeyCfg.BASE_COPY_VARIANT_ACTION.getText());
            this.fTestSet = (String)pTableItem.getData();
        }

        public void run() {
            try {
                TestSet set1 = "DEFAULT".equals(this.fTestSet) ? TestSetTool.getDefault() : TestSetTool.readTestSet(this.fTestSet);
                NewVariantNameDialog dlg = new NewVariantNameDialog(TestSetComposite.this.fShell, "Variant1");
                if (0 == dlg.open()) {
                    TestSet set2 = new TestSet(dlg.getValue(), set1.getTests());
                    TestSetTool.writeTestSet(set2);
                    TableItem item = new TableItem(TestSetComposite.this.fTab, 0);
                    item.setText(set2.getName());
                    item.setData((Object)set2.getName());
                }
            }
            catch (IOException io) {
                TestSetComposite.this.handleIOException(io);
            }
            catch (BadTreeException bt) {
                TestSetComposite.this.handleBadTreeException(bt);
            }
        }
    }

    class ActionTestSetNew
    extends Action {
        ActionTestSetNew() {
        }

        public void run() {
            NewVariantNameDialog dlg = new NewVariantNameDialog(TestSetComposite.this.fShell, "Variant1");
            if (0 == dlg.open()) {
                TestSet testSet = null;
                try {
                    Test[] tests = TestSetTool.getDefault().getTests();
                    int i = 0;
                    while (i < tests.length) {
                        tests[i].setActive(false);
                        ++i;
                    }
                    testSet = new TestSet(dlg.getValue(), tests);
                    TestSetTool.writeTestSet(testSet);
                }
                catch (IOException e) {
                    ExceptionHandler.handle(e);
                }
                TableItem item = new TableItem(TestSetComposite.this.fTab, 0);
                item.setText(testSet.getName());
                item.setData((Object)testSet.getName());
            }
        }
    }

    class ActionTestSetEdit
    extends Action {
        private String fTestSet;

        public ActionTestSetEdit(TableItem pTableItem) {
            super(TextKeyCfg.BASE_EDIT_VARIANT_ACTION.getText());
            this.fTestSet = (String)pTableItem.getData();
        }

        public void run() {
            block5: {
                try {
                    if (!"DEFAULT".equals(this.fTestSet)) {
                        TestSet set = TestSetTool.readTestSet(this.fTestSet);
                        if (0 == new TestSetDialog(TestSetComposite.this.fShell, set, false).open()) {
                            TestSetTool.writeTestSet(set);
                        }
                        break block5;
                    }
                    throw new IllegalStateException();
                }
                catch (IOException io) {
                    TestSetComposite.this.handleIOException(io);
                }
                catch (BadTreeException bt) {
                    TestSetComposite.this.handleBadTreeException(bt);
                }
            }
        }
    }

    class ActionTestSetShow
    extends Action {
        private String fTestSet;

        public ActionTestSetShow(TableItem pTableItem) {
            super(TextKeyCfg.BASE_SHOW_VARIANT_ACTION.getText());
            this.fTestSet = (String)pTableItem.getData();
        }

        public void run() {
            if (null != this.fTestSet) {
                try {
                    TestSet set = "DEFAULT".equals(this.fTestSet) ? TestSetTool.getDefault() : TestSetTool.readTestSet(this.fTestSet);
                    new TestSetDialog(TestSetComposite.this.fShell, set, true).open();
                }
                catch (IOException io) {
                    TestSetComposite.this.handleIOException(io);
                }
                catch (BadTreeException bt) {
                    TestSetComposite.this.handleBadTreeException(bt);
                }
            }
        }
    }
}

