/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.eclipse.config;

import com.sap.tc.jtools.jlint.eclipse.config.EditParamDialog;
import com.sap.tc.jtools.jlint.eclipse.config.IconKeyCfg;
import com.sap.tc.jtools.jlint.eclipse.config.ShowHelpAction;
import com.sap.tc.jtools.jlint.eclipse.config.TestSetTool;
import com.sap.tc.jtools.jlint.eclipse.config.TextKeyCfg;
import com.sap.tc.jtools.jlint.eclipse.util.ExceptionHandler;
import com.sap.tc.jtools.jtci.ParameterTool;
import com.sap.tc.jtools.jtci.Test;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;
import com.sap.tc.jtools.util.structures.StructureTree;
import com.sap.tc.jtools.util.xml.XMLParseException;
import com.sap.tc.jtools.util.xml.XMLTool;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Vector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TestDialog
extends Dialog
implements IMenuListener {
    private static final String fgBlankParam = TextKeyCfg.BLANK_PARAM.getText();
    private static final String TYPE_TAG = "TYPE";
    private Test fTest;
    private Tree fTree;
    private Shell fShell;
    private boolean fReadOnly;
    private Image fIconTest;
    private Image fIconString;
    private Image fIconArray;
    private Image fIconDeep;
    private Composite treeComposite;

    public TestDialog(Shell pParentShell, Test pTest, boolean pReadOnly) {
        super(pParentShell);
        this.fTest = pTest;
        this.fReadOnly = pReadOnly;
    }

    protected Control createDialogArea(Composite pBaseComposite) {
        this.fShell = pBaseComposite.getShell();
        if (this.fReadOnly) {
            this.fShell.setText(TextKeyCfg.TEST_SHOW_TITLE.getFormattedText(this.fTest.getName()));
        } else {
            this.fShell.setText(TextKeyCfg.TEST_EDIT_TITLE.getFormattedText(this.fTest.getName()));
        }
        this.treeComposite = new Composite(pBaseComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        this.treeComposite.setLayout((Layout)layout);
        this.treeComposite.setLayoutData((Object)new GridData(1808));
        this.createIcons(this.treeComposite);
        this.createParamTree(this.treeComposite);
        this.createMenuBar();
        return this.treeComposite;
    }

    protected void createMenuBar() {
    }

    private Point computeSize() {
        Rectangle r = Display.getCurrent().getClientArea();
        Point size = new Point(r.width, r.height);
        size.y = 1000 > r.height ? (400 > r.height ? 150 : 150 + r.height / 3) : 350 + r.height / 5;
        size.x = 1000 > r.width ? (400 > r.width ? 150 : 150 + r.width / 5) : 300 + r.width / 15;
        return size;
    }

    protected Point getInitialLocation(Point initialSize) {
        Point location = super.getInitialLocation(initialSize);
        location.x += 30;
        location.y += 30;
        return location;
    }

    private void createIcons(Composite superComposite) {
        Display d = superComposite.getDisplay();
        this.fIconArray = IconKeyCfg.PARAM_TYPE_ARRAY.create(d);
        this.fIconDeep = IconKeyCfg.PARAM_TYPE_DEEP.create(d);
        this.fIconString = IconKeyCfg.PARAM_TYPE_STRING.create(d);
        this.fIconTest = IconKeyCfg.TEST.create(d);
        DisposeListener dl = new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TestDialog.this.dispose();
            }
        };
        superComposite.addDisposeListener(dl);
    }

    private void dispose() {
        if (null != this.fIconArray && !this.fIconArray.isDisposed()) {
            this.fIconArray.dispose();
            this.fIconArray = null;
        }
        if (null != this.fIconDeep && !this.fIconDeep.isDisposed()) {
            this.fIconDeep.dispose();
            this.fIconDeep = null;
        }
        if (null != this.fIconString && !this.fIconString.isDisposed()) {
            this.fIconString.dispose();
            this.fIconString = null;
        }
        if (null != this.fIconTest && !this.fIconTest.isDisposed()) {
            this.fIconTest.dispose();
            this.fIconTest = null;
        }
    }

    private void createParamTree(Composite pParentComposite) {
        this.fTree = new Tree(pParentComposite, 2);
        GridData gd = new GridData(1808);
        gd.heightHint = this.computeSize().y;
        gd.widthHint = this.computeSize().x;
        this.fTree.setLayoutData((Object)gd);
        this.fillTree();
        this.initMenu((Control)this.fTree);
        if (!this.fReadOnly) {
            KeyAndMouseListener ls = new KeyAndMouseListener();
            this.fTree.addListener(1, (Listener)ls);
            this.fTree.addListener(8, (Listener)ls);
        }
    }

    private void fillTree() {
        TreeItem root = new TreeItem(this.fTree, 4);
        root.setText(this.fTest.getName());
        root.setData((Object)this.fTest);
        root.setImage(this.fIconTest);
        try {
            ParameterInterface[] params = this.fTest.getParameters();
            if (null != params) {
                int j = 0;
                while (j < params.length) {
                    TreeItem valueItem;
                    ParameterInterface curParam = params[j];
                    TreeItem nameItem = new TreeItem(root, 4);
                    nameItem.setText(params[j].getName());
                    nameItem.setData((Object)params[j]);
                    this.fTree.showItem(nameItem);
                    String type = curParam.getType();
                    if (ParameterTool.isSimpleType((String)type)) {
                        nameItem.setImage(this.fIconString);
                        Object value = curParam.getValue();
                        String textValue = value != null ? curParam.valueToString() : null;
                        valueItem = new TreeItem(nameItem, 4);
                        valueItem.setText(this.displayValue((Serializable)((Object)textValue)));
                        if (null == value) {
                            value = "";
                        }
                        valueItem.setData(value);
                        valueItem.setData(TYPE_TAG, (Object)type);
                    } else if (ParameterTool.isArrayType((String)type)) {
                        nameItem.setImage(this.fIconArray);
                        String[] values = (String[])curParam.getValue();
                        if (null != values) {
                            int k = 0;
                            while (k < values.length) {
                                valueItem = new TreeItem(nameItem, 4);
                                valueItem.setText(this.displayValue((Serializable)((Object)values[k])));
                                valueItem.setData((Object)values[k]);
                                valueItem.setData(TYPE_TAG, (Object)type);
                                ++k;
                            }
                        }
                    } else if (type.equals("DEEP STRUCTURE")) {
                        nameItem.setImage(this.fIconDeep);
                        StructureTree st = (StructureTree)curParam.getValue();
                        String value = XMLTool.toString((StructureTree)st);
                        valueItem = new TreeItem(nameItem, 4);
                        valueItem.setText(this.displayValue((Serializable)((Object)value)));
                        valueItem.setData((Object)value);
                        valueItem.setData(TYPE_TAG, (Object)type);
                    } else {
                        throw new IllegalStateException("unknown Parametertype");
                    }
                    ++j;
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    private String displayValue(Serializable pValue) {
        if (null == pValue) {
            return fgBlankParam;
        }
        return pValue.toString();
    }

    private void initMenu(Control pControl) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)this);
        Menu menu = menuMgr.createContextMenu(pControl);
        pControl.setMenu(menu);
    }

    public void menuAboutToShow(IMenuManager pManager) {
        if (this.fReadOnly) {
            TreeItem[] items = this.fTree.getSelection();
            if (null != items && 0 < items.length) {
                int i = 0;
                while (i < items.length) {
                    Object data = items[i].getData();
                    if (data instanceof Test) {
                        pManager.add((IAction)new ShowHelpAction(this.fShell, ((Test)data).getName()));
                    }
                    ++i;
                }
            }
            return;
        }
        TreeItem[] items = this.fTree.getSelection();
        if (null != items && 0 < items.length) {
            int i = 0;
            while (i < items.length) {
                Object info;
                Object data = items[i].getData();
                if (data instanceof ParameterInterface) {
                    ParameterInterface param = (ParameterInterface)data;
                    String pt = param.getType();
                    if (ParameterTool.isArrayType((String)pt)) {
                        pManager.add((IAction)new AppendAction(items[i]));
                    }
                } else if (data instanceof Test) {
                    pManager.add((IAction)new SetDefaultAction());
                    pManager.add((IAction)new ShowHelpAction(this.fShell, ((Test)data).getName()));
                } else if ((data instanceof String || data instanceof Integer || data instanceof Float || data instanceof Boolean) && (info = items[i].getData(TYPE_TAG)) instanceof String) {
                    String paramType = (String)info;
                    if (ParameterTool.isSimpleType((String)paramType)) {
                        pManager.add((IAction)new EditAction(items[i], false));
                    } else if (ParameterTool.isArrayType((String)paramType)) {
                        pManager.add((IAction)new EditAction(items[i], false));
                        pManager.add((IAction)new RemoveAction(items[i]));
                    } else if (paramType.equals("DEEP STRUCTURE")) {
                        pManager.add((IAction)new EditAction(items[i], true));
                    }
                }
                ++i;
            }
        }
    }

    class KeyAndMouseListener
    implements Listener {
        KeyAndMouseListener() {
        }

        public void handleEvent(Event e) {
            switch (e.type) {
                case 1: {
                    if (e.keyCode != 0) break;
                    this.handle();
                    break;
                }
                case 8: {
                    this.handle();
                }
            }
        }

        private void handle() {
            Object data;
            TreeItem[] items;
            if (null != TestDialog.this.fTree && null != (items = TestDialog.this.fTree.getSelection()) && 0 < items.length && (data = items[0].getData()) instanceof String) {
                String type = (String)data;
                new EditAction(items[0], type.equals("DEEP STRUCTURE")).run();
            }
        }
    }

    class EditAction
    extends Action {
        final TreeItem fItem;
        final boolean fStructureTree;

        EditAction(TreeItem pItem, boolean pStructureTree) {
            super(TextKeyCfg.TEST_EDIT_VALUE_ACTION.getText());
            this.fItem = pItem;
            this.fStructureTree = pStructureTree;
        }

        public void run() {
            String osSpecificValue;
            Object data = this.fItem.getData();
            Object typeTag = this.fItem.getData(TestDialog.TYPE_TAG);
            String paramType = null;
            Serializable value = null;
            Object newValue = null;
            if (typeTag != null && typeTag instanceof String) {
                paramType = (String)typeTag;
            }
            value = (Serializable)data;
            if ("FILE".equals(paramType) || "FILE[]".equals(paramType)) {
                FileDialog fd = new FileDialog(TestDialog.this.fShell);
                if (value != null) {
                    osSpecificValue = ((String)((Object)value)).replace('\\', File.separatorChar).replace('/', File.separatorChar);
                    fd.setFileName(osSpecificValue);
                }
                newValue = fd.open();
            } else if ("DIRECTORY".equals(paramType) || "DIRECTORY[]".equals(paramType)) {
                DirectoryDialog dd = new DirectoryDialog(TestDialog.this.fShell);
                if (value != null) {
                    osSpecificValue = ((String)((Object)value)).replace('\\', File.separatorChar).replace('/', File.separatorChar);
                    dd.setFilterPath(osSpecificValue);
                }
                newValue = dd.open();
            } else {
                EditParamDialog dg = new EditParamDialog(TestDialog.this.fShell, value, this.fStructureTree, paramType, this.fStructureTree);
                if (0 == dg.open()) {
                    newValue = dg.getParamValue();
                }
            }
            if (newValue == null) {
                return;
            }
            if (!value.equals(newValue)) {
                this.fItem.setData(newValue);
                this.fItem.setText(TestDialog.this.displayValue((Serializable)newValue));
                TreeItem parameterItem = this.fItem.getParentItem();
                ParameterInterface param = (ParameterInterface)parameterItem.getData();
                String type = param.getType();
                if (ParameterTool.isSimpleType((String)type)) {
                    param.setValue((Serializable)newValue);
                } else if (ParameterTool.isArrayType((String)type)) {
                    TreeItem[] arrayItems = parameterItem.getItems();
                    Vector<String> v = new Vector<String>(arrayItems.length);
                    int i = 0;
                    while (i < arrayItems.length) {
                        String curValue = (String)arrayItems[i].getData();
                        if (null != curValue && 0 < curValue.length()) {
                            v.add(curValue);
                        }
                        ++i;
                    }
                    Object[] newValues = new String[v.size()];
                    v.copyInto(newValues);
                    param.setValue((Serializable)newValues);
                } else if ("DEEP STRUCTURE".equals(type)) {
                    StringReader sr = new StringReader(newValue.toString());
                    try {
                        StructureTree valTree = XMLTool.parseReader((Reader)sr);
                        param.setValue((Serializable)valTree);
                    }
                    catch (IOException io) {
                        throw new IllegalStateException();
                    }
                    catch (XMLParseException e) {
                        ExceptionHandler.handle(e, TextKeyCfg.PARSE_ERROR_TITLE.getText(), TextKeyCfg.PARSE_ERROR_MESSAGE.getText());
                        return;
                    }
                } else {
                    throw new IllegalStateException("unknown type");
                }
            }
        }
    }

    class RemoveAction
    extends Action {
        final TreeItem fItem;

        public RemoveAction(TreeItem pItem) {
            super(TextKeyCfg.TEST_REMOVE_VALUE_ACTION.getText());
            this.fItem = pItem;
        }

        public void run() {
            String value = (String)this.fItem.getData();
            ParameterInterface param = (ParameterInterface)this.fItem.getParentItem().getData();
            String[] values = (String[])param.getValue();
            Vector<String> newValues = new Vector<String>();
            int i = 0;
            while (i < values.length) {
                if (!value.equals(values[i])) {
                    newValues.add(values[i]);
                }
                ++i;
            }
            String[] newValueNames = newValues.toArray(new String[newValues.size()]);
            if (newValueNames.length == 0) {
                param.setValue(null);
            } else {
                param.setValue((Serializable)newValueNames);
            }
            this.fItem.dispose();
        }
    }

    class AppendAction
    extends Action {
        final TreeItem fItem;

        public AppendAction(TreeItem pItem) {
            super(TextKeyCfg.TEST_APPEND_VALUE_ACTION.getText());
            this.fItem = pItem;
        }

        public void run() {
            TreeItem valueItem = new TreeItem(this.fItem, 4);
            valueItem.setText(fgBlankParam);
            valueItem.setData((Object)"");
            ParameterInterface param = (ParameterInterface)this.fItem.getData();
            String type = param.getType();
            valueItem.setData(TestDialog.TYPE_TAG, (Object)type);
        }
    }

    class SetDefaultAction
    extends Action {
        public SetDefaultAction() {
            super(TextKeyCfg.TEST_SET_DEFAULT_ACTION.getText());
        }

        public void run() {
            try {
                String testName = TestDialog.this.fTest.getName();
                Test defaultTest = TestSetTool.getDefault().getTest(testName);
                if (null == defaultTest) {
                    throw new IllegalStateException("unknown test: " + testName);
                }
                TestDialog.this.fTest.setParameters(defaultTest.getParameters());
                TestDialog.this.fTree.removeAll();
                TestDialog.this.fillTree();
            }
            catch (Exception ex) {
                ExceptionHandler.handle(ex);
            }
        }
    }
}

