/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.eclipse.config;

import com.sap.tc.jtools.jlint.eclipse.config.TextKeyCfg;
import com.sap.tc.jtools.jlint.eclipse.util.JLinSetupCache;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;
import com.sap.tc.jtools.jtci.interfaces.TestDescriptionInterface;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class ShowHelpAction
extends Action {
    final Shell fShell;
    final String testName;

    public ShowHelpAction(Shell pShell, String testName) {
        super(TextKeyCfg.SHOW_HELP_ACTION.getText());
        this.testName = testName;
        this.fShell = pShell;
    }

    public void run() {
        String helpText = null;
        TestDescriptionInterface[] tests = JLinSetupCache.getDispatcher().getTests();
        if (null != tests) {
            int i = 0;
            while (i < tests.length) {
                if (this.testName.equals(tests[i].getName())) {
                    StringBuffer help = new StringBuffer();
                    help.append(tests[i].getDescription() + "\n");
                    ParameterInterface pseudoComment = tests[i].getInternalParameter("PSEUDO_COMMENT_SUFFIX");
                    if (pseudoComment != null) {
                        String comment = "//$JL-" + ((String)((Object)pseudoComment.getValue())).trim().toUpperCase() + "$";
                        help.append("\n" + TextKeyCfg.TEST_SHOW_HELP_PSEUDO_CMT.getFormattedText(comment) + " .\n");
                    }
                    help.append("\n" + TextKeyCfg.TEST_SHOW_HELP_RESPONSIBLE.getText() + tests[i].getTestResponsible() + "\n");
                    help.append("\n" + TextKeyCfg.TEST_SHOW_HELP_VERSION.getText() + tests[i].getVersion() + "\n");
                    helpText = help.toString();
                    break;
                }
                ++i;
            }
        }
        if (null == helpText || 1 > helpText.length()) {
            helpText = TextKeyCfg.SHOW_HELP_NONE_THERE.getText();
        }
        String[] labels = new String[]{IDialogConstants.PROCEED_LABEL};
        MessageDialog dlg = new MessageDialog(this.fShell, this.testName, null, helpText, 2, labels, 0);
        dlg.open();
    }
}

