/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.eclipse.config;

import com.sap.tc.jtools.jlint.eclipse.config.TextKeyCfg;
import com.sap.tc.jtools.util.xml.XMLTool;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.jface.dialogs.IInputValidator;

class ParamValidator
implements IInputValidator {
    final boolean fXMLInput;
    final String paramType;

    public ParamValidator(boolean pXMLInput, String paramType) {
        this.fXMLInput = pXMLInput;
        this.paramType = paramType;
    }

    public String isValid(String pInput) {
        if ("STRING".equals(this.paramType)) {
            if (0 >= pInput.length()) {
                return TextKeyCfg.ENTER_VALUE_EMPTY_WARN.getText();
            }
        } else {
            if ("INT".equals(this.paramType)) {
                try {
                    Integer.parseInt(pInput);
                }
                catch (NumberFormatException e) {
                    return TextKeyCfg.ENTER_VALUE_INT_WARN.getText();
                }
            }
            if ("FLOAT".equals(this.paramType)) {
                try {
                    Float.parseFloat(pInput);
                }
                catch (NumberFormatException e) {
                    return TextKeyCfg.ENTER_VALUE_FLOAT_WARN.getText();
                }
            }
        }
        if (this.fXMLInput) {
            try {
                XMLTool.parseReader((Reader)new StringReader(pInput));
            }
            catch (Exception ex) {
                return TextKeyCfg.ENTER_VALUE_XML_WARN.getText();
            }
        }
        return null;
    }
}

