/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.eclipse;

import com.sap.tc.jtools.jlint.eclipse.JlinPlugin;
import com.sap.tc.jtools.jlint.eclipse.extension.EclipseModule;
import com.sap.tc.jtools.jlint.eclipse.extension.IMarkerManager;
import com.sap.tc.jtools.jlint.eclipse.extension.IRequestCreator;
import com.sap.tc.jtools.jlint.eclipse.extension.ISelectionHandler;
import com.sap.tc.jtools.jlint.eclipse.util.ExceptionHandler;
import com.sap.tc.jtools.jlint.extension.Module;
import com.sap.tc.jtools.jlint.extension.TestProvider;
import com.sap.tc.jtools.jlint.extension.TestProviderInterface;
import com.sap.tc.jtools.jlint.extension.TestSet;
import com.sap.tc.jtools.jtci.exceptions.BadTreeException;
import com.sap.tc.jtools.jtci.interfaces.TestDescriptionInterface;
import com.sap.tc.jtools.util.xml.XMLParseException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;

public class ExtensionManager {
    private static ExtensionManager extMan;
    private static Object lock;
    private static final String MODULE_EXT_POINT = "module";
    private static final String SELECTIONHANDLER_EXT_POINT = "selectionHandler";
    private static final String TESTS_EXT_POINT = "tests";
    private static final String REQUESTCREATOR_ELEMENT = "requestCreator";
    private static final String SELECTIONHANDLER_ELEMENT = "selectionHandler";
    private static final String TESTOBJECTTYPE_ELEMENT = "testObjectType";
    private static final String TESTSET_ELEMENT = "testSet";
    private static final String MARKERMANAGER_ELEMENT = "markerManager";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String DESCRIPTORFILE_ATTRIBUTE = "descriptorFile";
    private static final String MODULE_ID_ATTRIBUTE = "moduleId";
    private static final String NAME_ATTRIBUTE = "name";
    private Map testName2ModuleMap = new HashMap();
    private Map id2ModuleMap = new HashMap();
    private Map testObj2ModuleMap = new HashMap();
    private List selHandlerList = new ArrayList();
    private TestProviderInterface testProvider;

    public static ExtensionManager getExtensionManager() {
        Object object = lock;
        synchronized (object) {
            if (extMan != null) {
                ExtensionManager extensionManager = extMan;
                return extensionManager;
            }
            ExtensionManager extensionManager = extMan = new ExtensionManager();
            return extensionManager;
        }
    }

    private ExtensionManager() {
        try {
            this.init();
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public ISelectionHandler[] getSelectionHandlers() {
        return this.selHandlerList.toArray(new ISelectionHandler[0]);
    }

    public TestProviderInterface getTestProvider() {
        return this.testProvider;
    }

    private void init() throws IOException, CoreException, BadTreeException, XMLParseException {
        IPluginRegistry registry = Platform.getPluginRegistry();
        this.initModules(registry.getExtensionPoint(JlinPlugin.getPluginId(), MODULE_EXT_POINT));
        this.initSelectionHandlers(registry.getExtensionPoint(JlinPlugin.getPluginId(), "selectionHandler"));
        this.initTests(registry.getExtensionPoint(JlinPlugin.getPluginId(), TESTS_EXT_POINT));
    }

    private void initModules(IExtensionPoint moduleExtensionPoint) throws CoreException, XMLParseException {
        IExtension[] moduleExtensions = moduleExtensionPoint.getExtensions();
        int i = 0;
        while (i < moduleExtensions.length) {
            IConfigurationElement[] elements = moduleExtensions[i].getConfigurationElements();
            IMarkerManager markerMan = null;
            IRequestCreator creator = null;
            HashMap<String, String> name2testObjClasNameMap = new HashMap<String, String>();
            int j = 0;
            while (j < elements.length) {
                if (MARKERMANAGER_ELEMENT.equals(elements[j].getName())) {
                    markerMan = (IMarkerManager)elements[j].createExecutableExtension(CLASS_ATTRIBUTE);
                } else if (REQUESTCREATOR_ELEMENT.equals(elements[j].getName())) {
                    creator = (IRequestCreator)elements[j].createExecutableExtension(CLASS_ATTRIBUTE);
                } else if (TESTOBJECTTYPE_ELEMENT.equals(elements[j].getName())) {
                    String name = elements[j].getAttribute(NAME_ATTRIBUTE);
                    String className = elements[j].getAttribute(CLASS_ATTRIBUTE);
                    name2testObjClasNameMap.put(name, className);
                } else {
                    throw new XMLParseException("unknown element: " + elements[j].getName());
                }
                ++j;
            }
            if (creator == null || markerMan == null) {
                throw new XMLParseException("both markerManager and requestCreator elements must be declared in plugin " + moduleExtensions[i].getDeclaringPluginDescriptor().getUniqueIdentifier());
            }
            String moduleId = moduleExtensions[i].getUniqueIdentifier();
            ClassLoader pluginLoader = moduleExtensions[i].getDeclaringPluginDescriptor().getPluginClassLoader();
            EclipseModule module = new EclipseModule(moduleId, pluginLoader, name2testObjClasNameMap, markerMan, creator);
            this.id2ModuleMap.put(moduleId, module);
            Set testObjTypes = name2testObjClasNameMap.keySet();
            Iterator iter = testObjTypes.iterator();
            while (iter.hasNext()) {
                String testObjType = (String)iter.next();
                this.testObj2ModuleMap.put(testObjType, module);
            }
            ++i;
        }
    }

    private void initSelectionHandlers(IExtensionPoint selHandlerExtensionPoint) throws CoreException {
        IExtension[] selHandlers = selHandlerExtensionPoint.getExtensions();
        int i = 0;
        while (i < selHandlers.length) {
            IConfigurationElement[] elements = selHandlers[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                if ("selectionHandler".equals(elements[j].getName())) {
                    ISelectionHandler handler = (ISelectionHandler)elements[j].createExecutableExtension(CLASS_ATTRIBUTE);
                    this.selHandlerList.add(handler);
                }
                ++j;
            }
            ++i;
        }
    }

    private void initTests(IExtensionPoint testsExtensionPoint) throws BadTreeException, FileNotFoundException, IOException, XMLParseException {
        IExtension[] testSets = testsExtensionPoint.getExtensions();
        int i = 0;
        while (i < testSets.length) {
            IConfigurationElement[] elements = testSets[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                if (!TESTSET_ELEMENT.equals(elements[j].getName())) {
                    throw new XMLParseException("unknown element: " + elements[j].getName());
                }
                String descriptorFilePath = Platform.resolve((URL)testSets[i].getDeclaringPluginDescriptor().getInstallURL()).getPath() + elements[j].getAttribute(DESCRIPTORFILE_ATTRIBUTE);
                String moduleId = elements[j].getAttribute(MODULE_ID_ATTRIBUTE);
                Module module = (Module)this.id2ModuleMap.get(moduleId);
                if (module == null) {
                    throw new XMLParseException("unknown moduleID: " + moduleId + " in plugin " + testSets[i].getDeclaringPluginDescriptor().getUniqueIdentifier());
                }
                File descriptorFile = new File(descriptorFilePath);
                ClassLoader pluginLoader = testSets[i].getDeclaringPluginDescriptor().getPluginClassLoader();
                TestSet testSet = new TestSet(descriptorFile, pluginLoader);
                module.addTestSet(testSet);
                TestDescriptionInterface[] tests = testSet.getTestDescriptionSet().getTestTree().getAllLeaves();
                int k = 0;
                while (k < tests.length) {
                    this.testName2ModuleMap.put(tests[k].getName(), this.id2ModuleMap.get(moduleId));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.testProvider = TestProvider.initialize((Module[])this.id2ModuleMap.values().toArray(new EclipseModule[0]));
    }

    public EclipseModule getModuleForTest(String testName) {
        return (EclipseModule)((Object)this.testName2ModuleMap.get(testName));
    }

    public EclipseModule getModuleForTestObjectType(String testObjectType) {
        return (EclipseModule)((Object)this.testObj2ModuleMap.get(testObjectType));
    }

    static {
        lock = new char[]{'x'};
    }
}

