/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.util;

import com.sap.lcr.api.cim.CIMClass;
import com.sap.lcr.api.cim.CIMClassname;
import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMInstance;
import com.sap.lcr.api.cim.CIMInstancename;
import com.sap.lcr.api.cim.CIMKeybinding;
import com.sap.lcr.api.cim.CIMObjectpath;
import com.sap.lcr.api.cim.CIMObjectpathList;
import com.sap.lcr.api.cim.CIMProperty;
import com.sap.lcr.api.cim.CIMPropertyArray;
import com.sap.lcr.api.cim.CIMPropertyReference;
import com.sap.lcr.api.cim.CIMQualifier;
import com.sap.lcr.api.cim.CIMUtil;
import com.sap.lcr.api.cim.CIMValueArray;
import com.sap.lcr.api.cim.CIMValueNamedInstance;
import com.sap.lcr.api.cim.CIMValueReference;
import com.sap.lcr.api.cimclient.CIMClient;
import com.sap.lcr.api.cimclient.CIMClientException;
import com.sap.lcr.api.cimclient.CIMOMClient;
import com.sap.lcr.api.cimclient.CIMTraceUtil;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.log.Level;
import com.sap.lcr.api.log.Logger;
import com.sap.lcr.api.util.MD5;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.Iterator;

public final class Util {
    private static final Logger logger = Logger.getLogger((class$com$sap$lcr$api$util$Util == null ? (class$com$sap$lcr$api$util$Util = Util.class$("com.sap.lcr.api.util.Util")) : class$com$sap$lcr$api$util$Util).getName());
    public static final String UTF8 = "UTF-8";
    public static final Comparator TO_STRING_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return o1.toString().compareTo(o2.toString());
        }
    };
    public static final Comparator TO_STRING_COMPARATOR_IGNORECASE = new Comparator(){

        public int compare(Object o1, Object o2) {
            return o1.toString().compareToIgnoreCase(o2.toString());
        }
    };
    public static final Comparator VALUENAMEDINSTANCE_COMPARATOR_IGNORECASE = new Comparator(){

        public int compare(Object o1, Object o2) {
            CIMInstance inst1 = ((CIMValueNamedInstance)o1).getInstance();
            CIMInstance inst2 = ((CIMValueNamedInstance)o2).getInstance();
            if (inst1 == null && inst2 == null) {
                return 0;
            }
            if (inst1 == null) {
                return -1;
            }
            if (inst2 == null) {
                return -1;
            }
            return inst1.getDisplayName().compareToIgnoreCase(inst2.getDisplayName());
        }

        public boolean equals(Object o1, Object o2) {
            CIMInstance inst1 = ((CIMValueNamedInstance)o1).getInstance();
            CIMInstance inst2 = ((CIMValueNamedInstance)o2).getInstance();
            if (inst1 == null && inst2 == null) {
                return true;
            }
            if (inst1 == null || inst2 == null) {
                return false;
            }
            return inst1.getDisplayName().equalsIgnoreCase(inst2.getDisplayName());
        }
    };
    static /* synthetic */ Class class$com$sap$lcr$api$util$Util;

    private Util() {
    }

    public static boolean equals(Object obj1, Object obj2) {
        return obj1 == null ? obj2 == null : obj1.equals(obj2);
    }

    public static boolean equalsIgnoreCase(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equalsIgnoreCase(s2);
    }

    public static boolean isLogging(Logger logger, Level level) {
        return level.intValue() >= logger.getActiveLevel().intValue();
    }

    public static String getClassName(Object obj) {
        if (obj == null) {
            return "<null>";
        }
        String name = obj.getClass().getName();
        return name.substring(1 + name.lastIndexOf(46));
    }

    public static String fromUTF8(byte[] bytes) {
        return Util.fromUTF8(bytes, 0, bytes.length);
    }

    public static String fromUTF8(byte[] bytes, int offset, int len) {
        try {
            return new String(bytes, offset, len, UTF8);
        }
        catch (UnsupportedEncodingException ex) {
            throw new InternalError(ex.toString());
        }
    }

    public static String md5GUID(String key) {
        return Util.md5GUID(new String[]{key});
    }

    public static String md5GUID(String[] keys) {
        MD5 md5Generator = new MD5();
        int i = 0;
        while (i < keys.length) {
            md5Generator.update(Util.toUTF8(keys[i]));
            ++i;
        }
        byte[] md5 = md5Generator.finish();
        StringBuffer buf = new StringBuffer(36);
        int i2 = 0;
        while (i2 < md5.length) {
            byte b;
            String hex;
            if (i2 == 4 || i2 == 6 || i2 == 8 || i2 == 10) {
                buf.append('-');
            }
            if ((hex = Integer.toHexString(0xFF & (b = md5[i2]))).length() == 1) {
                buf.append('0');
            }
            buf.append(hex);
            ++i2;
        }
        return buf.toString();
    }

    public static byte[] toUTF8(String text) {
        try {
            return text.getBytes(UTF8);
        }
        catch (UnsupportedEncodingException ex) {
            throw new InternalError(ex.toString());
        }
    }

    public static CIMInstancename createAssociation(CIMClient cimclient, String assocclassname, String propnamesource, String instancenamesource, String propnametarget, String instancenametarget) throws Exception {
        CIMClass assocclass = cimclient.getCIMClass(assocclassname, false, true, true, null);
        CIMInstance associnst = CIMFactory.instance(assocclassname);
        CIMPropertyReference propref = assocclass.getPropertyReferenceByName(propnamesource);
        if (propref == null) {
            throw new Exception("Internal: Property " + propnamesource + " for class " + assocclassname + " not found.");
        }
        CIMPropertyReference newpropref = CIMFactory.propertyReference(propref.getName());
        CIMValueReference valRef = CIMFactory.createInstancenameFromString(instancenamesource).createValueReference();
        newpropref.setValueReference(valRef);
        associnst.addPropertyReference(newpropref);
        propref = assocclass.getPropertyReferenceByName(propnametarget);
        if (propref == null) {
            throw new Exception("Internal: Property " + propnametarget + " for class " + assocclassname + " not found.");
        }
        newpropref = CIMFactory.propertyReference(propref.getName());
        valRef = CIMFactory.createInstancenameFromString(instancenametarget).createValueReference();
        newpropref.setValueReference(valRef);
        associnst.addPropertyReference(newpropref);
        return Util.createInstance(cimclient, associnst);
    }

    public static CIMInstancename createAssociation(CIMOMClient cimclient, CIMClassname assocclassname, String propnamesource, CIMInstancename instancenamesource, String propnametarget, CIMInstancename instancenametarget) throws Exception {
        CIMClass assocclass = cimclient.getCIMClass(assocclassname, false, true, true, null);
        CIMInstance associnst = assocclass.createInstanceTemplate();
        CIMPropertyReference propref = assocclass.getPropertyReferenceByName(propnamesource);
        if (propref == null) {
            throw new Exception("Internal: Property " + propnamesource + " for class " + assocclassname + " not found.");
        }
        CIMPropertyReference newpropref = CIMFactory.propertyReference(propref.getName());
        CIMValueReference valRef = instancenamesource.createValueReference();
        newpropref.setValueReference(valRef);
        associnst.addPropertyReference(newpropref);
        propref = assocclass.getPropertyReferenceByName(propnametarget);
        if (propref == null) {
            throw new Exception("Internal: Property " + propnametarget + " for class " + assocclassname + " not found.");
        }
        newpropref = CIMFactory.propertyReference(propref.getName());
        valRef = instancenametarget.createValueReference();
        newpropref.setValueReference(valRef);
        associnst.addPropertyReference(newpropref);
        return cimclient.createInstance(associnst);
    }

    public static CIMInstancename createInstance(CIMClient cimclient, CIMInstance cimInst) throws LcrException {
        try {
            try {
                CIMInstancename instName = cimclient.createInstance(cimInst);
                return instName;
            }
            catch (LcrException ex) {
                if (ex.getStatusCode() == 11) {
                    CIMClass cls = Util.getCIMClass(cimclient, cimInst.getCIMClassname());
                    CIMInstancename instName = cimInst.buildInstanceName(cls);
                    return instName;
                }
                throw ex;
            }
        }
        catch (CIMClientException cce) {
            throw new LcrException(cce);
        }
    }

    public static CIMClass getCIMClass(CIMClient client, CIMClassname classname) throws CIMClientException, LcrException {
        return client.getCIMClass(classname, false, true, true, null);
    }

    public static CIMClass getCIMClass(CIMClient client, String classname) throws CIMClientException, LcrException {
        return Util.getCIMClass(client, CIMFactory.classname(classname));
    }

    public static CIMInstance getInstance(CIMClient cimclient, CIMInstancename instancename) throws CIMClientException, LcrException {
        return cimclient.getInstance(instancename, false, true, true, null);
    }

    public static CIMInstance getInstance(CIMClient cimclient, String instancename) throws CIMClientException, LcrException {
        return cimclient.getInstance(instancename, false, true, true, null);
    }

    public static CIMInstance getWritableInstance(CIMClient cimclient, CIMInstancename instancename) throws CIMClientException, LcrException {
        CIMInstance inst = cimclient.getInstance(instancename, false, true, true, null);
        if (inst != null) {
            return inst.toWritable();
        }
        return null;
    }

    public static CIMInstance getWritableInstance(CIMClient cimclient, String instancename) throws CIMClientException, LcrException {
        CIMInstance inst = cimclient.getInstance(instancename, false, true, true, null);
        if (inst != null) {
            return inst.toWritable();
        }
        return null;
    }

    public static String getInstancePropertyValue(CIMInstance inst, String propertyname, String defaultValue) {
        if (defaultValue == null) {
            defaultValue = "";
        }
        if (propertyname == null || inst == null) {
            if (CIMTraceUtil.traceLevel >= 3) {
                logger.debug("Warning: Instance or Property-String is NULL");
            }
            return defaultValue;
        }
        CIMProperty prop = inst.getPropertyByName(propertyname);
        if (prop == null) {
            if (CIMTraceUtil.traceLevel >= 3) {
                logger.debug("Warning: getInstancePropertyValue: " + propertyname + " is NULL");
            }
            return defaultValue;
        }
        String value = inst.getPropertyByName(propertyname).getValue();
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static String getInstancePropertyValueMapValue(CIMClass cimclass, CIMInstance inst, String propertyname, String defaultValue) {
        if (defaultValue == null) {
            defaultValue = "";
        }
        if (cimclass == null || propertyname == null || inst == null) {
            if (CIMTraceUtil.traceLevel >= 3) {
                logger.debug("Warning: getInstancePropertyValueMapValue, class, instance or property string is NULL");
            }
            return defaultValue;
        }
        CIMProperty prop = inst.getPropertyByName(propertyname);
        if (prop == null) {
            if (CIMTraceUtil.traceLevel >= 3) {
                logger.debug("Warning: getInstancePropertyValueMapValue: " + propertyname + " is NULL");
            }
            return defaultValue;
        }
        CIMProperty clsProp = cimclass.getPropertyByName(propertyname);
        if (clsProp == null) {
            if (CIMTraceUtil.traceLevel >= 3) {
                logger.debug("Warning: getInstancePropertyValueMapValue: property {0} not found in class {1}", new Object[]{propertyname, cimclass.getClassname()});
            }
            return defaultValue;
        }
        CIMQualifier qvaluemap = clsProp.getQualifierByName("ValueMap");
        if (qvaluemap == null) {
            if (CIMTraceUtil.traceLevel >= 3) {
                logger.debug("Warning: getInstancePropertyValueMapValue: qualifier ValueMap for property {0} not found in class {1}", new Object[]{propertyname, cimclass.getClassname()});
            }
            return defaultValue;
        }
        CIMQualifier qvalues = clsProp.getQualifierByName("Values");
        if (qvalues == null) {
            if (CIMTraceUtil.traceLevel >= 3) {
                logger.debug("Warning: getInstancePropertyValueMapValue: qualifier Values for property {0} not found in class {1}", new Object[]{propertyname, cimclass.getClassname()});
            }
            return defaultValue;
        }
        CIMValueArray vavaluemap = qvaluemap.getValueArray();
        String[] valuemap = new String[vavaluemap.size()];
        int i = 0;
        while (i < vavaluemap.size()) {
            valuemap[i] = vavaluemap.get(i).getStringvalue();
            ++i;
        }
        String[] values = null;
        if (qvalues != null) {
            CIMValueArray vavalues = qvalues.getValueArray();
            if (vavalues != null) {
                values = new String[vavalues.size()];
                int i2 = 0;
                while (i2 < vavalues.size()) {
                    values[i2] = vavalues.get(i2).getStringvalue();
                    ++i2;
                }
            }
            String currentvalue = prop.getValue();
            int i3 = 0;
            while (i3 < valuemap.length) {
                if (valuemap[i3].equals(currentvalue) && i3 < values.length) {
                    return values[i3];
                }
                ++i3;
            }
        }
        return prop.getValue();
    }

    public static String[] getInstancePropertyValueArray(CIMInstance inst, String propertyArrayName, String[] defaultValueArray) {
        if (defaultValueArray == null) {
            defaultValueArray = new String[]{};
        }
        if (propertyArrayName == null || inst == null) {
            if (CIMTraceUtil.traceLevel >= 3) {
                logger.debug("Warning: Instance or Property-String is NULL");
            }
            return defaultValueArray;
        }
        CIMPropertyArray prop = inst.getPropertyArrayByName(propertyArrayName);
        if (prop == null) {
            if (CIMTraceUtil.traceLevel >= 3) {
                logger.debug("Warning: getInstancePropertyValueArray: " + propertyArrayName + " is NULL");
            }
            return defaultValueArray;
        }
        CIMValueArray valueArray = prop.getValueArray();
        if (valueArray == null) {
            if (CIMTraceUtil.traceLevel >= 3) {
                logger.debug("Warning: getInstancePropertyValueArray: " + propertyArrayName + " value array is NULL");
            }
            return defaultValueArray;
        }
        int x = valueArray.size();
        String[] result = new String[x];
        int i = 0;
        while (i < x) {
            result[i] = valueArray.get(i).toString();
            ++i;
        }
        return result;
    }

    public static CIMInstance findInstance(CIMClient cimclient, String classname, String[] keypropnames, String[] keypropvalues) {
        if (keypropnames.length != keypropvalues.length) {
            throw new RuntimeException("Internal error: findInstance: number of property names and values do not match");
        }
        CIMInstancename instname = CIMFactory.instancename(classname);
        int i = 0;
        while (i < keypropnames.length) {
            CIMKeybinding keybinding = CIMFactory.keybinding(keypropnames[i], keypropvalues[i]);
            instname.addKeybinding(keybinding);
            ++i;
        }
        try {
            CIMInstance inst = cimclient.getInstance(instname, false, true, true, null);
            return inst;
        }
        catch (Exception ex) {
            if (CIMTraceUtil.traceLevel >= 4) {
                logger.fine("Instance not found", ex);
            }
            return null;
        }
    }

    public static CIMInstancename getAssociationInstanceName(CIMClient cimclient, String classname, String propertyname1, CIMInstancename instname1, String propertyname2, CIMInstancename instname2) {
        CIMInstancename associnstname = CIMFactory.instancename(classname);
        CIMKeybinding keybinding = CIMFactory.keybinding(propertyname1, CIMFactory.valueReference(instname1));
        associnstname.addKeybinding(keybinding);
        keybinding = CIMFactory.keybinding(propertyname2, CIMFactory.valueReference(instname2));
        associnstname.addKeybinding(keybinding);
        return associnstname;
    }

    public static CIMInstancename getAssociatedInstanceName(CIMClient cimclient, CIMInstancename srcinstname, String assocclassname) throws CIMClientException, LcrException {
        return Util.getAssociatedInstanceName(cimclient, srcinstname, CIMFactory.classname(assocclassname));
    }

    public static CIMInstancename getAssociatedInstanceName(CIMClient cimclient, String srcinstname, String assocclassname) throws CIMClientException, LcrException {
        return Util.getAssociatedInstanceName(cimclient, CIMFactory.createInstancenameFromString(srcinstname), CIMFactory.classname(assocclassname));
    }

    public static CIMInstancename getAssociatedInstanceName(CIMClient cimclient, CIMInstancename srcinstname, CIMClassname assocclassname) throws CIMClientException, LcrException {
        CIMObjectpath[] paths = cimclient.associatorNames(srcinstname, assocclassname, null, null, null);
        if (paths.length == 0) {
            return null;
        }
        return paths[0].getInstancename();
    }

    public static CIMInstancename getAssociatedInstanceName(CIMOMClient cimclient, CIMInstancename srcinstname, CIMClassname assocclassname) throws CIMClientException, LcrException {
        CIMObjectpathList paths = cimclient.associatorNames(srcinstname, assocclassname, null, null, null);
        if (paths == null || paths.size() == 0) {
            return null;
        }
        return paths.get(0).getInstancename();
    }

    public static CIMInstancename getAssociatedInstanceNameForReference(CIMOMClient cimclient, CIMInstancename srcinstname, CIMInstancename associnstname) throws CIMClientException, LcrException {
        CIMInstance associnst = cimclient.getInstance(associnstname, false, true, true, null);
        CIMInstancename refinstname0 = associnst.getPropertyReferences().get(0).getValueReference().getInstancename();
        CIMInstancename refinstname1 = associnst.getPropertyReferences().get(1).getValueReference().getInstancename();
        if (refinstname0.equals(srcinstname)) {
            return refinstname1;
        }
        return refinstname0;
    }

    public static boolean isInstanceAssociatedWith(CIMOMClient cimclient, CIMInstancename instnamesource, CIMInstancename instnametarget, CIMClassname assoccimclassname) {
        try {
            CIMObjectpathList associatedinstances = cimclient.associatorNames(instnamesource, assoccimclassname, instnametarget.getCIMClassname(), null, null);
            return associatedinstances.contains(instnametarget);
        }
        catch (Exception ex) {
            logger.error("isInstanceAssociatedWith", ex);
            return false;
        }
    }

    public static boolean instanceExists(CIMOMClient cimclient, CIMInstancename instname) {
        try {
            CIMInstance inst = cimclient.getInstance(instname, true, false, false, null);
            return inst != null;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static CIMClass[] enumerateClasses(CIMClient cimclient, String parentClass) throws CIMClientException, LcrException {
        if (CIMTraceUtil.traceLevel >= 4) {
            logger.fine("Enumerate subclasses of " + parentClass);
        }
        return cimclient.enumerateClasses(parentClass, false, false, true, true);
    }

    public static CIMValueNamedInstance[] enumerateInstances(CIMClient cimclient, String className) throws CIMClientException, LcrException {
        if (CIMTraceUtil.traceLevel >= 4) {
            logger.fine("Enumerate instances of " + className);
        }
        return cimclient.enumerateInstancesNoSubclasses(className, false, true, true, null);
    }

    public static CIMValueNamedInstance[] enumerateInstances(CIMClient cimclient, CIMClassname className) throws CIMClientException, LcrException {
        if (CIMTraceUtil.traceLevel >= 4) {
            logger.fine("Enumerate instances of " + className);
        }
        return cimclient.enumerateInstancesNoSubclasses(className, false, true, true, null);
    }

    public static void setInstancePropertyArray(CIMClient cimclient, CIMInstance inst, String propertyname, String[] values) throws Exception {
        CIMClass cimclass = Util.getCIMClass(cimclient, CIMFactory.classname(inst.getClassname()));
        Util.setInstancePropertyArray(cimclass, inst, propertyname, values);
    }

    public static void setInstancePropertyArray(CIMClass cimclass, CIMInstance inst, String propertyname, String[] values) throws Exception {
        Util.setInstancePropertyArray(cimclass, inst, propertyname, values, true);
    }

    public static void setInstancePropertyArray(CIMClass cimclass, CIMInstance inst, String propertyname, String[] values, boolean validate) throws Exception {
        if (values == null || values.length == 0) {
            if (CIMTraceUtil.traceLevel >= 3) {
                logger.debug("Property array value (" + cimclass.getClassname() + "." + propertyname + ") is NULL");
            }
            return;
        }
        CIMPropertyArray clsproparr = cimclass.getPropertyArrayByName(propertyname);
        CIMPropertyArray newproparr = CIMFactory.propertyArray(propertyname, clsproparr.getType());
        CIMValueArray valueArray = CIMFactory.valueArray(values);
        if (validate) {
            CIMQualifier valueMap = clsproparr.getQualifierByName("ValueMap");
            int i = valueArray.size() - 1;
            while (i >= 0) {
                CIMValueArray clsValueArray;
                String value = valueArray.get(i).getStringvalue();
                if (!CIMUtil.isValidValueForType(value, clsproparr.getType())) {
                    if (CIMTraceUtil.traceLevel >= 3) {
                        logger.debug("Warning: setInstancePropertyArray: invalid value for property \"" + cimclass.getClassname() + "." + propertyname + "\" type: " + clsproparr.getType() + " value: " + value);
                    }
                    valueArray.remove(i);
                } else if (valueMap != null && (clsValueArray = valueMap.getValueArray()) != null && !clsValueArray.containsValue(value, clsproparr.getType())) {
                    if (CIMTraceUtil.traceLevel >= 3) {
                        logger.debug("Warning: setInstancePropertyArray: value not in ValueMap \"" + cimclass.getClassname() + "." + propertyname + "\" value: " + value);
                    }
                    valueArray.remove(i);
                }
                --i;
            }
        }
        if (valueArray.size() <= 0) {
            if (CIMTraceUtil.traceLevel >= 3) {
                logger.debug("Warning: setInstancePropertyArray: no values left in ValueMap \"" + cimclass.getClassname() + "." + propertyname + "\"");
            }
            return;
        }
        newproparr.setValueArray(valueArray);
        inst.addPropertyArray(newproparr);
    }

    public static void setInstanceProperty(CIMClient cimclient, CIMInstance inst, String propertyname, String value) throws Exception {
        Util.setInstanceProperty(cimclient, inst, propertyname, value, false);
    }

    public static void setInstanceProperty(CIMClass cimclass, CIMInstance inst, String propertyname, String value) throws Exception {
        Util.setInstanceProperty(cimclass, inst, propertyname, value, false);
    }

    public static void setInstanceProperty(CIMClient cimclient, CIMInstance inst, String propertyname, String value, boolean trunc) throws Exception {
        CIMClass cimclass = Util.getCIMClass(cimclient, CIMFactory.classname(inst.getClassname()));
        Util.setInstanceProperty(cimclass, inst, propertyname, value, trunc);
    }

    public static void setInstanceProperty(CIMClass cimclass, CIMInstance inst, String propertyname, String value, boolean trunc) throws Exception {
        Util.setInstanceProperty(cimclass, inst, propertyname, value, trunc, true);
    }

    public static void setInstanceProperty(CIMClass cimclass, CIMInstance inst, String propertyname, String value, boolean trunc, boolean validate) throws Exception {
        CIMValueArray valueArray;
        CIMQualifier maxlen;
        if (value == null) {
            if (CIMTraceUtil.traceLevel >= 3) {
                logger.debug("Property value (" + cimclass.getClassname() + "." + propertyname + ") is null");
            }
            return;
        }
        CIMProperty clsProp = cimclass.getPropertyByName(propertyname);
        if (clsProp == null) {
            throw new NullPointerException(cimclass.getClassname() + "." + propertyname + " not found");
        }
        CIMProperty newprop = CIMFactory.property(propertyname, clsProp.getType());
        if (trunc && (maxlen = clsProp.getQualifierByName("maxlen")) != null) {
            int max = maxlen.toInt(Integer.MAX_VALUE);
            if (value.length() > max) {
                if (CIMTraceUtil.traceLevel >= 4) {
                    logger.fine(MessageFormat.format("Truncate the property value for {0}.{1}: {2} to maxlen {3}", cimclass.getClassname(), propertyname, value, new Integer(max)));
                }
                value = value.substring(0, max);
            }
        }
        if (clsProp.getType().equals("datetime") && value.length() == 8) {
            if (value.equals("00000000")) {
                return;
            }
            value = value + "000000.000000+000";
        }
        newprop.setValue(CIMFactory.value(value));
        if (validate && !CIMUtil.isValidValueForType(newprop.getValue(), newprop.getType())) {
            if (CIMTraceUtil.traceLevel >= 3) {
                logger.debug("Warning: setInstanceProperty: invalid value for property \"" + cimclass.getClassname() + "." + propertyname + "\" type: \"" + clsProp.getType() + "\" value: \"" + value + "\"");
            }
            return;
        }
        CIMQualifier valueMap = clsProp.getQualifierByName("ValueMap");
        if (validate && valueMap != null && (valueArray = valueMap.getValueArray()) != null && !valueArray.containsValue(newprop.getValue(), newprop.getType())) {
            if (CIMTraceUtil.traceLevel >= 3) {
                logger.debug("Warning: setInstanceProperty: value not in ValueMap \"" + cimclass.getClassname() + "." + propertyname + "\" value: \"" + value + "\"");
            }
            return;
        }
        inst.addProperty(newprop);
    }

    public static CIMValueNamedInstance moveInstance(CIMClient cimclient, String oldinstname, CIMInstance newinstance) throws Exception {
        CIMInstancename oldinstancename = CIMFactory.createInstancenameFromString(oldinstname);
        CIMObjectpathList insts = cimclient.renameInstance(oldinstancename, newinstance, false, false, true, false);
        Iterator iter = insts.iterator();
        while (iter.hasNext()) {
            CIMObjectpath instpath = (CIMObjectpath)iter.next();
            if (!instpath.getInstancename().equals(oldinstancename)) continue;
            CIMObjectpath newinstpath = (CIMObjectpath)iter.next();
            CIMInstancename newinstancename = newinstpath.getInstancename();
            return CIMFactory.valueNamedInstance(newinstancename, Util.getInstance(cimclient, newinstancename));
        }
        return CIMFactory.valueNamedInstance(oldinstancename, Util.getInstance(cimclient, oldinstancename));
    }

    public static boolean removeInstance(CIMClient cimclient, String instname) {
        try {
            CIMObjectpathList list = cimclient.deleteInstance(CIMFactory.createInstancenameFromString(instname), true);
            if (CIMTraceUtil.traceLevel >= 3) {
                logger.debug(MessageFormat.format("Deleted {0} with associations ({1} instances)", instname, new Integer(list.size())));
            }
        }
        catch (Exception ex) {
            if (CIMTraceUtil.traceLevel >= 3) {
                logger.debug("removeInstance", ex);
            }
            return false;
        }
        return true;
    }

    public static String normalizeHostname(String rawHostname) {
        if (rawHostname == null) {
            return null;
        }
        int i = (rawHostname = rawHostname.trim().toLowerCase()).indexOf(".");
        if (i > 0) {
            rawHostname = rawHostname.substring(0, i);
        }
        return rawHostname;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

