/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.util;

import com.sap.lcr.api.cimclient.CIMTraceUtil;
import com.sap.lcr.api.log.Logger;
import com.sap.lcr.api.util.SetDefaultConnect;
import java.util.Properties;

public class SetProfileConnect {
    private static final Logger myLogger = Logger.getLogger((class$com$sap$lcr$api$util$SetProfileConnect == null ? (class$com$sap$lcr$api$util$SetProfileConnect = SetProfileConnect.class$("com.sap.lcr.api.util.SetProfileConnect")) : class$com$sap$lcr$api$util$SetProfileConnect).getName());
    private static final String SPECIAL_SYSNUM_VALUE = "DELETE";
    private static final String REMOVE_PARAM_NAME = "removeConfiguration";
    private static final String STORE_SERVLET_PATH = "/exchangeProfile/store";
    static /* synthetic */ Class class$com$sap$lcr$api$util$SetProfileConnect;

    SetProfileConnect() {
    }

    private void usage() {
        System.err.println("Usage:");
        System.err.println(this.getClass() + " <SYShost> <SYSport> <SYSuser> <SYSpwd> <Servlet-Path> <ProfileClient> <ProfileHost> <ProfileSysNr> <ProfileLanguage> <ProfileUser> <ProfileUserPwd>");
    }

    public static void main(String[] args) {
        SetProfileConnect setter = new SetProfileConnect();
        setter.set(args);
    }

    void set(String[] args) {
        if (args.length != 11) {
            this.usage();
            System.exit(1);
        }
        String syshost = args[0];
        String sysport = args[1];
        String sysuser = args[2];
        String syspass = args[3];
        String srvpath = args[4];
        String profclient = args[5];
        String profhost = args[6];
        String profsysnum = args[7];
        String proflang = args[8];
        String profuser = args[9];
        String profpass = args[10];
        if (sysuser.equals("EMPTY")) {
            sysuser = "";
        }
        if (syspass.equals("EMPTY")) {
            syspass = "";
        }
        if (srvpath.equals("EMPTY")) {
            srvpath = STORE_SERVLET_PATH;
        }
        if (profuser.equals("EMPTY")) {
            profuser = "";
        }
        if (profpass.equals("EMPTY")) {
            profpass = "";
        }
        if (profhost.equals("EMPTY")) {
            profhost = null;
        }
        if (profsysnum.equals("EMPTY")) {
            profsysnum = null;
        }
        Properties connProps = SetProfileConnect.createConnectProperties(profclient, profhost, profsysnum, proflang, profuser, profpass);
        SetDefaultConnect.executeConfigRequest(syshost, sysport, sysuser, syspass, srvpath, connProps, "XI profile connect parameters");
    }

    private static Properties createConnectProperties(String client, String host, String sysnum, String language, String user, String pwd) {
        Properties connProps;
        if (sysnum.equals(SPECIAL_SYSNUM_VALUE)) {
            connProps = new Properties();
            connProps.setProperty(REMOVE_PARAM_NAME, "yes");
            if (CIMTraceUtil.traceLevel >= 2) {
                myLogger.info("Delete request for profile destinations created");
            }
        } else {
            int iport;
            try {
                iport = Integer.parseInt(sysnum);
            }
            catch (NumberFormatException nfe) {
                if (CIMTraceUtil.traceLevel >= 3) {
                    myLogger.debug("Invalid system number " + sysnum, nfe);
                }
                iport = 99;
            }
            connProps = new Properties();
            connProps.setProperty("client", client);
            if (host != null) {
                connProps.setProperty("hostname", host);
            }
            if (sysnum != null) {
                connProps.setProperty("systemNumber", Integer.toString(iport));
            }
            connProps.setProperty("user", user);
            connProps.setProperty("password", pwd);
            connProps.setProperty("language", language);
            if (CIMTraceUtil.traceLevel >= 2) {
                myLogger.info("Change request for the default profile destination created");
            }
        }
        return connProps;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

