/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.util;

import com.sap.lcr.api.cim.CIMClassname;
import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMValueNamedInstanceList;
import com.sap.lcr.api.cim.CIMValueObjectWithPathList;
import com.sap.lcr.api.cimclient.CIMBatchClient;
import com.sap.lcr.api.cimclient.CIMBatchHandle;
import com.sap.lcr.api.cimclient.CIMBatchResult;
import com.sap.lcr.api.cimclient.CIMClientException;
import com.sap.lcr.api.cimclient.CIMOMClient;
import com.sap.lcr.api.cimclient.CIMOMHandle;
import com.sap.lcr.api.cimclient.ClientFactory;
import com.sap.lcr.api.cimclient.ClientUtil;
import com.sap.lcr.api.cimclient.HttpRequestSender;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.log.Logger;
import com.tssap.dtr.client.lib.protocol.Connection;
import com.tssap.dtr.client.lib.protocol.URL;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;

public class MeasureRunTimes {
    private static final Logger myLogger = Logger.getLogger((class$com$sap$lcr$api$util$MeasureRunTimes == null ? (class$com$sap$lcr$api$util$MeasureRunTimes = MeasureRunTimes.class$("com.sap.lcr.api.util.MeasureRunTimes")) : class$com$sap$lcr$api$util$MeasureRunTimes).getName());
    private static final int MAX_GET_REQUEST_RERUN = 40;
    private static final int MAX_REF_REQUEST_RERUN = 80;
    private static final int MAX_ASSOC_REQUEST_RERUN = 80;
    private static final boolean INCLUDE_QUALIFIERS = false;
    private static final boolean INCLUDE_CLASSORIGIN = false;
    private static final boolean DEEP_INHERITANCE = true;
    private static final boolean LOCAL_ONLY = false;
    private static final int ENUM_RESULT_TYPE = 0;
    private static final int GET_RESULT_TYPE = 1;
    private static final int MGET_RESULT_TYPE = 2;
    private static final int REF_RESULT_TYPE = 3;
    private static final int ASSOC_RESULT_TYPE = 4;
    private static final int MASSOC_RESULT_TYPE = 5;
    private static final int NUM_OF_RESULT_TYPES = 6;
    private static final String[] RESULT_TYPE_NAMES = new String[]{"enumerate instances", "get instances", "multi-get instances", "get references", "get associators", "multi-get associators"};
    private String myServerURL;
    private String myUser;
    private String myPwd;
    private String myRootClass;
    private String myAssocClass;
    private String myMemberClass;
    private String myMode;
    private int myUserCount;
    private int myTimeout;
    private ArrayList myUserProxies = new ArrayList();
    private ArrayList myResults = new ArrayList();
    static /* synthetic */ Class class$com$sap$lcr$api$util$MeasureRunTimes;

    public static void main(String[] args) throws Exception {
        MeasureRunTimes tester = new MeasureRunTimes();
        if (args.length < 9) {
            myLogger.info("Usage: MeasureRunTimes <server-url> <user> <pwd>");
            myLogger.info("                       <root class> <assoc class> <member class>");
            myLogger.info("                       <user count> <serial/parallel> <timeout/sec>");
            myLogger.info("                       [buffer=true/false]");
            myLogger.info("<...>: required, [...]: optional");
            return;
        }
        tester.myServerURL = args[0];
        tester.myUser = args[1];
        tester.myPwd = args[2];
        tester.myRootClass = args[3];
        tester.myAssocClass = args[4];
        tester.myMemberClass = args[5];
        tester.myUserCount = Integer.parseInt(args[6]);
        if (tester.myUserCount <= 0) {
            tester.myUserCount = 1;
        }
        tester.myMode = args[7];
        tester.myTimeout = 1000 * Integer.parseInt(args[8]);
        if (args.length > 9) {
            String bufferArg = args[9];
            if ("true".equalsIgnoreCase(bufferArg = bufferArg.substring(1 + bufferArg.indexOf(61)))) {
                String[] names = new String[]{tester.myRootClass, tester.myAssocClass, tester.myMemberClass};
                CIMOMClient client = ClientFactory.newInstance().createClient(new URL(tester.myServerURL), tester.myUser, tester.myPwd);
                int i = 0;
                while (i < names.length) {
                    CIMClassname classname = CIMFactory.classname(names[i]);
                    myLogger.info("Prebuffering " + classname.toDisplayString());
                    CIMValueNamedInstanceList list = ClientUtil.enumerateInstancesNoSubclassesComplete(client, classname);
                    myLogger.info(list.size() + " instances");
                    ++i;
                }
            }
        }
        try {
            myLogger.info("Starting " + tester.myUserCount + " clients in " + tester.myMode + " mode.");
            myLogger.info("Target server: " + tester.myServerURL);
            myLogger.info("Class: " + tester.myRootClass);
            myLogger.info("Association class: " + tester.myAssocClass);
            myLogger.info("Associated class: " + tester.myMemberClass);
            myLogger.info("Please be patient...");
            tester.setupUserProxies();
            tester.startUserProxies();
            tester.waitForUserProxies();
            tester.logResult();
        }
        catch (CIMClientException cce) {
            myLogger.error("Client exception, aborted.", cce);
            return;
        }
        catch (MalformedURLException mfue) {
            myLogger.error("Malformed URL exception, aborted.", mfue);
            return;
        }
        catch (InterruptedException ire) {
            myLogger.error("Interrupted client exception, aborted.", ire);
            return;
        }
    }

    private void setupUserProxies() throws CIMClientException, MalformedURLException {
        int iu = 0;
        while (iu < this.myUserCount) {
            UserProxy nextUserProxy = new UserProxy();
            nextUserProxy.setClient(this.myServerURL, this.myUser, this.myPwd, this.myTimeout);
            nextUserProxy.setMeasurement(this);
            this.myUserProxies.add(nextUserProxy);
            ++iu;
        }
    }

    private void startUserProxies() throws CIMClientException, MalformedURLException, InterruptedException {
        boolean serial = this.myMode.equals("serial");
        int iu = 0;
        while (iu < this.myUserCount) {
            UserProxy nextUserProxy = (UserProxy)this.myUserProxies.get(iu);
            nextUserProxy.start();
            if (serial) {
                nextUserProxy.join();
            }
            ++iu;
        }
    }

    private void waitForUserProxies() throws InterruptedException {
        boolean serial = this.myMode.equals("serial");
        if (serial) {
            return;
        }
        int iu = 0;
        while (iu < this.myUserCount) {
            UserProxy nextUserProxy = (UserProxy)this.myUserProxies.get(iu);
            nextUserProxy.join();
            ++iu;
        }
    }

    synchronized void addResult(RuntimeResult res) {
        this.myResults.add(res);
    }

    private void logResult() {
        if (this.myResults.size() == 0) {
            return;
        }
        double[] rtSumList = new double[6];
        double[] rtSquareDistList = new double[6];
        double[] rtReqSumList = new double[6];
        double[] rtReqSquareDistList = new double[6];
        int[] rtNum = new int[6];
        int ires = 0;
        while (ires < this.myResults.size()) {
            RuntimeResult nextResult = (RuntimeResult)this.myResults.get(ires);
            int n = nextResult.type;
            rtSumList[n] = rtSumList[n] + nextResult.duration;
            int n2 = nextResult.type;
            rtReqSumList[n2] = rtReqSumList[n2] + nextResult.duration * (double)nextResult.objCount / (double)nextResult.reqCount;
            int n3 = nextResult.type;
            rtNum[n3] = rtNum[n3] + 1;
            ++ires;
        }
        int i = 0;
        while (i < 6) {
            if (rtNum[i] > 0) {
                int n = i;
                rtSumList[n] = rtSumList[n] / (double)rtNum[i];
            }
            int n = i;
            rtReqSumList[n] = rtReqSumList[n] / (double)rtNum[i];
            ++i;
        }
        int ires2 = 0;
        while (ires2 < this.myResults.size()) {
            RuntimeResult nextResult = (RuntimeResult)this.myResults.get(ires2);
            double dist = nextResult.duration - rtSumList[nextResult.type];
            int n = nextResult.type;
            rtSquareDistList[n] = rtSquareDistList[n] + dist * dist;
            dist = nextResult.duration * (double)nextResult.objCount / (double)nextResult.reqCount - rtReqSumList[nextResult.type];
            int n4 = nextResult.type;
            rtReqSquareDistList[n4] = rtReqSquareDistList[n4] + dist * dist;
            ++ires2;
        }
        int i2 = 0;
        while (i2 < 6) {
            if (rtNum[i2] > 1) {
                int n = i2;
                rtSquareDistList[n] = rtSquareDistList[n] / (double)rtNum[i2];
            }
            int n = i2;
            rtReqSquareDistList[n] = rtReqSquareDistList[n] / (double)rtNum[i2];
            ++i2;
        }
        myLogger.info("------------------------------------");
        myLogger.info("Measurement result over all clients:");
        myLogger.info("------------------------------------");
        int i3 = 0;
        while (i3 < 6) {
            String logMsg;
            if (rtNum[i3] > 0) {
                logMsg = MessageFormat.format("Average duration for {0} per request [msec]:  {1,number,#.00}", RESULT_TYPE_NAMES[i3], new Double(rtReqSumList[i3]));
                myLogger.info(logMsg);
            }
            if (rtNum[i3] > 1) {
                logMsg = MessageFormat.format("   Mean distribution for {0} per request [msec]: {1,number,#.00}", RESULT_TYPE_NAMES[i3], new Double(Math.sqrt(rtReqSquareDistList[i3])));
                myLogger.info(logMsg);
            }
            if (rtNum[i3] > 0) {
                logMsg = MessageFormat.format("Average duration for {0} per object [msec]:  {1,number,#.00}", RESULT_TYPE_NAMES[i3], new Double(rtSumList[i3]));
                myLogger.info(logMsg);
            }
            if (rtNum[i3] > 1) {
                logMsg = MessageFormat.format("   Mean distribution for {0} per object [msec]: {1,number,#.00}", RESULT_TYPE_NAMES[i3], new Double(Math.sqrt(rtSquareDistList[i3])));
                myLogger.info(logMsg);
            }
            ++i3;
        }
        myLogger.info("Run time measurement finished successfully.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class RuntimeResult {
        int type;
        int reqCount;
        int objCount;
        double duration;

        RuntimeResult(int type, int reqCount, int objCount, double duration) {
            this.type = type;
            this.reqCount = reqCount;
            this.objCount = objCount;
            this.duration = duration;
        }
    }

    static class UserProxy
    extends Thread {
        private CIMOMHandle myClient = null;
        private MeasureRunTimes myMeasurement;

        UserProxy() {
        }

        void setMeasurement(MeasureRunTimes measurement) throws CIMClientException, MalformedURLException {
            this.myMeasurement = measurement;
        }

        void setClient(String url, String user, String pwd, int timeout) throws CIMClientException, MalformedURLException {
            this.myClient = ClientFactory.newInstance().createClient(new URL(url), user, pwd);
            HttpRequestSender sender = (HttpRequestSender)((CIMOMClient)this.myClient).getRequestSender();
            Connection conn = sender.getConnection();
            conn.setSocketReadTimeout(timeout);
        }

        public void run() {
            CIMValueNamedInstanceList enumResult;
            try {
                enumResult = this.listInstances();
            }
            catch (CIMClientException cimcle) {
                myLogger.error("Communication error during enumerate, aborted.", cimcle);
                return;
            }
            catch (LcrException lcre) {
                myLogger.error("CIM error during enumerate, aborted.", lcre);
                return;
            }
            try {
                this.getIndividualInstances(enumResult, false);
            }
            catch (CIMClientException cimcle) {
                myLogger.error("Communication error during get instance, aborted.", cimcle);
                return;
            }
            catch (LcrException lcre) {
                myLogger.error("CIM error during get instance, aborted.", lcre);
                return;
            }
            try {
                this.getIndividualInstances(enumResult, true);
            }
            catch (CIMClientException cimcle) {
                myLogger.error("Communication error during multi-get instance, aborted.", cimcle);
                return;
            }
            catch (LcrException lcre) {
                myLogger.error("CIM error during multi-get instance, aborted.", lcre);
                return;
            }
            try {
                this.getReferences(enumResult);
            }
            catch (CIMClientException cimcle) {
                myLogger.error("Communication error during get references, aborted.", cimcle);
                return;
            }
            catch (LcrException lcre) {
                myLogger.error("CIM error during get references, aborted.", lcre);
                return;
            }
            try {
                this.getAssociators(enumResult, false);
            }
            catch (CIMClientException cimcle) {
                myLogger.error("Communication error during get associators, aborted.", cimcle);
                return;
            }
            catch (LcrException lcre) {
                myLogger.error("CIM error during get associators, aborted.", lcre);
                return;
            }
            try {
                this.getAssociators(enumResult, true);
            }
            catch (CIMClientException cimcle) {
                myLogger.error("Communication error during get associators, aborted.", cimcle);
                return;
            }
            catch (LcrException lcre) {
                myLogger.error("CIM error during get associators, aborted.", lcre);
                return;
            }
        }

        private CIMValueNamedInstanceList listInstances() throws CIMClientException, LcrException {
            if (this.myClient == null) {
                return null;
            }
            Date startDate = new Date();
            CIMValueNamedInstanceList result = this.myClient.enumerateInstances(CIMFactory.classname(this.myMeasurement.myRootClass), false, true, false, false, null);
            double ddt = this.calculateAverageDuration(startDate, result.size());
            String logMsg = MessageFormat.format("Average duration for enumerateInstance() [msec]: {0,number,#.00}", new Double(ddt));
            myLogger.info(logMsg);
            this.myMeasurement.addResult(new RuntimeResult(0, 1, result.size(), ddt));
            return result;
        }

        private void getIndividualInstances(CIMValueNamedInstanceList vniList, boolean useMultiRequest) throws CIMClientException, LcrException {
            Date startDate = new Date();
            int reruns = Math.min(vniList.size(), 40);
            int offset = this.getListOffset(vniList.size(), reruns);
            int endindex = offset + reruns;
            if (useMultiRequest) {
                CIMBatchClient reqHandle = new CIMBatchClient();
                ((CIMBatchHandle)reqHandle).setLocalNamespacePath(this.myClient.getLocalNamespacePath());
                int i = offset;
                while (i < endindex) {
                    ((CIMBatchHandle)reqHandle).getInstance(vniList.get(i).getInstancename(), false, false, false, null);
                    ++i;
                }
                this.myClient.performBatchOperation(reqHandle);
            } else {
                int i = offset;
                while (i < endindex) {
                    this.myClient.getInstance(vniList.get(i).getInstancename(), false, false, false, null);
                    ++i;
                }
            }
            double ddt = this.calculateAverageDuration(startDate, reruns);
            String logMsg = MessageFormat.format("Average duration for {0}getInstance() [msec]: {1,number,#.00}", useMultiRequest ? "multi-" : "", new Double(ddt));
            myLogger.info(logMsg);
            this.myMeasurement.addResult(new RuntimeResult(useMultiRequest ? 2 : 1, reruns, reruns, ddt));
        }

        private void getReferences(CIMValueNamedInstanceList vniList) throws CIMClientException, LcrException {
            Date startDate = new Date();
            int reruns = Math.min(vniList.size(), 80);
            int offset = this.getListOffset(vniList.size(), reruns);
            int endindex = offset + reruns;
            int ngot = 0;
            int i = offset;
            while (i < endindex) {
                CIMValueObjectWithPathList result = this.myClient.references(vniList.get(i).getInstancename(), CIMFactory.classname(this.myMeasurement.myAssocClass), null, false, false, null);
                ngot = result.size() == 0 ? ++ngot : (ngot += result.size());
                ++i;
            }
            double ddt = this.calculateAverageDuration(startDate, ngot);
            String logMsg = MessageFormat.format("Average duration for references() [msec]: {0,number,#.00}", new Double(ddt));
            myLogger.info(logMsg);
            this.myMeasurement.addResult(new RuntimeResult(3, reruns, ngot, ddt));
        }

        private void getAssociators(CIMValueNamedInstanceList vniList, boolean useMultiRequest) throws CIMClientException, LcrException {
            Date startDate = new Date();
            int reruns = Math.min(vniList.size(), 80);
            int offset = this.getListOffset(vniList.size(), reruns);
            int endindex = offset + reruns;
            int ngot = 0;
            CIMValueObjectWithPathList result = null;
            if (useMultiRequest) {
                CIMBatchClient batchClient = new CIMBatchClient();
                batchClient.setLocalNamespacePath(this.myClient.getLocalNamespacePath());
                int i = offset;
                while (i < endindex) {
                    batchClient.associators(vniList.get(i).getInstancename(), CIMFactory.classname(this.myMeasurement.myAssocClass), CIMFactory.classname(this.myMeasurement.myMemberClass), null, null, false, false, null);
                    ++i;
                }
                CIMBatchResult batchResult = this.myClient.performBatchOperation(batchClient);
                int i2 = 0;
                while (i2 < batchResult.size()) {
                    result = (CIMValueObjectWithPathList)batchResult.getResult(i2);
                    ngot = result.size() == 0 ? ++ngot : (ngot += result.size());
                    ++i2;
                }
            } else {
                int i = offset;
                while (i < endindex) {
                    result = this.myClient.associators(vniList.get(i).getInstancename(), CIMFactory.classname(this.myMeasurement.myAssocClass), CIMFactory.classname(this.myMeasurement.myMemberClass), null, null, false, false, null);
                    ngot = result.size() == 0 ? ++ngot : (ngot += result.size());
                    ++i;
                }
            }
            double ddt = this.calculateAverageDuration(startDate, ngot);
            String logMsg = MessageFormat.format("Average duration for {0}associators() [msec]: {1,number,#.00}", useMultiRequest ? "multi-" : "", new Double(ddt));
            myLogger.info(logMsg);
            this.myMeasurement.addResult(new RuntimeResult(useMultiRequest ? 5 : 4, reruns, ngot, ddt));
        }

        private double calculateAverageDuration(Date startDate, int count) {
            Date endDate = new Date();
            long ldt = endDate.getTime() - startDate.getTime();
            double selnum = count;
            if (selnum == 0.0) {
                selnum = 1.0;
            }
            myLogger.info("Object count = " + (int)selnum);
            return (double)ldt / selnum;
        }

        private int getListOffset(int listSize, int count) {
            if (listSize <= count) {
                return 0;
            }
            int maxOffset = listSize - count;
            return (int)(Math.random() * (double)maxOffset);
        }
    }
}

