/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.saputil;

import com.sap.lcr.api.cim.CIMObjectpath;
import com.sap.lcr.api.cim.ReferenceConversionExcp;
import com.sap.lcr.api.cimclient.CIMClient;
import com.sap.lcr.api.cimclient.CIMClientException;
import com.sap.lcr.api.cimclient.CIMClientHandle;
import com.sap.lcr.api.cimclient.CIMTraceUtil;
import com.sap.lcr.api.cimclient.ClientFactory;
import com.sap.lcr.api.cimclient.HttpRequestSender;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.log.Logger;
import com.sap.lcr.api.util.LcrUtility;
import com.tssap.dtr.client.lib.protocol.Connection;
import com.tssap.dtr.client.lib.protocol.URL;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;

public class GetReferenceNames
extends LcrUtility {
    private static final int connectionArgCount = 5;
    private static Logger logger = Logger.getLogger((class$com$sap$lcr$api$saputil$GetReferenceNames == null ? (class$com$sap$lcr$api$saputil$GetReferenceNames = GetReferenceNames.class$("com.sap.lcr.api.saputil.GetReferenceNames")) : class$com$sap$lcr$api$saputil$GetReferenceNames).getName());
    static /* synthetic */ Class class$com$sap$lcr$api$saputil$GetReferenceNames;

    public GetReferenceNames(CIMClientHandle aClientHandle) throws MalformedURLException {
        super(aClientHandle);
    }

    public void keepImportsUsed(Iterator anIter, ArrayList anArrayList, TreeSet aTreeSet) {
    }

    public static void main(String[] args) {
        CIMTraceUtil.traceLevel = 0;
        GetReferenceNames util = null;
        int port = 80;
        String host = null;
        String user = null;
        String password = null;
        String namespace = null;
        CIMClient client = null;
        CIMClient myClient = null;
        Connection connection = null;
        if (args.length != 6) {
            System.out.println("Usage: GetReferenceNames <host> <port> <user> <password> <classname>");
            System.exit(1);
        }
        host = args[0];
        try {
            port = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            logger.debug("NumberFormatException encountered", e);
            System.out.println("Bad port (not a number): " + args[1]);
            System.exit(1);
        }
        user = args[2];
        password = args[3];
        System.err.println("User    : <" + user + ">");
        System.err.println("Password: <" + password + ">");
        if (user.equalsIgnoreCase("EMPTY")) {
            user = "";
        }
        if (password.equalsIgnoreCase("EMPTY")) {
            password = "";
        }
        System.err.println("User    : <" + user + ">");
        System.err.println("Password: <" + password + ">");
        namespace = args[4];
        try {
            URL url = ClientFactory.newSAPHttpURL(host, port);
            myClient = new CIMClient(ClientFactory.newInstance().createClient(url, user, password));
            myClient.setLocalNamespacePath(namespace);
            HttpRequestSender sender = (HttpRequestSender)myClient.getRequestSender();
            connection = sender.getConnection();
            connection.setSocketReadTimeout(300000);
            client = myClient;
        }
        catch (Exception e) {
            logger.debug("Failed to create client", e);
            System.out.println("Exception while creating client instance");
            e.printStackTrace();
            System.exit(1);
        }
        try {
            util = new GetReferenceNames(client);
        }
        catch (MalformedURLException e) {
            logger.debug("Malformed URL", e);
            System.out.println("Bad URL");
            System.exit(1);
        }
        String[] propArgs = new String[]{args[5]};
        try {
            util.getReferenceNames(propArgs);
        }
        catch (Exception e) {
            logger.debug("Exception from getReferenceNames call", e);
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void getReferenceNames(String[] privArgs) throws CIMClientException, LcrException, ReferenceConversionExcp {
        if (privArgs.length != 1) {
            System.out.println("Wrong argument count: getReferenceNames (<classname>)");
            System.exit(1);
        }
        String classname = privArgs[0];
        CIMObjectpath[] referenceNames = this.client.referenceNames(classname);
        int i = 0;
        while (i < referenceNames.length) {
            System.out.println(referenceNames[i].toCIMObjectReference().toString());
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

