/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.saputil;

import com.sap.lcr.api.cim.CIMClass;
import com.sap.lcr.api.cim.CIMClassList;
import com.sap.lcr.api.cim.CIMClassname;
import com.sap.lcr.api.cim.CIMClassnameList;
import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMQualifierDeclarationList;
import com.sap.lcr.api.cim.CIMUniqueList;
import com.sap.lcr.api.cim.CanonicalizedStrings;
import com.sap.lcr.api.cim.ICIMProperties;
import com.sap.lcr.api.cimclient.CIMClientException;
import com.sap.lcr.api.cimclient.CIMOMClient;
import com.sap.lcr.api.cimclient.CIMOMHandle;
import com.sap.lcr.api.cimclient.ClientFactory;
import com.sap.lcr.api.cimclient.ClientUtil;
import com.sap.lcr.api.cimclient.HttpRequestSender;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.cimclient.ModelVersion;
import com.sap.lcr.api.util.Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;

public class GenerateCIMNames {
    private static final String INTERFACE = "CIMNames";
    private static final CIMClassname __NAMESPACE = CIMFactory.classname("__Namespace");
    private static PrintWriter out;
    private static CIMOMClient client;
    private static boolean __namespaceClassExists;
    static /* synthetic */ Class class$com$sap$lcr$api$saputil$GenerateCIMNames;

    public static void main(String[] args) throws Exception {
        client = ClientFactory.newInstance().createClient(ClientFactory.newSAPHttpURL(args[0], Integer.parseInt(args[1])), args[2], args[3]);
        HttpRequestSender sender = (HttpRequestSender)client.getRequestSender();
        client.setLocalNamespacePath(CIMFactory.createLocalNamespacepathFromString(args[4]));
        out = new PrintWriter(new FileOutputStream(new File(args[5], "cimclient/CIMNames.java")));
        System.out.print("Connecting to " + sender.getHost() + ":" + sender.getPort());
        System.out.println(", namespace " + client.getLocalNamespacePath().toDisplayString());
        ModelVersion version = ModelVersion.getConnectedServerVersion(client);
        if (version == null) {
            throw new Exception("ModelVersion.getConnectedServerVersion(client): failed to get connected server's version");
        }
        System.out.println("Model version: " + version.toString());
        __namespaceClassExists = ClientUtil.exists((CIMOMHandle)client, __NAMESPACE);
        GenerateCIMNames.p("// *****************************************************************************");
        GenerateCIMNames.p("// Generated by " + (class$com$sap$lcr$api$saputil$GenerateCIMNames == null ? (class$com$sap$lcr$api$saputil$GenerateCIMNames = GenerateCIMNames.class$("com.sap.lcr.api.saputil.GenerateCIMNames")) : class$com$sap$lcr$api$saputil$GenerateCIMNames).getName() + " - do not change manually");
        GenerateCIMNames.p("// *****************************************************************************");
        GenerateCIMNames.p("package com.sap.lcr.api.cimclient;");
        GenerateCIMNames.p();
        GenerateCIMNames.p("import com.sap.lcr.api.cim.CIMClassname;");
        GenerateCIMNames.p("import com.sap.lcr.api.cim.CIMFactory;");
        GenerateCIMNames.p();
        GenerateCIMNames.p("/**");
        GenerateCIMNames.p(" * Interface providing naming constants for the SAP CIM model " + version.toString() + ".");
        GenerateCIMNames.p(" * <p>");
        GenerateCIMNames.p(" * Copyright (c) 2003 SAP AG");
        GenerateCIMNames.p(" */");
        GenerateCIMNames.p("public interface CIMNames");
        GenerateCIMNames.p("{");
        GenerateCIMNames.p("  // class names ***************************************************************");
        GenerateCIMNames.printClassNameConstants();
        GenerateCIMNames.p();
        GenerateCIMNames.p("  // qualifier names ***********************************************************");
        GenerateCIMNames.printQualifierNameConstants();
        GenerateCIMNames.printPropertiesConstants();
        GenerateCIMNames.p("}");
        out.close();
        System.out.println("Finished");
    }

    private static void printPropertiesConstants() throws CIMClientException, LcrException {
        CanonicalizedStrings[] propNames = new CanonicalizedStrings[]{new CanonicalizedStrings(), new CanonicalizedStrings(), new CanonicalizedStrings()};
        if (!__namespaceClassExists) {
            CanonicalizedStrings tmp = propNames[0];
            tmp.add("LocalNameSpacePath");
            tmp.add("NameSpace");
        }
        CIMClassList classes = ClientUtil.enumerateClassesComplete(client, null, true);
        int c = 0;
        while (c < classes.size()) {
            CIMClass cls = classes.get(c);
            int ptype = 0;
            while (ptype < 3) {
                CIMUniqueList propList;
                switch (ptype) {
                    case 0: {
                        propList = cls.getProperties();
                        break;
                    }
                    case 1: {
                        propList = cls.getPropertyArrays();
                        break;
                    }
                    case 2: {
                        propList = cls.getPropertyReferences();
                        break;
                    }
                    default: {
                        throw new RuntimeException("Internal error");
                    }
                }
                int p = 0;
                while (p < propList.size()) {
                    ICIMProperties prop = (ICIMProperties)propList.getItem(p);
                    propNames[ptype].add(prop.getName());
                    ++p;
                }
                ++ptype;
            }
            ++c;
        }
        GenerateCIMNames.p();
        GenerateCIMNames.p("  // property names ************************************************************");
        GenerateCIMNames.printPropertyConstants("P", propNames[0]);
        GenerateCIMNames.p();
        GenerateCIMNames.p("  // property array names ******************************************************");
        GenerateCIMNames.printPropertyConstants("PA", propNames[1]);
        GenerateCIMNames.p();
        GenerateCIMNames.p("  // property reference names **************************************************");
        GenerateCIMNames.printPropertyConstants("ROLE", propNames[2]);
    }

    private static void printPropertyConstants(String prefix, CanonicalizedStrings strings) {
        System.out.println("Generating property name constants - " + prefix);
        ArrayList list = new ArrayList(strings.size());
        strings.addTo(list);
        Collections.sort(list, Util.TO_STRING_COMPARATOR);
        int i = 0;
        while (i < list.size()) {
            String name = (String)list.get(i);
            GenerateCIMNames.p("  String " + prefix + "_" + name.toUpperCase() + " = \"" + name + "\";");
            ++i;
        }
    }

    private static void printClassNameConstants() throws Exception {
        System.out.println("Generating class name constants");
        CIMClassnameList classNames = client.enumerateClassNames(null, true);
        ArrayList<CIMClassname> list = new ArrayList<CIMClassname>(classNames.size());
        classNames.addItemsTo(list);
        if (!__namespaceClassExists) {
            list.add(__NAMESPACE);
        }
        Collections.sort(list, Util.TO_STRING_COMPARATOR);
        int i = 0;
        while (i < list.size()) {
            String name = ((CIMClassname)list.get(i)).toDisplayString();
            GenerateCIMNames.p("  CIMClassname C_" + name + " =");
            GenerateCIMNames.p("    CIMFactory.classname(\"" + name + "\");");
            ++i;
        }
    }

    private static void printQualifierNameConstants() throws Exception {
        System.out.println("Generating qualifier name constants");
        CIMQualifierDeclarationList qualDecls = client.enumerateQualifiers();
        ArrayList<String> list = new ArrayList<String>(qualDecls.size());
        int q = 0;
        while (q < qualDecls.size()) {
            list.add(qualDecls.get(q).getName());
            ++q;
        }
        Collections.sort(list, Util.TO_STRING_COMPARATOR);
        int i = 0;
        while (i < list.size()) {
            String name = list.get(i).toString();
            GenerateCIMNames.p("  String Q_" + name.toUpperCase() + " = \"" + name + "\";");
            ++i;
        }
    }

    private static void p() {
        out.println();
    }

    private static void p(String text) {
        out.println(text);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

