/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.sapmodel;

import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMProperty;
import com.sap.lcr.api.cim.CIMPropertyArray;
import com.sap.lcr.api.cim.CIMPropertyReference;
import com.sap.lcr.api.cim.CIMUtil;
import com.sap.lcr.api.cim.CIMValue;
import com.sap.lcr.api.cim.CIMValueArray;
import com.sap.lcr.api.cim.CIMValueReference;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import com.sap.lcr.api.cim.ReferenceConversionExcp;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.cimname.CIMObjectReference;
import java.util.Date;
import java.util.Iterator;

public class SapmodelUtilities {
    public static CIMProperty boolean2booleanCIMProperty(String propName, boolean aValue) throws LcrException {
        try {
            CIMProperty result = CIMFactory.property(propName, "boolean");
            CIMValue value = SapmodelUtilities.boolean2booleanCIMValue(aValue);
            result.setValue(value);
            return result;
        }
        catch (ItemConstructionExcp e) {
            throw new LcrException(e);
        }
    }

    public static CIMValue boolean2booleanCIMValue(boolean aValue) {
        return CIMFactory.value(aValue ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
    }

    public static Boolean booleanCIMValue2boolean(CIMValue aCIMValue) {
        String cimstring = aCIMValue.getStringvalue();
        if (cimstring == null) {
            return null;
        }
        Boolean result = Boolean.valueOf(cimstring);
        return result;
    }

    public static Boolean booleanCIMProperty2boolean(CIMProperty aCIMProperty) {
        CIMValue cimValue = aCIMProperty.getCIMValue();
        if (cimValue == null) {
            return null;
        }
        return SapmodelUtilities.booleanCIMValue2boolean(cimValue);
    }

    public static CIMPropertyArray booleanArray2booleanCIMPropertyArray(String propName, boolean[] anArray) throws LcrException {
        try {
            CIMPropertyArray result = CIMFactory.propertyArray(propName, "boolean");
            CIMValueArray valueArray = SapmodelUtilities.booleanArray2booleanCIMValueArray(anArray);
            result.setValueArray(valueArray);
            return result;
        }
        catch (ItemConstructionExcp e) {
            throw new LcrException(e);
        }
    }

    public static CIMValueArray booleanArray2booleanCIMValueArray(boolean[] anArray) {
        CIMValueArray result = CIMFactory.valueArray();
        int size = anArray.length;
        int i = 0;
        while (i < size) {
            CIMValue value = CIMFactory.value(anArray[i] ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
            result.addValue(value);
            ++i;
        }
        return result;
    }

    public static boolean[] booleanCIMValueArray2booleanArray(CIMValueArray aValueArray) throws LcrException {
        int size = aValueArray.size();
        boolean[] result = new boolean[size];
        Iterator iter = aValueArray.iterator();
        int nrInserted = 0;
        while (iter.hasNext()) {
            CIMValue value = (CIMValue)iter.next();
            String cimstring = value.getStringvalue();
            if (cimstring == null) continue;
            result[nrInserted] = Boolean.valueOf(cimstring);
            ++nrInserted;
        }
        if (nrInserted == 0) {
            return null;
        }
        if (nrInserted < size) {
            boolean[] resizedResult = new boolean[nrInserted];
            int i = 0;
            while (i < nrInserted) {
                resizedResult[i] = result[i];
                ++i;
            }
            result = resizedResult;
        }
        return result;
    }

    public static boolean[] booleanCIMPropertyArray2booleanArray(CIMPropertyArray aPropertyArray) throws LcrException {
        CIMValueArray cimValueArray = aPropertyArray.getValueArray();
        if (cimValueArray == null) {
            return null;
        }
        return SapmodelUtilities.booleanCIMValueArray2booleanArray(cimValueArray);
    }

    public static CIMProperty char2char16CIMProperty(String propName, char aValue) throws LcrException {
        try {
            CIMProperty result = CIMFactory.property(propName, "char16");
            CIMValue value = SapmodelUtilities.char2char16CIMValue(aValue);
            result.setValue(value);
            return result;
        }
        catch (ItemConstructionExcp e) {
            throw new LcrException(e);
        }
    }

    public static CIMValue char2char16CIMValue(char aValue) {
        return CIMFactory.value(new Character(aValue).toString());
    }

    public static Character char16CIMValue2char(CIMValue aCIMValue) {
        String cimstring = aCIMValue.getStringvalue();
        if (cimstring == null) {
            return null;
        }
        Character result = new Character(cimstring.charAt(0));
        return result;
    }

    public static Character char16CIMProperty2char(CIMProperty aCIMProperty) {
        CIMValue cimValue = aCIMProperty.getCIMValue();
        if (cimValue == null) {
            return null;
        }
        return SapmodelUtilities.char16CIMValue2char(cimValue);
    }

    public static CIMPropertyArray charArray2char16CIMPropertyArray(String propName, char[] anArray) throws LcrException {
        try {
            CIMPropertyArray result = CIMFactory.propertyArray(propName, "char16");
            CIMValueArray valueArray = SapmodelUtilities.charArray2char16CIMValueArray(anArray);
            result.setValueArray(valueArray);
            return result;
        }
        catch (ItemConstructionExcp e) {
            throw new LcrException(e);
        }
    }

    public static CIMValueArray charArray2char16CIMValueArray(char[] anArray) {
        CIMValueArray result = CIMFactory.valueArray();
        int size = anArray.length;
        int i = 0;
        while (i < size) {
            CIMValue value = CIMFactory.value(new Character(anArray[i]).toString());
            result.addValue(value);
            ++i;
        }
        return result;
    }

    public static char[] char16CIMValueArray2charArray(CIMValueArray aValueArray) throws LcrException {
        int size = aValueArray.size();
        char[] result = new char[size];
        Iterator iter = aValueArray.iterator();
        int nrInserted = 0;
        while (iter.hasNext()) {
            CIMValue value = (CIMValue)iter.next();
            String cimstring = value.getStringvalue();
            if (cimstring == null) continue;
            result[nrInserted] = cimstring.charAt(0);
            ++nrInserted;
        }
        if (nrInserted == 0) {
            return null;
        }
        if (nrInserted < size) {
            char[] resizedResult = new char[nrInserted];
            int i = 0;
            while (i < nrInserted) {
                resizedResult[i] = result[i];
                ++i;
            }
            result = resizedResult;
        }
        return result;
    }

    public static char[] char16CIMPropertyArray2charArray(CIMPropertyArray aPropertyArray) throws LcrException {
        CIMValueArray cimValueArray = aPropertyArray.getValueArray();
        if (cimValueArray == null) {
            return null;
        }
        return SapmodelUtilities.char16CIMValueArray2charArray(cimValueArray);
    }

    public static CIMProperty Date2datetimeCIMProperty(String propName, Date aValue) throws LcrException {
        try {
            CIMProperty result = CIMFactory.property(propName, "datetime");
            CIMValue value = SapmodelUtilities.Date2datetimeCIMValue(aValue);
            result.setValue(value);
            return result;
        }
        catch (ItemConstructionExcp e) {
            throw new LcrException(e);
        }
    }

    public static CIMValue Date2datetimeCIMValue(Date aValue) {
        return CIMFactory.value(CIMUtil.date2CimDateTime(aValue));
    }

    public static Date datetimeCIMValue2Date(CIMValue aCIMValue) {
        Date result;
        String cimstring = aCIMValue.getStringvalue();
        if (cimstring == null) {
            return null;
        }
        try {
            result = CIMUtil.cimDateTime2Date(cimstring);
        }
        catch (LcrException ex) {
            result = null;
        }
        return result;
    }

    public static Date datetimeCIMProperty2Date(CIMProperty aCIMProperty) {
        CIMValue cimValue = aCIMProperty.getCIMValue();
        if (cimValue == null) {
            return null;
        }
        return SapmodelUtilities.datetimeCIMValue2Date(cimValue);
    }

    public static CIMPropertyArray DateArray2datetimeCIMPropertyArray(String propName, Date[] anArray) throws LcrException {
        try {
            CIMPropertyArray result = CIMFactory.propertyArray(propName, "datetime");
            CIMValueArray valueArray = SapmodelUtilities.DateArray2datetimeCIMValueArray(anArray);
            result.setValueArray(valueArray);
            return result;
        }
        catch (ItemConstructionExcp e) {
            throw new LcrException(e);
        }
    }

    public static CIMValueArray DateArray2datetimeCIMValueArray(Date[] anArray) {
        CIMValueArray result = CIMFactory.valueArray();
        int size = anArray.length;
        int i = 0;
        while (i < size) {
            CIMValue value = CIMFactory.value(CIMUtil.date2CimDateTime(anArray[i]));
            result.addValue(value);
            ++i;
        }
        return result;
    }

    public static Date[] datetimeCIMValueArray2DateArray(CIMValueArray aValueArray) throws LcrException {
        int size = aValueArray.size();
        Date[] result = new Date[size];
        Iterator iter = aValueArray.iterator();
        int nrInserted = 0;
        while (iter.hasNext()) {
            CIMValue value = (CIMValue)iter.next();
            String cimstring = value.getStringvalue();
            if (cimstring == null) continue;
            result[nrInserted] = CIMUtil.cimDateTime2Date(cimstring);
            ++nrInserted;
        }
        if (nrInserted == 0) {
            return null;
        }
        if (nrInserted < size) {
            Date[] resizedResult = new Date[nrInserted];
            int i = 0;
            while (i < nrInserted) {
                resizedResult[i] = result[i];
                ++i;
            }
            result = resizedResult;
        }
        return result;
    }

    public static Date[] datetimeCIMPropertyArray2DateArray(CIMPropertyArray aPropertyArray) throws LcrException {
        CIMValueArray cimValueArray = aPropertyArray.getValueArray();
        if (cimValueArray == null) {
            return null;
        }
        return SapmodelUtilities.datetimeCIMValueArray2DateArray(cimValueArray);
    }

    public static CIMProperty float2real32CIMProperty(String propName, float aValue) throws LcrException {
        try {
            CIMProperty result = CIMFactory.property(propName, "real32");
            CIMValue value = SapmodelUtilities.float2real32CIMValue(aValue);
            result.setValue(value);
            return result;
        }
        catch (ItemConstructionExcp e) {
            throw new LcrException(e);
        }
    }

    public static CIMValue float2real32CIMValue(float aValue) {
        return CIMFactory.value(new Float(aValue).toString());
    }

    public static Float real32CIMValue2float(CIMValue aCIMValue) {
        String cimstring = aCIMValue.getStringvalue();
        if (cimstring == null) {
            return null;
        }
        Float result = Float.valueOf(cimstring);
        return result;
    }

    public static Float real32CIMProperty2float(CIMProperty aCIMProperty) {
        CIMValue cimValue = aCIMProperty.getCIMValue();
        if (cimValue == null) {
            return null;
        }
        return SapmodelUtilities.real32CIMValue2float(cimValue);
    }

    public static CIMPropertyArray floatArray2real32CIMPropertyArray(String propName, float[] anArray) throws LcrException {
        try {
            CIMPropertyArray result = CIMFactory.propertyArray(propName, "real32");
            CIMValueArray valueArray = SapmodelUtilities.floatArray2real32CIMValueArray(anArray);
            result.setValueArray(valueArray);
            return result;
        }
        catch (ItemConstructionExcp e) {
            throw new LcrException(e);
        }
    }

    public static CIMValueArray floatArray2real32CIMValueArray(float[] anArray) {
        CIMValueArray result = CIMFactory.valueArray();
        int size = anArray.length;
        int i = 0;
        while (i < size) {
            CIMValue value = CIMFactory.value(new Float(anArray[i]).toString());
            result.addValue(value);
            ++i;
        }
        return result;
    }

    public static float[] real32CIMValueArray2floatArray(CIMValueArray aValueArray) throws LcrException {
        int size = aValueArray.size();
        float[] result = new float[size];
        Iterator iter = aValueArray.iterator();
        int nrInserted = 0;
        while (iter.hasNext()) {
            CIMValue value = (CIMValue)iter.next();
            String cimstring = value.getStringvalue();
            if (cimstring == null) continue;
            result[nrInserted] = Float.valueOf(cimstring).floatValue();
            ++nrInserted;
        }
        if (nrInserted == 0) {
            return null;
        }
        if (nrInserted < size) {
            float[] resizedResult = new float[nrInserted];
            int i = 0;
            while (i < nrInserted) {
                resizedResult[i] = result[i];
                ++i;
            }
            result = resizedResult;
        }
        return result;
    }

    public static float[] real32CIMPropertyArray2floatArray(CIMPropertyArray aPropertyArray) throws LcrException {
        CIMValueArray cimValueArray = aPropertyArray.getValueArray();
        if (cimValueArray == null) {
            return null;
        }
        return SapmodelUtilities.real32CIMValueArray2floatArray(cimValueArray);
    }

    public static CIMProperty double2real64CIMProperty(String propName, double aValue) throws LcrException {
        try {
            CIMProperty result = CIMFactory.property(propName, "real64");
            CIMValue value = SapmodelUtilities.double2real64CIMValue(aValue);
            result.setValue(value);
            return result;
        }
        catch (ItemConstructionExcp e) {
            throw new LcrException(e);
        }
    }

    public static CIMValue double2real64CIMValue(double aValue) {
        return CIMFactory.value(new Double(aValue).toString());
    }

    public static Double real64CIMValue2double(CIMValue aCIMValue) {
        String cimstring = aCIMValue.getStringvalue();
        if (cimstring == null) {
            return null;
        }
        Double result = Double.valueOf(cimstring);
        return result;
    }

    public static Double real64CIMProperty2double(CIMProperty aCIMProperty) {
        CIMValue cimValue = aCIMProperty.getCIMValue();
        if (cimValue == null) {
            return null;
        }
        return SapmodelUtilities.real64CIMValue2double(cimValue);
    }

    public static CIMPropertyArray doubleArray2real64CIMPropertyArray(String propName, double[] anArray) throws LcrException {
        try {
            CIMPropertyArray result = CIMFactory.propertyArray(propName, "real64");
            CIMValueArray valueArray = SapmodelUtilities.doubleArray2real64CIMValueArray(anArray);
            result.setValueArray(valueArray);
            return result;
        }
        catch (ItemConstructionExcp e) {
            throw new LcrException(e);
        }
    }

    public static CIMValueArray doubleArray2real64CIMValueArray(double[] anArray) {
        CIMValueArray result = CIMFactory.valueArray();
        int size = anArray.length;
        int i = 0;
        while (i < size) {
            CIMValue value = CIMFactory.value(new Double(anArray[i]).toString());
            result.addValue(value);
            ++i;
        }
        return result;
    }

    public static double[] real64CIMValueArray2doubleArray(CIMValueArray aValueArray) throws LcrException {
        int size = aValueArray.size();
        double[] result = new double[size];
        Iterator iter = aValueArray.iterator();
        int nrInserted = 0;
        while (iter.hasNext()) {
            CIMValue value = (CIMValue)iter.next();
            String cimstring = value.getStringvalue();
            if (cimstring == null) continue;
            result[nrInserted] = Double.valueOf(cimstring);
            ++nrInserted;
        }
        if (nrInserted == 0) {
            return null;
        }
        if (nrInserted < size) {
            double[] resizedResult = new double[nrInserted];
            int i = 0;
            while (i < nrInserted) {
                resizedResult[i] = result[i];
                ++i;
            }
            result = resizedResult;
        }
        return result;
    }

    public static double[] real64CIMPropertyArray2doubleArray(CIMPropertyArray aPropertyArray) throws LcrException {
        CIMValueArray cimValueArray = aPropertyArray.getValueArray();
        if (cimValueArray == null) {
            return null;
        }
        return SapmodelUtilities.real64CIMValueArray2doubleArray(cimValueArray);
    }

    public static CIMPropertyReference CIMObjectReference2referenceCIMProperty(String theCIMName, CIMObjectReference aValue) throws LcrException {
        try {
            CIMValueReference valref = CIMValueReference.fromCIMObjectReference(aValue);
            CIMPropertyReference propref = CIMFactory.propertyReference(theCIMName);
            propref.setValueReference(valref);
            return propref;
        }
        catch (ReferenceConversionExcp e) {
            throw new LcrException(e);
        }
    }

    public static CIMValueReference CIMObjectReference2referenceCIMValue(CIMObjectReference aValue) throws LcrException {
        try {
            return CIMValueReference.fromCIMObjectReference(aValue);
        }
        catch (ReferenceConversionExcp e) {
            throw new LcrException(e);
        }
    }

    public static CIMObjectReference referenceCIMProperty2CIMObjectReference(CIMPropertyReference aPropertyReference) throws LcrException {
        try {
            return aPropertyReference.getValueReference().toCIMObjectReference();
        }
        catch (ReferenceConversionExcp e) {
            throw new LcrException(e);
        }
    }

    public static CIMObjectReference referenceCIMValue2CIMObjectReference(CIMValueReference aValueReference) throws LcrException {
        try {
            return aValueReference.toCIMObjectReference();
        }
        catch (ReferenceConversionExcp e) {
            throw new LcrException(e);
        }
    }

    public static CIMProperty short2sint16CIMProperty(String propName, short aValue) throws LcrException {
        try {
            CIMProperty result = CIMFactory.property(propName, "sint16");
            CIMValue value = SapmodelUtilities.short2sint16CIMValue(aValue);
            result.setValue(value);
            return result;
        }
        catch (ItemConstructionExcp e) {
            throw new LcrException(e);
        }
    }

    public static CIMValue short2sint16CIMValue(short aValue) {
        return CIMFactory.value(new Short(aValue).toString());
    }

    public static Short sint16CIMValue2short(CIMValue aCIMValue) {
        String cimstring = aCIMValue.getStringvalue();
        if (cimstring == null) {
            return null;
        }
        Short result = Short.valueOf(cimstring);
        return result;
    }

    public static Short sint16CIMProperty2short(CIMProperty aCIMProperty) {
        CIMValue cimValue = aCIMProperty.getCIMValue();
        if (cimValue == null) {
            return null;
        }
        return SapmodelUtilities.sint16CIMValue2short(cimValue);
    }

    public static CIMPropertyArray shortArray2sint16CIMPropertyArray(String propName, short[] anArray) throws LcrException {
        try {
            CIMPropertyArray result = CIMFactory.propertyArray(propName, "sint16");
            CIMValueArray valueArray = SapmodelUtilities.shortArray2sint16CIMValueArray(anArray);
            result.setValueArray(valueArray);
            return result;
        }
        catch (ItemConstructionExcp e) {
            throw new LcrException(e);
        }
    }

    public static CIMValueArray shortArray2sint16CIMValueArray(short[] anArray) {
        CIMValueArray result = CIMFactory.valueArray();
        int size = anArray.length;
        int i = 0;
        while (i < size) {
            CIMValue value = CIMFactory.value(new Short(anArray[i]).toString());
            result.addValue(value);
            ++i;
        }
        return result;
    }

    public static short[] sint16CIMValueArray2shortArray(CIMValueArray aValueArray) throws LcrException {
        int size = aValueArray.size();
        short[] result = new short[size];
        Iterator iter = aValueArray.iterator();
        int nrInserted = 0;
        while (iter.hasNext()) {
            CIMValue value = (CIMValue)iter.next();
            String cimstring = value.getStringvalue();
            if (cimstring == null) continue;
            result[nrInserted] = Short.valueOf(cimstring);
            ++nrInserted;
        }
        if (nrInserted == 0) {
            return null;
        }
        if (nrInserted < size) {
            short[] resizedResult = new short[nrInserted];
            int i = 0;
            while (i < nrInserted) {
                resizedResult[i] = result[i];
                ++i;
            }
            result = resizedResult;
        }
        return result;
    }

    public static short[] sint16CIMPropertyArray2shortArray(CIMPropertyArray aPropertyArray) throws LcrException {
        CIMValueArray cimValueArray = aPropertyArray.getValueArray();
        if (cimValueArray == null) {
            return null;
        }
        return SapmodelUtilities.sint16CIMValueArray2shortArray(cimValueArray);
    }

    public static CIMProperty int2sint32CIMProperty(String propName, int aValue) throws LcrException {
        try {
            CIMProperty result = CIMFactory.property(propName, "sint32");
            CIMValue value = SapmodelUtilities.int2sint32CIMValue(aValue);
            result.setValue(value);
            return result;
        }
        catch (ItemConstructionExcp e) {
            throw new LcrException(e);
        }
    }

    public static CIMValue int2sint32CIMValue(int aValue) {
        return CIMFactory.value(new Integer(aValue).toString());
    }

    public static Integer sint32CIMValue2int(CIMValue aCIMValue) {
        String cimstring = aCIMValue.getStringvalue();
        if (cimstring == null) {
            return null;
        }
        Integer result = Integer.valueOf(cimstring);
        return result;
    }

    public static Integer sint32CIMProperty2int(CIMProperty aCIMProperty) {
        CIMValue cimValue = aCIMProperty.getCIMValue();
        if (cimValue == null) {
            return null;
        }
        return SapmodelUtilities.sint32CIMValue2int(cimValue);
    }

    public static CIMPropertyArray intArray2sint32CIMPropertyArray(String propName, int[] anArray) throws LcrException {
        try {
            CIMPropertyArray result = CIMFactory.propertyArray(propName, "sint32");
            CIMValueArray valueArray = SapmodelUtilities.intArray2sint32CIMValueArray(anArray);
            result.setValueArray(valueArray);
            return result;
        }
        catch (ItemConstructionExcp e) {
            throw new LcrException(e);
        }
    }

    public static CIMValueArray intArray2sint32CIMValueArray(int[] anArray) {
        CIMValueArray result = CIMFactory.valueArray();
        int size = anArray.length;
        int i = 0;
        while (i < size) {
            CIMValue value = CIMFactory.value(new Integer(anArray[i]).toString());
            result.addValue(value);
            ++i;
        }
        return result;
    }

    public static int[] sint32CIMValueArray2intArray(CIMValueArray aValueArray) throws LcrException {
        int size = aValueArray.size();
        int[] result = new int[size];
        Iterator iter = aValueArray.iterator();
        int nrInserted = 0;
        while (iter.hasNext()) {
            CIMValue value = (CIMValue)iter.next();
            String cimstring = value.getStringvalue();
            if (cimstring == null) continue;
            result[nrInserted] = Integer.valueOf(cimstring);
            ++nrInserted;
        }
        if (nrInserted == 0) {
            return null;
        }
        if (nrInserted < size) {
            int[] resizedResult = new int[nrInserted];
            int i = 0;
            while (i < nrInserted) {
                resizedResult[i] = result[i];
                ++i;
            }
            result = resizedResult;
        }
        return result;
    }

    public static int[] sint32CIMPropertyArray2intArray(CIMPropertyArray aPropertyArray) throws LcrException {
        CIMValueArray cimValueArray = aPropertyArray.getValueArray();
        if (cimValueArray == null) {
            return null;
        }
        return SapmodelUtilities.sint32CIMValueArray2intArray(cimValueArray);
    }

    public static CIMProperty long2sint64CIMProperty(String propName, long aValue) throws LcrException {
        try {
            CIMProperty result = CIMFactory.property(propName, "sint64");
            CIMValue value = SapmodelUtilities.long2sint64CIMValue(aValue);
            result.setValue(value);
            return result;
        }
        catch (ItemConstructionExcp e) {
            throw new LcrException(e);
        }
    }

    public static CIMValue long2sint64CIMValue(long aValue) {
        return CIMFactory.value(new Long(aValue).toString());
    }

    public static Long sint64CIMValue2long(CIMValue aCIMValue) {
        String cimstring = aCIMValue.getStringvalue();
        if (cimstring == null) {
            return null;
        }
        Long result = Long.valueOf(cimstring);
        return result;
    }

    public static Long sint64CIMProperty2long(CIMProperty aCIMProperty) {
        CIMValue cimValue = aCIMProperty.getCIMValue();
        if (cimValue == null) {
            return null;
        }
        return SapmodelUtilities.sint64CIMValue2long(cimValue);
    }

    public static CIMPropertyArray longArray2sint64CIMPropertyArray(String propName, long[] anArray) throws LcrException {
        try {
            CIMPropertyArray result = CIMFactory.propertyArray(propName, "sint64");
            CIMValueArray valueArray = SapmodelUtilities.longArray2sint64CIMValueArray(anArray);
            result.setValueArray(valueArray);
            return result;
        }
        catch (ItemConstructionExcp e) {
            throw new LcrException(e);
        }
    }

    public static CIMValueArray longArray2sint64CIMValueArray(long[] anArray) {
        CIMValueArray result = CIMFactory.valueArray();
        int size = anArray.length;
        int i = 0;
        while (i < size) {
            CIMValue value = CIMFactory.value(new Long(anArray[i]).toString());
            result.addValue(value);
            ++i;
        }
        return result;
    }

    public static long[] sint64CIMValueArray2longArray(CIMValueArray aValueArray) throws LcrException {
        int size = aValueArray.size();
        long[] result = new long[size];
        Iterator iter = aValueArray.iterator();
        int nrInserted = 0;
        while (iter.hasNext()) {
            CIMValue value = (CIMValue)iter.next();
            String cimstring = value.getStringvalue();
            if (cimstring == null) continue;
            result[nrInserted] = Long.valueOf(cimstring);
            ++nrInserted;
        }
        if (nrInserted == 0) {
            return null;
        }
        if (nrInserted < size) {
            long[] resizedResult = new long[nrInserted];
            int i = 0;
            while (i < nrInserted) {
                resizedResult[i] = result[i];
                ++i;
            }
            result = resizedResult;
        }
        return result;
    }

    public static long[] sint64CIMPropertyArray2longArray(CIMPropertyArray aPropertyArray) throws LcrException {
        CIMValueArray cimValueArray = aPropertyArray.getValueArray();
        if (cimValueArray == null) {
            return null;
        }
        return SapmodelUtilities.sint64CIMValueArray2longArray(cimValueArray);
    }

    public static CIMProperty byte2sint8CIMProperty(String propName, byte aValue) throws LcrException {
        try {
            CIMProperty result = CIMFactory.property(propName, "sint8");
            CIMValue value = SapmodelUtilities.byte2sint8CIMValue(aValue);
            result.setValue(value);
            return result;
        }
        catch (ItemConstructionExcp e) {
            throw new LcrException(e);
        }
    }

    public static CIMValue byte2sint8CIMValue(byte aValue) {
        return CIMFactory.value(new Byte(aValue).toString());
    }

    public static Byte sint8CIMValue2byte(CIMValue aCIMValue) {
        String cimstring = aCIMValue.getStringvalue();
        if (cimstring == null) {
            return null;
        }
        Byte result = Byte.valueOf(cimstring);
        return result;
    }

    public static Byte sint8CIMProperty2byte(CIMProperty aCIMProperty) {
        CIMValue cimValue = aCIMProperty.getCIMValue();
        if (cimValue == null) {
            return null;
        }
        return SapmodelUtilities.sint8CIMValue2byte(cimValue);
    }

    public static CIMPropertyArray byteArray2sint8CIMPropertyArray(String propName, byte[] anArray) throws LcrException {
        try {
            CIMPropertyArray result = CIMFactory.propertyArray(propName, "sint8");
            CIMValueArray valueArray = SapmodelUtilities.byteArray2sint8CIMValueArray(anArray);
            result.setValueArray(valueArray);
            return result;
        }
        catch (ItemConstructionExcp e) {
            throw new LcrException(e);
        }
    }

    public static CIMValueArray byteArray2sint8CIMValueArray(byte[] anArray) {
        CIMValueArray result = CIMFactory.valueArray();
        int size = anArray.length;
        int i = 0;
        while (i < size) {
            CIMValue value = CIMFactory.value(new Byte(anArray[i]).toString());
            result.addValue(value);
            ++i;
        }
        return result;
    }

    public static byte[] sint8CIMValueArray2byteArray(CIMValueArray aValueArray) throws LcrException {
        int size = aValueArray.size();
        byte[] result = new byte[size];
        Iterator iter = aValueArray.iterator();
        int nrInserted = 0;
        while (iter.hasNext()) {
            CIMValue value = (CIMValue)iter.next();
            String cimstring = value.getStringvalue();
            if (cimstring == null) continue;
            result[nrInserted] = Byte.valueOf(cimstring);
            ++nrInserted;
        }
        if (nrInserted == 0) {
            return null;
        }
        if (nrInserted < size) {
            byte[] resizedResult = new byte[nrInserted];
            int i = 0;
            while (i < nrInserted) {
                resizedResult[i] = result[i];
                ++i;
            }
            result = resizedResult;
        }
        return result;
    }

    public static byte[] sint8CIMPropertyArray2byteArray(CIMPropertyArray aPropertyArray) throws LcrException {
        CIMValueArray cimValueArray = aPropertyArray.getValueArray();
        if (cimValueArray == null) {
            return null;
        }
        return SapmodelUtilities.sint8CIMValueArray2byteArray(cimValueArray);
    }

    public static CIMProperty String2stringCIMProperty(String propName, String aValue) throws LcrException {
        try {
            CIMProperty result = CIMFactory.property(propName, "string");
            CIMValue value = SapmodelUtilities.String2stringCIMValue(aValue);
            result.setValue(value);
            return result;
        }
        catch (ItemConstructionExcp e) {
            throw new LcrException(e);
        }
    }

    public static CIMValue String2stringCIMValue(String aValue) {
        return CIMFactory.value(aValue);
    }

    public static String stringCIMValue2String(CIMValue aCIMValue) {
        String cimstring = aCIMValue.getStringvalue();
        if (cimstring == null) {
            return null;
        }
        String result = cimstring;
        return result;
    }

    public static String stringCIMProperty2String(CIMProperty aCIMProperty) {
        CIMValue cimValue = aCIMProperty.getCIMValue();
        if (cimValue == null) {
            return null;
        }
        return SapmodelUtilities.stringCIMValue2String(cimValue);
    }

    public static CIMPropertyArray StringArray2stringCIMPropertyArray(String propName, String[] anArray) throws LcrException {
        try {
            CIMPropertyArray result = CIMFactory.propertyArray(propName, "string");
            CIMValueArray valueArray = SapmodelUtilities.StringArray2stringCIMValueArray(anArray);
            result.setValueArray(valueArray);
            return result;
        }
        catch (ItemConstructionExcp e) {
            throw new LcrException(e);
        }
    }

    public static CIMValueArray StringArray2stringCIMValueArray(String[] anArray) {
        CIMValueArray result = CIMFactory.valueArray();
        int size = anArray.length;
        int i = 0;
        while (i < size) {
            CIMValue value = CIMFactory.value(anArray[i]);
            result.addValue(value);
            ++i;
        }
        return result;
    }

    public static String[] stringCIMValueArray2StringArray(CIMValueArray aValueArray) throws LcrException {
        int size = aValueArray.size();
        String[] result = new String[size];
        Iterator iter = aValueArray.iterator();
        int nrInserted = 0;
        while (iter.hasNext()) {
            CIMValue value = (CIMValue)iter.next();
            String cimstring = value.getStringvalue();
            if (cimstring == null) continue;
            result[nrInserted] = cimstring;
            ++nrInserted;
        }
        if (nrInserted == 0) {
            return null;
        }
        if (nrInserted < size) {
            String[] resizedResult = new String[nrInserted];
            int i = 0;
            while (i < nrInserted) {
                resizedResult[i] = result[i];
                ++i;
            }
            result = resizedResult;
        }
        return result;
    }

    public static String[] stringCIMPropertyArray2StringArray(CIMPropertyArray aPropertyArray) throws LcrException {
        CIMValueArray cimValueArray = aPropertyArray.getValueArray();
        if (cimValueArray == null) {
            return null;
        }
        return SapmodelUtilities.stringCIMValueArray2StringArray(cimValueArray);
    }

    public static CIMProperty short2uint16CIMProperty(String propName, short aValue) throws LcrException {
        try {
            CIMProperty result = CIMFactory.property(propName, "uint16");
            CIMValue value = SapmodelUtilities.short2uint16CIMValue(aValue);
            result.setValue(value);
            return result;
        }
        catch (ItemConstructionExcp e) {
            throw new LcrException(e);
        }
    }

    public static CIMValue short2uint16CIMValue(short aValue) {
        return CIMFactory.value(new Short(aValue).toString());
    }

    public static Short uint16CIMValue2short(CIMValue aCIMValue) {
        String cimstring = aCIMValue.getStringvalue();
        if (cimstring == null) {
            return null;
        }
        Short result = Short.valueOf(cimstring);
        return result;
    }

    public static Short uint16CIMProperty2short(CIMProperty aCIMProperty) {
        CIMValue cimValue = aCIMProperty.getCIMValue();
        if (cimValue == null) {
            return null;
        }
        return SapmodelUtilities.uint16CIMValue2short(cimValue);
    }

    public static CIMPropertyArray shortArray2uint16CIMPropertyArray(String propName, short[] anArray) throws LcrException {
        try {
            CIMPropertyArray result = CIMFactory.propertyArray(propName, "uint16");
            CIMValueArray valueArray = SapmodelUtilities.shortArray2uint16CIMValueArray(anArray);
            result.setValueArray(valueArray);
            return result;
        }
        catch (ItemConstructionExcp e) {
            throw new LcrException(e);
        }
    }

    public static CIMValueArray shortArray2uint16CIMValueArray(short[] anArray) {
        CIMValueArray result = CIMFactory.valueArray();
        int size = anArray.length;
        int i = 0;
        while (i < size) {
            CIMValue value = CIMFactory.value(new Short(anArray[i]).toString());
            result.addValue(value);
            ++i;
        }
        return result;
    }

    public static short[] uint16CIMValueArray2shortArray(CIMValueArray aValueArray) throws LcrException {
        int size = aValueArray.size();
        short[] result = new short[size];
        Iterator iter = aValueArray.iterator();
        int nrInserted = 0;
        while (iter.hasNext()) {
            CIMValue value = (CIMValue)iter.next();
            String cimstring = value.getStringvalue();
            if (cimstring == null) continue;
            result[nrInserted] = Short.valueOf(cimstring);
            ++nrInserted;
        }
        if (nrInserted == 0) {
            return null;
        }
        if (nrInserted < size) {
            short[] resizedResult = new short[nrInserted];
            int i = 0;
            while (i < nrInserted) {
                resizedResult[i] = result[i];
                ++i;
            }
            result = resizedResult;
        }
        return result;
    }

    public static short[] uint16CIMPropertyArray2shortArray(CIMPropertyArray aPropertyArray) throws LcrException {
        CIMValueArray cimValueArray = aPropertyArray.getValueArray();
        if (cimValueArray == null) {
            return null;
        }
        return SapmodelUtilities.uint16CIMValueArray2shortArray(cimValueArray);
    }

    public static CIMProperty int2uint32CIMProperty(String propName, int aValue) throws LcrException {
        try {
            CIMProperty result = CIMFactory.property(propName, "uint32");
            CIMValue value = SapmodelUtilities.int2uint32CIMValue(aValue);
            result.setValue(value);
            return result;
        }
        catch (ItemConstructionExcp e) {
            throw new LcrException(e);
        }
    }

    public static CIMValue int2uint32CIMValue(int aValue) {
        return CIMFactory.value(new Integer(aValue).toString());
    }

    public static Integer uint32CIMValue2int(CIMValue aCIMValue) {
        String cimstring = aCIMValue.getStringvalue();
        if (cimstring == null) {
            return null;
        }
        Integer result = Integer.valueOf(cimstring);
        return result;
    }

    public static Integer uint32CIMProperty2int(CIMProperty aCIMProperty) {
        CIMValue cimValue = aCIMProperty.getCIMValue();
        if (cimValue == null) {
            return null;
        }
        return SapmodelUtilities.uint32CIMValue2int(cimValue);
    }

    public static CIMPropertyArray intArray2uint32CIMPropertyArray(String propName, int[] anArray) throws LcrException {
        try {
            CIMPropertyArray result = CIMFactory.propertyArray(propName, "uint32");
            CIMValueArray valueArray = SapmodelUtilities.intArray2uint32CIMValueArray(anArray);
            result.setValueArray(valueArray);
            return result;
        }
        catch (ItemConstructionExcp e) {
            throw new LcrException(e);
        }
    }

    public static CIMValueArray intArray2uint32CIMValueArray(int[] anArray) {
        CIMValueArray result = CIMFactory.valueArray();
        int size = anArray.length;
        int i = 0;
        while (i < size) {
            CIMValue value = CIMFactory.value(new Integer(anArray[i]).toString());
            result.addValue(value);
            ++i;
        }
        return result;
    }

    public static int[] uint32CIMValueArray2intArray(CIMValueArray aValueArray) throws LcrException {
        int size = aValueArray.size();
        int[] result = new int[size];
        Iterator iter = aValueArray.iterator();
        int nrInserted = 0;
        while (iter.hasNext()) {
            CIMValue value = (CIMValue)iter.next();
            String cimstring = value.getStringvalue();
            if (cimstring == null) continue;
            result[nrInserted] = Integer.valueOf(cimstring);
            ++nrInserted;
        }
        if (nrInserted == 0) {
            return null;
        }
        if (nrInserted < size) {
            int[] resizedResult = new int[nrInserted];
            int i = 0;
            while (i < nrInserted) {
                resizedResult[i] = result[i];
                ++i;
            }
            result = resizedResult;
        }
        return result;
    }

    public static int[] uint32CIMPropertyArray2intArray(CIMPropertyArray aPropertyArray) throws LcrException {
        CIMValueArray cimValueArray = aPropertyArray.getValueArray();
        if (cimValueArray == null) {
            return null;
        }
        return SapmodelUtilities.uint32CIMValueArray2intArray(cimValueArray);
    }

    public static CIMProperty long2uint64CIMProperty(String propName, long aValue) throws LcrException {
        try {
            CIMProperty result = CIMFactory.property(propName, "uint64");
            CIMValue value = SapmodelUtilities.long2uint64CIMValue(aValue);
            result.setValue(value);
            return result;
        }
        catch (ItemConstructionExcp e) {
            throw new LcrException(e);
        }
    }

    public static CIMValue long2uint64CIMValue(long aValue) {
        return CIMFactory.value(new Long(aValue).toString());
    }

    public static Long uint64CIMValue2long(CIMValue aCIMValue) {
        String cimstring = aCIMValue.getStringvalue();
        if (cimstring == null) {
            return null;
        }
        Long result = Long.valueOf(cimstring);
        return result;
    }

    public static Long uint64CIMProperty2long(CIMProperty aCIMProperty) {
        CIMValue cimValue = aCIMProperty.getCIMValue();
        if (cimValue == null) {
            return null;
        }
        return SapmodelUtilities.uint64CIMValue2long(cimValue);
    }

    public static CIMPropertyArray longArray2uint64CIMPropertyArray(String propName, long[] anArray) throws LcrException {
        try {
            CIMPropertyArray result = CIMFactory.propertyArray(propName, "uint64");
            CIMValueArray valueArray = SapmodelUtilities.longArray2uint64CIMValueArray(anArray);
            result.setValueArray(valueArray);
            return result;
        }
        catch (ItemConstructionExcp e) {
            throw new LcrException(e);
        }
    }

    public static CIMValueArray longArray2uint64CIMValueArray(long[] anArray) {
        CIMValueArray result = CIMFactory.valueArray();
        int size = anArray.length;
        int i = 0;
        while (i < size) {
            CIMValue value = CIMFactory.value(new Long(anArray[i]).toString());
            result.addValue(value);
            ++i;
        }
        return result;
    }

    public static long[] uint64CIMValueArray2longArray(CIMValueArray aValueArray) throws LcrException {
        int size = aValueArray.size();
        long[] result = new long[size];
        Iterator iter = aValueArray.iterator();
        int nrInserted = 0;
        while (iter.hasNext()) {
            CIMValue value = (CIMValue)iter.next();
            String cimstring = value.getStringvalue();
            if (cimstring == null) continue;
            result[nrInserted] = Long.valueOf(cimstring);
            ++nrInserted;
        }
        if (nrInserted == 0) {
            return null;
        }
        if (nrInserted < size) {
            long[] resizedResult = new long[nrInserted];
            int i = 0;
            while (i < nrInserted) {
                resizedResult[i] = result[i];
                ++i;
            }
            result = resizedResult;
        }
        return result;
    }

    public static long[] uint64CIMPropertyArray2longArray(CIMPropertyArray aPropertyArray) throws LcrException {
        CIMValueArray cimValueArray = aPropertyArray.getValueArray();
        if (cimValueArray == null) {
            return null;
        }
        return SapmodelUtilities.uint64CIMValueArray2longArray(cimValueArray);
    }

    public static CIMProperty byte2uint8CIMProperty(String propName, byte aValue) throws LcrException {
        try {
            CIMProperty result = CIMFactory.property(propName, "uint8");
            CIMValue value = SapmodelUtilities.byte2uint8CIMValue(aValue);
            result.setValue(value);
            return result;
        }
        catch (ItemConstructionExcp e) {
            throw new LcrException(e);
        }
    }

    public static CIMValue byte2uint8CIMValue(byte aValue) {
        return CIMFactory.value(new Byte(aValue).toString());
    }

    public static Byte uint8CIMValue2byte(CIMValue aCIMValue) {
        String cimstring = aCIMValue.getStringvalue();
        if (cimstring == null) {
            return null;
        }
        Byte result = Byte.valueOf(cimstring);
        return result;
    }

    public static Byte uint8CIMProperty2byte(CIMProperty aCIMProperty) {
        CIMValue cimValue = aCIMProperty.getCIMValue();
        if (cimValue == null) {
            return null;
        }
        return SapmodelUtilities.uint8CIMValue2byte(cimValue);
    }

    public static CIMPropertyArray byteArray2uint8CIMPropertyArray(String propName, byte[] anArray) throws LcrException {
        try {
            CIMPropertyArray result = CIMFactory.propertyArray(propName, "uint8");
            CIMValueArray valueArray = SapmodelUtilities.byteArray2uint8CIMValueArray(anArray);
            result.setValueArray(valueArray);
            return result;
        }
        catch (ItemConstructionExcp e) {
            throw new LcrException(e);
        }
    }

    public static CIMValueArray byteArray2uint8CIMValueArray(byte[] anArray) {
        CIMValueArray result = CIMFactory.valueArray();
        int size = anArray.length;
        int i = 0;
        while (i < size) {
            CIMValue value = CIMFactory.value(new Byte(anArray[i]).toString());
            result.addValue(value);
            ++i;
        }
        return result;
    }

    public static byte[] uint8CIMValueArray2byteArray(CIMValueArray aValueArray) throws LcrException {
        int size = aValueArray.size();
        byte[] result = new byte[size];
        Iterator iter = aValueArray.iterator();
        int nrInserted = 0;
        while (iter.hasNext()) {
            CIMValue value = (CIMValue)iter.next();
            String cimstring = value.getStringvalue();
            if (cimstring == null) continue;
            result[nrInserted] = Byte.valueOf(cimstring);
            ++nrInserted;
        }
        if (nrInserted == 0) {
            return null;
        }
        if (nrInserted < size) {
            byte[] resizedResult = new byte[nrInserted];
            int i = 0;
            while (i < nrInserted) {
                resizedResult[i] = result[i];
                ++i;
            }
            result = resizedResult;
        }
        return result;
    }

    public static byte[] uint8CIMPropertyArray2byteArray(CIMPropertyArray aPropertyArray) throws LcrException {
        CIMValueArray cimValueArray = aPropertyArray.getValueArray();
        if (cimValueArray == null) {
            return null;
        }
        return SapmodelUtilities.uint8CIMValueArray2byteArray(cimValueArray);
    }

    public static void appendProperty(StringBuffer aBuffer, String aPropName, CIMObjectReference aValue, boolean isInstvarKey, boolean isInstvarValid) {
        StringBuffer buffer = new StringBuffer(25);
        buffer.append("                         ");
        buffer.replace(0, aPropName.length() - 1, aPropName);
        String nameString = buffer.toString();
        String keyInd = isInstvarKey ? "Key / " : "--- / ";
        String validInd = isInstvarValid ? "Val => " : "--- => ";
        aBuffer.append(nameString).append(keyInd).append(validInd);
        if (aValue != null) {
            aBuffer.append(aValue);
        } else {
            aBuffer.append("<null>");
        }
        aBuffer.append("\n");
    }

    public static void appendProperty(StringBuffer aBuffer, String aPropName, CIMObjectReference[] aValue, boolean isInstvarKey, boolean isInstvarValid) {
        StringBuffer buffer = new StringBuffer(25);
        buffer.append("                         ");
        buffer.replace(0, aPropName.length() - 1, aPropName);
        String nameString = buffer.toString();
        String keyInd = isInstvarKey ? "Key / " : "--- / ";
        String validInd = isInstvarValid ? "Val => " : "--- => ";
        aBuffer.append(nameString).append(keyInd).append(validInd);
        if (aValue != null) {
            aBuffer.append(aValue);
        } else {
            aBuffer.append("<null>");
        }
        aBuffer.append("\n");
    }

    public static void appendProperty(StringBuffer aBuffer, String aPropName, Date aValue, boolean isInstvarKey, boolean isInstvarValid) {
        StringBuffer buffer = new StringBuffer(25);
        buffer.append("                         ");
        buffer.replace(0, aPropName.length() - 1, aPropName);
        String nameString = buffer.toString();
        String keyInd = isInstvarKey ? "Key / " : "--- / ";
        String validInd = isInstvarValid ? "Val => " : "--- => ";
        aBuffer.append(nameString).append(keyInd).append(validInd);
        if (aValue != null) {
            aBuffer.append(aValue);
        } else {
            aBuffer.append("<null>");
        }
        aBuffer.append("\n");
    }

    public static void appendProperty(StringBuffer aBuffer, String aPropName, Date[] aValue, boolean isInstvarKey, boolean isInstvarValid) {
        StringBuffer buffer = new StringBuffer(25);
        buffer.append("                         ");
        buffer.replace(0, aPropName.length() - 1, aPropName);
        String nameString = buffer.toString();
        String keyInd = isInstvarKey ? "Key / " : "--- / ";
        String validInd = isInstvarValid ? "Val => " : "--- => ";
        aBuffer.append(nameString).append(keyInd).append(validInd);
        if (aValue != null) {
            aBuffer.append(aValue);
        } else {
            aBuffer.append("<null>");
        }
        aBuffer.append("\n");
    }

    public static void appendProperty(StringBuffer aBuffer, String aPropName, String aValue, boolean isInstvarKey, boolean isInstvarValid) {
        StringBuffer buffer = new StringBuffer(25);
        buffer.append("                         ");
        buffer.replace(0, aPropName.length() - 1, aPropName);
        String nameString = buffer.toString();
        String keyInd = isInstvarKey ? "Key / " : "--- / ";
        String validInd = isInstvarValid ? "Val => " : "--- => ";
        aBuffer.append(nameString).append(keyInd).append(validInd);
        if (aValue != null) {
            aBuffer.append(aValue);
        } else {
            aBuffer.append("<null>");
        }
        aBuffer.append("\n");
    }

    public static void appendProperty(StringBuffer aBuffer, String aPropName, String[] aValue, boolean isInstvarKey, boolean isInstvarValid) {
        StringBuffer buffer = new StringBuffer(25);
        buffer.append("                         ");
        buffer.replace(0, aPropName.length() - 1, aPropName);
        String nameString = buffer.toString();
        String keyInd = isInstvarKey ? "Key / " : "--- / ";
        String validInd = isInstvarValid ? "Val => " : "--- => ";
        aBuffer.append(nameString).append(keyInd).append(validInd);
        if (aValue != null) {
            aBuffer.append(aValue);
        } else {
            aBuffer.append("<null>");
        }
        aBuffer.append("\n");
    }

    public static void appendProperty(StringBuffer aBuffer, String aPropName, boolean aValue, boolean isInstvarKey, boolean isInstvarValid) {
        StringBuffer buffer = new StringBuffer(25);
        buffer.append("                         ");
        buffer.replace(0, aPropName.length() - 1, aPropName);
        String nameString = buffer.toString();
        String keyInd = isInstvarKey ? "Key / " : "--- / ";
        String validInd = isInstvarValid ? "Val => " : "--- => ";
        aBuffer.append(nameString).append(keyInd).append(validInd);
        aBuffer.append(aValue);
        aBuffer.append("\n");
    }

    public static void appendProperty(StringBuffer aBuffer, String aPropName, boolean[] aValue, boolean isInstvarKey, boolean isInstvarValid) {
        StringBuffer buffer = new StringBuffer(25);
        buffer.append("                         ");
        buffer.replace(0, aPropName.length() - 1, aPropName);
        String nameString = buffer.toString();
        String keyInd = isInstvarKey ? "Key / " : "--- / ";
        String validInd = isInstvarValid ? "Val => " : "--- => ";
        aBuffer.append(nameString).append(keyInd).append(validInd);
        if (aValue != null) {
            aBuffer.append(aValue);
        } else {
            aBuffer.append("<null>");
        }
        aBuffer.append("\n");
    }

    public static void appendProperty(StringBuffer aBuffer, String aPropName, byte aValue, boolean isInstvarKey, boolean isInstvarValid) {
        StringBuffer buffer = new StringBuffer(25);
        buffer.append("                         ");
        buffer.replace(0, aPropName.length() - 1, aPropName);
        String nameString = buffer.toString();
        String keyInd = isInstvarKey ? "Key / " : "--- / ";
        String validInd = isInstvarValid ? "Val => " : "--- => ";
        aBuffer.append(nameString).append(keyInd).append(validInd);
        aBuffer.append(aValue);
        aBuffer.append("\n");
    }

    public static void appendProperty(StringBuffer aBuffer, String aPropName, byte[] aValue, boolean isInstvarKey, boolean isInstvarValid) {
        StringBuffer buffer = new StringBuffer(25);
        buffer.append("                         ");
        buffer.replace(0, aPropName.length() - 1, aPropName);
        String nameString = buffer.toString();
        String keyInd = isInstvarKey ? "Key / " : "--- / ";
        String validInd = isInstvarValid ? "Val => " : "--- => ";
        aBuffer.append(nameString).append(keyInd).append(validInd);
        if (aValue != null) {
            aBuffer.append(aValue);
        } else {
            aBuffer.append("<null>");
        }
        aBuffer.append("\n");
    }

    public static void appendProperty(StringBuffer aBuffer, String aPropName, char aValue, boolean isInstvarKey, boolean isInstvarValid) {
        StringBuffer buffer = new StringBuffer(25);
        buffer.append("                         ");
        buffer.replace(0, aPropName.length() - 1, aPropName);
        String nameString = buffer.toString();
        String keyInd = isInstvarKey ? "Key / " : "--- / ";
        String validInd = isInstvarValid ? "Val => " : "--- => ";
        aBuffer.append(nameString).append(keyInd).append(validInd);
        aBuffer.append(aValue);
        aBuffer.append("\n");
    }

    public static void appendProperty(StringBuffer aBuffer, String aPropName, char[] aValue, boolean isInstvarKey, boolean isInstvarValid) {
        StringBuffer buffer = new StringBuffer(25);
        buffer.append("                         ");
        buffer.replace(0, aPropName.length() - 1, aPropName);
        String nameString = buffer.toString();
        String keyInd = isInstvarKey ? "Key / " : "--- / ";
        String validInd = isInstvarValid ? "Val => " : "--- => ";
        aBuffer.append(nameString).append(keyInd).append(validInd);
        if (aValue != null) {
            aBuffer.append(aValue);
        } else {
            aBuffer.append("<null>");
        }
        aBuffer.append("\n");
    }

    public static void appendProperty(StringBuffer aBuffer, String aPropName, double aValue, boolean isInstvarKey, boolean isInstvarValid) {
        StringBuffer buffer = new StringBuffer(25);
        buffer.append("                         ");
        buffer.replace(0, aPropName.length() - 1, aPropName);
        String nameString = buffer.toString();
        String keyInd = isInstvarKey ? "Key / " : "--- / ";
        String validInd = isInstvarValid ? "Val => " : "--- => ";
        aBuffer.append(nameString).append(keyInd).append(validInd);
        aBuffer.append(aValue);
        aBuffer.append("\n");
    }

    public static void appendProperty(StringBuffer aBuffer, String aPropName, double[] aValue, boolean isInstvarKey, boolean isInstvarValid) {
        StringBuffer buffer = new StringBuffer(25);
        buffer.append("                         ");
        buffer.replace(0, aPropName.length() - 1, aPropName);
        String nameString = buffer.toString();
        String keyInd = isInstvarKey ? "Key / " : "--- / ";
        String validInd = isInstvarValid ? "Val => " : "--- => ";
        aBuffer.append(nameString).append(keyInd).append(validInd);
        if (aValue != null) {
            aBuffer.append(aValue);
        } else {
            aBuffer.append("<null>");
        }
        aBuffer.append("\n");
    }

    public static void appendProperty(StringBuffer aBuffer, String aPropName, float aValue, boolean isInstvarKey, boolean isInstvarValid) {
        StringBuffer buffer = new StringBuffer(25);
        buffer.append("                         ");
        buffer.replace(0, aPropName.length() - 1, aPropName);
        String nameString = buffer.toString();
        String keyInd = isInstvarKey ? "Key / " : "--- / ";
        String validInd = isInstvarValid ? "Val => " : "--- => ";
        aBuffer.append(nameString).append(keyInd).append(validInd);
        aBuffer.append(aValue);
        aBuffer.append("\n");
    }

    public static void appendProperty(StringBuffer aBuffer, String aPropName, float[] aValue, boolean isInstvarKey, boolean isInstvarValid) {
        StringBuffer buffer = new StringBuffer(25);
        buffer.append("                         ");
        buffer.replace(0, aPropName.length() - 1, aPropName);
        String nameString = buffer.toString();
        String keyInd = isInstvarKey ? "Key / " : "--- / ";
        String validInd = isInstvarValid ? "Val => " : "--- => ";
        aBuffer.append(nameString).append(keyInd).append(validInd);
        if (aValue != null) {
            aBuffer.append(aValue);
        } else {
            aBuffer.append("<null>");
        }
        aBuffer.append("\n");
    }

    public static void appendProperty(StringBuffer aBuffer, String aPropName, int aValue, boolean isInstvarKey, boolean isInstvarValid) {
        StringBuffer buffer = new StringBuffer(25);
        buffer.append("                         ");
        buffer.replace(0, aPropName.length() - 1, aPropName);
        String nameString = buffer.toString();
        String keyInd = isInstvarKey ? "Key / " : "--- / ";
        String validInd = isInstvarValid ? "Val => " : "--- => ";
        aBuffer.append(nameString).append(keyInd).append(validInd);
        aBuffer.append(aValue);
        aBuffer.append("\n");
    }

    public static void appendProperty(StringBuffer aBuffer, String aPropName, int[] aValue, boolean isInstvarKey, boolean isInstvarValid) {
        StringBuffer buffer = new StringBuffer(25);
        buffer.append("                         ");
        buffer.replace(0, aPropName.length() - 1, aPropName);
        String nameString = buffer.toString();
        String keyInd = isInstvarKey ? "Key / " : "--- / ";
        String validInd = isInstvarValid ? "Val => " : "--- => ";
        aBuffer.append(nameString).append(keyInd).append(validInd);
        if (aValue != null) {
            aBuffer.append(aValue);
        } else {
            aBuffer.append("<null>");
        }
        aBuffer.append("\n");
    }

    public static void appendProperty(StringBuffer aBuffer, String aPropName, long aValue, boolean isInstvarKey, boolean isInstvarValid) {
        StringBuffer buffer = new StringBuffer(25);
        buffer.append("                         ");
        buffer.replace(0, aPropName.length() - 1, aPropName);
        String nameString = buffer.toString();
        String keyInd = isInstvarKey ? "Key / " : "--- / ";
        String validInd = isInstvarValid ? "Val => " : "--- => ";
        aBuffer.append(nameString).append(keyInd).append(validInd);
        aBuffer.append(aValue);
        aBuffer.append("\n");
    }

    public static void appendProperty(StringBuffer aBuffer, String aPropName, long[] aValue, boolean isInstvarKey, boolean isInstvarValid) {
        StringBuffer buffer = new StringBuffer(25);
        buffer.append("                         ");
        buffer.replace(0, aPropName.length() - 1, aPropName);
        String nameString = buffer.toString();
        String keyInd = isInstvarKey ? "Key / " : "--- / ";
        String validInd = isInstvarValid ? "Val => " : "--- => ";
        aBuffer.append(nameString).append(keyInd).append(validInd);
        if (aValue != null) {
            aBuffer.append(aValue);
        } else {
            aBuffer.append("<null>");
        }
        aBuffer.append("\n");
    }

    public static void appendProperty(StringBuffer aBuffer, String aPropName, short aValue, boolean isInstvarKey, boolean isInstvarValid) {
        StringBuffer buffer = new StringBuffer(25);
        buffer.append("                         ");
        buffer.replace(0, aPropName.length() - 1, aPropName);
        String nameString = buffer.toString();
        String keyInd = isInstvarKey ? "Key / " : "--- / ";
        String validInd = isInstvarValid ? "Val => " : "--- => ";
        aBuffer.append(nameString).append(keyInd).append(validInd);
        aBuffer.append(aValue);
        aBuffer.append("\n");
    }

    public static void appendProperty(StringBuffer aBuffer, String aPropName, short[] aValue, boolean isInstvarKey, boolean isInstvarValid) {
        StringBuffer buffer = new StringBuffer(25);
        buffer.append("                         ");
        buffer.replace(0, aPropName.length() - 1, aPropName);
        String nameString = buffer.toString();
        String keyInd = isInstvarKey ? "Key / " : "--- / ";
        String validInd = isInstvarValid ? "Val => " : "--- => ";
        aBuffer.append(nameString).append(keyInd).append(validInd);
        if (aValue != null) {
            aBuffer.append(aValue);
        } else {
            aBuffer.append("<null>");
        }
        aBuffer.append("\n");
    }

    public static void printReference(String aName, Object aRef) {
        StringBuffer buffer = new StringBuffer(25);
        buffer.append("                         ");
        buffer.replace(0, aName.length() - 1, aName);
        String nameString = buffer.toString();
        if (aRef == null) {
            System.out.println(nameString + "<null>");
        } else {
            System.out.println(nameString + aRef + " (" + aRef.getClass() + ")");
        }
    }
}

