/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.sapaccess;

import com.sap.lcr.api.cimclient.CIMClientHandle;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.sapmodel.CIMInstancepathJavacimobject;
import com.sap.lcr.api.sapmodel.SAP_ABAPDriverRFCDestination;
import com.sap.lcr.api.sapmodel.SAP_ApplicationSystem;
import com.sap.lcr.api.sapmodel.SAP_ApplicationSystemAccessor;
import com.sap.lcr.api.sapmodel.SAP_BCApplicationServer;
import com.sap.lcr.api.sapmodel.SAP_BCApplicationServerAccessor;
import com.sap.lcr.api.sapmodel.SAP_BCClient;
import com.sap.lcr.api.sapmodel.SAP_BCClientAccessor;
import com.sap.lcr.api.sapmodel.SAP_BCMessageServer;
import com.sap.lcr.api.sapmodel.SAP_BCMessageServerAccessor;
import com.sap.lcr.api.sapmodel.SAP_BCSystem;
import com.sap.lcr.api.sapmodel.SAP_BCSystemAccessor;
import com.sap.lcr.api.sapmodel.SAP_BusinessSystem;
import com.sap.lcr.api.sapmodel.SAP_BusinessSystemAccessor;
import com.sap.lcr.api.sapmodel.SAP_CMCRFCDestination;
import com.sap.lcr.api.sapmodel.SAP_ComputerSystem;
import com.sap.lcr.api.sapmodel.SAP_ExternalBusinessSystem;
import com.sap.lcr.api.sapmodel.SAP_ExternalBusinessSystemAccessor;
import com.sap.lcr.api.sapmodel.SAP_GlobalUniqueID;
import com.sap.lcr.api.sapmodel.SAP_InstalledProduct;
import com.sap.lcr.api.sapmodel.SAP_InstalledProductAccessor;
import com.sap.lcr.api.sapmodel.SAP_InstalledSoftwareComponent;
import com.sap.lcr.api.sapmodel.SAP_InstalledSoftwareComponentAccessor;
import com.sap.lcr.api.sapmodel.SAP_R2RFCDestination;
import com.sap.lcr.api.sapmodel.SAP_R3InternalRFCDestination;
import com.sap.lcr.api.sapmodel.SAP_R3LogicalRFCDestination;
import com.sap.lcr.api.sapmodel.SAP_R3RFCDestination;
import com.sap.lcr.api.sapmodel.SAP_RFCDestination;
import com.sap.lcr.api.sapmodel.SAP_SNARFCDestination;
import com.sap.lcr.api.sapmodel.SAP_SoftwareComponent;
import com.sap.lcr.api.sapmodel.SAP_SoftwareComponentAccessor;
import com.sap.lcr.api.sapmodel.SAP_TCPIPRFCDestination;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

public class SDAccess {
    private CIMClientHandle client = null;

    public SDAccess(CIMClientHandle clientHandle) {
        this.client = clientHandle;
    }

    public SAP_ApplicationSystem getApplicationSystem(SAP_BusinessSystem businessSystem) throws LcrException {
        SAP_BusinessSystemAccessor businessSystemAcc = new SAP_BusinessSystemAccessor(this.client);
        CIMInstancepathJavacimobject[] CIMInstancePathJavaCIMObjectArray = null;
        SAP_ApplicationSystem applicationSystem = null;
        CIMInstancePathJavaCIMObjectArray = businessSystemAcc.associators(businessSystem, "SAP_LogicalSystemViewedSystem", "SAP_ApplicationSystem", null, null, null);
        if (CIMInstancePathJavaCIMObjectArray != null && CIMInstancePathJavaCIMObjectArray.length != 0) {
            applicationSystem = (SAP_ApplicationSystem)CIMInstancePathJavaCIMObjectArray[0].getJavaCIMObject();
        }
        return applicationSystem;
    }

    public SAP_BCApplicationServer[] getBCApplicationServerList(SAP_BCSystem BCSystem) throws LcrException {
        SAP_BCSystemAccessor BCSystemAcc = new SAP_BCSystemAccessor(this.client);
        CIMInstancepathJavacimobject[] CIMInstancePathJavaCIMObjectArray = null;
        SAP_BCApplicationServer[] applicationServerArray = null;
        CIMInstancePathJavaCIMObjectArray = BCSystemAcc.associators(BCSystem, "SAP_BCSystemApplicationServer", "SAP_BCApplicationServer", null, null, null);
        int array_length = CIMInstancePathJavaCIMObjectArray == null ? 0 : CIMInstancePathJavaCIMObjectArray.length;
        applicationServerArray = new SAP_BCApplicationServer[array_length];
        int i = 0;
        while (i < array_length) {
            applicationServerArray[i] = (SAP_BCApplicationServer)CIMInstancePathJavaCIMObjectArray[i].getJavaCIMObject();
            ++i;
        }
        return applicationServerArray;
    }

    public SAP_BCClient getBCClient(SAP_BusinessSystem businessSystem) throws LcrException {
        SAP_BusinessSystemAccessor businessSystemAcc = new SAP_BusinessSystemAccessor(this.client);
        CIMInstancepathJavacimobject[] CIMInstancePathJavaCIMObjectArray = null;
        SAP_BCClient BCClient = null;
        CIMInstancePathJavaCIMObjectArray = businessSystemAcc.associators(businessSystem, "SAP_BusinessSystemViewedBCClient", "SAP_BCClient", null, null, null);
        if (CIMInstancePathJavaCIMObjectArray != null && CIMInstancePathJavaCIMObjectArray.length != 0) {
            BCClient = (SAP_BCClient)CIMInstancePathJavaCIMObjectArray[0].getJavaCIMObject();
        }
        return BCClient;
    }

    public SAP_BCClient[] getBCClientList(SAP_BCSystem BCSystem) throws LcrException {
        SAP_BCSystemAccessor BCSystemAcc = new SAP_BCSystemAccessor(this.client);
        CIMInstancepathJavacimobject[] CIMInstancePathJavaCIMObjectArray = null;
        SAP_BCClient[] clientArray = null;
        CIMInstancePathJavaCIMObjectArray = BCSystemAcc.associators(BCSystem, "SAP_BCSystemClient", "SAP_BCClient", null, null, null);
        int array_length = CIMInstancePathJavaCIMObjectArray == null ? 0 : CIMInstancePathJavaCIMObjectArray.length;
        clientArray = new SAP_BCClient[array_length];
        int i = 0;
        while (i < array_length) {
            clientArray[i] = (SAP_BCClient)CIMInstancePathJavaCIMObjectArray[i].getJavaCIMObject();
            ++i;
        }
        return clientArray;
    }

    public SAP_BCMessageServer[] getBCMessageServerList(SAP_BCSystem BCSystem) throws LcrException {
        SAP_BCSystemAccessor BCSystemAcc = new SAP_BCSystemAccessor(this.client);
        CIMInstancepathJavacimobject[] CIMInstancePathJavaCIMObjectArray = null;
        SAP_BCMessageServer[] messageServerArray = null;
        CIMInstancePathJavaCIMObjectArray = BCSystemAcc.associators(BCSystem, "SAP_BCSystemMessageServer", "SAP_BCMessageServer", null, null, null);
        int array_length = CIMInstancePathJavaCIMObjectArray == null ? 0 : CIMInstancePathJavaCIMObjectArray.length;
        messageServerArray = new SAP_BCMessageServer[array_length];
        int i = 0;
        while (i < array_length) {
            messageServerArray[i] = (SAP_BCMessageServer)CIMInstancePathJavaCIMObjectArray[i].getJavaCIMObject();
            ++i;
        }
        return messageServerArray;
    }

    public SAP_BCSystem getBCSystem(SAP_BusinessSystem businessSystem) throws LcrException {
        SAP_BusinessSystemAccessor businessSystemAcc = new SAP_BusinessSystemAccessor(this.client);
        CIMInstancepathJavacimobject[] CIMInstancePathJavaCIMObjectArray = null;
        SAP_BCSystem BCSystem = null;
        SAP_BCClient BCClient = null;
        BCClient = this.getBCClient(businessSystem);
        if (BCClient != null) {
            BCSystem = this.getBCSystem(BCClient);
        } else {
            CIMInstancePathJavaCIMObjectArray = businessSystemAcc.associators(businessSystem, "SAP_LogicalSystemViewedSystem", "SAP_BCSystem", null, null, null);
            if (CIMInstancePathJavaCIMObjectArray != null && CIMInstancePathJavaCIMObjectArray.length != 0) {
                BCSystem = (SAP_BCSystem)CIMInstancePathJavaCIMObjectArray[0].getJavaCIMObject();
            }
        }
        return BCSystem;
    }

    public SAP_BCSystem getBCSystem(SAP_BCClient BCClient) throws LcrException {
        SAP_BCClientAccessor BCClientAcc = new SAP_BCClientAccessor(this.client);
        CIMInstancepathJavacimobject[] CIMInstancePathJavaCIMObjectArray = null;
        SAP_BCSystem BCSystem = null;
        CIMInstancePathJavaCIMObjectArray = BCClientAcc.associators(BCClient, "SAP_BCSystemClient", "SAP_BCSystem", null, null, null);
        if (CIMInstancePathJavaCIMObjectArray != null && CIMInstancePathJavaCIMObjectArray.length != 0) {
            BCSystem = (SAP_BCSystem)CIMInstancePathJavaCIMObjectArray[0].getJavaCIMObject();
        }
        return BCSystem;
    }

    public SAP_BusinessSystem[] getBusinessSystemList() throws LcrException {
        SAP_BusinessSystemAccessor businessSystemAcc = new SAP_BusinessSystemAccessor(this.client);
        return businessSystemAcc.enumerateSAP_BusinessSystemInstances(true, false, null);
    }

    public SAP_ComputerSystem getComputerSystem(SAP_BCMessageServer messageServer) throws LcrException {
        SAP_BCMessageServerAccessor messageServerAcc = new SAP_BCMessageServerAccessor(this.client);
        CIMInstancepathJavacimobject[] CIMInstancePathJavaCIMObjectArray = null;
        SAP_ComputerSystem computerSystem = null;
        CIMInstancePathJavaCIMObjectArray = messageServerAcc.associators(messageServer, "SAP_BCMessageServerHost", "SAP_ComputerSystem", null, null, null);
        if (CIMInstancePathJavaCIMObjectArray != null && CIMInstancePathJavaCIMObjectArray.length != 0) {
            computerSystem = (SAP_ComputerSystem)CIMInstancePathJavaCIMObjectArray[0].getJavaCIMObject();
        }
        return computerSystem;
    }

    public SAP_ComputerSystem getComputerSystem(SAP_BCApplicationServer applicationServer) throws LcrException {
        SAP_BCApplicationServerAccessor applicationServerAcc = new SAP_BCApplicationServerAccessor(this.client);
        CIMInstancepathJavacimobject[] CIMInstancePathJavaCIMObjectArray = null;
        SAP_ComputerSystem computerSystem = null;
        CIMInstancePathJavaCIMObjectArray = applicationServerAcc.associators(applicationServer, "SAP_BCApplicationServerHost", "SAP_ComputerSystem", null, null, null);
        if (CIMInstancePathJavaCIMObjectArray != null && CIMInstancePathJavaCIMObjectArray.length != 0) {
            computerSystem = (SAP_ComputerSystem)CIMInstancePathJavaCIMObjectArray[0].getJavaCIMObject();
        }
        return computerSystem;
    }

    public SAP_ComputerSystem getComputerSystem(SAP_ApplicationSystem applicationSystem) throws LcrException {
        SAP_ApplicationSystemAccessor applicationSystemAcc = new SAP_ApplicationSystemAccessor(this.client);
        CIMInstancepathJavacimobject[] CIMInstancePathJavaCIMObjectArray = null;
        SAP_ComputerSystem computerSystem = null;
        CIMInstancePathJavaCIMObjectArray = applicationSystemAcc.associators(applicationSystem, "SAP_ApplicationSystemHost", "SAP_ComputerSystem", null, null, null);
        if (CIMInstancePathJavaCIMObjectArray != null && CIMInstancePathJavaCIMObjectArray.length != 0) {
            computerSystem = (SAP_ComputerSystem)CIMInstancePathJavaCIMObjectArray[0].getJavaCIMObject();
        }
        return computerSystem;
    }

    public SAP_ExternalBusinessSystem[] getExternalBusinessSystemList() throws LcrException {
        SAP_ExternalBusinessSystemAccessor externalBusinessSystemAcc = new SAP_ExternalBusinessSystemAccessor(this.client);
        return externalBusinessSystemAcc.enumerateSAP_ExternalBusinessSystemInstances(true, false, null);
    }

    private SAP_InstalledProduct[] getInstalledProductList(SAP_BusinessSystem businessSystem) throws LcrException {
        SAP_BusinessSystemAccessor businessSystemAcc = new SAP_BusinessSystemAccessor(this.client);
        CIMInstancepathJavacimobject[] CIMInstancePathJavaCIMObjectArray = null;
        SAP_InstalledProduct[] installedProductArray = null;
        CIMInstancePathJavaCIMObjectArray = businessSystemAcc.associators(businessSystem, "SAP_InstalledProductLogicalApplicationSystem", "SAP_InstalledProduct", null, null, null);
        int array_length = CIMInstancePathJavaCIMObjectArray == null ? 0 : CIMInstancePathJavaCIMObjectArray.length;
        installedProductArray = new SAP_InstalledProduct[array_length];
        int i = 0;
        while (i < array_length) {
            installedProductArray[i] = (SAP_InstalledProduct)CIMInstancePathJavaCIMObjectArray[i].getJavaCIMObject();
            ++i;
        }
        return installedProductArray;
    }

    public SAP_InstalledSoftwareComponent[] getInstalledSoftwareComponentList(SAP_InstalledProduct installedProduct) throws LcrException {
        SAP_InstalledProductAccessor installedProductAcc = new SAP_InstalledProductAccessor(this.client);
        CIMInstancepathJavacimobject[] CIMInstancePathJavaCIMObjectArray = null;
        SAP_InstalledSoftwareComponent[] installedSoftwareComponentArray = null;
        CIMInstancePathJavaCIMObjectArray = installedProductAcc.associators(installedProduct, "SAP_CollectedSoftwareComponents", "SAP_InstalledSoftwareComponent", null, null, null);
        int array_length = CIMInstancePathJavaCIMObjectArray == null ? 0 : CIMInstancePathJavaCIMObjectArray.length;
        installedSoftwareComponentArray = new SAP_InstalledSoftwareComponent[array_length];
        int i = 0;
        while (i < array_length) {
            installedSoftwareComponentArray[i] = (SAP_InstalledSoftwareComponent)CIMInstancePathJavaCIMObjectArray[i].getJavaCIMObject();
            ++i;
        }
        return installedSoftwareComponentArray;
    }

    public SAP_InstalledSoftwareComponent[] getInstalledSoftwareComponentList(SAP_BusinessSystem businessSystem) throws LcrException {
        SAP_InstalledProduct[] installedProductArray = this.getInstalledProductList(businessSystem);
        SAP_InstalledSoftwareComponent[] installedSoftwareComponentArray = null;
        Vector<SAP_InstalledSoftwareComponent> installedSoftwareComponents = new Vector<SAP_InstalledSoftwareComponent>();
        int i = 0;
        while (i < installedProductArray.length) {
            installedSoftwareComponentArray = this.getInstalledSoftwareComponentList(installedProductArray[i]);
            int j = 0;
            while (j < installedSoftwareComponentArray.length) {
                installedSoftwareComponents.add(installedSoftwareComponentArray[j]);
                ++j;
            }
            ++i;
        }
        if (installedSoftwareComponents.size() == 0) {
            return new SAP_InstalledSoftwareComponent[0];
        }
        return installedSoftwareComponents.toArray(new SAP_InstalledSoftwareComponent[0]);
    }

    public SAP_RFCDestination[] getRFCDestinationList(SAP_BCSystem system) throws LcrException {
        SAP_BCSystemAccessor systemAcc = new SAP_BCSystemAccessor(this.client);
        CIMInstancepathJavacimobject[] CIMInstancePathJavaCIMObjectArray = null;
        Vector<SAP_RFCDestination> RFCDestinations = new Vector<SAP_RFCDestination>();
        int array_length = 0;
        CIMInstancePathJavaCIMObjectArray = systemAcc.associators(system, "SAP_HostedInternalRFCDestination", "SAP_R3InternalRFCDestination", null, null, null);
        array_length = CIMInstancePathJavaCIMObjectArray == null ? 0 : CIMInstancePathJavaCIMObjectArray.length;
        int i = 0;
        while (i < array_length) {
            RFCDestinations.add((SAP_R3InternalRFCDestination)CIMInstancePathJavaCIMObjectArray[i].getJavaCIMObject());
            ++i;
        }
        CIMInstancePathJavaCIMObjectArray = systemAcc.associators(system, "SAP_HostedTCPIPRFCDestination", "SAP_TCPIPRFCDestination", null, null, null);
        array_length = CIMInstancePathJavaCIMObjectArray == null ? 0 : CIMInstancePathJavaCIMObjectArray.length;
        int i2 = 0;
        while (i2 < array_length) {
            RFCDestinations.add((SAP_TCPIPRFCDestination)CIMInstancePathJavaCIMObjectArray[i2].getJavaCIMObject());
            ++i2;
        }
        CIMInstancePathJavaCIMObjectArray = systemAcc.associators(system, "SAP_HostedABAPDriverRFCDestination", "SAP_ABAPDriverRFCDestination", null, null, null);
        array_length = CIMInstancePathJavaCIMObjectArray == null ? 0 : CIMInstancePathJavaCIMObjectArray.length;
        int i3 = 0;
        while (i3 < array_length) {
            RFCDestinations.add((SAP_ABAPDriverRFCDestination)CIMInstancePathJavaCIMObjectArray[i3].getJavaCIMObject());
            ++i3;
        }
        CIMInstancePathJavaCIMObjectArray = systemAcc.associators(system, "SAP_HostedR2RFCDestination", "SAP_R2RFCDestination", null, null, null);
        array_length = CIMInstancePathJavaCIMObjectArray == null ? 0 : CIMInstancePathJavaCIMObjectArray.length;
        int i4 = 0;
        while (i4 < array_length) {
            RFCDestinations.add((SAP_R2RFCDestination)CIMInstancePathJavaCIMObjectArray[i4].getJavaCIMObject());
            ++i4;
        }
        CIMInstancePathJavaCIMObjectArray = systemAcc.associators(system, "SAP_HostedSNARFCDestination", "SAP_SNARFCDestination", null, null, null);
        array_length = CIMInstancePathJavaCIMObjectArray == null ? 0 : CIMInstancePathJavaCIMObjectArray.length;
        int i5 = 0;
        while (i5 < array_length) {
            RFCDestinations.add((SAP_SNARFCDestination)CIMInstancePathJavaCIMObjectArray[i5].getJavaCIMObject());
            ++i5;
        }
        CIMInstancePathJavaCIMObjectArray = systemAcc.associators(system, "SAP_HostedR3RFCDestination", "SAP_R3RFCDestination", null, null, null);
        array_length = CIMInstancePathJavaCIMObjectArray == null ? 0 : CIMInstancePathJavaCIMObjectArray.length;
        int i6 = 0;
        while (i6 < array_length) {
            RFCDestinations.add((SAP_R3RFCDestination)CIMInstancePathJavaCIMObjectArray[i6].getJavaCIMObject());
            ++i6;
        }
        CIMInstancePathJavaCIMObjectArray = systemAcc.associators(system, "SAP_HostedCMCRFCDestination", "SAP_CMCRFCDestination", null, null, null);
        array_length = CIMInstancePathJavaCIMObjectArray == null ? 0 : CIMInstancePathJavaCIMObjectArray.length;
        int i7 = 0;
        while (i7 < array_length) {
            RFCDestinations.add((SAP_CMCRFCDestination)CIMInstancePathJavaCIMObjectArray[i7].getJavaCIMObject());
            ++i7;
        }
        CIMInstancePathJavaCIMObjectArray = systemAcc.associators(system, "SAP_HostedLogicalRFCDestination", "SAP_R3LogicalRFCDestination", null, null, null);
        array_length = CIMInstancePathJavaCIMObjectArray == null ? 0 : CIMInstancePathJavaCIMObjectArray.length;
        int i8 = 0;
        while (i8 < array_length) {
            RFCDestinations.add((SAP_R3LogicalRFCDestination)CIMInstancePathJavaCIMObjectArray[i8].getJavaCIMObject());
            ++i8;
        }
        if (RFCDestinations.size() == 0) {
            return new SAP_RFCDestination[0];
        }
        return RFCDestinations.toArray(new SAP_RFCDestination[0]);
    }

    public SAP_BusinessSystem[] getSAPBusinessSystemList() throws LcrException {
        Vector<SAP_BusinessSystem> SAPBusinessSystems = new Vector<SAP_BusinessSystem>();
        SAP_BCClient BCClient = null;
        SAP_BusinessSystem[] businessSystemArray = this.getBusinessSystemList();
        int i = 0;
        while (i < businessSystemArray.length) {
            BCClient = this.getBCClient(businessSystemArray[i]);
            if (BCClient != null) {
                SAPBusinessSystems.add(businessSystemArray[i]);
            }
            ++i;
        }
        if (SAPBusinessSystems.size() == 0) {
            return new SAP_BusinessSystem[0];
        }
        return SAPBusinessSystems.toArray(new SAP_BusinessSystem[0]);
    }

    public SAP_BusinessSystem[] getSAPIntegrationServerList() throws LcrException {
        Vector<SAP_BusinessSystem> SAPIntegrationServers = new Vector<SAP_BusinessSystem>();
        SAP_BusinessSystem[] businessSystemArray = this.getSAPBusinessSystemList();
        int i = 0;
        while (i < businessSystemArray.length) {
            List<String> list;
            String[] roles = businessSystemArray[i].getRoles();
            if (roles != null && (list = Arrays.asList(roles)).contains("Integration Server")) {
                SAPIntegrationServers.add(businessSystemArray[i]);
            }
            ++i;
        }
        if (SAPIntegrationServers.size() == 0) {
            return new SAP_BusinessSystem[0];
        }
        return SAPIntegrationServers.toArray(new SAP_BusinessSystem[0]);
    }

    public SAP_SoftwareComponent getSoftwareComponent(SAP_InstalledSoftwareComponent installedSoftwareComponent) throws LcrException {
        SAP_InstalledSoftwareComponentAccessor installedSoftwareComponentAcc = new SAP_InstalledSoftwareComponentAccessor(this.client);
        CIMInstancepathJavacimobject[] CIMInstancePathJavaCIMObjectArray = null;
        SAP_SoftwareComponent softwareComponent = null;
        CIMInstancePathJavaCIMObjectArray = installedSoftwareComponentAcc.associators(installedSoftwareComponent, "SAP_SoftwareComponentType", "SAP_SoftwareComponent", null, null, null);
        if (CIMInstancePathJavaCIMObjectArray != null && CIMInstancePathJavaCIMObjectArray.length != 0) {
            softwareComponent = (SAP_SoftwareComponent)CIMInstancePathJavaCIMObjectArray[0].getJavaCIMObject();
        }
        return softwareComponent;
    }

    public SAP_GlobalUniqueID getUniqueID(SAP_SoftwareComponent softwareComponent) throws LcrException {
        SAP_SoftwareComponentAccessor softwareComponentAcc = new SAP_SoftwareComponentAccessor(this.client);
        CIMInstancepathJavacimobject[] CIMInstancePathJavaCIMObjectArray = null;
        SAP_GlobalUniqueID globalUniqueID = null;
        CIMInstancePathJavaCIMObjectArray = softwareComponentAcc.associators(softwareComponent, "SAP_SoftwareComponentGuid", "SAP_GlobalUniqueID", null, null, null);
        if (CIMInstancePathJavaCIMObjectArray != null && CIMInstancePathJavaCIMObjectArray.length != 0) {
            globalUniqueID = (SAP_GlobalUniqueID)CIMInstancePathJavaCIMObjectArray[0].getJavaCIMObject();
        }
        return globalUniqueID;
    }
}

