/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.sapaccess;

import com.sap.lcr.api.cimclient.CIMClient;
import com.sap.lcr.api.cimclient.ClientFactory;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.sapmodel.CIMInstancenameJavacimobject;
import com.sap.lcr.api.sapmodel.CIMInstancepathJavacimobject;
import com.sap.lcr.api.sapmodel.SAP_BCClient;
import com.sap.lcr.api.sapmodel.SAP_BCClientAccessor;
import com.sap.lcr.api.sapmodel.SAP_BCClientFilter;
import com.sap.lcr.api.sapmodel.SAP_BusinessSystem;
import com.sap.lcr.api.sapmodel.SAP_BusinessSystemAccessor;
import com.sap.lcr.api.sapmodel.SAP_InstalledProduct;
import com.sap.lcr.api.sapmodel.SAP_InstalledProductAccessor;
import com.sap.lcr.api.sapmodel.SAP_InstalledProductFilter;
import com.sap.lcr.api.sapmodel.SAP_ProductLine;

public class ProxyAccess {
    public static void main(String[] args) {
        try {
            if (args.length != 4) {
                System.err.println("Usage: java com.sap.lcr.api.sapaccess.ProxyAccess <host> <port> <user> <password>");
                System.exit(0);
            }
            String tAddress = args[0];
            Integer tPort = Integer.valueOf(args[1]);
            String tUser = args[2];
            String tPassword = args[3];
            CIMClient client = new CIMClient(ClientFactory.newInstance().createClient(ClientFactory.newSAPHttpURL(tAddress, tPort), tUser, tPassword));
            SAP_BusinessSystemAccessor businessSystemAcc = new SAP_BusinessSystemAccessor(client);
            SAP_BCClientAccessor bCClientAcc = new SAP_BCClientAccessor(client);
            SAP_BCClient[] bCClientFieldArray = ProxyAccess.getSAP_BCClientList(bCClientAcc);
            if (bCClientFieldArray.length == 0) {
                System.out.println("\n*** No SAP_BCClient instances found - please check ***");
                System.exit(1);
            }
            System.out.println("=== CIMObjectReferences of all SAP_BCClient instances ===");
            int i = 0;
            while (i < bCClientFieldArray.length) {
                System.out.println("  " + i + " (SAP_BCClient): " + bCClientFieldArray[i].toCIMObjectReference().toString());
                ++i;
            }
            System.out.println("");
            SAP_BCClientFilter bCClientFilter = new SAP_BCClientFilter();
            SAP_BCClient[] filteredBCClientFieldArray = bCClientFilter.filter(bCClientFieldArray);
            if (filteredBCClientFieldArray.length == 0) {
                System.out.println("\n*** No matching SAP_BCClient instances found - please check ***");
                System.exit(1);
            }
            System.out.println("=== CIMObjectReferences of filtered SAP_BCClient instances (no pattern) ===");
            int i2 = 0;
            while (i2 < filteredBCClientFieldArray.length) {
                System.out.println("  " + i2 + " (SAP_BCClient): " + filteredBCClientFieldArray[i2].toCIMObjectReference().toString());
                ++i2;
            }
            System.out.println("");
            String pattern = "^0";
            bCClientFilter.setNamePattern(pattern);
            filteredBCClientFieldArray = bCClientFilter.filter(bCClientFieldArray);
            System.out.println("=== CIMObjectReferences of filtered SAP_BCClient instances (pattern: " + pattern + ") ===");
            int i3 = 0;
            while (i3 < filteredBCClientFieldArray.length) {
                System.out.println("  " + i3 + " (SAP_BCClient): " + filteredBCClientFieldArray[i3].toCIMObjectReference().toString());
                ++i3;
            }
            System.out.println("");
            pattern = "p44";
            bCClientFilter.setNamePattern(pattern);
            filteredBCClientFieldArray = bCClientFilter.filter(bCClientFieldArray);
            System.out.println("=== CIMObjectReferences of filtered SAP_BCClient instances (pattern: " + pattern + ") ===");
            int i4 = 0;
            while (i4 < filteredBCClientFieldArray.length) {
                System.out.println("  " + i4 + " (SAP_BCClient): " + filteredBCClientFieldArray[i4].toCIMObjectReference().toString());
                ++i4;
            }
            System.out.println("");
            pattern = "dieses pattern existiert wohl nicht";
            bCClientFilter.setNamePattern(pattern);
            filteredBCClientFieldArray = bCClientFilter.filter(bCClientFieldArray);
            System.out.println("=== CIMObjectReferences of filtered SAP_BCClient instances (pattern: " + pattern + ") ===");
            int i5 = 0;
            while (i5 < filteredBCClientFieldArray.length) {
                System.out.println("  " + i5 + " (SAP_BCClient): " + filteredBCClientFieldArray[i5].toCIMObjectReference().toString());
                ++i5;
            }
            System.out.println("");
            SAP_BCClient bCClient = bCClientFieldArray[0];
            SAP_BusinessSystem businessSystem = ProxyAccess.getAssociatedSAP_BusinessSystem(bCClientAcc, bCClient);
            System.out.println("=== CIMObjectReference of SAP_BusinessSystem associated to SAP_BCClient  ===");
            if (businessSystem != null) {
                System.out.println("  1 (SAP_BusinessSystem): " + businessSystem.toCIMObjectReference().toString());
            } else {
                System.out.println("  *** Found no associated SAP_BusinessSystem ***");
            }
            System.out.println("");
            SAP_BusinessSystem[] businessSystemArray = ProxyAccess.getSAP_BusinessSystemList(businessSystemAcc);
            System.out.println("=== CIMObjectReferences of SAP_BusinessSystem instances ===");
            if (businessSystemArray.length == 0) {
                System.out.println("  *** No SAP_BusinessSystem instances found - please check ***");
                System.exit(1);
            }
            int i6 = 0;
            while (i6 < businessSystemArray.length) {
                System.out.println("  " + i6 + " (SAP_BusinessSystem): " + businessSystemArray[i6].toCIMObjectReference().toString());
                ++i6;
            }
            System.out.println("");
            SAP_InstalledProductAccessor installedProductAcc = new SAP_InstalledProductAccessor(client);
            SAP_InstalledProduct[] installedProductArray = ProxyAccess.getSAP_InstalledProductList(installedProductAcc);
            System.out.println("=== CIMObjectReferences of SAP_InstalledProduct instances ===");
            if (installedProductArray.length == 0) {
                System.out.println("  *** No SAP_InstalledProduct instances found - please check ***");
                System.exit(1);
            }
            int i7 = 0;
            while (i7 < installedProductArray.length) {
                System.out.println("  " + i7 + " (SAP_InstalledProduct): " + installedProductArray[i7].toCIMObjectReference().toString());
                ++i7;
            }
            System.out.println("");
            SAP_InstalledProductFilter installedProductFilter = new SAP_InstalledProductFilter();
            pattern = "place$";
            installedProductFilter.setProductNamePattern(pattern);
            SAP_InstalledProduct[] filteredInstalledProductArray = installedProductFilter.filter(installedProductArray);
            System.out.println("=== CIMObjectReferences of SAP_InstalledProduct instances (pattern:" + pattern + ") ===");
            if (filteredInstalledProductArray.length == 0) {
                System.out.println("  *** No SAP_InstalledProduct instances found - please check ***");
            }
            int i8 = 0;
            while (i8 < filteredInstalledProductArray.length) {
                System.out.println("  " + i8 + " (SAP_InstalledProduct): " + filteredInstalledProductArray[i8].toCIMObjectReference().toString());
                ++i8;
            }
            System.out.println("");
            installedProductFilter = new SAP_InstalledProductFilter();
            pattern = "1";
            installedProductFilter.setCollectionIDPattern(pattern);
            filteredInstalledProductArray = installedProductFilter.filter(installedProductArray);
            System.out.println("=== CIMObjectReferences of SAP_InstalledProduct instances (pattern:" + pattern + ") ===");
            if (filteredInstalledProductArray.length == 0) {
                System.out.println("  *** No SAP_InstalledProduct instances found - please check ***");
            }
            int i9 = 0;
            while (i9 < filteredInstalledProductArray.length) {
                System.out.println("  " + i9 + " (SAP_InstalledProduct): " + filteredInstalledProductArray[i9].toCIMObjectReference().toString());
                ++i9;
            }
            System.out.println("");
            String pattern2 = "SAP";
            installedProductFilter.setProductVendorPattern(pattern2);
            filteredInstalledProductArray = installedProductFilter.filter(installedProductArray);
            System.out.println("=== CIMObjectReferences of SAP_InstalledProduct instances (pattern:" + pattern + "; pattern2: " + pattern2 + ") ===");
            if (filteredInstalledProductArray.length == 0) {
                System.out.println("  *** No SAP_InstalledProduct instances found - please check ***");
            }
            int i10 = 0;
            while (i10 < filteredInstalledProductArray.length) {
                System.out.println("  " + i10 + " (SAP_InstalledProduct): " + filteredInstalledProductArray[i10].toCIMObjectReference().toString());
                ++i10;
            }
            System.out.println("");
            String pattern3 = "1";
            installedProductFilter.setProductIdentifyingNumberPattern(pattern3);
            filteredInstalledProductArray = installedProductFilter.filter(installedProductArray);
            System.out.println("=== CIMObjectReferences of SAP_InstalledProduct instances (pattern:" + pattern + "; pattern2: " + pattern2 + "; pattern3: " + pattern3 + ") ===");
            if (filteredInstalledProductArray.length == 0) {
                System.out.println("  *** No SAP_InstalledProduct instances found - please check ***");
            }
            int i11 = 0;
            while (i11 < filteredInstalledProductArray.length) {
                System.out.println("  " + i11 + " (SAP_InstalledProduct): " + filteredInstalledProductArray[i11].toCIMObjectReference().toString());
                ++i11;
            }
            System.out.println("");
            String pattern4 = "gibts nicht";
            installedProductFilter.setInstallTypePattern(pattern4);
            filteredInstalledProductArray = installedProductFilter.filter(installedProductArray);
            System.out.println("=== CIMObjectReferences of SAP_InstalledProduct instances (pattern:" + pattern + "; pattern2: " + pattern2 + "; pattern3: " + pattern3 + "; pattern4: " + pattern4 + ") ===");
            if (filteredInstalledProductArray.length == 0) {
                System.out.println("  *** No SAP_InstalledProduct instances found - please check ***");
            }
            int i12 = 0;
            while (i12 < filteredInstalledProductArray.length) {
                System.out.println("  " + i12 + " (SAP_InstalledProduct): " + filteredInstalledProductArray[i12].toCIMObjectReference().toString());
                ++i12;
            }
            System.out.println("");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static SAP_BusinessSystem getAssociatedSAP_BusinessSystem(SAP_BCClientAccessor anAccessor, SAP_BCClient aBCClient) throws LcrException {
        CIMInstancepathJavacimobject[] associatorsResult = anAccessor.associators(aBCClient, "SAP_BusinessSystemViewedBCClient", "SAP_BusinessSystem", null, null, null);
        int resultLength = associatorsResult.length;
        if (resultLength > 1) {
            throw new LcrException(0, "Fehler: Mehr als ein SAP_BusinessSystem gefunden");
        }
        if (resultLength == 0) {
            return null;
        }
        SAP_BusinessSystem finalResult = (SAP_BusinessSystem)associatorsResult[0].getJavaCIMObject();
        return finalResult;
    }

    public static SAP_BusinessSystem[] getSAP_BusinessSystemList(SAP_BusinessSystemAccessor anAccessor) throws LcrException {
        CIMInstancenameJavacimobject[] enumerateResult = anAccessor.enumerateInstances(false, true, null);
        int resultLength = enumerateResult.length;
        SAP_BusinessSystem[] finalResult = new SAP_BusinessSystem[resultLength];
        int i = 0;
        while (i < resultLength) {
            finalResult[i] = (SAP_BusinessSystem)enumerateResult[i].getJavaCIMObject();
            ++i;
        }
        return finalResult;
    }

    public static SAP_BCClient[] getSAP_BCClientList(SAP_BCClientAccessor anAccessor) throws LcrException {
        CIMInstancenameJavacimobject[] enumerateResult = anAccessor.enumerateInstances(false, true, null);
        int resultLength = enumerateResult.length;
        SAP_BCClient[] finalResult = new SAP_BCClient[resultLength];
        int i = 0;
        while (i < resultLength) {
            finalResult[i] = (SAP_BCClient)enumerateResult[i].getJavaCIMObject();
            ++i;
        }
        return finalResult;
    }

    public static SAP_InstalledProduct[] getSAP_InstalledProductList(SAP_InstalledProductAccessor anAccessor) throws LcrException {
        CIMInstancenameJavacimobject[] enumerateResult = anAccessor.enumerateInstances(false, true, null);
        int resultLength = enumerateResult.length;
        SAP_InstalledProduct[] finalResult = new SAP_InstalledProduct[resultLength];
        int i = 0;
        while (i < resultLength) {
            finalResult[i] = (SAP_InstalledProduct)enumerateResult[i].getJavaCIMObject();
            ++i;
        }
        return finalResult;
    }

    public static SAP_ProductLine getSAP_ProductLine(SAP_BusinessSystemAccessor anAccessor, SAP_BusinessSystem aBusinessSystem) throws LcrException {
        CIMInstancepathJavacimobject[] associatorsResult = anAccessor.associators(aBusinessSystem, null, "SAP_ProductLine", null, null, null);
        int resultLength = associatorsResult.length;
        if (resultLength > 1) {
            throw new LcrException(0, "Error: Found more than one SAP_ProductLine");
        }
        if (resultLength == 0) {
            return null;
        }
        SAP_ProductLine finalResult = (SAP_ProductLine)associatorsResult[0].getJavaCIMObject();
        return finalResult;
    }
}

