/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.log;

import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class Util {
    private Util() {
    }

    public static String byteToHex(byte b) {
        String result = Integer.toHexString(b < 0 ? 256 + b : b);
        if (result.length() < 2) {
            result = "0" + result;
        }
        return result;
    }

    public static byte hexToByte(String hex) {
        int x;
        if (hex == null) {
            return 0;
        }
        int len = hex.length();
        if (len < 1) {
            return 0;
        }
        if (len > 2) {
            hex = hex.substring(len - 2);
        }
        return (x = Integer.parseInt(hex, 16)) < 128 ? (byte)x : (byte)(x - 256);
    }

    public static String byteArrayToHex(byte[] b) {
        if (b == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < b.length) {
            sb.append(Util.byteToHex(b[i]));
            ++i;
        }
        return sb.toString();
    }

    public static byte[] hexToByteArray(String hex) {
        if (hex == null) {
            return null;
        }
        int len = hex.length();
        int size = len / 2;
        int inc = 2;
        if (len % 2 == 1) {
            ++size;
            inc = 1;
        }
        byte[] b = new byte[size];
        int j = 0;
        int pos = 0;
        while (j < size) {
            String s = hex.substring(pos, pos += inc);
            b[j] = Util.hexToByte(s);
            inc = 2;
            ++j;
        }
        return b;
    }

    public static int parseIntDefault(String s, int defaultValue) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public static Object findMapValue(Map map, Object value) {
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            if (!value.equals(map.get(key))) continue;
            return key;
        }
        return null;
    }

    public static Enumeration sort(Enumeration in, Comparator comp) {
        LinkedList list = new LinkedList();
        while (in.hasMoreElements()) {
            list.add(in.nextElement());
        }
        if (comp == null) {
            Collections.sort(list);
        } else {
            Collections.sort(list, comp);
        }
        return Collections.enumeration(list);
    }

    public static String getClassName(Object obj) {
        String className = obj.getClass().getName();
        int pos = className.lastIndexOf(46);
        if (pos < 0) {
            return className;
        }
        return className.substring(pos + 1);
    }
}

