/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.log;

import com.sap.lcr.api.log.Handler;
import com.sap.lcr.api.log.Level;
import com.sap.lcr.api.log.LogRecord;
import com.sap.lcr.api.log.LogUtil;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.HashMap;
import java.util.Map;

public class SAPStandardLogHandler
extends Handler {
    private static Map locations = new HashMap();
    private static final String LOGCATEGORY = "SLD";

    public SAPStandardLogHandler(String name) {
        super(name);
    }

    public void publish(String message) {
    }

    public synchronized void publish(LogRecord rec) {
        if (this.getLevel() == null || rec.getLevel().getPriority() >= this.getLevel().getPriority()) {
            Location loc = SAPStandardLogHandler.getLocation(rec.getLoggerName());
            int severity = this.getSeverity(rec.getLevel());
            Category cat = Category.getCategory((String)"/Applications/SLD");
            String message = rec.getMessage();
            if (severity <= 100) {
                if (rec.getThrown() != null) {
                    message = message + "\n" + LogUtil.formatThrowable(rec.getThrown());
                }
                loc.logT(severity, message);
            } else {
                if (message.length() != 0) {
                    cat.logT(severity, loc, message);
                }
                if (rec.getThrown() != null) {
                    loc.logT(severity, LogUtil.formatThrowable(rec.getThrown()));
                }
            }
        }
    }

    public void close() {
    }

    private static Location getLocation(String classname) {
        Location loc = (Location)locations.get(classname);
        if (loc == null) {
            loc = Location.getLocation((String)classname);
            locations.put(classname, loc);
        }
        return loc;
    }

    private int getSeverity(Level loglevel) {
        int severity = loglevel.equals(Level.FATAL) ? 600 : (loglevel.equals(Level.ERROR) ? 500 : (loglevel.equals(Level.WARNING) ? 400 : (loglevel.equals(Level.INFO) ? 300 : (loglevel.equals(Level.DEBUG) ? 100 : 100))));
        return severity;
    }
}

