/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.log;

import com.sap.lcr.api.log.Formatter;
import com.sap.lcr.api.log.LogRecord;
import com.sap.lcr.api.log.LogUtil;
import java.text.DateFormat;

public class PatternFormatter
extends Formatter {
    private static final DateFormat dateFormat = DateFormat.getDateInstance(2);
    private static final DateFormat timeFormat = DateFormat.getTimeInstance(2);
    private String pattern;

    public PatternFormatter(String pattern) {
        this.pattern = pattern;
    }

    public String format(LogRecord rec) {
        StringBuffer sb = new StringBuffer();
        int len = this.pattern.length();
        int pos = 0;
        int next = this.pattern.indexOf(37);
        while (next > -1) {
            if (next > pos) {
                sb.append(this.pattern.substring(pos, next));
            }
            if (++next < len) {
                switch (this.pattern.charAt(next)) {
                    case 'm': {
                        sb.append(rec.getMessage());
                        break;
                    }
                    case 'C': {
                        sb.append(rec.getLoggerName());
                        break;
                    }
                    case 'l': {
                        sb.append(rec.getLevel());
                        break;
                    }
                    case 'n': {
                        sb.append(rec.getSequenceNumber());
                        break;
                    }
                    case 'd': {
                        sb.append(dateFormat.format(rec.getDate()));
                        break;
                    }
                    case 't': {
                        sb.append(timeFormat.format(rec.getDate()));
                        break;
                    }
                    case 'T': {
                        sb.append(rec.getThreadName());
                        break;
                    }
                    case 'c': {
                        sb.append(rec.getLogger().getShortName());
                        break;
                    }
                    case 'x': {
                        Throwable t = rec.getThrown();
                        if (t == null) break;
                        sb.append(LogUtil.formatThrowable(t));
                        break;
                    }
                    case '%': {
                        sb.append('%');
                    }
                }
            }
            pos = next + 1;
            next = this.pattern.indexOf(37, pos);
        }
        if (pos < len) {
            sb.append(this.pattern.substring(pos));
        }
        return sb.toString();
    }
}

