/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.log;

import com.sap.lcr.api.log.AsyncHandler;
import com.sap.lcr.api.log.ConsoleHandler;
import com.sap.lcr.api.log.DefaultFormatter;
import com.sap.lcr.api.log.FileHandler;
import com.sap.lcr.api.log.GetLoggerEvent;
import com.sap.lcr.api.log.Handler;
import com.sap.lcr.api.log.Level;
import com.sap.lcr.api.log.LogRecord;
import com.sap.lcr.api.log.LogUtil;
import com.sap.lcr.api.log.MemLogHandler;
import com.sap.lcr.api.log.PatternFormatter;
import com.sap.lcr.api.log.PipedHandler;
import com.sap.lcr.api.log.SAPStandardLogHandler;
import com.sap.lcr.api.log.SimpleFormatter;
import com.sap.lcr.api.log.SimpleLog;
import com.sap.lcr.api.log.SocketHandler;
import com.sap.lcr.api.log.StringUtil;
import com.sap.lcr.api.log.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class Logger {
    private static final String CONFIG_FILE = "log.properties";
    private static Map categoryMap = new Hashtable();
    static final String ROOT_NAME;
    public static final Logger ROOT;
    public static final Logger global;
    private static boolean active;
    private String name;
    private Logger parent;
    private Level level;
    private boolean useParentHandlers = true;
    private Vector handlers = new Vector();
    private static final String CONFIG_MODE_NONE = "none";
    private static final String CONFIG_MODE_FILE = "file";
    private static final String CONFIG_MODE_SYSTEM = "system";
    private static final String CONFIG_MODE_DEFAULT = "default";
    private static final String CONFIG_MODE_SIMPLE = "simple";
    static /* synthetic */ Class class$com$sap$lcr$api$log$Logger;

    private Logger(String name, Logger parent) {
        this.name = name;
        this.parent = parent;
        this.level = null;
        categoryMap.put(name, this);
    }

    public static Logger getLogger(String name) {
        Logger result;
        if (categoryMap.containsKey(name)) {
            result = (Logger)categoryMap.get(name);
        } else {
            int pos = name.lastIndexOf(46);
            String parentName = pos < 0 ? ROOT_NAME : name.substring(0, pos);
            Logger parent = Logger.getLogger(parentName);
            result = new Logger(name, parent);
        }
        if (LogUtil.hasAdminListeners()) {
            LogUtil.fireLogAdminEvent(new GetLoggerEvent(class$com$sap$lcr$api$log$Logger == null ? (class$com$sap$lcr$api$log$Logger = Logger.class$("com.sap.lcr.api.log.Logger")) : class$com$sap$lcr$api$log$Logger, name));
        }
        return result;
    }

    public void log(Throwable throwable) {
        this.log(Level.ERROR, throwable.getMessage(), null, null, throwable);
    }

    public void log(Level level, String message) {
        this.log(level, message, null, null, null);
    }

    public void log(Level level, String message, String user) {
        this.log(level, message, null, user, null);
    }

    public void log(Level level, String message, String user, Throwable t) {
        this.log(level, message, null, user, t);
    }

    public void log(Level level, String pattern, Object[] arguments, String user, Throwable t) {
        if (level == null) {
            level = Level.DEFAULT;
        }
        try {
            if (active && level.getPriority() >= this.getActiveLevel().getPriority()) {
                String message = arguments == null ? pattern : MessageFormat.format(pattern, arguments);
                LogRecord rec = new LogRecord(this.name, level, message);
                if (t != null) {
                    rec.setThrown(t);
                }
                if (user != null) {
                    rec.setUser(user);
                }
                this.publish(rec);
            }
        }
        catch (Exception e) {
            SimpleLog.error("in log", e);
        }
    }

    public void log(String message) {
        this.log(Level.DEFAULT, message, null, null, null);
    }

    public void fatal(String message, String user, Throwable t) {
        this.log(Level.FATAL, message, user, t);
    }

    public void error(String message, String user, Throwable t) {
        this.log(Level.ERROR, message, user, t);
    }

    public void warning(String message, String user, Throwable t) {
        this.log(Level.WARNING, message, user, t);
    }

    public void info(String message, String user, Throwable t) {
        this.log(Level.INFO, message, user, t);
    }

    public void debug(String message, String user, Throwable t) {
        this.log(Level.DEBUG, message, user, t);
    }

    public void fine(String message, String user, Throwable t) {
        this.log(Level.FINE, message, user, t);
    }

    public void finer(String message, String user, Throwable t) {
        this.log(Level.FINER, message, user, t);
    }

    public void finest(String message, String user, Throwable t) {
        this.log(Level.FINEST, message, user, t);
    }

    public void fatal(String pattern, Object[] arguments, String user, Throwable t) {
        this.log(Level.FATAL, pattern, arguments, user, t);
    }

    public void error(String pattern, Object[] arguments, String user, Throwable t) {
        this.log(Level.ERROR, pattern, arguments, user, t);
    }

    public void warning(String pattern, Object[] arguments, String user, Throwable t) {
        this.log(Level.WARNING, pattern, arguments, user, t);
    }

    public void info(String pattern, Object[] arguments, String user, Throwable t) {
        this.log(Level.INFO, pattern, arguments, user, t);
    }

    public void debug(String pattern, Object[] arguments, String user, Throwable t) {
        this.log(Level.DEBUG, pattern, arguments, user, t);
    }

    public void fine(String pattern, Object[] arguments, String user, Throwable t) {
        this.log(Level.FINE, pattern, arguments, user, t);
    }

    public void finer(String pattern, Object[] arguments, String user, Throwable t) {
        this.log(Level.FINER, pattern, arguments, user, t);
    }

    public void finest(String pattern, Object[] arguments, String user, Throwable t) {
        this.log(Level.FINEST, pattern, arguments, user, t);
    }

    public void fatal(String message, Throwable t) {
        this.log(Level.FATAL, message, null, t);
    }

    public void error(String message, Throwable t) {
        this.log(Level.ERROR, message, null, t);
    }

    public void warning(String message, Throwable t) {
        this.log(Level.WARNING, message, null, t);
    }

    public void info(String message, Throwable t) {
        this.log(Level.INFO, message, null, t);
    }

    public void debug(String message, Throwable t) {
        this.log(Level.DEBUG, message, null, t);
    }

    public void fine(String message, Throwable t) {
        this.log(Level.FINE, message, null, t);
    }

    public void finer(String message, Throwable t) {
        this.log(Level.FINER, message, null, t);
    }

    public void finest(String message, Throwable t) {
        this.log(Level.FINEST, message, null, t);
    }

    public void fatal(String pattern, Object[] arguments, Throwable t) {
        this.log(Level.FATAL, pattern, arguments, null, t);
    }

    public void error(String pattern, Object[] arguments, Throwable t) {
        this.log(Level.ERROR, pattern, arguments, null, t);
    }

    public void warning(String pattern, Object[] arguments, Throwable t) {
        this.log(Level.WARNING, pattern, arguments, null, t);
    }

    public void info(String pattern, Object[] arguments, Throwable t) {
        this.log(Level.INFO, pattern, arguments, null, t);
    }

    public void debug(String pattern, Object[] arguments, Throwable t) {
        this.log(Level.DEBUG, pattern, arguments, null, t);
    }

    public void fine(String pattern, Object[] arguments, Throwable t) {
        this.log(Level.FINE, pattern, arguments, null, t);
    }

    public void finer(String pattern, Object[] arguments, Throwable t) {
        this.log(Level.FINER, pattern, arguments, null, t);
    }

    public void finest(String pattern, Object[] arguments, Throwable t) {
        this.log(Level.FINEST, pattern, arguments, null, t);
    }

    public void fatal(String message, String user) {
        this.log(Level.FATAL, message, user);
    }

    public void error(String message, String user) {
        this.log(Level.ERROR, message, user);
    }

    public void warning(String message, String user) {
        this.log(Level.WARNING, message, user);
    }

    public void info(String message, String user) {
        this.log(Level.INFO, message, user);
    }

    public void debug(String message, String user) {
        this.log(Level.DEBUG, message, user);
    }

    public void fine(String message, String user) {
        this.log(Level.FINE, message, user);
    }

    public void finer(String message, String user) {
        this.log(Level.FINER, message, user);
    }

    public void finest(String message, String user) {
        this.log(Level.FINEST, message, user);
    }

    public void fatal(String pattern, Object[] arguments, String user) {
        this.log(Level.FATAL, pattern, arguments, user, null);
    }

    public void error(String pattern, Object[] arguments, String user) {
        this.log(Level.ERROR, pattern, arguments, user, null);
    }

    public void warning(String pattern, Object[] arguments, String user) {
        this.log(Level.WARNING, pattern, arguments, user, null);
    }

    public void info(String pattern, Object[] arguments, String user) {
        this.log(Level.INFO, pattern, arguments, user, null);
    }

    public void debug(String pattern, Object[] arguments, String user) {
        this.log(Level.DEBUG, pattern, arguments, user, null);
    }

    public void fine(String pattern, Object[] arguments, String user) {
        this.log(Level.FINE, pattern, arguments, user, null);
    }

    public void finer(String pattern, Object[] arguments, String user) {
        this.log(Level.FINER, pattern, arguments, user, null);
    }

    public void finest(String pattern, Object[] arguments, String user) {
        this.log(Level.FINEST, pattern, arguments, user, null);
    }

    public void fatal(String message) {
        this.log(Level.FATAL, message, null);
    }

    public void error(String message) {
        this.log(Level.ERROR, message, null);
    }

    public void warning(String message) {
        this.log(Level.WARNING, message, null);
    }

    public void info(String message) {
        this.log(Level.INFO, message, null);
    }

    public void debug(String message) {
        this.log(Level.DEBUG, message, null);
    }

    public void fine(String message) {
        this.log(Level.FINE, message, null);
    }

    public void finer(String message) {
        this.log(Level.FINER, message, null);
    }

    public void finest(String message) {
        this.log(Level.FINEST, message, null);
    }

    public void fatal(String pattern, Object[] arguments) {
        this.log(Level.FATAL, pattern, arguments, null, null);
    }

    public void error(String pattern, Object[] arguments) {
        this.log(Level.ERROR, pattern, arguments, null, null);
    }

    public void warning(String pattern, Object[] arguments) {
        this.log(Level.WARNING, pattern, arguments, null, null);
    }

    public void info(String pattern, Object[] arguments) {
        this.log(Level.INFO, pattern, arguments, null, null);
    }

    public void debug(String pattern, Object[] arguments) {
        this.log(Level.DEBUG, pattern, arguments, null, null);
    }

    public void fine(String pattern, Object[] arguments) {
        this.log(Level.FINE, pattern, arguments, null, null);
    }

    public void finer(String pattern, Object[] arguments) {
        this.log(Level.FINER, pattern, arguments, null, null);
    }

    public void finest(String pattern, Object[] arguments) {
        this.log(Level.FINEST, pattern, arguments, null, null);
    }

    public void setLevel(Level level) {
        if (level != this.level) {
            if (level != null && level.getPriority() > this.getActiveLevel().getPriority()) {
                SimpleLog.info("changing output level of \"" + this.getName() + "\" from " + this.getActiveLevel() + " to " + level);
            }
            this.level = level;
        }
    }

    public Level getLevel() {
        return this.level;
    }

    public Level getActiveLevel() {
        if (!active) {
            return Level.OFF;
        }
        if (this.level != null) {
            return this.level;
        }
        if (this.parent != null) {
            return this.parent.getActiveLevel();
        }
        return Level.ALL;
    }

    public static void off() {
        active = false;
    }

    public static void on() {
        active = true;
    }

    private static Properties getSubProperties(Properties prop, String prefix) {
        Properties newProp = new Properties();
        int len = prefix.length();
        Enumeration<?> e = prop.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.startsWith(prefix)) continue;
            String value = prop.getProperty(name);
            name = name.length() > len ? name.substring(len) : "";
            newProp.setProperty(name, value);
        }
        return newProp;
    }

    public static void configure(Properties props) {
        String name;
        Logger.clearAll();
        String value = props.getProperty("log.internalDebug");
        if (value != null) {
            Logger.setInternalDebug(Boolean.valueOf(value));
        }
        if ((value = props.getProperty("log.internalInfo")) != null) {
            Logger.setInternalInfo(Boolean.valueOf(value));
        }
        if ((value = props.getProperty("log.stacktraceMode")) != null) {
            if (value.equals("always")) {
                LogUtil.setStacktraceMode(0);
            }
            if (value.equals("never")) {
                LogUtil.setStacktraceMode(2);
            }
            if (value.equals("runtime")) {
                LogUtil.setStacktraceMode(1);
            }
        }
        Properties handlerProp = Logger.getSubProperties(props, "log.handler.");
        Enumeration<?> e = handlerProp.propertyNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            value = handlerProp.getProperty(name);
            SimpleLog.debug("configure Handler: " + name + "=" + value);
            if (StringUtil.contains(name, '.')) continue;
            Handler handler = null;
            StringTokenizer tok = new StringTokenizer(value, " ,");
            if (tok.hasMoreTokens()) {
                String hclass = tok.nextToken();
                if (hclass.equals("ConsoleHandler")) {
                    boolean async = false;
                    while (tok.hasMoreTokens()) {
                        String flag = tok.nextToken();
                        if (!flag.equalsIgnoreCase("async")) continue;
                        async = true;
                    }
                    if (async) {
                        handler = new AsyncHandler(name);
                        ((PipedHandler)handler).addHandler(new ConsoleHandler());
                    } else {
                        handler = new ConsoleHandler(name);
                    }
                    SimpleLog.debug("   new ConsoleHandler \"" + name + "\" async=" + async);
                } else if (hclass.equals("SAPStandardLogHandler")) {
                    while (tok.hasMoreTokens()) {
                        tok.nextToken();
                    }
                    handler = new SAPStandardLogHandler(name);
                    SimpleLog.debug("   new SAPStandardLogHandler \"" + name + "\"");
                } else if (hclass.equals("MemoryHandler")) {
                    int size = Util.parseIntDefault(tok.nextToken(), 100);
                    handler = new MemLogHandler(name, size);
                    SimpleLog.info(">>> MemoryHandler has been replaced by MemLogHandler! Please change your configuration properties. <<<");
                    SimpleLog.debug("   new MemLogHandler \"" + name + "\" size=" + size);
                } else if (hclass.equals("MemLogHandler")) {
                    int size = Util.parseIntDefault(tok.nextToken(), 100);
                    handler = new MemLogHandler(name, size);
                    SimpleLog.debug("   new MemLogHandler \"" + name + "\" size=" + size);
                } else if (hclass.equals("SocketHandler")) {
                    String host = tok.nextToken();
                    int port = Util.parseIntDefault(tok.nextToken(), 100);
                    try {
                        handler = new SocketHandler(name, host, port);
                        SimpleLog.debug("   new SocketHandler \"" + name + "\" host=" + host + " port=" + port);
                    }
                    catch (IOException ex) {
                        SimpleLog.error("cannot create SocketHandler \"" + name + "\" host=" + host + " port=" + port, ex);
                    }
                } else if (hclass.equals("FileHandler")) {
                    String file = "log.txt";
                    boolean append = false;
                    boolean async = false;
                    if (tok.hasMoreTokens()) {
                        file = tok.nextToken();
                    }
                    while (tok.hasMoreTokens()) {
                        String flag = tok.nextToken();
                        if (flag.equalsIgnoreCase("append")) {
                            append = true;
                            continue;
                        }
                        if (!flag.equalsIgnoreCase("async")) continue;
                        async = true;
                    }
                    try {
                        if (async) {
                            handler = new AsyncHandler(name);
                            ((AsyncHandler)handler).addHandler(new FileHandler(null, file, append));
                        } else {
                            handler = new FileHandler(name, file, append);
                        }
                        SimpleLog.debug("   new FileHandler \"" + name + "\" file=" + file + " append=" + append + " async=" + async);
                    }
                    catch (IOException ex) {
                        SimpleLog.error("cannot create FileHandler \"" + name + "\" file=" + file, ex);
                    }
                } else {
                    SimpleLog.error("Handler " + hclass + " not supported by readConfig()");
                }
            }
            if (handler == null || name == null) continue;
            Properties subProp = Logger.getSubProperties(handlerProp, name + ".");
            Enumeration<?> e2 = subProp.propertyNames();
            while (e2.hasMoreElements()) {
                String n = (String)e2.nextElement();
                String v = subProp.getProperty(n);
                if (n.equals("level")) {
                    handler.setLevel(Level.getLevel(v));
                    continue;
                }
                if (!n.equals("format")) continue;
                if (v.equals("SIMPLE")) {
                    handler.setFormatter(new SimpleFormatter());
                    continue;
                }
                if (v.equals("DEFAULT")) {
                    handler.setFormatter(new DefaultFormatter());
                    continue;
                }
                handler.setFormatter(new PatternFormatter(v));
            }
        }
        Properties logProp = Logger.getSubProperties(props, "log.logger.");
        e = logProp.propertyNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            value = logProp.getProperty(name);
            SimpleLog.debug("configure Logger: " + name + "=" + value);
            Logger logger = Logger.getLogger(name);
            StringTokenizer tok = new StringTokenizer(value, " ,");
            if (tok.hasMoreTokens()) {
                logger.setLevel(Level.getLevel(tok.nextToken()));
                SimpleLog.debug("   setLevel=" + logger.getLevel());
            }
            while (tok.hasMoreTokens()) {
                String t = tok.nextToken();
                Handler h = Handler.getHandler(t);
                if (h != null) {
                    logger.addHandler(h);
                    SimpleLog.debug("   addHandler=" + t);
                    continue;
                }
                SimpleLog.error("Handler \"" + t + "\" not found");
            }
        }
    }

    public String toString() {
        return this.name + '(' + this.level + ')';
    }

    private void publish(LogRecord rec) {
        int i = 0;
        while (i < this.handlers.size()) {
            ((Handler)this.handlers.get(i)).publish(rec);
            ++i;
        }
        if (this.parent != null && this.useParentHandlers) {
            this.parent.publish(rec);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        int pos = this.name.lastIndexOf(46);
        if (pos < 0) {
            return this.name;
        }
        return this.name.substring(pos + 1);
    }

    public void setUseParentHandlers(boolean flag) {
        this.useParentHandlers = flag;
    }

    public void addHandler(Handler handler) {
        this.handlers.addElement(handler);
    }

    public void removeAllHandlers() {
        this.handlers.removeAllElements();
        SimpleLog.debug("removing all Handlers from " + this.getName());
    }

    public void removeHandler(Handler handler) {
        this.handlers.remove(handler);
    }

    public void removeHandler(String name) {
        this.handlers.remove(Handler.getHandler(name));
    }

    public Enumeration listHandlers() {
        return this.handlers.elements();
    }

    boolean contains(Logger p) {
        while (p != null) {
            if (p == this) {
                return true;
            }
            p = p.parent;
        }
        return false;
    }

    public static Enumeration listLoggers() {
        return Collections.enumeration(categoryMap.keySet());
    }

    public static void clearAll() {
        Iterator i = categoryMap.keySet().iterator();
        while (i.hasNext()) {
            Logger l = (Logger)categoryMap.get((String)i.next());
            l.removeAllHandlers();
            l.level = null;
            l.setUseParentHandlers(true);
        }
    }

    public static void resetAll() {
        Logger.clearAll();
        Logger.init();
    }

    private static Properties getDefaultConfig() {
        Properties props = new Properties();
        props.setProperty("log.internalDebug", "false");
        props.setProperty("log.internalInfo", "false");
        props.setProperty("log.stacktraceMode", "always");
        props.setProperty("log.handler.RootMemLog", "MemLogHandler, 10000");
        props.setProperty("log.handler.RootMemLog.level", "ALL");
        props.setProperty("log.handler.RootSAPLog", "SAPStandardLogHandler");
        props.setProperty("log.handler.RootSAPLog.level", "ALL");
        props.setProperty("log.logger.ROOT", "ALL, RootMemLog, RootSAPLog");
        return props;
    }

    private static Properties getSimpleConfig(Level level) {
        if (level == null) {
            level = Level.ERROR;
        }
        Properties props = new Properties();
        props.setProperty("log.internalDebug", "false");
        props.setProperty("log.internalInfo", "false");
        props.setProperty("log.stacktraceMode", "always");
        props.setProperty("log.handler.RootConsole", "ConsoleHandler");
        props.setProperty("log.handler.RootConsole.level", level.getName());
        props.setProperty("log.handler.RootMemLog", "MemLogHandler, 400");
        props.setProperty("log.logger.ROOT", "ALL, RootConsole, RootMemLog");
        return props;
    }

    private static void init() {
        String mode = System.getProperty("log.initialConfiguration", CONFIG_MODE_DEFAULT).trim();
        String s = System.getProperty("log.useDefaultFile", "true");
        boolean useDefaultFile = Boolean.valueOf(s);
        s = System.getProperty("log.createDefaultFile", "true");
        Boolean.valueOf(s).booleanValue();
        if (mode.equalsIgnoreCase(CONFIG_MODE_NONE)) {
            return;
        }
        if (mode.equalsIgnoreCase(CONFIG_MODE_SYSTEM)) {
            SimpleLog.debug("using system properties for log configuration");
            Logger.configure(System.getProperties());
        } else if (mode.equalsIgnoreCase(CONFIG_MODE_DEFAULT)) {
            Properties props = new Properties();
            File file = new File(CONFIG_FILE);
            if (file.exists()) {
                try {
                    FileInputStream in = new FileInputStream(file);
                    SimpleLog.debug("SLD reading log configuration from \"" + file.getAbsolutePath() + "\"");
                    props.load(in);
                    ((InputStream)in).close();
                }
                catch (IOException ex) {
                    SimpleLog.error("error during log configuration", ex);
                }
                Logger.configure(props);
            } else {
                SimpleLog.debug("SLD using default log configuration");
                Logger.configure(Logger.getDefaultConfig());
            }
        } else if (mode.equalsIgnoreCase(CONFIG_MODE_SIMPLE)) {
            SimpleLog.info("using simple log configuration");
            Logger.configure(Logger.getSimpleConfig(null));
        } else if (mode.equalsIgnoreCase(CONFIG_MODE_FILE)) {
            if (useDefaultFile) {
                Properties props = new Properties();
                File file = new File(CONFIG_FILE);
                if (file.exists()) {
                    try {
                        FileInputStream in = new FileInputStream(file);
                        SimpleLog.debug("reading log configuration from \"" + file.getAbsolutePath() + "\"");
                        props.load(in);
                        ((InputStream)in).close();
                    }
                    catch (IOException ex) {
                        SimpleLog.error("error during log configuration", ex);
                    }
                } else {
                    props = Logger.getDefaultConfig();
                }
                Logger.configure(props);
            }
        } else {
            SimpleLog.error("error during log configuration - unknown mode: " + mode);
        }
    }

    public static void setInternalDebug(boolean x) {
        SimpleLog.setDebug(x);
    }

    public static void setInternalInfo(boolean x) {
        SimpleLog.setInfo(x);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        active = true;
        ROOT_NAME = "ROOT";
        ROOT = new Logger(ROOT_NAME, null);
        global = new Logger("global", ROOT);
        Logger.init();
    }
}

