/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.log;

import com.sap.lcr.api.log.LogAdminEvent;
import com.sap.lcr.api.log.LogAdminEventListener;
import com.sap.lcr.api.log.Logger;
import com.sap.lcr.api.log.SimpleLog;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Vector;

public class LogUtil {
    public static final int STACKTRACE_ALWAYS = 0;
    public static final int STACKTRACE_RUNTIME = 1;
    public static final int STACKTRACE_NEVER = 2;
    public static final String UNKNOWN_CLASS = "UnknownClass";
    public static final String UNKNOWN_METHOD = "UnknownClass.method";
    private static int stacktraceMode = 0;
    private static Vector adminListeners = new Vector();

    public static int getStacktraceMode() {
        return stacktraceMode;
    }

    public static void setStacktraceMode(int mode) {
        stacktraceMode = mode;
    }

    public static Logger getClassLogger(Object obj) {
        return Logger.getLogger(obj.getClass().getName());
    }

    public static String formatThrowable(Throwable t) {
        try {
            StringBuffer buf = new StringBuffer("Thrown: \n");
            LogUtil.formatThrowable(t, buf);
            return buf.toString();
        }
        catch (Error e) {
            SimpleLog.error("Unexpected Error during Trace output", e);
            return "";
        }
    }

    private static void formatThrowable(Throwable t, StringBuffer buf) {
        switch (stacktraceMode) {
            case 2: {
                buf.append(LogUtil.formatStackTraceMessageOnly(t));
                break;
            }
            case 1: {
                if (t instanceof RuntimeException) {
                    buf.append(LogUtil.formatStackTrace(t));
                    break;
                }
                buf.append(LogUtil.formatStackTraceMessageOnly(t));
                break;
            }
            default: {
                buf.append(LogUtil.formatStackTrace(t));
            }
        }
    }

    private static String formatStackTraceMessageOnly(Throwable t) {
        return t.getClass().getName() + ": " + t.getMessage() + "\n";
    }

    private static String formatStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        pw.close();
        return sw.toString();
    }

    static boolean hasAdminListeners() {
        return !adminListeners.isEmpty();
    }

    public static void addLogAdminEventListener(LogAdminEventListener listener) {
        adminListeners.add(listener);
    }

    public static void removeLogAdminEventListener(LogAdminEventListener listener) {
        adminListeners.remove(listener);
    }

    static void fireLogAdminEvent(LogAdminEvent event) {
        int i = 0;
        while (i < adminListeners.size()) {
            LogAdminEventListener l = (LogAdminEventListener)adminListeners.get(i);
            l.adminEvent(event);
            ++i;
        }
    }
}

