/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.log;

import com.sap.lcr.api.log.DefaultFormatter;
import com.sap.lcr.api.log.Formatter;
import com.sap.lcr.api.log.Level;
import com.sap.lcr.api.log.LogRecord;
import com.sap.lcr.api.log.MemLogHandler;
import com.sap.lcr.api.log.NameMap;
import java.util.Collections;
import java.util.Enumeration;

public abstract class Handler {
    private static final NameMap handlers = new NameMap();
    private Level level;
    protected String name;
    protected Formatter formatter = new DefaultFormatter();

    protected Handler(String name) {
        Handler oldHandler;
        if (name != null && !((oldHandler = Handler.getHandler(name)) instanceof MemLogHandler)) {
            handlers.remove(name);
            handlers.put(name, "Handler", this);
        }
        this.level = null;
        this.name = name;
    }

    public static Handler getHandler(String name) {
        return (Handler)handlers.get(name);
    }

    public static void setHandler(String name, Handler handler) {
        handlers.remove(name);
        handlers.put(name, "Handler", handler);
    }

    static void clearHandlers() {
        handlers.clear();
    }

    public void publish(LogRecord rec) {
        if (this.isLoggable(rec)) {
            this.publish(this.formatter.format(rec));
        }
    }

    public boolean isLoggable(LogRecord rec) {
        return this.level == null || rec.getLevel().getPriority() >= this.level.getPriority();
    }

    public abstract void publish(String var1);

    public abstract void close();

    public void setLevel(Level level) {
        this.level = level;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setFormatter(Formatter formatter) {
        this.formatter = formatter;
    }

    public Formatter getFormatter() {
        return this.formatter;
    }

    public String getName() {
        return this.name;
    }

    public static Enumeration listHandlers() {
        return Collections.enumeration(handlers.keySet());
    }
}

