/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.log;

import com.sap.lcr.api.log.Formatter;
import com.sap.lcr.api.log.LogRecord;
import com.sap.lcr.api.log.LogUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

public class DefaultFormatter
extends Formatter {
    private static final DateFormat df = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss.SS");

    public String format(LogRecord rec) {
        String date;
        StringBuffer sb = new StringBuffer();
        sb.append("#");
        sb.append(rec.getSequenceNumber());
        sb.append(" ");
        DateFormat dateFormat = df;
        synchronized (dateFormat) {
            date = df.format(rec.getDate());
        }
        sb.append(date);
        sb.append(" [");
        sb.append(rec.getThreadName());
        sb.append("] ");
        sb.append(rec.getLevel().getName());
        sb.append(" ");
        sb.append(rec.getLoggerName());
        sb.append(": ");
        String user = rec.getUser();
        if (user != null) {
            sb.append("(" + user + ") ");
        }
        sb.append(rec.getMessage());
        Throwable t = rec.getThrown();
        if (t != null) {
            sb.append("\n").append(LogUtil.formatThrowable(t));
        }
        return sb.toString();
    }
}

