/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cimname;

import com.sap.lcr.api.cim.CIMClass;
import com.sap.lcr.api.cim.CIMClassname;
import com.sap.lcr.api.cim.CIMClasspath;
import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMInstance;
import com.sap.lcr.api.cim.CIMInstancename;
import com.sap.lcr.api.cim.CIMInstancepath;
import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.CIMKeyValue;
import com.sap.lcr.api.cim.CIMKeybinding;
import com.sap.lcr.api.cim.CIMLocalclasspath;
import com.sap.lcr.api.cim.CIMLocalinstancepath;
import com.sap.lcr.api.cim.CIMLocalnamespacepath;
import com.sap.lcr.api.cim.CIMNamespace;
import com.sap.lcr.api.cim.CIMNamespacepath;
import com.sap.lcr.api.cim.CIMObjectname;
import com.sap.lcr.api.cim.CIMObjectpath;
import com.sap.lcr.api.cim.CIMUtil;
import com.sap.lcr.api.cim.CIMValueReference;
import com.sap.lcr.api.cim.ICIMObjRef;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import com.sap.lcr.api.cim.ReferenceConversionExcp;
import com.sap.lcr.api.cimclient.CIMConst;
import com.sap.lcr.api.cimclient.CIMStatusCodes;
import com.sap.lcr.api.cimclient.CIMTraceUtil;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.cimname.CIMKey;
import com.sap.lcr.api.cimname.CIMKeyList;
import com.sap.lcr.api.cimname.CIMKeyListIterator;
import com.sap.lcr.api.log.LocationLogger;
import com.sap.lcr.api.log.Logger;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class CIMObjectReference
implements Serializable,
Cloneable,
Comparable,
CIMConst,
CIMStatusCodes {
    public static final long serialVersionUID = 10000L;
    private static final Logger logger = Logger.getLogger((class$com$sap$lcr$api$cimname$CIMObjectReference == null ? (class$com$sap$lcr$api$cimname$CIMObjectReference = CIMObjectReference.class$("com.sap.lcr.api.cimname.CIMObjectReference")) : class$com$sap$lcr$api$cimname$CIMObjectReference).getName());
    private String hostName = "";
    private ArrayList namespaceList = new ArrayList();
    private String className = "";
    private CIMKeyList keyList = new CIMKeyList();
    private String keyString = null;
    private boolean anInstance = false;
    private boolean anAssociation = false;
    static /* synthetic */ Class class$com$sap$lcr$api$cimname$CIMObjectReference;

    public CIMObjectReference(String hostName, ArrayList namespaceList, String className, CIMKeyList keyList) {
        if (hostName != null) {
            this.hostName = hostName.trim();
        }
        if (namespaceList != null) {
            this.namespaceList = (ArrayList)namespaceList.clone();
        }
        this.className = className.trim();
        if (keyList != null) {
            this.keyList = (CIMKeyList)keyList.clone();
        }
        this.setFlags();
    }

    public CIMObjectReference(String className) {
        this(null, null, className, null);
    }

    public CIMObjectReference(String className, CIMKeyList keyList) {
        this(null, null, className, keyList);
    }

    public static CIMObjectReference createFromString(String referenceString) throws ReferenceConversionExcp {
        try {
            ICIMObjRef ref = CIMFactory.createObjPathFromString(referenceString);
            return ref.toCIMObjectReference();
        }
        catch (LcrException ex) {
            throw new ReferenceConversionExcp(ex);
        }
    }

    public Object clone() {
        try {
            CIMObjectReference newRef = (CIMObjectReference)super.clone();
            newRef.namespaceList = (ArrayList)this.namespaceList.clone();
            newRef.keyList = (CIMKeyList)this.keyList.clone();
            return newRef;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }

    public int compareTo(Object obj) {
        int otherHashValue;
        CIMObjectReference other = (CIMObjectReference)obj;
        int hashValue = this.hashCode();
        if (hashValue < (otherHashValue = other.hashCode())) {
            return -1;
        }
        if (hashValue > otherHashValue) {
            return 1;
        }
        return this.keyString.compareTo(other.keyString);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CIMObjectReference) {
            return this.compareTo(obj) == 0;
        }
        return false;
    }

    public boolean equals(String aObjRefString) {
        if (aObjRefString == null) {
            return false;
        }
        try {
            return this.equals(CIMObjectReference.createFromString(aObjRefString));
        }
        catch (ReferenceConversionExcp ex) {
            return false;
        }
    }

    public int hashCode() {
        this.toString();
        return this.keyString.hashCode();
    }

    public void addCIMKey(CIMKey key) {
        this.keyList.add(key);
        this.setFlags();
        this.keyString = null;
    }

    public void addCIMKey(String keyName, String keyValue, String keyType) {
        this.keyList.add(new CIMKey(keyName, keyValue, keyType));
        this.setFlags();
        this.keyString = null;
    }

    public void addCIMKey(String keyName, CIMObjectReference keyValue) {
        this.keyList.add(new CIMKey(keyName, keyValue));
        this.setFlags();
        this.keyString = null;
    }

    public void addCIMKey(CIMKeyList keyList) {
        this.keyList.addAll(keyList);
        this.setFlags();
        this.keyString = null;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName != null ? hostName.trim() : "";
        this.keyString = null;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        if (className == null) {
            throw new NullPointerException("Class name not set.");
        }
        this.className = className.trim();
        this.keyString = null;
        this.setFlags();
    }

    public boolean isCIMClass() {
        return !this.anInstance;
    }

    public boolean isCIMInstance() {
        return this.anInstance;
    }

    public boolean isSingletonInstance() {
        return this.keyList.size() == 1 && this.keyList.get(0).equals(CIMKey.SINGLETON);
    }

    public boolean isCIMAssociation() {
        return this.anAssociation;
    }

    public void declareAsAssociation() {
        this.anAssociation = true;
    }

    public CIMKeyListIterator getKeyListIterator() {
        return this.keyList.iterator();
    }

    public Object getKeyValue(String keyName) {
        CIMKeyListIterator iter = this.keyList.iterator();
        while (iter.hasNext()) {
            CIMKey key = (CIMKey)iter.next();
            if (!key.getKeyName().equals(keyName)) continue;
            return key.getKeyValue();
        }
        return null;
    }

    public CIMKey getKey(int idx) {
        return (CIMKey)this.keyList.get(idx);
    }

    public int getKeyListSize() {
        return this.keyList.size();
    }

    public void setNamespaceList(ArrayList namespaceList) {
        if (namespaceList != null) {
            this.namespaceList = (ArrayList)namespaceList.clone();
        } else {
            this.namespaceList.clear();
        }
        this.keyString = null;
    }

    public void setNamespaceList(CIMLocalnamespacepath localNamespacePath) {
        this.namespaceList = localNamespacePath.getLocalnamespaceList();
        this.keyString = null;
    }

    public ArrayList getNamespaceList() {
        return (ArrayList)this.namespaceList.clone();
    }

    public int getNamespaceListSize() {
        return this.namespaceList.size();
    }

    public boolean containsKey(String keyName) {
        return this.keyList.contains(keyName);
    }

    public CIMKeyList getKeyList() {
        return this.keyList;
    }

    public CIMObjectReference getClassReference() {
        CIMObjectReference objRef = this;
        if (!this.isCIMClass()) {
            objRef = (CIMObjectReference)this.clone();
            objRef.keyList.clear();
            objRef.keyString = null;
            objRef.setFlags();
        }
        return objRef;
    }

    public String toDisplayString() {
        return this.toString(false);
    }

    public String toString() {
        if (this.keyString == null) {
            this.keyString = this.toString(true);
        }
        return this.keyString;
    }

    public String getObjectName() {
        return this.getModelPath(true);
    }

    public String getCompareModelPath() {
        return this.getObjectName();
    }

    public String getObjectDisplayName() {
        return this.getModelPath(false);
    }

    public String getModelPath() {
        return this.getObjectDisplayName();
    }

    public String getNamespacePath() {
        if (this.hostName.length() == 0) {
            return this.getLocalNamespacePath();
        }
        if (this.namespaceList.size() == 0) {
            return "";
        }
        StringBuffer strBuf = new StringBuffer(50);
        strBuf.append("//").append(this.hostName);
        Iterator iter = ((AbstractList)this.namespaceList).iterator();
        while (iter.hasNext()) {
            strBuf.append('/').append((String)iter.next());
        }
        return strBuf.toString();
    }

    public String getLocalNamespacePath() {
        StringBuffer strBuf = new StringBuffer(32);
        boolean first = true;
        Iterator iter = ((AbstractList)this.namespaceList).iterator();
        while (iter.hasNext()) {
            if (!first) {
                strBuf.append('/');
            } else {
                first = false;
            }
            strBuf.append((String)iter.next());
        }
        return strBuf.toString();
    }

    public CIMClass newCIMClass() throws LcrException {
        if (this.anInstance) {
            throw new LcrException(1, "Cannot convert. Object referenced is not a class: " + this.toDisplayString());
        }
        return CIMFactory.cimclass(this.className);
    }

    public CIMInstance newCIMInstance() throws LcrException {
        if (!this.anInstance) {
            throw new LcrException(1, "Cannot convert. Object referenced is not an instance: " + this.toDisplayString());
        }
        CIMInstance newInst = CIMFactory.instance(this.className);
        if (!this.isSingletonInstance()) {
            int keyCount = this.keyList.size();
            int i = 0;
            while (i < keyCount) {
                CIMKey key = (CIMKey)this.keyList.get(i);
                String keyName = key.getKeyName();
                if (keyName.length() > 0) {
                    Object keyValue = key.getKeyValue();
                    if (keyValue instanceof String) {
                        try {
                            newInst.addProperty(CIMFactory.property(keyName, key.getKeyType(), (String)keyValue));
                        }
                        catch (ItemConstructionExcp ex) {
                            if (CIMTraceUtil.traceLevel >= 3) {
                                logger.debug("ItemConstructionExcp in CIMObjectReference.toCIMInstance");
                            }
                            throw new LcrException(ex);
                        }
                    } else {
                        newInst.addPropertyReference(CIMFactory.propertyReference(keyName, ((CIMObjectReference)keyValue).toCIMValueReference()));
                    }
                }
                ++i;
            }
        }
        return newInst;
    }

    public CIMClassname toCIMClassname() throws LcrException {
        if (this.anInstance) {
            throw new LcrException(1, "Cannot convert. Object referenced is not a class: " + this.toDisplayString());
        }
        return CIMFactory.classname(this.className);
    }

    public CIMLocalclasspath toCIMLocalclasspath() throws LcrException {
        return CIMFactory.localclasspath(this.toCIMLocalnamespacepath(), this.toCIMClassname());
    }

    public CIMClasspath toCIMClasspath() throws LcrException {
        return CIMFactory.classpath(this.toCIMNamespacepath(), this.toCIMClassname());
    }

    public CIMInstancename toCIMInstancename() throws LcrException {
        try {
            if (!this.anInstance) {
                throw new LcrException(1, "Cannot convert. Object referenced is not an instance: " + this.toDisplayString());
            }
            CIMInstancename newInstName = CIMFactory.instancename(this.className);
            if (this.keyList.size() == 1) {
                CIMItem keyElement = this.getKey(0).toCIMDTDKeyElement();
                if (keyElement != null) {
                    if (keyElement instanceof CIMKeyValue) {
                        newInstName.setKeyValue((CIMKeyValue)keyElement);
                    } else {
                        if (keyElement instanceof CIMValueReference) {
                            throw new LcrException("Single VALUE.REFERENCE subelement impossible for INSTANCENAME in CIM");
                        }
                        newInstName.addKeybinding((CIMKeybinding)keyElement);
                    }
                }
            } else {
                try {
                    CIMKeyListIterator iter = this.keyList.iterator();
                    while (iter.hasNext()) {
                        CIMKey key = (CIMKey)iter.next();
                        newInstName.addKeybinding((CIMKeybinding)key.toCIMDTDKeyElement());
                    }
                }
                catch (ClassCastException cce) {
                    throw new LcrException(1, "Object reference with multiple keys must only contain KEYBINDINGs.");
                }
            }
            return newInstName;
        }
        catch (LcrException ex) {
            if (CIMTraceUtil.traceLevel >= 3) {
                logger.debug("toCIMInstancename failed:", ex);
            }
            throw ex;
        }
    }

    public CIMLocalinstancepath toCIMLocalinstancepath() throws LcrException {
        return CIMFactory.localinstancepath(this.toCIMLocalnamespacepath(), this.toCIMInstancename());
    }

    public CIMInstancepath toCIMInstancepath() throws LcrException {
        return CIMFactory.instancepath(this.toCIMNamespacepath(), this.toCIMInstancename());
    }

    public CIMValueReference toCIMValueReference() throws LcrException {
        if (this.anInstance) {
            if (this.hostName.length() == 0) {
                if (this.namespaceList.isEmpty()) {
                    return CIMFactory.valueReference(this.toCIMInstancename());
                }
                return CIMFactory.valueReference(this.toCIMLocalinstancepath());
            }
            return CIMFactory.valueReference(this.toCIMInstancepath());
        }
        if (this.hostName.length() == 0) {
            if (this.namespaceList.isEmpty()) {
                return CIMFactory.valueReference(this.toCIMClassname());
            }
            return CIMFactory.valueReference(this.toCIMLocalclasspath());
        }
        return CIMFactory.valueReference(this.toCIMClasspath());
    }

    public CIMObjectname toCIMObjectname() throws LcrException {
        if (this.anInstance) {
            return CIMFactory.objectname(this.toCIMInstancename());
        }
        return CIMFactory.objectname(this.toCIMClassname());
    }

    public CIMObjectpath toCIMObjectpath() throws LcrException {
        if (this.anInstance) {
            return CIMFactory.objectpath(this.toCIMInstancepath());
        }
        return CIMFactory.objectpath(this.toCIMClasspath());
    }

    public CIMLocalnamespacepath toCIMLocalnamespacepath() throws LcrException {
        int size = this.namespaceList.size();
        if (size == 0) {
            LcrException e = new LcrException(1, "namespace is missing");
            if (CIMTraceUtil.traceLevel >= 3) {
                LocationLogger.debug(logger, e, "(com/sap/lcr/api/cimname/CIMObjectReference.java:913)");
            }
            throw e;
        }
        CIMLocalnamespacepath result = null;
        int i = 0;
        while (i < size) {
            CIMNamespace namespace = CIMFactory.namespace((String)this.namespaceList.get(i));
            if (result == null) {
                result = CIMFactory.localnamespacepath(namespace);
            } else {
                result.addNamespace(namespace);
            }
            ++i;
        }
        return result;
    }

    public CIMNamespacepath toCIMNamespacepath() throws LcrException {
        if (this.hostName == null || this.hostName.length() == 0) {
            throw new LcrException(1, "no host name defined");
        }
        return CIMFactory.namespacepath(this.hostName, this.toCIMLocalnamespacepath());
    }

    private void setFlags() {
        if (this.keyList.size() != 0) {
            this.anInstance = true;
            this.anAssociation = false;
            CIMKeyListIterator iter = this.getKeyListIterator();
            while (iter.hasNext()) {
                CIMKey nextKey = (CIMKey)iter.next();
                if (!nextKey.isReference()) continue;
                this.anAssociation = true;
                break;
            }
        } else {
            this.anInstance = false;
            this.anAssociation = false;
        }
    }

    private String toString(boolean toLower) {
        StringBuffer strBuf = new StringBuffer(this.anInstance ? (this.anAssociation ? 512 : 256) : 64);
        if (this.hostName != null && this.hostName.length() != 0) {
            strBuf.append("//").append(this.hostName);
        }
        Iterator iter = ((AbstractList)this.namespaceList).iterator();
        while (iter.hasNext()) {
            if (strBuf.length() != 0) {
                strBuf.append('/');
            }
            strBuf.append(toLower ? ((String)iter.next()).toLowerCase() : (String)iter.next());
        }
        if (strBuf.length() != 0) {
            strBuf.append(':');
        }
        strBuf.append(this.getModelPath(toLower));
        return strBuf.toString();
    }

    private String getModelPath(boolean toLower) {
        StringBuffer strBuf = new StringBuffer(this.anInstance ? (this.anAssociation ? 512 : 256) : 64);
        strBuf.append(toLower ? this.className.toLowerCase() : this.className);
        if (this.keyList.size() != 0) {
            strBuf.append('.');
            CIMKeyListIterator iter = this.keyList.iterator();
            while (iter.hasNext()) {
                CIMKey currKey = (CIMKey)iter.next();
                String currKeyName = toLower ? currKey.getKeyName().toLowerCase() : currKey.getKeyName();
                Object currKeyValue = currKey.getKeyValue();
                if (this.keyList.size() == 1 && currKeyName.length() == 0) {
                    strBuf.deleteCharAt(strBuf.length() - 1);
                } else {
                    strBuf.append(currKeyName);
                }
                strBuf.append('=');
                if (currKeyValue instanceof String) {
                    String type = currKey.getKeyType();
                    boolean needMask = type.equals("string") || type.equals("datetime");
                    strBuf.append(needMask ? CIMUtil.getMaskedValue((String)currKeyValue) : (String)currKeyValue);
                } else if (currKeyValue instanceof CIMObjectReference) {
                    strBuf.append(CIMUtil.getMaskedValue(((CIMObjectReference)currKeyValue).toString(toLower)));
                } else {
                    throw new RuntimeException("Invalid type in key list.");
                }
                if (!iter.hasNext()) continue;
                strBuf.append(',');
            }
        }
        return strBuf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

