/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cimname;

import com.sap.lcr.api.cimname.CIMKey;
import com.sap.lcr.api.cimname.CIMKeyListIterator;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class CIMKeyList
implements Serializable,
Cloneable {
    public static final long serialVersionUID = 100L;
    private ArrayList list = new ArrayList();

    public CIMKeyList() {
    }

    public CIMKeyList(CIMKeyList inList) {
        this.list = (ArrayList)inList.list.clone();
    }

    public CIMKeyList(Collection inList) {
        Iterator iter = inList.iterator();
        while (iter.hasNext()) {
            Object currObj = iter.next();
            if (!(currObj instanceof CIMKey)) {
                throw new ClassCastException("Invalid type in key list construction array: " + currObj.getClass().getName());
            }
            this.list.add(currObj);
        }
        this.sortListAndMakeUnique();
    }

    public CIMKeyList(String[] names, String[] values) {
        int namesLength = names.length;
        int valuesLength = values.length;
        int i = 0;
        while (i < namesLength && i < valuesLength) {
            CIMKey nextKey = new CIMKey(names[i], values[i], "string");
            this.list.add(nextKey);
            ++i;
        }
        this.sortListAndMakeUnique();
    }

    public CIMKeyList(String[] names, String[] values, String[] types) {
        int namesLength = names.length;
        int valuesLength = values.length;
        int typesLength = types.length;
        int i = 0;
        while (i < namesLength && i < valuesLength && i < typesLength) {
            CIMKey nextKey = new CIMKey(names[i], values[i], types[i]);
            this.list.add(nextKey);
            ++i;
        }
        this.sortListAndMakeUnique();
    }

    public Object clone() {
        try {
            CIMKeyList newList = (CIMKeyList)super.clone();
            newList.list = (ArrayList)this.list.clone();
            int i = 0;
            CIMKeyListIterator it = newList.iterator();
            while (it.hasNext()) {
                CIMKey key = (CIMKey)((CIMKey)it.next()).clone();
                newList.update(i, key);
                ++i;
            }
            return newList;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.toString());
        }
    }

    public void add(CIMKey key) {
        this.list.add(key);
        this.sortListAndMakeUnique();
    }

    public int size() {
        return this.list.size();
    }

    public void remove(int idx) throws IndexOutOfBoundsException {
        this.list.remove(idx);
    }

    public void remove(Object obj) {
        CIMKeyListIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (!iter.next().equals(obj)) continue;
            iter.remove();
        }
    }

    public Object get(int idx) throws IndexOutOfBoundsException {
        return this.list.get(idx);
    }

    public CIMKey get(CIMKey obj) {
        int i = 0;
        while (i < this.list.size()) {
            if (this.list.get(i).equals(obj)) {
                return (CIMKey)this.list.get(i);
            }
            ++i;
        }
        return null;
    }

    public CIMKeyListIterator iterator() {
        return new CIMKeyListIterator(this);
    }

    public void addAll(CIMKeyList inList) {
        ((AbstractCollection)this.list).removeAll(inList.list);
        this.list.addAll(inList.list);
        this.sortListAndMakeUnique();
    }

    public boolean contains(Object obj) {
        return this.list.contains(obj);
    }

    public void clear() {
        this.list.clear();
    }

    public void update(CIMKeyList changeList) {
        if (changeList == null) {
            this.list.clear();
            return;
        }
        CIMKeyListIterator iter = this.iterator();
        while (iter.hasNext()) {
            CIMKey obj = (CIMKey)iter.next();
            if (!changeList.contains(obj)) {
                iter.remove();
                continue;
            }
            iter.remove();
            this.add(changeList.get(obj));
        }
        CIMKeyListIterator iter2 = changeList.iterator();
        while (iter2.hasNext()) {
            CIMKey obj = (CIMKey)iter2.next();
            if (this.contains(obj)) continue;
            this.add(obj);
        }
        this.sortListAndMakeUnique();
    }

    public void update(int idx, Object obj) {
        this.list.set(idx, obj);
        this.sortListAndMakeUnique();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CIMKeyList)) {
            return false;
        }
        if (this.list.size() != ((CIMKeyList)obj).list.size()) {
            return false;
        }
        CIMKeyList compList = (CIMKeyList)obj;
        int i = 0;
        while (i < this.list.size()) {
            CIMKey currKey2;
            CIMKey currKey1 = (CIMKey)this.get(i);
            if (!currKey1.equals(currKey2 = (CIMKey)compList.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        StringBuffer str = new StringBuffer();
        int i = 0;
        while (i < this.list.size()) {
            CIMKey currKey = (CIMKey)this.get(i);
            str.append(currKey.toString());
            ++i;
        }
        return str.toString().hashCode();
    }

    private void sortListAndMakeUnique() {
        int size = this.list.size();
        int i = 0;
        while (i < size) {
            int j = i + 1;
            while (j < size) {
                CIMKey key1 = (CIMKey)this.list.get(i);
                CIMKey key2 = (CIMKey)this.list.get(j);
                int comp = key1.getKeyName().compareToIgnoreCase(key2.getKeyName());
                if (comp > 0) {
                    this.list.set(i, key2);
                    this.list.set(j, key1);
                } else if (comp == 0) {
                    this.list.remove(i);
                }
                ++j;
            }
            ++i;
        }
    }
}

