/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cimname;

import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.CIMKeyValue;
import com.sap.lcr.api.cim.CIMUtil;
import com.sap.lcr.api.cimclient.CIMConst;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.cimname.CIMObjectReference;
import java.io.Serializable;

public class CIMKey
implements Serializable,
Comparable,
Cloneable,
CIMConst {
    public static final long serialVersionUID = 10002L;
    public static final CIMKey SINGLETON = new CIMKey();
    private String keyName;
    private Object keyValue;
    private String keyType;

    private CIMKey() {
        this.keyName = "";
        this.keyValue = "@";
        this.keyType = "";
    }

    public CIMKey(CIMKey cimKey) {
        this.keyName = cimKey.keyName.trim();
        this.keyValue = cimKey.keyValue;
        this.keyType = cimKey.keyType;
    }

    public CIMKey(String keyName, String keyValue, String keyType) throws IllegalArgumentException {
        keyType = this.mapCIMTypes(keyType);
        if (!this.validNameValueType(keyName, keyValue, keyType)) {
            throw new IllegalArgumentException("Key name/value invalid.");
        }
        this.keyName = keyName.trim();
        this.keyValue = keyValue;
        this.keyType = keyType;
    }

    public CIMKey(String keyName, CIMObjectReference keyValue) throws IllegalArgumentException {
        if (!this.validNameValueType(keyName, keyValue, null)) {
            throw new IllegalArgumentException("Key name/value invalid.");
        }
        this.keyName = keyName.trim();
        this.keyValue = keyValue;
        this.keyType = null;
    }

    public void setKeyName(String keyName) throws IllegalArgumentException {
        if (!this.validNameValueType(keyName, this.keyValue, this.keyType)) {
            throw new IllegalArgumentException("Key name invalid.");
        }
        this.keyName = keyName.trim();
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyValue(Object keyValue) throws IllegalArgumentException {
        if (!this.validNameValueType(this.keyName, keyValue, this.keyType)) {
            throw new IllegalArgumentException("Key name invalid.");
        }
        this.keyValue = keyValue;
    }

    private String mapCIMTypes(String type) throws IllegalArgumentException {
        if ((type = type.trim()).equals("string") || type.equals("boolean") || type.equals("numeric")) {
            return type;
        }
        String result = CIMUtil.cimType2keypropertyType(type);
        if (result == null) {
            throw new IllegalArgumentException("Invalid key value type specified: " + type);
        }
        return result;
    }

    private boolean validNameValueType(String name, Object value, String type) {
        if (name == null || value == null) {
            return false;
        }
        if (value instanceof CIMObjectReference) {
            return true;
        }
        boolean ret = false;
        if (type != null) {
            ret = type.equals("string") || type.equals("boolean") || type.equals("numeric");
        }
        return ret;
    }

    public Object getKeyValue() {
        return this.keyValue;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public boolean equals(Object obj) {
        return this.equals(obj, true);
    }

    public boolean equalsWithoutName(CIMKey key) {
        return this.equals(key, false);
    }

    private boolean equals(Object obj, boolean includeName) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CIMKey) {
            CIMKey key = (CIMKey)obj;
            if (includeName && !this.keyName.equalsIgnoreCase(key.keyName)) {
                return false;
            }
            if (!this.keyValue.equals(key.keyValue)) {
                return false;
            }
            return this.keyType == null ? key.keyType == null : this.keyType.equals(key.keyType);
        }
        if (obj instanceof String) {
            return this.keyName.equalsIgnoreCase((String)obj);
        }
        return false;
    }

    public int hashCode() {
        StringBuffer str = new StringBuffer(this.keyName);
        if (this.keyValue instanceof String) {
            str.append(this.keyValue);
        } else if (this.keyValue instanceof CIMObjectReference) {
            str.append(this.keyValue.toString());
        } else {
            throw new RuntimeException("Illegal key value type.");
        }
        return str.toString().hashCode();
    }

    public int compareTo(Object obj) {
        if (!(obj instanceof CIMKey)) {
            throw new IllegalArgumentException("Incompatible objects.");
        }
        if (this.equals(obj)) {
            return 0;
        }
        return this.keyName.toLowerCase().compareTo(((CIMKey)obj).keyName.toLowerCase());
    }

    public Object clone() {
        try {
            if (this.keyValue instanceof String) {
                return super.clone();
            }
            CIMKey newKey = (CIMKey)super.clone();
            newKey.keyValue = ((CIMObjectReference)this.keyValue).clone();
            return newKey;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }

    public boolean isReference() {
        return this.keyValue instanceof CIMObjectReference;
    }

    public CIMItem toCIMDTDKeyElement() throws LcrException {
        if (this.keyName == null || this.keyName.length() == 0) {
            if (this.equals(SINGLETON)) {
                return null;
            }
            if (this.keyValue instanceof CIMObjectReference) {
                return ((CIMObjectReference)this.keyValue).toCIMValueReference();
            }
            return this.value2CIMKeyValue((String)this.keyValue, this.keyType);
        }
        if (this.keyValue instanceof CIMObjectReference) {
            return CIMFactory.keybinding(this.keyName, ((CIMObjectReference)this.keyValue).toCIMValueReference());
        }
        return CIMFactory.keybinding(this.keyName, this.value2CIMKeyValue((String)this.keyValue, this.keyType));
    }

    private CIMKeyValue value2CIMKeyValue(String value, String type) {
        CIMKeyValue cimKeyValue = CIMFactory.keyValue(value);
        if (type.equals("string")) {
            cimKeyValue.setValuetypeString();
        } else if (type.equals("boolean")) {
            cimKeyValue.setValuetypeBoolean();
        } else if (type.equals("numeric")) {
            cimKeyValue.setValuetypeNumeric();
        }
        return cimKeyValue;
    }
}

