/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cimclient;

import com.sap.lcr.api.cim.CIMClass;
import com.sap.lcr.api.cim.CIMProperty;
import com.sap.lcr.api.cimclient.CIMClientException;
import com.sap.lcr.api.cimclient.CIMClientHandle;
import com.sap.lcr.api.cimclient.CIMNames;
import com.sap.lcr.api.cimclient.CIMOMHandle;
import com.sap.lcr.api.cimclient.ClientUtil;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.util.Version;
import java.util.StringTokenizer;

public class ModelVersion {
    private static final int EXPECT_MAJOR = 1;
    private static final int EXPECT_MINOR = 2;
    private static final int EXPECT_PATCH = 3;
    private int major = 0;
    private int minor = 0;
    private int patch = 0;

    ModelVersion(int aMajor, int aMinor, int aPatch) {
        this.major = aMajor;
        this.minor = aMinor;
        this.patch = aPatch;
    }

    public static ModelVersion fromVersionString(String aVersionString) {
        ModelVersion newInstance = null;
        int currentState = 1;
        int localMajor = 0;
        int localMinor = 0;
        int localPatch = 0;
        StringTokenizer tokenizer = new StringTokenizer(aVersionString, ".");
        while (tokenizer.hasMoreTokens()) {
            String nextToken = tokenizer.nextToken();
            try {
                Integer tokenAsInteger = Integer.valueOf(nextToken);
                int tokenAsInt = tokenAsInteger;
                if (tokenAsInt < 0) {
                    return null;
                }
                switch (currentState) {
                    case 1: {
                        localMajor = tokenAsInt;
                        break;
                    }
                    case 2: {
                        localMinor = tokenAsInt;
                        break;
                    }
                    case 3: {
                        localPatch = tokenAsInt;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                ++currentState;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (currentState < 3) {
            return null;
        }
        newInstance = new ModelVersion(localMajor, localMinor, localPatch);
        return newInstance;
    }

    public String versionString() {
        return this.major + "." + this.minor + "." + this.patch;
    }

    public String toString() {
        return this.versionString();
    }

    public Version toVersion() {
        return new Version(this.major, this.minor, this.patch);
    }

    public static boolean isConnectedServerCompatible(ModelVersion myOwnVersion, CIMClientHandle client) {
        return ModelVersion.isConnectedServerCompatible(myOwnVersion, client.getCIMOMHandle());
    }

    public static boolean isConnectedServerCompatible(ModelVersion myOwnVersion, CIMOMHandle client) {
        ModelVersion serverVersion = ModelVersion.getConnectedServerVersion(client);
        if (serverVersion == null) {
            return false;
        }
        return ModelVersion.areModelVersionsCompatible(myOwnVersion, serverVersion);
    }

    public static ModelVersion getConnectedServerVersion(CIMClientHandle client) {
        return ModelVersion.getConnectedServerVersion(client.getCIMOMHandle());
    }

    public static ModelVersion getConnectedServerVersion(CIMOMHandle client) {
        CIMClass cimClass;
        try {
            cimClass = ClientUtil.getCIMClassComplete(client, CIMNames.C_SAP_CIMSchema);
        }
        catch (CIMClientException e) {
            return null;
        }
        catch (LcrException le) {
            return null;
        }
        CIMProperty cimProperty = cimClass.getPropertyByName("Version");
        if (cimProperty == null) {
            return null;
        }
        String serverVersionString = cimProperty.getValue();
        return ModelVersion.fromVersionString(serverVersionString);
    }

    public static boolean pingConnectedServer(CIMClientHandle client) {
        return ModelVersion.pingConnectedServer(client.getCIMOMHandle());
    }

    public static boolean pingConnectedServer(CIMOMHandle client) {
        try {
            ClientUtil.getCIMClass(client, CIMNames.C_SAP_CIMSchema);
            return true;
        }
        catch (CIMClientException e) {
            return false;
        }
        catch (LcrException le) {
            return true;
        }
    }

    public static boolean areModelVersionsCompatible(ModelVersion clientVersion, ModelVersion serverVersion) {
        if (clientVersion.getMajor() != serverVersion.getMajor()) {
            return false;
        }
        return ModelVersion.isFirstGreaterOrEqual(serverVersion, clientVersion);
    }

    public static boolean isFirstGreaterOrEqual(ModelVersion firstVersion, ModelVersion secondVersion) {
        int secondVersionPatch;
        int secondVersionMinor;
        int secondVersionMajor;
        int firstVersionMajor = firstVersion.getMajor();
        if (firstVersionMajor < (secondVersionMajor = secondVersion.getMajor())) {
            return false;
        }
        if (firstVersionMajor > secondVersionMajor) {
            return true;
        }
        int firstVersionMinor = firstVersion.getMinor();
        if (firstVersionMinor < (secondVersionMinor = secondVersion.getMinor())) {
            return false;
        }
        if (firstVersionMinor > secondVersionMinor) {
            return true;
        }
        int firstVersionPatch = firstVersion.getPatch();
        return firstVersionPatch >= (secondVersionPatch = secondVersion.getPatch());
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    static void compareVerbose(String clientVersionString, String serverVersionString) {
        System.out.println("clientVersionString: " + clientVersionString);
        System.out.println("serverVersionString: " + serverVersionString);
        ModelVersion clientVersion = ModelVersion.fromVersionString(clientVersionString);
        if (clientVersion == null) {
            System.out.println("*** clientVersionString: Invalid version specification\n");
            return;
        }
        ModelVersion serverVersion = ModelVersion.fromVersionString(serverVersionString);
        if (serverVersion == null) {
            System.out.println("*** serverVersionString: Invalid version specification\n");
            return;
        }
        if (ModelVersion.isFirstGreaterOrEqual(clientVersion, serverVersion)) {
            System.out.println("clientVersion >= serverVersion");
        } else {
            System.out.println("clientVersion <  serverVersion");
        }
        if (ModelVersion.areModelVersionsCompatible(clientVersion, serverVersion)) {
            System.out.println("+++ Versions are compatible +++\n");
        } else {
            System.out.println("*** Versions are NOT compatible ***\n");
        }
    }
}

