/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cimclient;

import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMLocalnamespacepath;
import com.sap.lcr.api.cimclient.CIMClientException;
import com.sap.lcr.api.cimclient.CIMHttp;
import com.sap.lcr.api.cimclient.CIMOMClient;
import com.sap.lcr.api.cimclient.HttpRequestSender;
import com.sap.lcr.api.cimclient.LcrException;
import com.tssap.dtr.client.lib.protocol.Connection;
import com.tssap.dtr.client.lib.protocol.IAuthenticator;
import com.tssap.dtr.client.lib.protocol.ISessionContext;
import com.tssap.dtr.client.lib.protocol.session.BasicAuthenticator;
import com.tssap.dtr.client.lib.protocol.session.SSO2Authenticator;
import com.tssap.dtr.client.lib.protocol.session.SessionContext;
import com.tssap.dtr.client.lib.protocol.ssl.IAIKSecureSocketProvider;
import com.tssap.dtr.client.lib.protocol.ssl.ISecureSocketProvider;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;

public final class ClientFactory {
    private static final String PROTOCOL_HTTP = "http";
    private static final String PROTOCOL_HTTPS = "https";
    private String trustStore = "TrustedCAs";
    private String keyStore;

    public static ClientFactory newInstance() {
        return new ClientFactory();
    }

    public static URL newHttpURL(String host, int port) throws CIMClientException {
        try {
            return new URL(PROTOCOL_HTTP, host, port, "");
        }
        catch (MalformedURLException mue) {
            throw new CIMClientException(mue);
        }
    }

    public static URL newHttpsURL(String host, int port) throws CIMClientException {
        try {
            return new URL(PROTOCOL_HTTPS, host, port, "");
        }
        catch (MalformedURLException mue) {
            throw new CIMClientException(mue);
        }
    }

    public static com.tssap.dtr.client.lib.protocol.URL newSAPHttpURL(String host, int port) throws CIMClientException {
        return new com.tssap.dtr.client.lib.protocol.URL(PROTOCOL_HTTP, host, port, "");
    }

    public static com.tssap.dtr.client.lib.protocol.URL newSAPHttpsURL(String host, int port) throws CIMClientException {
        return new com.tssap.dtr.client.lib.protocol.URL(PROTOCOL_HTTPS, host, port, "");
    }

    private ClientFactory() {
    }

    public void configureEngineKeyStores(String trustStore, String keyStore) {
        this.trustStore = trustStore;
        this.keyStore = keyStore;
    }

    public CIMOMClient createClient(Connection connection) {
        try {
            com.tssap.dtr.client.lib.protocol.URL url = new com.tssap.dtr.client.lib.protocol.URL(connection.getUrl());
            url = this.checkURL(url);
            connection.setUrl(url);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return new CIMOMClient(new HttpRequestSender(connection, false));
    }

    public CIMOMClient createClient(URL url, KeyStore scstore, String user, String password) throws CIMClientException {
        try {
            return this.createClientImpl(CIMHttp.java2DtrHttpURL(url), scstore, user, password);
        }
        catch (MalformedURLException e) {
            throw new CIMClientException(e);
        }
    }

    public CIMOMClient createClient(com.tssap.dtr.client.lib.protocol.URL url, KeyStore scstore, String user, String password) throws CIMClientException {
        return this.createClientImpl(url, scstore, user, password);
    }

    public CIMOMClient createClient(URL url, String user, String password) throws CIMClientException {
        try {
            return this.createClientImpl(CIMHttp.java2DtrHttpURL(url), null, user, password);
        }
        catch (MalformedURLException e) {
            throw new CIMClientException(e);
        }
    }

    public CIMOMClient createClient(com.tssap.dtr.client.lib.protocol.URL url, String user, String password) throws CIMClientException {
        return this.createClientImpl(url, null, user, password);
    }

    private CIMOMClient createClientImpl(com.tssap.dtr.client.lib.protocol.URL url, KeyStore scstore, String user, String password) throws CIMClientException {
        Connection connection;
        com.tssap.dtr.client.lib.protocol.URL cimomUrl;
        String targetNameSpace = CIMHttp.getPartition(url);
        CIMLocalnamespacepath targetLnsp = null;
        if (targetNameSpace == null || targetNameSpace.length() == 0) {
            cimomUrl = url;
        } else {
            try {
                cimomUrl = CIMHttp.setPartition(url, null);
                targetLnsp = CIMFactory.createLocalNamespacepathFromString(targetNameSpace);
            }
            catch (MalformedURLException mfurle) {
                throw new CIMClientException(mfurle);
            }
            catch (LcrException lcre) {
                throw new CIMClientException(lcre);
            }
        }
        String protocol = cimomUrl.getProtocol();
        if (PROTOCOL_HTTP.equals(protocol)) {
            connection = this.createConnection(cimomUrl, user, password);
        } else if (PROTOCOL_HTTPS.equalsIgnoreCase(protocol)) {
            connection = this.createConnection(cimomUrl, user, password);
            IAIKSecureSocketProvider sslProvider = scstore != null ? new IAIKSecureSocketProvider(scstore) : new IAIKSecureSocketProvider(this.trustStore, this.keyStore);
            connection.setSecureSocketProvider((ISecureSocketProvider)sslProvider);
        } else {
            throw new CIMClientException("Unsupported protocol: " + protocol);
        }
        HttpRequestSender sender = new HttpRequestSender(connection, true);
        CIMOMClient result = new CIMOMClient(sender);
        if (targetLnsp != null) {
            result.setLocalNamespacePath(targetLnsp);
        }
        return result;
    }

    private Connection createConnection(com.tssap.dtr.client.lib.protocol.URL url, String user, String pwd) throws CIMClientException {
        SessionContext sessionContext = new SessionContext(user, pwd);
        sessionContext.setAuthenticator((IAuthenticator)new SSO2Authenticator((ISessionContext)sessionContext, (IAuthenticator)new BasicAuthenticator((ISessionContext)sessionContext)));
        try {
            return new Connection(this.checkURL(url), (ISessionContext)sessionContext);
        }
        catch (MalformedURLException e) {
            throw new CIMClientException(e);
        }
    }

    private com.tssap.dtr.client.lib.protocol.URL checkURL(com.tssap.dtr.client.lib.protocol.URL cimomUrl) {
        String pathPart = cimomUrl.getPath();
        if (pathPart == null || pathPart.length() == 0 || pathPart.equals("/")) {
            return new com.tssap.dtr.client.lib.protocol.URL(cimomUrl.getProtocol(), cimomUrl.getHost(), cimomUrl.getPort(), "/sld/cimom");
        }
        return cimomUrl;
    }
}

