/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cimclient;

import com.sap.lcr.api.cim.CIMCim;
import com.sap.lcr.api.cim.CIMClass;
import com.sap.lcr.api.cim.CIMClassList;
import com.sap.lcr.api.cim.CIMClassname;
import com.sap.lcr.api.cim.CIMClassnameList;
import com.sap.lcr.api.cim.CIMConstants;
import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMInstance;
import com.sap.lcr.api.cim.CIMInstancename;
import com.sap.lcr.api.cim.CIMInstancenameList;
import com.sap.lcr.api.cim.CIMKeyValue;
import com.sap.lcr.api.cim.CIMLocalnamespacepath;
import com.sap.lcr.api.cim.CIMLocalnamespacepathList;
import com.sap.lcr.api.cim.CIMMessage;
import com.sap.lcr.api.cim.CIMMultiRsp;
import com.sap.lcr.api.cim.CIMObjectname;
import com.sap.lcr.api.cim.CIMObjectpathList;
import com.sap.lcr.api.cim.CIMPropertyValue;
import com.sap.lcr.api.cim.CIMQualifierDeclaration;
import com.sap.lcr.api.cim.CIMQualifierDeclarationList;
import com.sap.lcr.api.cim.CIMSimpleReq;
import com.sap.lcr.api.cim.CIMSimpleReqList;
import com.sap.lcr.api.cim.CIMSimpleRsp;
import com.sap.lcr.api.cim.CIMSimpleRspList;
import com.sap.lcr.api.cim.CIMUtil;
import com.sap.lcr.api.cim.CIMValueNamedInstance;
import com.sap.lcr.api.cim.CIMValueNamedInstanceList;
import com.sap.lcr.api.cim.CIMValueObjectWithPathList;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import com.sap.lcr.api.cimclient.CIMBatchHandle;
import com.sap.lcr.api.cimclient.CIMBatchResult;
import com.sap.lcr.api.cimclient.CIMClientException;
import com.sap.lcr.api.cimclient.CIMNames;
import com.sap.lcr.api.cimclient.CIMOMHandle;
import com.sap.lcr.api.cimclient.CIMTraceUtil;
import com.sap.lcr.api.cimclient.HttpRequestSender;
import com.sap.lcr.api.cimclient.IRequestSender;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.cimclient.SimpleRequestAssembler;
import com.sap.lcr.api.cimclient.SimpleResponseAnalyser;
import com.sap.lcr.api.log.Logger;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Random;

public final class CIMOMClient
implements CIMOMHandle {
    private static final Logger logger = Logger.getLogger((class$com$sap$lcr$api$cimclient$CIMOMClient == null ? (class$com$sap$lcr$api$cimclient$CIMOMClient = CIMOMClient.class$("com.sap.lcr.api.cimclient.CIMOMClient")) : class$com$sap$lcr$api$cimclient$CIMOMClient).getName());
    private Random random;
    private SimpleRequestAssembler simpleReqAssembler;
    private IRequestSender sender;
    private boolean returnWritables;
    static /* synthetic */ Class class$com$sap$lcr$api$cimclient$CIMOMClient;
    static /* synthetic */ Class class$com$sap$lcr$api$cim$CIMObjectpathList;
    static /* synthetic */ Class class$com$sap$lcr$api$cim$CIMValueObjectWithPathList;
    static /* synthetic */ Class class$com$sap$lcr$api$cim$CIMInstancenameList;
    static /* synthetic */ Class class$com$sap$lcr$api$cim$CIMValueNamedInstanceList;
    static /* synthetic */ Class class$com$sap$lcr$api$cim$CIMClass;
    static /* synthetic */ Class class$com$sap$lcr$api$cim$CIMInstance;
    static /* synthetic */ Class class$com$sap$lcr$api$cim$CIMInstancename;
    static /* synthetic */ Class class$com$sap$lcr$api$cim$CIMClassList;
    static /* synthetic */ Class class$com$sap$lcr$api$cim$CIMClassnameList;
    static /* synthetic */ Class class$com$sap$lcr$api$cim$CIMPropertyValue;
    static /* synthetic */ Class class$com$sap$lcr$api$cim$CIMQualifierDeclaration;
    static /* synthetic */ Class class$com$sap$lcr$api$cim$CIMQualifierDeclarationList;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;

    public CIMOMClient(IRequestSender sender) {
        this.sender = sender;
        this.random = new Random();
        this.simpleReqAssembler = new SimpleRequestAssembler();
        this.returnWritables = this.sender.returnWritableObjectsPerDefault();
    }

    public Object clone() {
        try {
            CIMOMClient clone = (CIMOMClient)super.clone();
            clone.sender = (IRequestSender)this.sender.clone();
            clone.random = new Random();
            clone.simpleReqAssembler = new SimpleRequestAssembler();
            clone.simpleReqAssembler.setLocalnamespacepath(this.simpleReqAssembler.getLocalNamespacePath());
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public IRequestSender getRequestSender() {
        return this.sender;
    }

    public boolean isReturnWritableObjects() {
        return this.returnWritables;
    }

    public void setReturnWritableObjects(boolean returnWritables) {
        this.returnWritables = returnWritables;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(64);
        if (this.sender instanceof HttpRequestSender) {
            HttpRequestSender httpSender = (HttpRequestSender)this.sender;
            buf.append(httpSender.getConnection().getUrl());
        } else {
            buf.append("<local>");
        }
        buf.append(", namespace ");
        buf.append(this.getLocalNamespacePath().toDisplayString());
        return buf.toString();
    }

    private Object send(CIMSimpleReq simpleReq) throws CIMClientException, LcrException {
        return this.sendImpl(simpleReq, false);
    }

    private Object sendImpl(CIMSimpleReq simpleReq, boolean returnSimpleRsp) throws CIMClientException, LcrException {
        CIMMessage message;
        try {
            simpleReq.validateCharacters(false);
        }
        catch (ItemConstructionExcp e) {
            throw new CIMClientException(e);
        }
        CIMCim cimRequest = CIMFactory.cim("2.0", "2.0", CIMFactory.message(Integer.toString(this.random.nextInt(Integer.MAX_VALUE)), "1.0", simpleReq));
        if (CIMTraceUtil.traceLevel >= 4) {
            StringBuffer buf = new StringBuffer(2048);
            buf.append("Sending simple request:");
            buf.append(CIMConstants.NEWLINE);
            cimRequest.appendXml(buf, "");
            logger.fine(buf.toString());
        }
        CIMCim cimResponse = this.sender.send(cimRequest);
        if (CIMTraceUtil.traceLevel >= 4) {
            StringBuffer buf = new StringBuffer(2048);
            buf.append("Received simple response:");
            buf.append(CIMConstants.NEWLINE);
            cimResponse.appendXml(buf, "");
            logger.fine(buf.toString());
        }
        if ((message = cimResponse.getMessage()) == null) {
            throw new CIMClientException("Corrupt response: subelement MESSAGE missing");
        }
        CIMSimpleRsp simpleRsp = message.getSimpleRsp();
        if (simpleRsp == null) {
            throw new CIMClientException("Corrupt response: subelement SIMPLERSP missing");
        }
        return returnSimpleRsp ? simpleRsp : SimpleResponseAnalyser.getIResult(simpleRsp, this.returnWritables);
    }

    private CIMSimpleRspList send(CIMSimpleReqList simpleRequests) throws CIMClientException, LcrException {
        CIMMessage message;
        switch (simpleRequests.size()) {
            case 0: {
                return CIMSimpleRspList.EMPTY;
            }
            case 1: {
                CIMSimpleRsp response = (CIMSimpleRsp)this.sendImpl(simpleRequests.get(0), true);
                CIMSimpleRspList responses = CIMFactory.simpleRspList(1);
                responses.add(response);
                return responses;
            }
        }
        CIMCim cimRequest = CIMFactory.cim("2.0", "2.0", CIMFactory.message(Integer.toString(this.random.nextInt(Integer.MAX_VALUE)), "1.0", CIMFactory.multiReq(simpleRequests)));
        try {
            cimRequest.validateCharacters(false);
        }
        catch (ItemConstructionExcp e) {
            throw new CIMClientException(e);
        }
        if (CIMTraceUtil.traceLevel >= 4) {
            StringBuffer buf = new StringBuffer(2048);
            buf.append("Sending multi request:");
            buf.append(CIMConstants.NEWLINE);
            cimRequest.appendXml(buf, "");
            logger.fine(buf.toString());
        }
        CIMCim cimResponse = this.sender.send(cimRequest);
        if (CIMTraceUtil.traceLevel >= 4) {
            StringBuffer buf = new StringBuffer(2048);
            buf.append("Received multi response:");
            buf.append(CIMConstants.NEWLINE);
            cimResponse.appendXml(buf, "");
            logger.fine(buf.toString());
        }
        if ((message = cimResponse.getMessage()) == null) {
            throw new CIMClientException("Corrupt response: subelement MESSAGE missing");
        }
        CIMMultiRsp multiRsp = message.getMultiRsp();
        if (multiRsp == null) {
            throw new CIMClientException("Corrupt response: subelement MULTIRSP missing");
        }
        CIMSimpleRspList simpleResponses = multiRsp.getSimpleRsps();
        if (simpleResponses == null) {
            throw new CIMClientException("Corrupt response: SIMPLERSP subelements missing");
        }
        if (simpleRequests.size() != simpleResponses.size()) {
            throw new CIMClientException("Corrupt response: " + simpleResponses.size() + " responses received for " + simpleRequests.size() + " requests");
        }
        return simpleResponses;
    }

    private CIMClientException newIllegalReturnTypeError(Object received, Class expected) {
        return new CIMClientException(MessageFormat.format("Illegal return type {0}, expected {1}", received.getClass().getName(), expected.getName()));
    }

    private CIMObjectpathList associatorNamesImpl(CIMClassname className, CIMInstancename instanceName, CIMClassname assocClass, CIMClassname resultClass, String role, String resultRole) throws CIMClientException, LcrException {
        CIMSimpleReq msg = this.simpleReqAssembler.associatorNames(className, instanceName, assocClass, resultClass, role, resultRole);
        Object iResult = this.send(msg);
        try {
            return (CIMObjectpathList)iResult;
        }
        catch (ClassCastException cce) {
            throw this.newIllegalReturnTypeError(iResult, class$com$sap$lcr$api$cim$CIMObjectpathList == null ? (class$com$sap$lcr$api$cim$CIMObjectpathList = CIMOMClient.class$("com.sap.lcr.api.cim.CIMObjectpathList")) : class$com$sap$lcr$api$cim$CIMObjectpathList);
        }
    }

    private CIMValueObjectWithPathList associatorsImpl(CIMClassname className, CIMInstancename instanceName, CIMClassname assocClass, CIMClassname resultClass, String role, String resultRole, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        CIMSimpleReq msg = this.simpleReqAssembler.associators(className, instanceName, assocClass, resultClass, role, resultRole, includeQualifiers, includeClassOrigin, propertyList);
        Object iResult = this.send(msg);
        try {
            return (CIMValueObjectWithPathList)iResult;
        }
        catch (ClassCastException cce) {
            throw this.newIllegalReturnTypeError(iResult, class$com$sap$lcr$api$cim$CIMValueObjectWithPathList == null ? (class$com$sap$lcr$api$cim$CIMValueObjectWithPathList = CIMOMClient.class$("com.sap.lcr.api.cim.CIMValueObjectWithPathList")) : class$com$sap$lcr$api$cim$CIMValueObjectWithPathList);
        }
    }

    private CIMInstancenameList enumerateInstanceNamesImpl(boolean subclasses, CIMClassname className) throws CIMClientException, LcrException {
        CIMSimpleReq msg = this.simpleReqAssembler.enumerateInstanceNames(subclasses, className);
        Object iResult = this.send(msg);
        try {
            return (CIMInstancenameList)iResult;
        }
        catch (ClassCastException cce) {
            throw this.newIllegalReturnTypeError(iResult, class$com$sap$lcr$api$cim$CIMInstancenameList == null ? (class$com$sap$lcr$api$cim$CIMInstancenameList = CIMOMClient.class$("com.sap.lcr.api.cim.CIMInstancenameList")) : class$com$sap$lcr$api$cim$CIMInstancenameList);
        }
    }

    private CIMValueNamedInstanceList enumerateInstancesImpl(boolean subclasses, CIMClassname className, boolean localOnly, boolean deepInheritance, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        CIMSimpleReq msg = this.simpleReqAssembler.enumerateInstances(subclasses, className, localOnly, deepInheritance, includeQualifiers, includeClassOrigin, propertyList);
        Object iResult = this.send(msg);
        try {
            return (CIMValueNamedInstanceList)iResult;
        }
        catch (ClassCastException cce) {
            throw this.newIllegalReturnTypeError(iResult, class$com$sap$lcr$api$cim$CIMValueNamedInstanceList == null ? (class$com$sap$lcr$api$cim$CIMValueNamedInstanceList = CIMOMClient.class$("com.sap.lcr.api.cim.CIMValueNamedInstanceList")) : class$com$sap$lcr$api$cim$CIMValueNamedInstanceList);
        }
    }

    private CIMObjectpathList referenceNamesImpl(CIMClassname className, CIMInstancename instanceName, CIMClassname resultClass, String role) throws CIMClientException, LcrException {
        CIMSimpleReq msg = this.simpleReqAssembler.referenceNames(className, instanceName, resultClass, role);
        Object iResult = this.send(msg);
        try {
            return (CIMObjectpathList)iResult;
        }
        catch (ClassCastException cce) {
            throw this.newIllegalReturnTypeError(iResult, class$com$sap$lcr$api$cim$CIMObjectpathList == null ? (class$com$sap$lcr$api$cim$CIMObjectpathList = CIMOMClient.class$("com.sap.lcr.api.cim.CIMObjectpathList")) : class$com$sap$lcr$api$cim$CIMObjectpathList);
        }
    }

    private CIMValueObjectWithPathList referencesImpl(CIMClassname className, CIMInstancename instName, CIMClassname resultClass, String role, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        CIMSimpleReq msg = this.simpleReqAssembler.references(className, instName, resultClass, role, includeQualifiers, includeClassOrigin, propertyList);
        Object iResult = this.send(msg);
        try {
            return (CIMValueObjectWithPathList)iResult;
        }
        catch (ClassCastException cce) {
            throw this.newIllegalReturnTypeError(iResult, class$com$sap$lcr$api$cim$CIMValueObjectWithPathList == null ? (class$com$sap$lcr$api$cim$CIMValueObjectWithPathList = CIMOMClient.class$("com.sap.lcr.api.cim.CIMValueObjectWithPathList")) : class$com$sap$lcr$api$cim$CIMValueObjectWithPathList);
        }
    }

    public void disconnect() {
        this.sender.disconnect();
    }

    public void setLocalNamespacePath(CIMLocalnamespacepath localNamespacepath) {
        this.simpleReqAssembler.setLocalnamespacepath(localNamespacepath);
    }

    public CIMLocalnamespacepath getLocalNamespacePath() {
        return this.simpleReqAssembler.getLocalNamespacePath();
    }

    public CIMClass getCIMClass(CIMClassname className, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        CIMSimpleReq msg = this.simpleReqAssembler.getCIMClass(className, localOnly, includeQualifiers, includeClassOrigin, propertyList);
        Object iResult = this.send(msg);
        try {
            return (CIMClass)iResult;
        }
        catch (ClassCastException cce) {
            throw this.newIllegalReturnTypeError(iResult, class$com$sap$lcr$api$cim$CIMClass == null ? (class$com$sap$lcr$api$cim$CIMClass = CIMOMClient.class$("com.sap.lcr.api.cim.CIMClass")) : class$com$sap$lcr$api$cim$CIMClass);
        }
    }

    public CIMInstance getInstance(CIMInstancename instanceName, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        CIMSimpleReq msg = this.simpleReqAssembler.getInstance(instanceName, localOnly, includeQualifiers, includeClassOrigin, propertyList);
        Object iResult = this.send(msg);
        try {
            return (CIMInstance)iResult;
        }
        catch (ClassCastException cce) {
            throw this.newIllegalReturnTypeError(iResult, class$com$sap$lcr$api$cim$CIMInstance == null ? (class$com$sap$lcr$api$cim$CIMInstance = CIMOMClient.class$("com.sap.lcr.api.cim.CIMInstance")) : class$com$sap$lcr$api$cim$CIMInstance);
        }
    }

    public void deleteClass(CIMClassname className) throws CIMClientException, LcrException {
        CIMSimpleReq msg = this.simpleReqAssembler.deleteClass(className);
        this.send(msg);
    }

    public void deleteInstance(CIMInstancename instanceName) throws CIMClientException, LcrException {
        this.deleteInstanceImpl(instanceName, false, false);
    }

    public CIMObjectpathList deleteInstance(CIMInstancename instanceName, boolean withReferences) throws CIMClientException, LcrException {
        return this.deleteInstanceImpl(instanceName, withReferences, false);
    }

    private CIMObjectpathList deleteInstanceImpl(CIMInstancename instanceName, boolean withReferences, boolean allowNamespaceManagement) throws CIMClientException, LcrException {
        if (!allowNamespaceManagement && CIMNames.C_CIM_Namespace.equals(instanceName.getCIMClassname())) {
            throw new LcrException(7, "Deleting instances of CIM_Namespace has side-effects, use deleteNamespace() instead.");
        }
        CIMSimpleReq msg = this.simpleReqAssembler.deleteInstance(instanceName, withReferences);
        Object iResult = this.send(msg);
        if (withReferences) {
            try {
                return (CIMObjectpathList)iResult;
            }
            catch (ClassCastException cce) {
                throw this.newIllegalReturnTypeError(iResult, class$com$sap$lcr$api$cim$CIMObjectpathList == null ? (class$com$sap$lcr$api$cim$CIMObjectpathList = CIMOMClient.class$("com.sap.lcr.api.cim.CIMObjectpathList")) : class$com$sap$lcr$api$cim$CIMObjectpathList);
            }
        }
        return null;
    }

    public void createClass(CIMClass newClass) throws CIMClientException, LcrException {
        CIMSimpleReq msg = this.simpleReqAssembler.createClass(newClass);
        this.send(msg);
    }

    public CIMInstancename createInstance(CIMInstance newInstance) throws CIMClientException, LcrException {
        return this.createInstanceImpl(newInstance, false);
    }

    private CIMInstancename createInstanceImpl(CIMInstance newInstance, boolean allowNamespaceManagement) throws CIMClientException, LcrException {
        if (!allowNamespaceManagement && CIMNames.C_CIM_Namespace.equals(newInstance.getCIMClassname())) {
            throw new LcrException(7, "Creating instances of CIM_Namespace has side-effects, use createNamespace() instead.");
        }
        CIMSimpleReq msg = this.simpleReqAssembler.createInstance(newInstance);
        Object iResult = this.send(msg);
        try {
            return (CIMInstancename)iResult;
        }
        catch (ClassCastException cce) {
            throw this.newIllegalReturnTypeError(iResult, class$com$sap$lcr$api$cim$CIMInstancename == null ? (class$com$sap$lcr$api$cim$CIMInstancename = CIMOMClient.class$("com.sap.lcr.api.cim.CIMInstancename")) : class$com$sap$lcr$api$cim$CIMInstancename);
        }
    }

    public void modifyClass(CIMClass modifiedClass) throws CIMClientException, LcrException {
        CIMSimpleReq msg = this.simpleReqAssembler.modifyClass(modifiedClass);
        this.send(msg);
    }

    public void modifyInstance(CIMValueNamedInstance modifiedNamedInstance) throws CIMClientException, LcrException {
        CIMSimpleReq msg = this.simpleReqAssembler.modifyMergeInstance(modifiedNamedInstance, false);
        this.send(msg);
    }

    public CIMClassList enumerateClasses(CIMClassname className, boolean deepInheritance, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin) throws CIMClientException, LcrException {
        CIMSimpleReq msg = this.simpleReqAssembler.enumerateClasses(className, deepInheritance, localOnly, includeQualifiers, includeClassOrigin);
        Object iResult = this.send(msg);
        try {
            return (CIMClassList)iResult;
        }
        catch (ClassCastException cce) {
            throw this.newIllegalReturnTypeError(iResult, class$com$sap$lcr$api$cim$CIMClassList == null ? (class$com$sap$lcr$api$cim$CIMClassList = CIMOMClient.class$("com.sap.lcr.api.cim.CIMClassList")) : class$com$sap$lcr$api$cim$CIMClassList);
        }
    }

    public CIMClassnameList enumerateClassNames(CIMClassname className, boolean deepInheritance) throws CIMClientException, LcrException {
        CIMSimpleReq msg = this.simpleReqAssembler.enumerateClassNames(className, deepInheritance);
        Object iResult = this.send(msg);
        try {
            return (CIMClassnameList)iResult;
        }
        catch (ClassCastException cce) {
            throw this.newIllegalReturnTypeError(iResult, class$com$sap$lcr$api$cim$CIMClassnameList == null ? (class$com$sap$lcr$api$cim$CIMClassnameList = CIMOMClient.class$("com.sap.lcr.api.cim.CIMClassnameList")) : class$com$sap$lcr$api$cim$CIMClassnameList);
        }
    }

    public CIMValueNamedInstanceList enumerateInstances(CIMClassname className, boolean localOnly, boolean deepInheritance, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        return this.enumerateInstancesImpl(true, className, localOnly, deepInheritance, includeQualifiers, includeClassOrigin, propertyList);
    }

    public CIMInstancenameList enumerateInstanceNames(CIMClassname className) throws CIMClientException, LcrException {
        return this.enumerateInstanceNamesImpl(true, className);
    }

    public CIMValueObjectWithPathList associators(CIMObjectname objectName, CIMClassname assocClass, CIMClassname resultClass, String role, String resultRole, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        return this.associatorsImpl(objectName.getCIMClassname(), objectName.getInstancename(), assocClass, resultClass, role, resultRole, includeQualifiers, includeClassOrigin, propertyList);
    }

    public CIMValueObjectWithPathList associators(CIMClassname className, CIMClassname assocClass, CIMClassname resultClass, String role, String resultRole, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        return this.associatorsImpl(className, null, assocClass, resultClass, role, resultRole, includeQualifiers, includeClassOrigin, propertyList);
    }

    public CIMValueObjectWithPathList associators(CIMInstancename instanceName, CIMClassname assocClass, CIMClassname resultClass, String role, String resultRole, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        return this.associatorsImpl(null, instanceName, assocClass, resultClass, role, resultRole, includeQualifiers, includeClassOrigin, propertyList);
    }

    public CIMObjectpathList associatorNames(CIMObjectname objectName, CIMClassname assocClass, CIMClassname resultClass, String role, String resultRole) throws CIMClientException, LcrException {
        return this.associatorNamesImpl(objectName.getCIMClassname(), objectName.getInstancename(), assocClass, resultClass, role, resultRole);
    }

    public CIMObjectpathList associatorNames(CIMClassname className, CIMClassname assocClass, CIMClassname resultClass, String role, String resultRole) throws CIMClientException, LcrException {
        return this.associatorNamesImpl(className, null, assocClass, resultClass, role, resultRole);
    }

    public CIMObjectpathList associatorNames(CIMInstancename instanceName, CIMClassname assocClass, CIMClassname resultClass, String role, String resultRole) throws CIMClientException, LcrException {
        return this.associatorNamesImpl(null, instanceName, assocClass, resultClass, role, resultRole);
    }

    public CIMValueObjectWithPathList references(CIMObjectname objectName, CIMClassname resultClass, String role, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        return this.referencesImpl(objectName.getCIMClassname(), objectName.getInstancename(), resultClass, role, includeQualifiers, includeClassOrigin, propertyList);
    }

    public CIMValueObjectWithPathList references(CIMClassname className, CIMClassname resultClass, String role, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        return this.referencesImpl(className, null, resultClass, role, includeQualifiers, includeClassOrigin, propertyList);
    }

    public CIMValueObjectWithPathList references(CIMInstancename instanceName, CIMClassname resultClass, String role, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        return this.referencesImpl(null, instanceName, resultClass, role, includeQualifiers, includeClassOrigin, propertyList);
    }

    public CIMObjectpathList referenceNames(CIMObjectname objectName, CIMClassname resultClass, String role) throws CIMClientException, LcrException {
        return this.referenceNamesImpl(objectName.getCIMClassname(), objectName.getInstancename(), resultClass, role);
    }

    public CIMObjectpathList referenceNames(CIMClassname className, CIMClassname resultClass, String role) throws CIMClientException, LcrException {
        return this.referenceNamesImpl(className, null, resultClass, role);
    }

    public CIMObjectpathList referenceNames(CIMInstancename instanceName, CIMClassname resultClass, String role) throws CIMClientException, LcrException {
        return this.referenceNamesImpl(null, instanceName, resultClass, role);
    }

    public CIMPropertyValue getProperty(CIMInstancename instanceName, String propertyName) throws CIMClientException, LcrException {
        CIMSimpleReq msg = this.simpleReqAssembler.getProperty(instanceName, propertyName);
        Object iResult = this.send(msg);
        try {
            return (CIMPropertyValue)iResult;
        }
        catch (ClassCastException cce) {
            throw this.newIllegalReturnTypeError(iResult, class$com$sap$lcr$api$cim$CIMPropertyValue == null ? (class$com$sap$lcr$api$cim$CIMPropertyValue = CIMOMClient.class$("com.sap.lcr.api.cim.CIMPropertyValue")) : class$com$sap$lcr$api$cim$CIMPropertyValue);
        }
    }

    public void setProperty(CIMInstancename instanceName, String propertyName, CIMPropertyValue newValue) throws CIMClientException, LcrException {
        CIMSimpleReq msg = this.simpleReqAssembler.setProperty(instanceName, propertyName, newValue);
        this.send(msg);
    }

    public CIMQualifierDeclaration getQualifier(String qualifierName) throws CIMClientException, LcrException {
        CIMSimpleReq msg = this.simpleReqAssembler.getQualifier(qualifierName);
        Object iResult = this.send(msg);
        try {
            return (CIMQualifierDeclaration)iResult;
        }
        catch (ClassCastException cce) {
            throw this.newIllegalReturnTypeError(iResult, class$com$sap$lcr$api$cim$CIMQualifierDeclaration == null ? (class$com$sap$lcr$api$cim$CIMQualifierDeclaration = CIMOMClient.class$("com.sap.lcr.api.cim.CIMQualifierDeclaration")) : class$com$sap$lcr$api$cim$CIMQualifierDeclaration);
        }
    }

    public void setQualifier(CIMQualifierDeclaration qualifierDeclaration) throws CIMClientException, LcrException {
        CIMSimpleReq msg = this.simpleReqAssembler.setQualifier(qualifierDeclaration);
        this.send(msg);
    }

    public void deleteQualifier(String qualifierName) throws CIMClientException, LcrException {
        CIMSimpleReq msg = this.simpleReqAssembler.deleteQualifier(qualifierName);
        this.send(msg);
    }

    public CIMQualifierDeclarationList enumerateQualifiers() throws CIMClientException, LcrException {
        CIMSimpleReq msg = this.simpleReqAssembler.enumerateQualifiers();
        Object iResult = this.send(msg);
        try {
            return (CIMQualifierDeclarationList)iResult;
        }
        catch (ClassCastException cce) {
            throw this.newIllegalReturnTypeError(iResult, class$com$sap$lcr$api$cim$CIMQualifierDeclarationList == null ? (class$com$sap$lcr$api$cim$CIMQualifierDeclarationList = CIMOMClient.class$("com.sap.lcr.api.cim.CIMQualifierDeclarationList")) : class$com$sap$lcr$api$cim$CIMQualifierDeclarationList);
        }
    }

    public CIMValueObjectWithPathList execQuery(String queryLanguage, String query) throws CIMClientException, LcrException {
        CIMSimpleReq msg = this.simpleReqAssembler.execQuery(queryLanguage, query);
        Object iResult = this.send(msg);
        try {
            return (CIMValueObjectWithPathList)iResult;
        }
        catch (ClassCastException cce) {
            throw this.newIllegalReturnTypeError(iResult, class$com$sap$lcr$api$cim$CIMValueObjectWithPathList == null ? (class$com$sap$lcr$api$cim$CIMValueObjectWithPathList = CIMOMClient.class$("com.sap.lcr.api.cim.CIMValueObjectWithPathList")) : class$com$sap$lcr$api$cim$CIMValueObjectWithPathList);
        }
    }

    public CIMValueNamedInstanceList enumerateInstancesNoSubclasses(CIMClassname className, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        return this.enumerateInstancesImpl(false, className, localOnly, false, includeQualifiers, includeClassOrigin, propertyList);
    }

    public CIMInstancenameList enumerateInstanceNamesNoSubclasses(CIMClassname className) throws CIMClientException, LcrException {
        return this.enumerateInstanceNamesImpl(false, className);
    }

    public int getInstanceCount(CIMClassname className) throws CIMClientException, LcrException {
        CIMSimpleReq msg = this.simpleReqAssembler.getInstanceCount(className);
        Object iResult = this.send(msg);
        try {
            return (Integer)iResult;
        }
        catch (ClassCastException cce) {
            throw this.newIllegalReturnTypeError(iResult, class$java$lang$Integer == null ? (class$java$lang$Integer = CIMOMClient.class$("java.lang.Integer")) : class$java$lang$Integer);
        }
    }

    public int referenceCount(CIMInstancename instancename) throws CIMClientException, LcrException {
        CIMSimpleReq msg = this.simpleReqAssembler.getReferenceCount(instancename);
        Object iResult = this.send(msg);
        try {
            return (Integer)iResult;
        }
        catch (ClassCastException cce) {
            throw this.newIllegalReturnTypeError(iResult, class$java$lang$Integer == null ? (class$java$lang$Integer = CIMOMClient.class$("java.lang.Integer")) : class$java$lang$Integer);
        }
    }

    public void mergeInstance(CIMValueNamedInstance modifiedNamedInstance) throws CIMClientException, LcrException {
        CIMSimpleReq msg = this.simpleReqAssembler.modifyMergeInstance(modifiedNamedInstance, true);
        this.send(msg);
    }

    public CIMObjectpathList renameInstance(CIMInstancename sourceName, CIMInstancename targetName, boolean allowExistingTargets, boolean additionalReferences, boolean weakReferences, boolean merge) throws CIMClientException, LcrException {
        CIMSimpleReq msg = this.simpleReqAssembler.copyOrRenameInstance(false, sourceName, targetName, null, allowExistingTargets, additionalReferences, weakReferences, merge);
        Object iResult = this.send(msg);
        try {
            return (CIMObjectpathList)iResult;
        }
        catch (ClassCastException cce) {
            throw this.newIllegalReturnTypeError(iResult, class$com$sap$lcr$api$cim$CIMObjectpathList == null ? (class$com$sap$lcr$api$cim$CIMObjectpathList = CIMOMClient.class$("com.sap.lcr.api.cim.CIMObjectpathList")) : class$com$sap$lcr$api$cim$CIMObjectpathList);
        }
    }

    public CIMObjectpathList renameInstance(CIMInstancename sourceName, CIMInstance targetInstance, boolean allowExistingTargets, boolean additionalReferences, boolean weakReferences, boolean merge) throws CIMClientException, LcrException {
        CIMSimpleReq msg = this.simpleReqAssembler.copyOrRenameInstance(false, sourceName, null, targetInstance, allowExistingTargets, additionalReferences, weakReferences, merge);
        Object iResult = this.send(msg);
        try {
            return (CIMObjectpathList)iResult;
        }
        catch (ClassCastException cce) {
            throw this.newIllegalReturnTypeError(iResult, class$com$sap$lcr$api$cim$CIMObjectpathList == null ? (class$com$sap$lcr$api$cim$CIMObjectpathList = CIMOMClient.class$("com.sap.lcr.api.cim.CIMObjectpathList")) : class$com$sap$lcr$api$cim$CIMObjectpathList);
        }
    }

    public CIMObjectpathList copyInstance(CIMInstancename sourceName, CIMInstancename targetName, boolean allowExistingTargets, boolean additionalReferences, boolean weakReferences, boolean merge) throws CIMClientException, LcrException {
        CIMSimpleReq msg = this.simpleReqAssembler.copyOrRenameInstance(true, sourceName, targetName, null, allowExistingTargets, additionalReferences, weakReferences, merge);
        Object iResult = this.send(msg);
        try {
            return (CIMObjectpathList)iResult;
        }
        catch (ClassCastException cce) {
            throw this.newIllegalReturnTypeError(iResult, class$com$sap$lcr$api$cim$CIMObjectpathList == null ? (class$com$sap$lcr$api$cim$CIMObjectpathList = CIMOMClient.class$("com.sap.lcr.api.cim.CIMObjectpathList")) : class$com$sap$lcr$api$cim$CIMObjectpathList);
        }
    }

    public String getObjectServer() throws CIMClientException, LcrException {
        CIMSimpleReq msg = this.simpleReqAssembler.getObjectServer();
        Object iResult = this.send(msg);
        try {
            return (String)iResult;
        }
        catch (ClassCastException cce) {
            throw this.newIllegalReturnTypeError(iResult, class$java$lang$String == null ? (class$java$lang$String = CIMOMClient.class$("java.lang.String")) : class$java$lang$String);
        }
    }

    public void setProviderSyncTime(CIMInstancename instanceName, Date date) throws CIMClientException, LcrException {
        CIMSimpleReq msg = this.simpleReqAssembler.setProviderSyncTime(instanceName, date);
        this.send(msg);
    }

    public CIMBatchResult performBatchOperation(CIMBatchHandle batch) throws CIMClientException, LcrException {
        CIMSimpleRspList reply = this.send(batch.getSimpleRequests());
        return new CIMBatchResult(reply, this.returnWritables);
    }

    public void createNamespace(CIMLocalnamespacepath newNamespace) throws CIMClientException, LcrException {
        CIMLocalnamespacepath targetNamespace = this.simpleReqAssembler.getLocalNamespacePath();
        this.simpleReqAssembler.setLocalnamespacepath(null);
        try {
            try {
                CIMInstance instance = CIMFactory.instance(CIMNames.C_CIM_Namespace);
                instance.addProperty(CIMFactory.property("Name", "string", newNamespace.toDisplayString()));
                this.createInstanceImpl(instance, true);
            }
            catch (ItemConstructionExcp e) {
                throw new CIMClientException(e);
            }
            Object var5_5 = null;
            this.simpleReqAssembler.setLocalnamespacepath(targetNamespace);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.simpleReqAssembler.setLocalnamespacepath(targetNamespace);
            throw throwable;
        }
    }

    public void deleteNamespace(CIMLocalnamespacepath namespace, boolean deleteContent) throws CIMClientException, LcrException {
        CIMLocalnamespacepath targetNamespace = this.simpleReqAssembler.getLocalNamespacePath();
        this.simpleReqAssembler.setLocalnamespacepath(null);
        try {
            try {
                CIMInstancename instancename = CIMFactory.instancename(CIMNames.C_CIM_Namespace);
                instancename.addKeybinding(CIMFactory.keybinding("Name", "string", namespace.toDisplayString()));
                this.deleteInstanceImpl(instancename, deleteContent, true);
            }
            catch (ItemConstructionExcp e) {
                throw new CIMClientException(e);
            }
            Object var6_6 = null;
            this.simpleReqAssembler.setLocalnamespacepath(targetNamespace);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.simpleReqAssembler.setLocalnamespacepath(targetNamespace);
            throw throwable;
        }
    }

    public CIMLocalnamespacepathList enumerateNamespaces() throws CIMClientException, LcrException {
        CIMInstancenameList namespaceInstNames;
        CIMLocalnamespacepath targetNamespace = this.simpleReqAssembler.getLocalNamespacePath();
        this.simpleReqAssembler.setLocalnamespacepath(null);
        try {
            namespaceInstNames = this.enumerateInstanceNamesNoSubclasses(CIMNames.C_CIM_Namespace);
            Object var4_3 = null;
            this.simpleReqAssembler.setLocalnamespacepath(targetNamespace);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.simpleReqAssembler.setLocalnamespacepath(targetNamespace);
            throw throwable;
        }
        CIMLocalnamespacepathList localnamespacepathList = CIMFactory.localnamespacepathList(namespaceInstNames.size());
        int i = 0;
        while (i < namespaceInstNames.size()) {
            CIMInstancename instancename = namespaceInstNames.get(i);
            CIMKeyValue keyValue = CIMUtil.getKeyValueByName(instancename, "Name");
            if (keyValue == null) {
                throw new CIMClientException("Illegal server response, no valid CIM_Namespace instance names");
            }
            CIMLocalnamespacepath localnamespacepath = CIMFactory.createLocalNamespacepathFromString(keyValue.getValue());
            localnamespacepathList.add(localnamespacepath);
            ++i;
        }
        return localnamespacepathList;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

