/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cimclient;

import com.sap.lcr.api.cimclient.WrapperException;
import java.text.MessageFormat;

public class CIMClientException
extends WrapperException {
    private final int httpStatusCode;

    public CIMClientException(String msg) {
        super(msg);
        this.httpStatusCode = 0;
    }

    public CIMClientException(Exception ex) {
        super(ex);
        this.httpStatusCode = 0;
    }

    public CIMClientException(int httpStatusCode) {
        super("HTTP response code: " + httpStatusCode);
        this.httpStatusCode = httpStatusCode;
    }

    public CIMClientException(int httpStatusCode, String description) {
        super(MessageFormat.format("HTTP response code: {0} {1}", new Integer(httpStatusCode), description));
        this.httpStatusCode = httpStatusCode;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }
}

